<?php
/**
 * Team info on hover shortcode template
 */
?>

<div class="mkd-team <?php echo esc_attr( $team_type )?> <?php echo esc_html($team_classes); ?>">
	<div class="mkd-team-inner">
		<?php if ( $team_image !== '' ) { ?>
		<div class="mkd-team-image">
            <?php echo wp_get_attachment_image($team_image,'full');?>
			<div class="mkd-team-info-holder">
				<div class="mkd-team-info">
					<div class="mkd-team-info-inner">
						<div class="mkd-team-title-holder">
							<?php if ( $team_name !== '' ) { ?>
							<div class="mkd-team-title-holder-inner">
								<<?php echo esc_attr($team_name_tag); ?> class="mkd-team-name">
									<?php echo esc_attr( $team_name ); ?>
								</<?php echo esc_attr($team_name_tag); ?>>
							</div>
							<?php }
							if ( $team_position !== '' ) { ?>
							<div class="mkd-team-position-holder">
								<h6 class="mkd-team-position">
									<?php echo esc_attr( $team_position ); ?>
								</h6>
							</div>
							<?php } ?>
						</div>
						<?php if(!empty($team_social_icons)) : ?>
							<div class="mkd-team-social">
								<div class="mkd-team-social-wrapp">
									<?php foreach( $team_social_icons as $team_social_icon ) {
										print buro_mikado_display_content_output($team_social_icon);
									} ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
	</div>
</div>