<?php
namespace BuroMikado\Modules\Shortcodes\Underliner;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class Message
 */
class Underliner implements ShortcodeInterface
{
    private $base;

    function __construct() {
        $this->base = 'mkd_underliner';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    public function vcMap() {

        vc_map(array(
                'name'                      => esc_html__('Underliner', 'buro'),
                'base'                      => $this->base,
                'category'                  => esc_html__('by MIKADO', 'buro'),
                'icon'                      => 'icon-wpb-underliner extended-custom-icon',
                'allowed_container_element' => 'vc_row',
                'params'                    => array(
                    array(
                        'type'        => 'dropdown',
                        'param_name'  => 'title_tag',
                        'heading'     => esc_html__('Title tag', 'buro'),
                        'value'       => array(
                            'p'  => 'p',
                            'h1' => 'h1',
                            'h2' => 'h2',
                            'h3' => 'h3',
                            'h4' => 'h4',
                            'h5' => 'h5',
                            'h6' => 'h6',
                        ),
                        'save_always' => true,
                    ),
                    array(
                        'type'       => 'textfield',
                        'param_name' => 'custom_size',
                        'heading'    => esc_html__('Custom Size (px)', 'buro')
                    ),
                    array(
                        'type'       => 'param_group',
                        'heading'    => esc_html__('Underliner items', 'buro'),
                        'param_name' => 'underliner_items',
                        'value'      => '',
                        'params'     => array(
                            array(
                                'type'        => 'textfield',
                                'param_name'  => 'text',
                                'heading'     => esc_html__('Text', 'buro'),
                                'description' => esc_html__('', 'buro')
                            ),
                            array(
                                'type'       => 'dropdown',
                                'param_name' => 'underlined',
                                'heading'    => esc_html__('Underlined', 'buro'),
                                'value'      => array(
                                    esc_html__('No', 'buro')  => 'no',
                                    esc_html__('Yes', 'buro') => 'yes',
                                ),
                                'dependency' => array('element' => 'title', 'not_empty' => true)
                            ),
                            array(
                                'type'       => 'colorpicker',
                                'heading'    => esc_html__('Color', 'buro'),
                                'param_name' => 'color',
                                'save_always' => true,
                            ),
                            array(
                                'type'       => 'textfield',
                                'param_name' => 'link',
                                'heading'    => esc_html__('Link', 'buro'),
                                'dependency' => array('element' => 'title', 'not_empty' => true)
                            ),
                            array(
                                'type'        => 'dropdown',
                                'param_name'  => 'target',
                                'heading'     => esc_html__('Link Target', 'buro'),
                                'value'       => array(
                                    esc_html__('Self', 'buro')  => '_self',
                                    esc_html__('Blank', 'buro') => '_blank',

                                ),
                                'save_always' => true,
                                'dependency'  => array('element' => 'link', 'not_empty' => true)
                            )
                        )
                    )
                )
            )
        );

    }

    public function render($atts, $content = null) {

        $args = array(
            'title_tag'        => '',
            'custom_size'      => '',
            'underliner_items' => ''
        );

        $params = shortcode_atts($args, $atts);


        $params['items'] = vc_param_group_parse_atts($params['underliner_items']);
        $params['underliner_size'] = $this->getUnderlinerSize($params);

        $html = mkd_core_get_module_shortcode_template_part('templates/underliner-template', 'underliner', '', $params);

        return $html;
    }

    /**
     * Generates shortcode styles
     *
     * @param $params
     *
     * @return array
     */
    private function getUnderlinerSize($params) {
        $style = array();

        if($params['custom_size'] !== '') {
            $style[] = 'font-size: ' . $params['custom_size'] . ';';
        }

        return $style;
    }
}