<?php

class BuroMikadoWoocommerceDropdownCart extends WP_Widget {
	public function __construct() {
		parent::__construct(
			'mkd_woocommerce_dropdown_cart', // Base ID
			'Mikado Woocommerce Dropdown Cart', // Name
			array( 'description' => esc_html__( 'Mikado Woocommerce Dropdown Cart', 'buro' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
		global $post;
		extract( $args );

		global $woocommerce;
		global $buro_mikado_options;

		$cart_style = 'mkd-with-icon';

		?>
		<div class="mkd-shopping-cart-outer">
			<div class="mkd-shopping-cart-inner">
				<div class="mkd-shopping-cart-header">
					<a class="mkd-header-cart" href="<?php echo wc_get_cart_url(); ?>">
						<span class="mkd-cart-icon fa fa-shopping-cart"></span>
						<span class="mkd-cart-amount"><?php echo esc_html($woocommerce->cart->get_cart_contents_count()); ?></span>
					</a>

					<div class="mkd-shopping-cart-dropdown">
						<?php
						$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
						$list_class    = array( 'mkd-cart-list', 'product_list_widget' );
						?>
						<ul>

							<?php if ( ! $cart_is_empty ) : ?>

								<?php foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) :

									$_product      = $cart_item['data'];

									// Only display if allowed
									if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
										continue;
									}

									// Get price
									if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
										$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
									} else {
										$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? $_product->get_price_excluding_tax() : $_product->get_price_including_tax();
									}
									?>


									<li>
										<div class="mkd-item-image-holder">
											<a href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>">
												<?php echo wp_kses( $_product->get_image(), array(
													'img' => array(
														'src'    => true,
														'width'  => true,
														'height' => true,
														'class'  => true,
														'alt'    => true,
														'title'  => true,
														'id'     => true
													)
												) ); ?>
											</a>
										</div>
										<div class="mkd-item-info-holder">
											<div class="mkd-item-left">
												<a href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>">
													<?php echo apply_filters( 'woocommerce_widget_cart_product_title', $_product->get_title(), $_product ); ?>
												</a>
												<div class="mkd-quantity-holder">
													<span class="mkd-quantity"><?php echo esc_html( $cart_item['quantity'] ); ?></span>
													<span>x</span>
													<?php echo apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_price ), $cart_item, $cart_item_key ); ?>
												</div>
											</div>
											<div class="mkd-cart-remove">
												<?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s"><span class="ion-close"></span></a>', esc_url( $woocommerce->cart->get_remove_url( $cart_item_key ) ), esc_html__('Remove this item', 'buro') ), $cart_item_key ); ?>
											</div>
										</div>
									</li>

								<?php endforeach; ?>
							</ul>
								<div class="mkd-cart-bottom">
									<div class="mkd-subtotal-holder clearfix">
										<span class="mkd-total"><?php esc_html_e( 'Total', 'buro' ); ?>:</span>
										<span class="mkd-total-amount">
											<?php echo wp_kses( $woocommerce->cart->get_cart_subtotal(), array(
												'span' => array(
													'class' => true,
													'id'    => true
												)
											) ); ?>
										</span>
									</div>
									<div class="mkd-btns-holder clearfix">
										<a href="<?php echo wc_get_cart_url(); ?>"
										   class="mkd-btn-small view-cart">
										   <span class="ion-bag"></span>
											<?php esc_html_e( 'Shopping Bag', 'buro' ); ?>
										</a>
										<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>"
										   class="mkd-btn-small checkout">
										   <span class="ion-ios-checkmark-outline"></span>
											<?php esc_html_e( 'Checkout', 'buro' ); ?>
										</a>
									</div>
								</div>
							<?php else : ?>

								<li class="mkd-empty-cart"><?php esc_html_e( 'No products in the cart.', 'buro' ); ?></li>
							</ul>

							<?php endif; ?>

						<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

						<?php endif; ?>


						<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}

}

add_action('widgets_init', function () {
    register_widget( "BuroMikadoWoocommerceDropdownCart" );
});

?>
<?php

if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
	add_filter( 'woocommerce_add_to_cart_fragments', 'buro_mikado_woocommerce_header_add_to_cart_fragment' );
} else {
	add_filter( 'add_to_cart_fragments', 'buro_mikado_woocommerce_header_add_to_cart_fragment' );
}
function buro_mikado_woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;

	ob_start();
	?>
	<div class="mkd-shopping-cart-header">
		<a class="mkd-header-cart" href="<?php echo wc_get_cart_url(); ?>">
			<span class="mkd-cart-icon fa fa-shopping-cart"></span>
			<span class="mkd-cart-amount"><?php echo esc_html($woocommerce->cart->get_cart_contents_count()); ?></span>
		</a>

		<div class="mkd-shopping-cart-dropdown">
			<?php
			$cart_is_empty = sizeof( $woocommerce->cart->get_cart() ) <= 0;
			//$list_class = array( 'mkd-cart-list', 'product_list_widget' );
			?>
			<ul>

				<?php if ( ! $cart_is_empty ) : ?>

					<?php foreach ( $woocommerce->cart->get_cart() as $cart_item_key => $cart_item ) :

						$_product      = $cart_item['data'];

						// Only display if allowed
						if ( ! $_product->exists() || $cart_item['quantity'] == 0 ) {
							continue;
						}

						// Get price
						if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
							$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? wc_get_price_excluding_tax($_product) : wc_get_price_including_tax($_product);
						} else {
							$product_price = get_option( 'woocommerce_tax_display_cart' ) == 'excl' ? $_product->get_price_excluding_tax() : $_product->get_price_including_tax();
						}
						?>

						<li>
							<div class="mkd-item-image-holder">
								<?php echo wp_kses( $_product->get_image(), array(
									'img' => array(
										'src'    => true,
										'width'  => true,
										'height' => true,
										'class'  => true,
										'alt'    => true,
										'title'  => true,
										'id'     => true
									)
								) ); ?>
							</div>
							<div class="mkd-item-info-holder">
								<div class="mkd-item-left">
									<a href="<?php echo esc_url( get_permalink( $cart_item['product_id'] ) ); ?>">
										<?php echo apply_filters( 'woocommerce_widget_cart_product_title', $_product->get_title(), $_product ); ?>
									</a>
									<div class="mkd-quantity-holder">
										<span class="mkd-quantity"><?php echo esc_html( $cart_item['quantity'] ); ?></span>
										<span>x</span>
										<?php echo apply_filters( 'woocommerce_cart_item_price_html', wc_price( $product_price ), $cart_item, $cart_item_key ); ?>
									</div>
								</div>
								<div class="mkd-cart-remove">
									<?php echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf('<a href="%s" class="remove" title="%s"><span class="ion-close"></span></a>', esc_url( $woocommerce->cart->get_remove_url( $cart_item_key ) ), esc_html__('Remove this item', 'buro') ), $cart_item_key ); ?>
								</div>
							</div>
						</li>

					<?php endforeach; ?>
				</ul>
					<div class="mkd-cart-bottom">
						<div class="mkd-subtotal-holder clearfix">
							<span class="mkd-total"><?php esc_html_e( 'Total', 'buro' ); ?>:</span>
								<span class="mkd-total-amount">
									<?php echo wp_kses( $woocommerce->cart->get_cart_subtotal(), array(
										'span' => array(
											'class' => true,
											'id'    => true
										)
									) ); ?>
								</span>
						</div>
						<div class="mkd-btns-holder clearfix">
							<a href="<?php echo wc_get_cart_url(); ?>"
							   class="mkd-btn-small view-cart">
							   <span class="ion-bag"></span>
								<?php esc_html_e( 'Shopping Bag', 'buro' ); ?>
							</a>
							<a href="<?php echo esc_url( wc_get_checkout_url() ); ?>"
							   class="mkd-btn-small checkout">
							   <span class="ion-ios-checkmark-outline"></span>
								<?php esc_html_e( 'Checkout', 'buro' ); ?>
							</a>
						</div>
					</div>
				<?php else : ?>

					<li class="mkd-empty-cart"><?php esc_html_e( 'No products in the cart.', 'buro' ); ?></li>
				</ul>

				<?php endif; ?>
			<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

			<?php endif; ?>


			<?php if ( sizeof( $woocommerce->cart->get_cart() ) <= 0 ) : ?>

			<?php endif; ?>
		</div>
	</div>

	<?php
	$fragments['div.mkd-shopping-cart-header'] = ob_get_clean();

	return $fragments;
}

?>