<?php
if(!function_exists('buro_mikado_design_styles')) {
    /**
     * Generates general custom styles
     */
    function buro_mikado_design_styles() {

        $preload_background_styles = array();

        if(buro_mikado_options()->getOptionValue('preload_pattern_image') !== ""){
            $preload_background_styles['background-image'] = 'url('.buro_mikado_options()->getOptionValue('preload_pattern_image').') !important';
        }else{
            $preload_background_styles['background-image'] = 'url('.esc_url(MIKADO_ASSETS_ROOT."/img/preload_pattern.png").') !important';
        }

        echo buro_mikado_dynamic_css('.mkd-preload-background', $preload_background_styles);

		if (buro_mikado_options()->getOptionValue('google_fonts')){
			$font_family = buro_mikado_options()->getOptionValue('google_fonts');
			if(buro_mikado_is_font_option_valid($font_family)) {
				echo buro_mikado_dynamic_css('body', array('font-family' => buro_mikado_get_font_option_val($font_family)));
			}
		}

		if (buro_mikado_options()->getOptionValue('google_fonts_second')){
			$second_font_family = buro_mikado_options()->getOptionValue('google_fonts_second');
			$second_font_selector = array(
				'h1',
				'h2',
				'h3',
				'h4',
				'h5',
				'h6',
				'.mkd-comment-holder .mkd-comment-text .replay',
				'.mkd-comment-holder .mkd-comment-text .comment-reply-link',
				'.mkd-comment-holder .mkd-comment-text .comment-edit-link',
				'.mkd-comment-holder .mkd-comment-text .mkd-comment-date',
				'.wpcf7-form-control.wpcf7-text',
				'.wpcf7-form-control.wpcf7-number',
				'.wpcf7-form-control.wpcf7-date',
				'.wpcf7-form-control.wpcf7-textarea',
				'.wpcf7-form-control.wpcf7-select',
				'.wpcf7-form-control.wpcf7-quiz',
				'.select2-container--default .select2-search--inline .select2-search__field',
				'#respond textarea',
				'#respond input[type="text"]',
				'.post-password-form input[type="password"]',
				'.slick-slider .mkd-slick-numbers li',
				'.mkd-404-text',
				'.mkd-main-menu > ul > li > a',
				'.mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner>ul>li>a',
				'.mkd-header-vertical .mkd-vertical-menu > ul > li > a',
				'.mkd-mobile-header .mkd-mobile-nav a',
				'.mkd-mobile-header .mkd-mobile-nav h4',
				'.mkd-title .mkd-title-holder h1',
				'nav.mkd-fullscreen-menu ul li a',
				'.mkd-search-cover input',
				'.mkd-search-cover input:focus',
				'.mkd-counter-holder .mkd-counter',
				'.countdown-section',
				'.mkd-message .mkd-message-inner .mkd-message-text .mkd-message-text-inner',
				'.mkd-testimonials.mkd-testimonials-type-buro .mkd-testimonial-text',
				'.mkd-testimonials.mkd-testimonials-type-buro .mkd-testimonials-quotes',
				'.mkd-price-table .mkd-price-table-inner ul li.mkd-table-prices .mkd-price-holder',
				'.mkd-pie-chart-holder .mkd-to-counter',
				'.mkd-pie-chart-holder .mkd-percent-sign',
				'.mkd-pie-chart-doughnut-holder .mkd-pie-legend ul li p',
				'.mkd-process-holder .mkd-process-item-holder .mkd-pi-number-holder .mkd-pi-number',
				'.mkd-tabs .mkd-tabs-nav li a',
				'.mkd-blog-list-holder .mkd-item-info-section .mkd-post-info-date',
				'.mkd-blog-slider .mkd-item-info-section .mkd-post-info-date',
				'.mkd-btn',
				'blockquote .mkd-blockquote-text',
				'.mkd-portfolio-filter-holder .mkd-portfolio-filter-holder-inner ul li span',
				'.mkd-social-share-holder.mkd-list .mkd-social-share-title',
				'.mkd-section-title',
				'.mkd-image-with-text span.mkd-iwt-title',
				'.mkd-sidebar .widget.widget_categories li',
				'.mkd-sidebar .widget.widget_archive li',
				'.mkd-sidebar .widget a',
				'.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left > div',
				'.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right > div',
				'.mkd-blog-holder article .mkd-post-mark .mkd-quote-mark-inner',
				'.mkd-blog-single-navigation .mkd-nav-holder .mkd-nav-text',
				'.woocommerce .amount',
				'.mkd-woocommerce-page .amount',
				'.woocommerce .woocommerce-result-count',
				'.mkd-woocommerce-page .woocommerce-result-count',
				'.woocommerce .added_to_cart',
				'.mkd-woocommerce-page .added_to_cart',
				'.mkd-single-product-summary .product_meta > span .mkd-info-meta-title',
				'.woocommerce-account input[type=submit]',
				'.woocommerce-checkout input[type=submit]',
				'.mkd-woocommerce-page input[type="text"]',
				'.mkd-woocommerce-page input[type="email"]',
				'.mkd-woocommerce-page input[type="tel"]',
				'.mkd-woocommerce-page input[type="password"]',
				'.mkd-woocommerce-page textarea',
				'.mkd-shopping-cart-outer .mkd-cart-amount',
				'.mkd-shopping-cart-dropdown',
				'.mkd-shopping-cart-dropdown .mkd-cart-bottom .mkd-subtotal-holder',
				'.mkd-woocommerce-page .select2-container .select2-choice',
				'.woocommerce.widget input[type=submit]',
				'.woocommerce.widget button',
				'.woocommerce.widget.widget_product_categories li',
				'.mkd-top-bar .widget',
			);
			
			if(buro_mikado_is_font_option_valid($second_font_family)) {
				echo buro_mikado_dynamic_css($second_font_selector, array('font-family' => buro_mikado_get_font_option_val($second_font_family)));
			}
		}

        if(buro_mikado_options()->getOptionValue('first_color') !== "") {
            $color_selector = array(
                'a',
                'h1 a:hover',
                'h2 a:hover',
                'h3 a:hover',
                'h4 a:hover',
                'h5 a:hover',
                'h6 a:hover',
                'p a',
                '.mkd-comment-holder .mkd-comment-text .comment-edit-link:before',
                '.mkd-comment-holder .mkd-comment-text .comment-reply-link:before',
                '.mkd-comment-holder .mkd-comment-text .replay:before',
                '.mkd-comment-holder .mkd-comment-text .comment-edit-link:hover',
                '.mkd-comment-holder .mkd-comment-text .comment-reply-link:hover',
                '.mkd-comment-holder .mkd-comment-text .replay:hover',
                '.slick-slider .mkd-slick-numbers li.slick-active',
                '.mkd-404-text',
                'span.wpcf7-not-valid-tip',
                '.mkd-main-menu>ul>li>a:hover',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li.current-menu-item>a',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li a:hover',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li h4:hover',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul.right li.current-menu-item>a',
                '.mkd-header-vertical .mkd-vertical-dropdown-float .mkd-menu-second .mkd-menu-inner ul li a:hover',
                '.mkd-header-vertical .mkd-vertical-menu>ul>li>a:hover',
                '.mkd-mobile-header .mkd-mobile-nav a:hover',
                '.mkd-mobile-header .mkd-mobile-nav h4:hover',
                '.mkd-mobile-header .mkd-mobile-menu-opener a:hover',
                'footer .mkd-light-skin .widget a:hover',
                'footer .mkd-light-skin .widget.widget_calendar #today',
                'footer .mkd-light-skin .widget.widget_mkd_twitter_widget .mkd-tweet-icon',
                'footer .mkd-dark-skin .widget a:hover',
                'footer .mkd-dark-skin .widget.widget_calendar #today',
                '.mkd-title .mkd-title-holder .mkd-breadcrumbs a:hover',
                '.mkd-side-menu .widget_calendar a',
                '.mkd-side-menu .widget_nav_menu li a:hover',
                'nav.mkd-fullscreen-menu ul li a:hover',
                'nav.mkd-fullscreen-menu ul li ul li a:hover',
                '.mkd-search-cover .mkd-search-close a:hover',
                '.mkd-fullscreen-search-holder .mkd-search-submit',
                '.mkd-portfolio-single-holder .mkd-portfolio-related-holder .mkd-portfolio-back-btn:hover span',
                '.mkd-team .mkd-team-social .mkd-icon-shortcode:hover',
                '.mkd-team.main-info-below-image .mkd-team-info .mkd-team-position',
                '.mkd-team.main-info-below-image .mkd-team-social .mkd-icon-shortcode:hover',
                '.mkd-counter-holder .mkd-counter-icon .mkd-icon-shortcode',
                '.countdown-amount',
                '.countdown-period',
                '.mkd-message .mkd-message-inner a.mkd-close',
                '.mkd-ordered-list ol>li:before',
                '.mkd-unordered-list ul>li:before',
                '.mkd-icon-list-item .mkd-icon-list-icon-holder-inner i',
                '.mkd-icon-list-item .mkd-icon-list-icon-holder-inner span',
                '.mkd-testimonials.mkd-testimonials-type-buro .mkd-testimonial-author .mkd-testimonial-author-text',
                '.mkd-price-table.mkd-active .mkd-price-table-inner ul li.mkd-table-prices .mkd-price-holder',
                '.mkd-process-holder .mkd-process-item-holder .mkd-pi-number-holder .mkd-pi-arrow',
                '.mkd-accordion-holder.mkd-style-transparent .mkd-title-holder.ui-state-active',
                '.mkd-accordion-holder.mkd-style-transparent .mkd-title-holder.ui-state-hover',
                '.mkd-blog-list-holder .mkd-item-info-section>div a:hover',
                '.mkd-blog-slider .mkd-item-info-section>div a:hover',
                '.mkd-btn.mkd-btn-transparent',
                '.mkd-btn.mkd-btn-outline',
                '.mkd-video-button-play .mkd-video-button-wrapper',
                '.mkd-dropcaps',
                '.mkd-portfolio-list-holder-outer.mkd-ptf-hover-zoom-lightbox article .mkd-item-text-holder span',
                '.mkd-iwt .mkd-icon-shortcode',
                '.mkd-portfolio-filter-holder .mkd-portfolio-filter-holder-inner ul li.active span',
                '.mkd-portfolio-filter-holder .mkd-portfolio-filter-holder-inner ul li.current span',
                '.mkd-portfolio-filter-holder .mkd-portfolio-filter-holder-inner ul li:hover span',
                '.mkd-twitter-feed .mkd-tweet-info-holder .mkd-tweeter-username',
                '.mkd-image-with-text span.mkd-iwt-title',
                '.mkd-banner:hover .mkd-banner-info .mkd-banner-title',
                '.mkd-ils .mkd-ils-item-content.active .mkd-ils-item-link',
                '.mkd-underliner-holder .mkd-underlined',
                '.widget.widget_meta a:hover',
                '.widget.widget_pages a:hover',
                '.widget.widget_recent_comments a:hover',
                '.widget.widget_calendar #next a',
                '.widget.widget_calendar #prev a',
                '.widget.widget_rss ul li a.rsswidget:hover',
                '.mkd-sidebar .widget a:hover',
                '.mkd-sidebar .widget.widget_categories li a:hover',
                '.mkd-sidebar .widget.widget_recent_entries ul li a:before',
                '.mkd-sidebar .widget.widget_archive li a:hover',
                '.mkd-twitter-widget .mkd-tweet-icon:hover',
                '.mkd-blog-holder article.sticky .mkd-post-title a',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right>div a:hover',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right>div.mkd-post-info-date',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right .mkd-like>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right .mkd-like>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right .mkd-post-info-comments>i:first-child',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right .mkd-post-info-comments>span:first-child',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-left .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-bottom-right .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-left .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-bottom .mkd-post-info-top-right .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-left .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-bottom-right .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-left .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-info-top .mkd-post-info-top-right .mkd-blog-btn-read-more',
                '.mkd-blog-holder article .mkd-post-mark',
                '.mkd-filter-blog-holder li.mkd-active',
                '.mkd-blog-single-navigation .mkd-nav-holder .mkd-nav-text',
                '.mkd-blog-single-navigation .mkd-blog-single-prev .mkd-nav-text span',
                '.mkd-blog-single-navigation a:hover .mkd-nav-title-inner',
                '.mkd-related-posts-holder .mkd-related-post .mkd-related-post-title a:hover h5',
                '.mkd-related-posts-holder .mkd-related-post .mkd-post-info-top-left>div a:hover',
                '.mkd-related-posts-holder .mkd-related-post .mkd-post-info-top-right>div a:hover',
                'body div.pp_default a.pp_next:hover',
                'body div.pp_default a.pp_previous:hover',
                '.mkd-top-bar #lang_sel li .lang_sel_sel:hover',
                '.mkd-top-bar #lang_sel ul ul a:hover',
                '.mkd-woocommerce-page .mkd-product-cat a:hover',
                '.woocommerce .mkd-product-cat a:hover',
                '.mkd-single-product-related-products-holder .products .mkd-related-glob:hover span',
                '.mkd-single-product-wrapper-top .out-of-stock',
                '.mkd-single-product-summary .product_meta>span a:hover',
                '.mkd-woocommerce-page .mkd-product-single-next:hover span',
                '.mkd-woocommerce-page .mkd-product-single-prev:hover span',
                '.summary .group_table td.label a',
                '.woocommerce-account .woocommerce-MyAccount-navigation .woocommerce-MyAccount-navigation-link.is-active a',
                '.woocommerce-account .woocommerce-MyAccount-navigation .woocommerce-MyAccount-navigation-link:hover a',
                '.mkd-shopping-cart-dropdown .mkd-item-info-holder .mkd-cart-remove a',
                '.mkd-shopping-cart-dropdown ul li a:hover',
                '.mkd-shopping-cart-dropdown .mkd-item-info-holder .mkd-item-left a:hover',
                '.mkd-shopping-cart-dropdown .mkd-cart-bottom .checkout:hover',
                '.mkd-shopping-cart-dropdown .mkd-cart-bottom .view-cart:hover',
                '.mkd-shopping-cart-dropdown .mkd-cart-bottom .checkout span',
                '.mkd-shopping-cart-dropdown .mkd-cart-bottom .view-cart span',
                '.star-rating span',
                '.product_list_widget li>a:hover',
                '.woocommerce.widget.widget_product_categories li a:hover',
                '.product_list_widget li .product-title:hover',
                '.mkd-side-menu #menu-side-area-menu li>a .mkd-menu-item-clone'
            );

            $background_color_selector = array(
                '.mkd-st-loader .pulse',
                '.mkd-st-loader .double_pulse .double-bounce1',
                '.mkd-st-loader .double_pulse .double-bounce2',
                '.mkd-st-loader .cube',
                '.mkd-st-loader .rotating_cubes .cube1',
                '.mkd-st-loader .rotating_cubes .cube2',
                '.mkd-st-loader .stripes>div',
                '.mkd-st-loader .wave>div',
                '.mkd-st-loader .two_rotating_circles .dot1',
                '.mkd-st-loader .two_rotating_circles .dot2',
                '.mkd-st-loader .five_rotating_circles .container1>div',
                '.mkd-st-loader .five_rotating_circles .container2>div',
                '.mkd-st-loader .five_rotating_circles .container3>div',
                '.mkd-st-loader .lines .line1',
                '.mkd-st-loader .lines .line2',
                '.mkd-st-loader .lines .line3',
                '.mkd-st-loader .lines .line4',
                '#submit_comment',
                '.post-password-form input[type=submit]',
                'input.wpcf7-form-control.wpcf7-submit',
                '#mkd-back-to-top>span',
                '.flex-control-paging.flex-control-nav li a .flex-active',
                '.flex-control-paging.flex-control-nav li a:hover',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li.current-menu-item>a:before',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li a:before',
                '.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li h4:before',
                '.mkd-header-vertical .mkd-vertical-dropdown-float .mkd-menu-second .mkd-menu-inner ul li a:before',
                '.mkd-header-vertical .mkd-vertical-menu>ul>li>a:before',
                '.mkd-header-vertical .mkd-vertical-menu>ul>li>a:after',
                'footer .mkd-footer-ingrid-border-holder-outer',
                'footer .mkd-dark-skin .widget.widget_tag_cloud .tagcloud a',
                '.mkd-icon-shortcode.circle',
                '.mkd-icon-shortcode.square',
                '.mkd-message',
                '.mkd-progress-bar .mkd-progress-content-outer .mkd-progress-content',
                '.mkd-progress-bar.mkd-progress-bar-light .mkd-progress-content-outer .mkd-progress-content',
                '.mkd-price-table.mkd-active .mkd-price-table-inner ul li.mkd-table-title',
                '.mkd-pie-chart-doughnut-holder .mkd-pie-legend ul li .mkd-pie-color-holder',
                '.mkd-pie-chart-pie-holder .mkd-pie-legend ul li .mkd-pie-color-holder',
                '.mkd-process-holder .mkd-process-item-holder .mkd-pi-number-holder:after',
                '.mkd-tabs .mkd-tabs-nav li.ui-state-active:after',
                '.mkd-tabs .mkd-tabs-nav li.ui-state-hover:after',
                '.mkd-tabs.mkd-tab-boxed .mkd-tabs-nav li.ui-state-active a',
                '.mkd-tabs.mkd-tab-boxed .mkd-tabs-nav li.ui-state-hover a',
                '.mkd-tabs.mkd-tab-boxed.mkd-style-grey .mkd-tabs-nav li.ui-state-active a',
                '.mkd-tabs.mkd-tab-boxed.mkd-style-grey .mkd-tabs-nav li.ui-state-hover a',
                '.mkd-tabs.mkd-tab-boxed.mkd-style-white .mkd-tabs-nav li.ui-state-active a',
                '.mkd-tabs.mkd-tab-boxed.mkd-style-white .mkd-tabs-nav li.ui-state-hover a',
                '.mkd-accordion-holder .mkd-title-holder.ui-state-active',
                '.mkd-accordion-holder .mkd-title-holder.ui-state-hover',
                '.mkd-accordion-holder.mkd-style-grey .mkd-title-holder.ui-state-active',
                '.mkd-accordion-holder.mkd-style-grey .mkd-title-holder.ui-state-hover',
                '.mkd-accordion-holder.mkd-style-white .mkd-title-holder.ui-state-active',
                '.mkd-accordion-holder.mkd-style-white .mkd-title-holder.ui-state-hover',
                '.mkd-btn.add_to_cart_button.mkd-btn-bckg-hover:hover',
                'input[type=submit].mkd-btn',
                '.mkd-video-button-play .mkd-video-button-wrapper:hover',
                '.mkd-dropcaps.mkd-circle',
                '.mkd-dropcaps.mkd-square',
                '.mkd-underliner-holder .mkd-underlined:after',
                '.mkd-ils .mkd-ils-item-link:after',
                '.widget .tagcloud a:hover',
                '.widget.widget_calendar td a',
                '.mkd-blog-holder article.format-link .mkd-post-text',
                '.mkd-blog-holder article.format-quote .mkd-post-text:hover',
                '.mkd-woocommerce-page .product .mkd-product-badge.mkd-onsale',
                '.woocommerce .product .mkd-product-badge.mkd-onsale',
                '.mkd-woocommerce-page .added_to_cart:hover',
                '.woocommerce .added_to_cart:hover',
                '.mkd-shopping-cart-outer .mkd-cart-amount',
                '.mkd-dark-header .mkd-page-header>div:not(.mkd-sticky-header) .mkd-shopping-cart-header .mkd-header-cart>.mkd-cart-amount',
                '.woocommerce.widget .buttons .wc-forward',
                '.woocommerce.widget button',
                '.woocommerce.widget input[type=submit]',
                '.mkd-tabs.mkd-horizontal-tab:not(.mkd-tab-boxed) .mkd-tabs-nav li:not(.mkd-border-active).mkd-tabs-line'
            );

            $background_color_important_selector = array(
                'input[type=submit].mkd-btn.mkd-btn-huge-full-width:hover',
            );

            $border_bottom_color_selector = array(
                '.mkd-accordion-holder.mkd-style-transparent .mkd-title-holder.ui-state-active',
                '.mkd-accordion-holder.mkd-style-transparent .mkd-title-holder.ui-state-hover',
                '.mkd-separator'
            );

            $border_top_color_selector = array(
                '.mkd-shopping-cart-dropdown'
            );

            $border_color_selector = array(
                '.mkd-st-loader .pulse_circles .ball',
                '#respond input[type=text]:focus',
                '#respond textarea:focus',
                '.post-password-form input[type=password]:focus',
                '.wpcf7-form-control.wpcf7-date:focus',
                '.wpcf7-form-control.wpcf7-number:focus',
                '.wpcf7-form-control.wpcf7-quiz:focus',
                '.wpcf7-form-control.wpcf7-select:focus',
                '.wpcf7-form-control.wpcf7-text:focus',
                '.wpcf7-form-control.wpcf7-textarea:focus',
                '#submit_comment',
                '.post-password-form input[type=submit]',
                'input.wpcf7-form-control.wpcf7-submit',
                '.flex-control-paging.flex-control-nav li a',
                'div.wpcf7-validation-errors',
                '.mkd-message',
                '.mkd-btn.mkd-btn-outline',
                '.mkd-woocommerce-page .mkd-quantity-buttons .mkd-quantity-input:focus',
                '.mkd-woocommerce-page input[type=email]:focus',
                '.mkd-woocommerce-page input[type=tel]:focus',
                '.mkd-woocommerce-page input[type=password]:focus',
                '.mkd-woocommerce-page input[type=text]:focus',
                '.mkd-woocommerce-page textarea:focus',
                '.woocommerce.widget button',
                '.woocommerce.widget input[type=submit]',
            );

            echo buro_mikado_dynamic_css($color_selector, array('color' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css('::selection', array('background' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css('::-moz-selection', array('background' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css($background_color_selector, array('background-color' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css($background_color_important_selector, array('background-color' => buro_mikado_options()->getOptionValue('first_color').'!important'));
            echo buro_mikado_dynamic_css($border_color_selector, array('border-color' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css($border_bottom_color_selector, array('border-bottom-color' => buro_mikado_options()->getOptionValue('first_color')));
            echo buro_mikado_dynamic_css($border_top_color_selector, array('border-top-color' => buro_mikado_options()->getOptionValue('first_color')));
        }

        if(buro_mikado_options()->getOptionValue('second_color') !== "") {
            $color_selector = array(
				'.mkd-main-menu>ul>li>a .mkd-item-outer:before',
				'.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li a:not(.mkd-no-link):not(.mkd-image-widget-link):before',
				'.mkd-drop-down .mkd-menu-second .mkd-menu-inner ul.right li a:not(.mkd-no-link):not(.mkd-image-widget-link):before',
				'.mkd-header-vertical .mkd-vertical-menu ul li>a .mkd-item-outer:before',
				'.mkd-team .mkd-team-social .mkd-icon-shortcode:hover',
				'.mkd-custom-font-holder .mkd-highlighted',
				'.mkd-unordered-list ul>li:before',
				'.mkd-testimonials .mkd-slick-next',
				'.mkd-testimonials .mkd-slick-prev',
				'.mkd-btn.mkd-btn-transparent .mkd-btn-icon-holder',
				'.mkd-carousel-holder .mkd-slick-next',
				'.mkd-carousel-holder .mkd-slick-prev',
				'.mkd-section-title .mkd-section-highlighted',
				'.mkd-sidebar .widget.widget_recent_entries ul li a:before',
            );

            $background_color_selector = array(
				'#submit_comment:hover',
				'.post-password-form input[type=submit]:hover',
				'input.wpcf7-form-control.wpcf7-submit:hover',
				'#mkd-back-to-top:hover>span',
				'.mkd-btn.mkd-btn-solid',
				'.woocommerce-account input[type=submit]:hover',
				'.woocommerce-checkout input[type=submit]:hover',
				'.woocommerce.widget button:hover',
				'.woocommerce.widget input[type=submit]:hover',
                '.mkd-iwt .mkd-icon-shortcode.circle:hover',
                '.mkd-iwt .mkd-icon-shortcode.square:hover',
				'.mkd-blog-holder article.format-link:hover .mkd-post-text',
				'.mkd-blog-holder article.format-quote:hover .mkd-post-text',
            );

            $background_color_important_selector = array(
				'.mkd-btn.mkd-btn-solid.mkd-btn-frst-clr.mkd-btn-bckg-hover:hover',
				'input[type=submit].mkd-btn.mkd-btn-bckg-hover:hover',
            );

            $border_color_selector = array(
				'#submit_comment:hover',
				'.post-password-form input[type=submit]:hover',
				'input.wpcf7-form-control.wpcf7-submit:hover',
				'.mkd-team.main-info-on-hover .mkd-separator',
				'.mkd-testimonials.mkd-testimonials-type-buro .mkd-separator',
				'.woocommerce-account input[type=submit]:hover',
				'.woocommerce-checkout input[type=submit]:hover',
				'.woocommerce.widget button:hover',
				'.woocommerce.widget input[type=submit]:hover',
            );

            echo buro_mikado_dynamic_css($color_selector, array('color' => buro_mikado_options()->getOptionValue('second_color')));
            echo buro_mikado_dynamic_css($background_color_selector, array('background-color' => buro_mikado_options()->getOptionValue('second_color')));
            echo buro_mikado_dynamic_css($background_color_important_selector, array('background-color' => buro_mikado_options()->getOptionValue('second_color').'!important'));
            echo buro_mikado_dynamic_css($border_color_selector, array('border-color' => buro_mikado_options()->getOptionValue('second_color')));
        }
		if (buro_mikado_options()->getOptionValue('page_background_color')) {
			$background_color_selector = array(
				'.mkd-wrapper-inner',
				'.mkd-content',
				'.mkd-content-inner > .mkd-container'
			);
			echo buro_mikado_dynamic_css($background_color_selector, array('background-color' => buro_mikado_options()->getOptionValue('page_background_color')));
		}

		if (buro_mikado_options()->getOptionValue('selection_color')) {
			echo buro_mikado_dynamic_css('::selection', array('background' => buro_mikado_options()->getOptionValue('selection_color')));
			echo buro_mikado_dynamic_css('::-moz-selection', array('background' => buro_mikado_options()->getOptionValue('selection_color')));
		}

		$boxed_background_style = array();
		if (buro_mikado_options()->getOptionValue('page_background_color_in_box')) {
			$boxed_background_style['background-color'] = buro_mikado_options()->getOptionValue('page_background_color_in_box');
		}

		if (buro_mikado_options()->getOptionValue('boxed_background_image')) {
			$boxed_background_style['background-image'] = 'url('.esc_url(buro_mikado_options()->getOptionValue('boxed_background_image')).')';
			if(buro_mikado_options()->getOptionValue('boxed_background_image_repeating') == 'yes') {
				$boxed_background_style['background-position'] = '0px 0px';
				$boxed_background_style['background-repeat'] = 'repeat';
			} else {
				$boxed_background_style['background-position'] = 'center 0px';
				$boxed_background_style['background-repeat'] = 'no-repeat';
			}
		}


		if (buro_mikado_options()->getOptionValue('boxed_background_image_attachment')) {
			$boxed_background_style['background-attachment'] = (buro_mikado_options()->getOptionValue('boxed_background_image_attachment'));
		}

		echo buro_mikado_dynamic_css('.mkd-boxed .mkd-wrapper', $boxed_background_style);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_design_styles');
}

if (!function_exists('buro_mikado_h1_styles')) {

    function buro_mikado_h1_styles() {

        $h1_styles = array();

        if(buro_mikado_options()->getOptionValue('h1_color') !== '') {
            $h1_styles['color'] = buro_mikado_options()->getOptionValue('h1_color');
        }
        if(buro_mikado_options()->getOptionValue('h1_google_fonts') !== '-1') {
            $h1_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h1_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h1_fontsize') !== '') {
            $h1_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h1_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h1_lineheight') !== '') {
            $h1_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h1_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h1_texttransform') !== '') {
            $h1_styles['text-transform'] = buro_mikado_options()->getOptionValue('h1_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h1_fontstyle') !== '') {
            $h1_styles['font-style'] = buro_mikado_options()->getOptionValue('h1_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h1_fontweight') !== '') {
            $h1_styles['font-weight'] = buro_mikado_options()->getOptionValue('h1_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h1_letterspacing') !== '') {
            $h1_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h1_letterspacing')).'px';
        }

        $h1_selector = array(
            'h1'
        );

        if (!empty($h1_styles)) {
            echo buro_mikado_dynamic_css($h1_selector, $h1_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h1_styles');
}

if (!function_exists('buro_mikado_h2_styles')) {

    function buro_mikado_h2_styles() {

        $h2_styles = array();

        if(buro_mikado_options()->getOptionValue('h2_color') !== '') {
            $h2_styles['color'] = buro_mikado_options()->getOptionValue('h2_color');
        }
        if(buro_mikado_options()->getOptionValue('h2_google_fonts') !== '-1') {
            $h2_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h2_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h2_fontsize') !== '') {
            $h2_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h2_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h2_lineheight') !== '') {
            $h2_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h2_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h2_texttransform') !== '') {
            $h2_styles['text-transform'] = buro_mikado_options()->getOptionValue('h2_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h2_fontstyle') !== '') {
            $h2_styles['font-style'] = buro_mikado_options()->getOptionValue('h2_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h2_fontweight') !== '') {
            $h2_styles['font-weight'] = buro_mikado_options()->getOptionValue('h2_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h2_letterspacing') !== '') {
            $h2_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h2_letterspacing')).'px';
        }

        $h2_selector = array(
            'h2'
        );

        if (!empty($h2_styles)) {
            echo buro_mikado_dynamic_css($h2_selector, $h2_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h2_styles');
}

if (!function_exists('buro_mikado_h3_styles')) {

    function buro_mikado_h3_styles() {

        $h3_styles = array();

        if(buro_mikado_options()->getOptionValue('h3_color') !== '') {
            $h3_styles['color'] = buro_mikado_options()->getOptionValue('h3_color');
        }
        if(buro_mikado_options()->getOptionValue('h3_google_fonts') !== '-1') {
            $h3_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h3_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h3_fontsize') !== '') {
            $h3_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h3_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h3_lineheight') !== '') {
            $h3_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h3_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h3_texttransform') !== '') {
            $h3_styles['text-transform'] = buro_mikado_options()->getOptionValue('h3_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h3_fontstyle') !== '') {
            $h3_styles['font-style'] = buro_mikado_options()->getOptionValue('h3_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h3_fontweight') !== '') {
            $h3_styles['font-weight'] = buro_mikado_options()->getOptionValue('h3_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h3_letterspacing') !== '') {
            $h3_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h3_letterspacing')).'px';
        }

        $h3_selector = array(
            'h3'
        );

        if (!empty($h3_styles)) {
            echo buro_mikado_dynamic_css($h3_selector, $h3_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h3_styles');
}

if (!function_exists('buro_mikado_h4_styles')) {

    function buro_mikado_h4_styles() {

        $h4_styles = array();

        if(buro_mikado_options()->getOptionValue('h4_color') !== '') {
            $h4_styles['color'] = buro_mikado_options()->getOptionValue('h4_color');
        }
        if(buro_mikado_options()->getOptionValue('h4_google_fonts') !== '-1') {
            $h4_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h4_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h4_fontsize') !== '') {
            $h4_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h4_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h4_lineheight') !== '') {
            $h4_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h4_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h4_texttransform') !== '') {
            $h4_styles['text-transform'] = buro_mikado_options()->getOptionValue('h4_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h4_fontstyle') !== '') {
            $h4_styles['font-style'] = buro_mikado_options()->getOptionValue('h4_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h4_fontweight') !== '') {
            $h4_styles['font-weight'] = buro_mikado_options()->getOptionValue('h4_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h4_letterspacing') !== '') {
            $h4_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h4_letterspacing')).'px';
        }

        $h4_selector = array(
            'h4'
        );

        if (!empty($h4_styles)) {
            echo buro_mikado_dynamic_css($h4_selector, $h4_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h4_styles');
}

if (!function_exists('buro_mikado_h5_styles')) {

    function buro_mikado_h5_styles() {

        $h5_styles = array();

        if(buro_mikado_options()->getOptionValue('h5_color') !== '') {
            $h5_styles['color'] = buro_mikado_options()->getOptionValue('h5_color');
        }
        if(buro_mikado_options()->getOptionValue('h5_google_fonts') !== '-1') {
            $h5_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h5_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h5_fontsize') !== '') {
            $h5_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h5_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h5_lineheight') !== '') {
            $h5_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h5_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h5_texttransform') !== '') {
            $h5_styles['text-transform'] = buro_mikado_options()->getOptionValue('h5_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h5_fontstyle') !== '') {
            $h5_styles['font-style'] = buro_mikado_options()->getOptionValue('h5_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h5_fontweight') !== '') {
            $h5_styles['font-weight'] = buro_mikado_options()->getOptionValue('h5_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h5_letterspacing') !== '') {
            $h5_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h5_letterspacing')).'px';
        }

        $h5_selector = array(
            'h5'
        );

        if (!empty($h5_styles)) {
            echo buro_mikado_dynamic_css($h5_selector, $h5_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h5_styles');
}

if (!function_exists('buro_mikado_h6_styles')) {

    function buro_mikado_h6_styles() {

        $h6_styles = array();

        if(buro_mikado_options()->getOptionValue('h6_color') !== '') {
            $h6_styles['color'] = buro_mikado_options()->getOptionValue('h6_color');
        }
        if(buro_mikado_options()->getOptionValue('h6_google_fonts') !== '-1') {
            $h6_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('h6_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('h6_fontsize') !== '') {
            $h6_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h6_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h6_lineheight') !== '') {
            $h6_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h6_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('h6_texttransform') !== '') {
            $h6_styles['text-transform'] = buro_mikado_options()->getOptionValue('h6_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('h6_fontstyle') !== '') {
            $h6_styles['font-style'] = buro_mikado_options()->getOptionValue('h6_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('h6_fontweight') !== '') {
            $h6_styles['font-weight'] = buro_mikado_options()->getOptionValue('h6_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('h6_letterspacing') !== '') {
            $h6_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('h6_letterspacing')).'px';
        }

        $h6_selector = array(
            'h6'
        );

        if (!empty($h6_styles)) {
            echo buro_mikado_dynamic_css($h6_selector, $h6_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_h6_styles');
}

if (!function_exists('buro_mikado_text_styles')) {

    function buro_mikado_text_styles() {

        $text_styles = array();

        if(buro_mikado_options()->getOptionValue('text_color') !== '') {
            $text_styles['color'] = buro_mikado_options()->getOptionValue('text_color');
        }
        if(buro_mikado_options()->getOptionValue('text_google_fonts') !== '-1') {
            $text_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('text_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('text_fontsize') !== '') {
            $text_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('text_fontsize')).'px';
        }
        if(buro_mikado_options()->getOptionValue('text_lineheight') !== '') {
            $text_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('text_lineheight')).'px';
        }
        if(buro_mikado_options()->getOptionValue('text_texttransform') !== '') {
            $text_styles['text-transform'] = buro_mikado_options()->getOptionValue('text_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('text_fontstyle') !== '') {
            $text_styles['font-style'] = buro_mikado_options()->getOptionValue('text_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('text_fontweight') !== '') {
            $text_styles['font-weight'] = buro_mikado_options()->getOptionValue('text_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('text_letterspacing') !== '') {
            $text_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('text_letterspacing')).'px';
        }

        $text_selector = array(
            'p'
        );

        if (!empty($text_styles)) {
            echo buro_mikado_dynamic_css($text_selector, $text_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_text_styles');
}

if (!function_exists('buro_mikado_link_styles')) {

    function buro_mikado_link_styles() {

        $link_styles = array();

        if(buro_mikado_options()->getOptionValue('link_color') !== '') {
            $link_styles['color'] = buro_mikado_options()->getOptionValue('link_color');
        }
        if(buro_mikado_options()->getOptionValue('link_fontstyle') !== '') {
            $link_styles['font-style'] = buro_mikado_options()->getOptionValue('link_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('link_fontweight') !== '') {
            $link_styles['font-weight'] = buro_mikado_options()->getOptionValue('link_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('link_fontdecoration') !== '') {
            $link_styles['text-decoration'] = buro_mikado_options()->getOptionValue('link_fontdecoration');
        }

        $link_selector = array(
            'a',
            'p a'
        );

        if (!empty($link_styles)) {
            echo buro_mikado_dynamic_css($link_selector, $link_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_link_styles');
}

if (!function_exists('buro_mikado_link_hover_styles')) {

    function buro_mikado_link_hover_styles() {

        $link_hover_styles = array();

        if(buro_mikado_options()->getOptionValue('link_hovercolor') !== '') {
            $link_hover_styles['color'] = buro_mikado_options()->getOptionValue('link_hovercolor');
        }
        if(buro_mikado_options()->getOptionValue('link_hover_fontdecoration') !== '') {
            $link_hover_styles['text-decoration'] = buro_mikado_options()->getOptionValue('link_hover_fontdecoration');
        }

        $link_hover_selector = array(
            'a:hover',
            'p a:hover'
        );

        if (!empty($link_hover_styles)) {
            echo buro_mikado_dynamic_css($link_hover_selector, $link_hover_styles);
        }

        $link_heading_hover_styles = array();

        if(buro_mikado_options()->getOptionValue('link_hovercolor') !== '') {
            $link_heading_hover_styles['color'] = buro_mikado_options()->getOptionValue('link_hovercolor');
        }

        $link_heading_hover_selector = array(
            'h1 a:hover',
            'h2 a:hover',
            'h3 a:hover',
            'h4 a:hover',
            'h5 a:hover',
            'h6 a:hover'
        );

        if (!empty($link_heading_hover_styles)) {
            echo buro_mikado_dynamic_css($link_heading_hover_selector, $link_heading_hover_styles);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_link_hover_styles');
}

if (!function_exists('buro_mikado_smooth_page_transition_styles')) {

    function buro_mikado_smooth_page_transition_styles() {
        
        $loader_style = array();

        if(buro_mikado_options()->getOptionValue('smooth_pt_bgnd_color') !== '') {
            $loader_style['background-color'] = buro_mikado_options()->getOptionValue('smooth_pt_bgnd_color');
        }

        $loader_selector = array('.mkd-smooth-transition-loader');

        if (!empty($loader_style)) {
            echo buro_mikado_dynamic_css($loader_selector, $loader_style);
        }

        $spinner_style = array();

        if(buro_mikado_options()->getOptionValue('smooth_pt_spinner_color') !== '') {
            $spinner_style['background-color'] = buro_mikado_options()->getOptionValue('smooth_pt_spinner_color');
        }

        $spinner_selectors = array(
            '.mkd-st-loader .pulse',
            '.mkd-st-loader .double_pulse .double-bounce1',
            '.mkd-st-loader .double_pulse .double-bounce2',
            '.mkd-st-loader .cube',
            '.mkd-st-loader .rotating_cubes .cube1',
            '.mkd-st-loader .rotating_cubes .cube2',
            '.mkd-st-loader .stripes > div',
            '.mkd-st-loader .wave > div',
            '.mkd-st-loader .two_rotating_circles .dot1',
            '.mkd-st-loader .two_rotating_circles .dot2',
            '.mkd-st-loader .five_rotating_circles .container1 > div',
            '.mkd-st-loader .five_rotating_circles .container2 > div',
            '.mkd-st-loader .five_rotating_circles .container3 > div',
            '.mkd-st-loader .atom .ball-1:before',
            '.mkd-st-loader .atom .ball-2:before',
            '.mkd-st-loader .atom .ball-3:before',
            '.mkd-st-loader .atom .ball-4:before',
            '.mkd-st-loader .clock .ball:before',
            '.mkd-st-loader .mitosis .ball',
            '.mkd-st-loader .lines .line1',
            '.mkd-st-loader .lines .line2',
            '.mkd-st-loader .lines .line3',
            '.mkd-st-loader .lines .line4',
            '.mkd-st-loader .fussion .ball',
            '.mkd-st-loader .fussion .ball-1',
            '.mkd-st-loader .fussion .ball-2',
            '.mkd-st-loader .fussion .ball-3',
            '.mkd-st-loader .fussion .ball-4',
            '.mkd-st-loader .wave_circles .ball',
            '.mkd-st-loader .pulse_circles .ball'
        );

        if (!empty($spinner_style)) {
            echo buro_mikado_dynamic_css($spinner_selectors, $spinner_style);
        }
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_smooth_page_transition_styles');
}