(function($) {
    'use strict';

    var portfolio = {};
    mkd.modules.portfolio = portfolio;

    portfolio.mkdOnDocumentReady = mkdOnDocumentReady;
    portfolio.mkdOnWindowLoad = mkdOnWindowLoad;
    portfolio.mkdOnWindowResize = mkdOnWindowResize;
    portfolio.mkdOnWindowScroll = mkdOnWindowScroll;

    portfolio.mkdPortfolioSingleMasonry = mkdPortfolioSingleMasonry;
    portfolio.mkdPortfolioWideSlider = mkdPortfolioWideSlider;
    portfolio.mkdPortfolioRelatedProducts = mkdPortfolioRelatedProducts;

    $(document).ready(mkdOnDocumentReady);
    $(window).load(mkdOnWindowLoad);
    $(window).resize(mkdOnWindowResize);
    $(window).scroll(mkdOnWindowScroll);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function mkdOnDocumentReady() {
        mkdPortfolioSingleMasonry();
        mkdPortfolioWideSlider();
        mkdPortfolioFullScreenSlider().init();
        mkdPortfolioRelatedProducts();
    }

    /* 
        All functions to be called on $(window).load() should be in this function
    */
    function mkdOnWindowLoad() {
        mkdPortfolioSingleFollow().init();
        mkdPortfolioSingleStick().init();
    }

    /* 
        All functions to be called on $(window).resize() should be in this function
    */
    function mkdOnWindowResize() {

    }

    /* 
        All functions to be called on $(window).scroll() should be in this function
    */
    function mkdOnWindowScroll() {

    }



    var mkdPortfolioSingleFollow = function() {

        var info = $('.mkd-follow-portfolio-info .small-images.mkd-portfolio-single-holder .mkd-portfolio-info-holder, ' +
            '.mkd-follow-portfolio-info .small-slider.mkd-portfolio-single-holder .mkd-portfolio-info-holder, ' +
            '.mkd-follow-portfolio-info .small-masonry.mkd-portfolio-single-holder .mkd-portfolio-info-holder, ' +
            '.mkd-follow-portfolio-info .wide-images.mkd-portfolio-single-holder .mkd-portfolio-info-holder, ' +
            '.mkd-follow-portfolio-info .gallery.mkd-portfolio-single-holder .mkd-portfolio-info-holder');

        if (info.length) {
            var infoHolder = info.parent(),
                infoHolderOffset = infoHolder.offset().top,
                infoHolderHeight = infoHolder.height(),
                mediaHolder = $('.mkd-portfolio-media'),
                mediaHolderHeight = mediaHolder.height(),
                header = $('.header-appear, .mkd-fixed-wrapper'),
                headerHeight = (header.length) ? header.height() : 0;
        }

        var infoHolderPosition = function() {

            if(info.length && mkd.windowWidth > 1024) {

                if (mediaHolderHeight > infoHolderHeight) {
                    if(mkd.scroll > infoHolderOffset) {
                        var marginTop = mkd.scroll - infoHolderOffset + mkdGlobalVars.vars.mkdAddForAdminBar + headerHeight + 20; //20 px is for styling, spacing between header and info holder
                        // if scroll is initially positioned below mediaHolderHeight
                        if(marginTop + infoHolderHeight > mediaHolderHeight){
                            marginTop = mediaHolderHeight - infoHolderHeight;
                        }
                        info.animate({
                            marginTop: marginTop
                        });
                    }
                }

            }
        };

        var recalculateInfoHolderPosition = function() {

            if (info.length && mkd.windowWidth > 1024) {
                if(mediaHolderHeight > infoHolderHeight) {
                    if(mkd.scroll > infoHolderOffset) {

                        if(mkd.scroll + headerHeight + mkdGlobalVars.vars.mkdAddForAdminBar + infoHolderHeight + 100 < infoHolderOffset + mediaHolderHeight) {    //70 to prevent mispositioning

                            //Calculate header height if header appears
                            if ($('.header-appear, .mkd-fixed-wrapper').length) {
                                headerHeight = $('.header-appear, .mkd-fixed-wrapper').height();
                            }
                            info.stop().animate({
                                marginTop: (mkd.scroll - infoHolderOffset + mkdGlobalVars.vars.mkdAddForAdminBar + headerHeight + 20) //20 px is for styling, spacing between header and info holder
                            });
                            //Reset header height
                            headerHeight = 0;
                        }
                        else{
                            info.stop().animate({
                                marginTop: mediaHolderHeight - infoHolderHeight
                            });
                        }
                    } else {
                        info.stop().animate({
                            marginTop: 0
                        });
                    }
                }
            }
        };

        return {

            init : function() {

                infoHolderPosition();
                $(window).scroll(function(){
                    recalculateInfoHolderPosition();
                });

            }

        };

    };

    /**
     * Init Portfolio Single Masonry
     */
    function mkdPortfolioSingleMasonry(){
        var gallery = $('.mkd-portfolio-single-holder.small-masonry .mkd-portfolio-media, .mkd-portfolio-single-holder.big-masonry .mkd-portfolio-media');

        if(gallery.length) {
            gallery.each(function () {
                var thisGallery = $(this);
                thisGallery.waitForImages(function () {
                    var size = thisGallery.find('.mkd-single-masonry-grid-sizer').width();
                    mkdPortfolioSingleResizeMasonry(size,thisGallery);
                    mkdInitSingleMasonry(thisGallery);

                });
                $(window).resize(function(){
                    var size = thisGallery.find('.mkd-single-masonry-grid-sizer').width();
                    mkdPortfolioSingleResizeMasonry(size,thisGallery);
                    mkdInitSingleMasonry(thisGallery);
                });
            });
        }
    }

    function mkdInitSingleMasonry(container){
        container.animate({opacity: 1});
        container.isotope({
            itemSelector: '.mkd-portfolio-single-media',
            masonry: {
                columnWidth: '.mkd-single-masonry-grid-sizer'
            }
        });
    }


    function mkdPortfolioSingleResizeMasonry(size,container){

        var defaultMasonryItem = container.find('.mkd-default-masonry-item');
        var largeWidthMasonryItem = container.find('.mkd-large-width-masonry-item');
        var largeHeightMasonryItem = container.find('.mkd-large-height-masonry-item');
        var largeWidthHeightMasonryItem = container.find('.mkd-large-width-height-masonry-item');

        defaultMasonryItem.css('height', size);
        largeHeightMasonryItem.css('height', Math.round(2*size));

        if(mkd.windowWidth > 600){
            largeWidthHeightMasonryItem.css('height', Math.round(2*size));
            largeWidthMasonryItem.css('height', size);
        }else{
            largeWidthHeightMasonryItem.css('height', size);
            largeWidthMasonryItem.css('height', Math.round(size/2));
        }
    }

    function mkdPortfolioRelatedProducts(){
		var relatedProducts = $('.mkd-portfolio-related-holder');

		if (relatedProducts.length){
			var prevArrow = relatedProducts.find('.mkd-related-prev'),
				nextArrow = relatedProducts.find('.mkd-related-next'),
				prevSlick = relatedProducts.find('.mkd-slick-prev'),
				nextSlick = relatedProducts.find('.mkd-slick-next');

			prevArrow.on('click', function(){
				prevSlick.trigger("click");
			});

			nextArrow.on('click', function(){
				nextSlick.trigger("click");
			});
		}
    }


    function mkdPortfolioWideSlider(){
    	var wideSlider = $('.mkd-ptf-wide-slider');

    	if (wideSlider.length){

    		wideSlider.slick({
				infinite: true,
				autoplay: true,
				slidesToShow : 3,
				centerMode: true,
				arrows: true,
				dots: false,
				adaptiveHeight: true,
				prevArrow: '<span class="mkd-slick-prev mkd-prev-icon"><span class="arrow_carrot-left"></span></span>',
				nextArrow: '<span class="mkd-slick-next mkd-next-icon"><span class="arrow_carrot-right"></span></span>'
			});
    	}
    }
        /* Portfolio Single Split*/
    var mkdPortfolioSingleStick = function(){
    	var portfolioSplit = $('.mkd-portfolio-single-holder.split-screen');
        var info = $('.mkd-follow-portfolio-info .split-screen.mkd-portfolio-single-holder .mkd-portfolio-info-holder');
        if (info.length && mkd.htmlEl.hasClass('no-touch')) {
            var infoHolder = info.parent(),
                infoHolderOffset = infoHolder.offset().top,
                infoHolderHeight = info.outerHeight() + 100, //30 is some default margin
                mediaHolder = $('.mkd-portfolio-media'),
                mediaHolderHeight = mediaHolder.height(),
                header = $('.mkd-page-header'),
                fixedHeader = header.find('.mkd-fixed-wrapper'),
                headerHeight = (header.length) ? header.height() : 0,
                fixedHeaderHeight = (fixedHeader.length) ? fixedHeader.height() : 0,
                infoHolderOffsetAfterScroll = headerHeight + 15; //15 is some default margin

        }

        var infoWidth = function() {
			if(info.length && mkd.htmlEl.hasClass('no-touch')){
				info.css('width',info.width());
			}
        };


        var initInfoHolder = function(){
            if(info.length && mkd.htmlEl.hasClass('no-touch')){
				var stickyActive = header.find('.mkd-sticky-header');
				if (stickyActive.length){
					if (!stickyActive.hasClass('header-appear')){
						var headerVisible = (headerHeight - mkd.scroll) > 0 ? true : false;
						if (headerVisible){
							infoHolderOffsetAfterScroll = mkdGlobalVars.vars.mkdAddForAdminBar + headerHeight - 5; // 5 is designer wishes
						}
						else{
							infoHolderOffsetAfterScroll = 24;
						}
					}
					else{
						infoHolderOffsetAfterScroll = mkdGlobalVars.vars.mkdStickyHeaderTransparencyHeight + mkdGlobalVars.vars.mkdAddForAdminBar + 15;
					}
				}
				else if (fixedHeader.length){
					infoHolderOffsetAfterScroll = mkdGlobalVars.vars.mkdAddForAdminBar + fixedHeaderHeight + 15; // 5 is designer wishes
				}
				if(info.length && mediaHolderHeight > infoHolderHeight && mkd.htmlEl.hasClass('no-touch')) {
					info.css('top',infoHolderOffsetAfterScroll+'px');
				}
			}
        };

        var calcInfoHolderPosition = function(){
            if(info.length && mkd.htmlEl.hasClass('no-touch')){
                infoHolderHeight = info.outerHeight() + 30;
                mediaHolderHeight = mediaHolder.height();

                if(mediaHolderHeight > infoHolderHeight && mkd.htmlEl.hasClass('no-touch')) {
                	if (fixedHeader.length){
                		headerHeight = fixedHeaderHeight;
                	}
            		if(mkd.scroll >= infoHolderOffset - headerHeight - mkdGlobalVars.vars.mkdAddForAdminBar){
            			if (info.css('position') !== 'fixed'){
							info.css('position','fixed');
							if (mkd.scroll > 0) {
								info.addClass('mkd-animating');
								info.one('webkitAnimationEnd oanimationend msAnimationEnd animationend', function(){
									info.removeClass('mkd-animating');
								});
							}
						}
                    }else{
                        info.css('position','static');
                    }

                    if(infoHolderOffset+mediaHolderHeight<=mkd.scroll+infoHolderHeight + infoHolderOffsetAfterScroll){
                        info.stop().css('margin-top',infoHolderOffset + mediaHolderHeight - mkd.scroll - infoHolderHeight - infoHolderOffsetAfterScroll+'px');
                    }else{
                        info.css('margin-top','0');
                    }
                }
				if (!info.hasClass('mkd-appeared')){
					info.addClass('mkd-appeared');
				}
            }
            else if (mkd.htmlEl.hasClass('touch')){
				if (!info.hasClass('mkd-appeared')){
					info.addClass('mkd-appeared');
				}
            }
        };

        return {
            init: function(){
				if (portfolioSplit.length){
					infoWidth();
					calcInfoHolderPosition();
					initInfoHolder();
					$(window).scroll(function(){
						calcInfoHolderPosition();
						initInfoHolder();
					});
					$(window).resize(function(){
						initInfoHolder();
						calcInfoHolderPosition();
					});
				}
            }
        };
    };
    /**
     * Init Full Screen Slider
     */
    var mkdPortfolioFullScreenSlider = function() {

        var sliderHolder = $('.mkd-full-screen-slider-holder');
        var content = $('.mkd-wrapper .mkd-content');

        var sliders = $('.mkd-portfolio-full-screen-slider');
        var fullScreenSliderHolder = $('.full-screen-slider');

        var mkdFullScreenSliderHeight = function() {
            if (sliderHolder.length) {

                var contentMargin = parseInt(content.css('margin-top')),
                	imageHolder = sliderHolder.find('.mkd-portfolio-single-media'),
                	title = $('.mkd-title'),
                	paspartuHeight = 0,
                	sliderHeight = mkd.windowHeight;


                if (mkd.body.hasClass('mkd-passepartout')){
                	var paspartu = $('.mkd-passepartout-top');

                	paspartuHeight = paspartu.outerHeight() * 2;
                	sliderHeight -= paspartuHeight;
                }

                if (title.length){
                	sliderHeight -= title.height();
                }

                if(mkd.windowWidth > 1024) {
                    if(contentMargin >= 0) {
                        sliderHeight -= mkdGlobalVars.vars.mkdMenuAreaHeight;
                    }
                }
                else {
                    sliderHeight -= mkdGlobalVars.vars.mkdMobileHeaderHeight;
                }

                fullScreenSliderHolder.css("height", sliderHeight);
                sliderHolder.css("height", sliderHeight);
                imageHolder.css("height", sliderHeight);
            }
        };

        var mkdFullScreenSlider = function() {

            if (sliderHolder.length) {
                sliders.each(function () {
                    var slider = $(this);


                    slider.on('init', function(slick){
						var activeSlide = slider.find('.slick-active.mkd-portfolio-single-media');
                        if(activeSlide.hasClass('mkd-slide-dark-skin')){
                            slider.removeClass('mkd-slide-light-skin').addClass('mkd-slide-dark-skin');
                        }else{
                            slider.removeClass('mkd-slide-dark-skin').addClass('mkd-slide-light-skin');
                        }
					});

                    slider.on('afterChange', function(slick, currentSlide){
						var activeSlide = slider.find('.slick-active.mkd-portfolio-single-media');
                        if(activeSlide.hasClass('mkd-slide-dark-skin')){
                            slider.removeClass('mkd-slide-light-skin').addClass('mkd-slide-dark-skin');
                        }else{
                            slider.removeClass('mkd-slide-dark-skin').addClass('mkd-slide-light-skin');
                        }
					});

                    slider.slick({
						vertical: true,
						verticalSwiping: true,
						infinite: true,
						slidesToShow : 1,
						arrows: true,
						dots: false,
	                    easing: 'easeOutQuart',
						dotsClass: 'mkd-slick-dots',
						prevArrow: '<span class="mkd-slick-prev mkd-prev-icon"><span class="arrow_carrot-up"></span></span>',
						nextArrow: '<span class="mkd-slick-next mkd-prev-icon"><span class="arrow_carrot-down"></span></span>',
						customPaging: function(slider, i) {
							return '<span class="mkd-slick-dot-inner"></span>';
						}
                    }).animate({'opacity': 1}, 600);
                });
            }

        };

        var mkdFullScreenSliderInfo = function() {

            if (sliderHolder.length) {

                var sliderContent = $('.mkd-portfolio-slider-content');
                var close = $('.mkd-control.mkd-close');
                var description = $('.mkd-description');
                var info = $('.mkd-portfolio-slider-content-info');

                sliderContent.on('click',function(e){
                    e.preventDefault();
                    if (!sliderContent.hasClass('opened')) {
                        description.fadeOut(400, function() {
                            sliderContent.addClass('opened');
                            setTimeout(function(){
                                info.fadeIn(400);
                            }, 400);
                            setTimeout(function(){
                                $(".mkd-portfolio-slider-content-info").niceScroll({
                                    scrollspeed: 60,
                                    mousescrollstep: 40,
                                    cursorwidth: 0,
                                    cursorborder: 0,
                                    cursorborderradius: 0,
                                    cursorcolor: "transparent",
                                    autohidemode: false,
                                    horizrailenabled: false
                                });
                            }, 800);
                        });
                    }
                });

                close.on('click',function(e){
                    e.preventDefault();
                    e.stopPropagation();
                    info.fadeOut( 400, function() {
                        sliderContent.removeClass('opened');
                        setTimeout(function() {
                            description.fadeIn(400);
                        }, 400);
                    });
                });

            }

        };
        return {
            init : function() {
                mkdFullScreenSliderHeight();
                mkdFullScreenSlider();
                mkdFullScreenSliderInfo();

                $(window).resize(function(){
                    mkdFullScreenSliderHeight();
                });
            }
        };
    };
    
})(jQuery);