(function($) {
    'use strict';

    var woocommerce = {};
    mkd.modules.woocommerce = woocommerce;

    woocommerce.mkdInitQuantityButtons = mkdInitQuantityButtons;
    woocommerce.mkdInitSelect2 = mkdInitSelect2;

    woocommerce.mkdOnDocumentReady = mkdOnDocumentReady;
    woocommerce.mkdOnWindowLoad = mkdOnWindowLoad;
    woocommerce.mkdOnWindowResize = mkdOnWindowResize;
    woocommerce.mkdOnWindowScroll = mkdOnWindowScroll;

    $(document).ready(mkdOnDocumentReady);
    $(window).load(mkdOnWindowLoad);
    $(window).resize(mkdOnWindowResize);
    $(window).scroll(mkdOnWindowScroll);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function mkdOnDocumentReady() {
        mkdInitQuantityButtons();
        mkdInitButtonLoading();
        mkdInitSelect2();
        mkdInitSingleProductImageSwitch();
        mkdInitRelatedProducts();
    }

    /* 
        All functions to be called on $(window).load() should be in this function
    */
    function mkdOnWindowLoad() {

    }

    /* 
        All functions to be called on $(window).resize() should be in this function
    */
    function mkdOnWindowResize() {

    }

    /* 
        All functions to be called on $(window).scroll() should be in this function
    */
    function mkdOnWindowScroll() {

    }
    

    function mkdInitQuantityButtons() {

        $(document).on('click', '.mkd-quantity-minus, .mkd-quantity-plus', function(e) {
            e.stopPropagation();

            var button = $(this),
                inputField = button.parent().siblings('.mkd-quantity-input'),
                step = parseFloat(inputField.data('step')),
                max = parseFloat(inputField.data('max')),
                minus = false,
                inputValue = parseFloat(inputField.val()),
                newInputValue;

            if (button.hasClass('mkd-quantity-minus')) {
                minus = true;
            }

            if (minus) {
                newInputValue = inputValue - step;
                if (newInputValue >= 1) {
                    inputField.val(newInputValue);
                } else {
                    inputField.val(0);
                }
            } else {
                newInputValue = inputValue + step;
                if ( max === undefined ) {
                    inputField.val(newInputValue);
                } else {
                    if ( newInputValue >= max ) {
                        inputField.val(max);
                    } else {
                        inputField.val(newInputValue);
                    }
                }
            }
            inputField.trigger('change');

        });

    }

    function mkdInitButtonLoading() {

        $(".add_to_cart_button").on('click', function(){
            $(this).children(".mkd-btn-text").text(mkdGlobalVars.vars.mkdAddingToCart);
        });

    }

    function mkdInitSelect2() {

        if ($('.woocommerce-ordering .orderby').length ||  $('#calc_shipping_country').length ) {

            $('.woocommerce-ordering .orderby').select2({
                minimumResultsForSearch: Infinity
            });

            $('#calc_shipping_country, .dropdown_product_cat, .dropdown_layered_nav_color').select2();

        }

    }

    /*
    ** Init switch image logic for thumbnail and featured images on product single page
    */
    function mkdInitSingleProductImageSwitch() {
            
        var thumbnailImage = $('.mkd-single-product-wrapper-top .images .thumbnails a'),
            mainImage = $('.mkd-single-product-wrapper-top .images .woocommerce-main-image');

        if(mainImage.length) {
            mainImage.on('click', function(e) {
                e.preventDefault();
                if(mainImage.children('.mkd-fake-featured-image').length){
                    $('.mkd-fake-featured-image').stop().animate({'opacity': '0'}, 100, function() {
                        $(this).remove();
                    });
                    mainImage.find('a img').css('opacity', '1');
                }             
            });
        }

        if(thumbnailImage.length) {
            thumbnailImage.each(function(){
                var thisThumbnailImage = $(this),
                    thisThumbnailImageSrc = thisThumbnailImage.attr('href');                    

                thisThumbnailImage.on('click', function(e) {
                    e.preventDefault();
                    if(thisThumbnailImageSrc !== '' && mainImage !== '') {
                        mainImage.append('<img itemprop="image" class="mkd-fake-featured-image" src="'+thisThumbnailImageSrc+'" />');
                        if(mainImage.children('.mkd-fake-featured-image').length > 1){
                            $('.mkd-fake-featured-image').first().remove();
                        }
                        mainImage.find('a img').css('opacity', '0');
                    }
                });
            });
        }
    }

	function mkdInitRelatedProducts() {
		var relatedProducts = $('.related.products');

		if (relatedProducts.length){
			var productList = relatedProducts.find('ul.products'),
				prevArrow = relatedProducts.find('.mkd-related-prev'),
				nextArrow = relatedProducts.find('.mkd-related-next'),
				prevSlick, nextSlick;

			var responsive = [
				{
					breakpoint: 769,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 1,
						infinite: true
					}
				},
				{
					breakpoint: 601,
					settings: {
						slidesToShow: 1,
						slidesToScroll: 1
					}
				}
			];

			productList.slick({
				infinite: true,
				slidesToShow : 3,
				arrows: true,
				dots: false,
				dotsClass: 'mkd-slick-dots',
				adaptiveHeight: true,
				prevArrow: '<span class="mkd-slick-prev mkd-prev-icon"></span>',
				nextArrow: '<span class="mkd-slick-next mkd-next-icon"></span>',
				responsive: responsive
			});

			prevSlick = relatedProducts.find('.mkd-slick-prev');
			nextSlick = relatedProducts.find('.mkd-slick-next');


			prevArrow.on('click', function(){
				prevSlick.trigger("click");
			});

			nextArrow.on('click', function(){
				nextSlick.trigger("click");
			});
		}
	}

})(jQuery);