<?php
if ( post_password_required() ) {
	return;
}

if ( comments_open() || get_comments_number()) : ?>
	<div class="mkd-comment-holder clearfix" id="comments">
		<div class="mkd-comment-number">
			<div class="mkd-comment-number-inner">
				<h5><?php comments_number( esc_html__('No Comments','buro'), esc_html__('Comment: ','buro').' 1', esc_html__('Comments: ','buro').' %'); ?></h5>
			</div>
		</div>
		<div class="mkd-comments">
			<?php if ( have_comments() ) : ?>
				<ul class="mkd-comment-list">
					<?php wp_list_comments(array( 'callback' => 'buro_mikado_comment')); ?>
				</ul>
			<?php endif; ?>
			<?php if( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' )) : ?>
				<p><?php esc_html_e('Sorry, the comment form is closed at this time.', 'buro'); ?></p>
			<?php endif; ?>
		</div>
	</div>
	<?php
		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );
		$consent  = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';

		$args = array(
			'id_form' => 'commentform',
			'id_submit' => 'submit_comment',
			'title_reply'=> esc_html__( 'Post a Comment','buro' ),
			'title_reply_to' => esc_html__( 'Post a Reply to %s','buro' ),
			'cancel_reply_link' => esc_html__( 'Cancel Reply','buro' ),
			'label_submit' => esc_html__( 'Submit','buro' ),
			'comment_field' => '<textarea id="comment" placeholder="'.esc_attr__( 'Type comment...','buro' ).'" name="comment" cols="45" rows="5" aria-required="true"></textarea>',
            'title_reply_before' => '<h5 id="reply-title" class="comment-reply-title mkd-comment-reply-title-registered">',
            'title_reply_after' => '</h5>',
			'comment_notes_before' => '',
			'comment_notes_after' => '',
			'fields' => apply_filters( 'comment_form_default_fields', array(
				'author' => '<div class="mkd-two-columns-50-50 clearfix"><div class="mkd-two-columns-50-50-inner clearfix"><div class="mkd-column"><div class="mkd-column-inner"><input id="author" name="author" placeholder="'. esc_attr__( 'Name','buro' ) .'" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"' . $aria_req . ' /></div></div>',
				'url' => '<div class="mkd-column"><div class="mkd-column-inner"><input id="email" name="email" placeholder="'. esc_attr__( 'E-mail','buro' ) .'" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '"' . $aria_req . ' /></div></div></div></div>',
                'cookies' => '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes" ' . $consent . ' />' .
                     '<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'buro' ) . '</label></p>'
				 ) )
			);

		if(is_user_logged_in()) {
            $args['class_form'] = 'mkd-comment-registered-user';
        }

	?>
	<?php if(get_comment_pages_count() > 1 ){ ?>
		<div class="mkd-comment-pager">
			<p><?php paginate_comments_links(); ?></p>
		</div>
	<?php } ?>
	 <div class="mkd-comment-form">
		<?php comment_form($args); ?>
	</div>
<?php endif; ?>


