<?php

if(!function_exists('buro_mikado_map_blog_meta_fields')) {

	function buro_mikado_map_blog_meta_fields() {

		$mkd_blog_categories = array();
		$categories = get_categories();
		foreach($categories as $category) {
		    $mkd_blog_categories[$category->term_id] = $category->name;
		}

		$blog_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page'),
		        'title' => esc_html__('Blog', 'buro'),
		        'name' => 'blog_meta'
		    )
		);

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        =>'mkd_blog_category_meta',
	            'type'        => 'selectblank',
	            'label'       => esc_html__('Blog Category', 'buro'),
	            'description' => esc_html__('Choose category of posts to display (leave empty to display all categories)', 'buro'),
	            'parent'      => $blog_meta_box,
	            'options'     => $mkd_blog_categories
	        )
	    );

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        => 'mkd_show_posts_per_page_meta',
	            'type'        => 'text',
	            'label'       => esc_html__('Number of Posts', 'buro'),
	            'description' => esc_html__('Enter the number of posts to display', 'buro'),
	            'parent'      => $blog_meta_box,
	            'options'     => $mkd_blog_categories,
	            'args'        => array("col_width" => 3)
	        )
	    );
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_blog_meta_fields');
}

