<?php

//Carousels

if(!function_exists('buro_mikado_map_carousel_meta_fields')) {

	function buro_mikado_map_carousel_meta_fields() {

		$carousel_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('carousels'),
		        'title' => esc_html__('Carousel', 'buro'),
		        'name' => 'carousel_meta',
		    )
		);

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        => 'mkd_carousel_image',
	            'type'        => 'image',
	            'label'       => esc_html__('Carousel Image', 'buro'),
	            'description' => esc_html__('Choose carousel image (min width needs to be 215px)', 'buro'),
	            'parent'      => $carousel_meta_box
	        )
	    );

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        => 'mkd_carousel_hover_image',
	            'type'        => 'image',
	            'label'       => esc_html__('Carousel Hover Image', 'buro'),
	            'description' => esc_html__('Choose carousel hover image (min width needs to be 215px)', 'buro'),
	            'parent'      => $carousel_meta_box
	        )
	    );

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        => 'mkd_carousel_item_link',
	            'type'        => 'text',
	            'label'       => esc_html__('Link', 'buro'),
	            'description' => esc_html__('Enter the URL to which you want the image to link to (e.g. http://www.example.com)', 'buro'),
	            'parent'      => $carousel_meta_box
	        )
	    );

	    buro_mikado_create_meta_box_field(
	        array(
	            'name'        => 'mkd_carousel_item_target',
	            'type'        => 'selectblank',
	            'label'       => esc_html__('Target', 'buro'),
	            'description' => esc_html__('Specify where to open the linked document', 'buro'),
	            'parent'      => $carousel_meta_box,
	            'options' => array(
	            	'_self' => esc_html__('Self','buro'),
	            	'_blank' => esc_html__('Blank','buro')
	        	)
	        )
	    );
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_carousel_meta_fields');
}