<?php

if(!function_exists('buro_mikado_map_footer_meta_fields')) {

	function buro_mikado_map_footer_meta_fields() {
        $buro_mikado_custom_sidebars = buro_mikado_get_custom_sidebars();

        $footer_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('Footer', 'buro'),
		        'name' => 'footer_meta'
		    )
		);

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_show_footer_top_meta',
                'type' => 'yesno',
                'default_value' => 'yes',
                'label' => esc_html__('Show Footer Top for this Page', 'buro'),
                'description' => esc_html__('Enabling this option will show Footer Top area', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_show_footer_top_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );


        $show_footer_top_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'show_footer_top_meta_container',
                'hidden_property' => 'mkd_show_footer_top_meta',
                'hidden_value' => 'no'

            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_footer_top_skin_meta',
                'type' => 'select',
                'default_value' => 'light',
                'label' => esc_html__('Footer Top Skin', 'buro'),
                'description' => esc_html__('Choose footer top skin', 'buro'),
                'options' => array(
                    '' => esc_html__('Default', 'buro'),
                    'light' => esc_html__('Light', 'buro'),
                    'dark' => esc_html__('Dark', 'buro'),
                ),
                'parent' =>  $show_footer_top_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'parent' => $show_footer_top_meta_container,
                'type' => 'color',
                'name' => 'mkd_footer_top_background_color_meta',
                'default_value' => '',
                'label' => esc_html__('Background color', 'buro'),
                'description' => esc_html__('Set background color for footer top', 'buro')
            )
        );


//        ------------------------------------------------------------------------------------------

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_enable_custom_footer_col_1_widget_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Enable Custom Widget Area in Footer Column 1', 'buro'),
                'description' => esc_html__('Enabling this option will show widget area for Footer Top Column 1', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_mkd_enable_custom_widget_footer_col_1_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );

        $enable_custom_footer_col_1_widget_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'mkd_enable_custom_widget_footer_col_1_meta_container',
                'hidden_property' => 'mkd_enable_custom_footer_col_1_widget_meta',
                'hidden_value' => 'no'

            )
        );

        if(count($buro_mikado_custom_sidebars) > 0) {
            buro_mikado_create_meta_box_field(array(
                'name' => 'mkd_custom_footer_col_1_widget_meta',
                'type' => 'selectblank',
                'label' => esc_html__('Choose Custom Widget Area in Footer Column 1', 'buro'),
                'description' => esc_html__('Choose custom widget area to display in footer column 1"', 'buro'),
                'parent' => $enable_custom_footer_col_1_widget_meta_container,
                'options' => $buro_mikado_custom_sidebars
            ));
        }

//        ------------------------------------------------------------------------------------------

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_enable_custom_footer_col_2_widget_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Enable Custom Widget Area in Footer Column 2', 'buro'),
                'description' => esc_html__('Enabling this option will show widget area for Footer Top Column 2', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_mkd_enable_custom_widget_footer_col_2_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );

        $enable_custom_footer_col_2_widget_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'mkd_enable_custom_widget_footer_col_2_meta_container',
                'hidden_property' => 'mkd_enable_custom_footer_col_2_widget_meta',
                'hidden_value' => 'no'

            )
        );

        if(count($buro_mikado_custom_sidebars) > 0) {
            buro_mikado_create_meta_box_field(array(
                'name' => 'mkd_custom_footer_col_2_widget_meta',
                'type' => 'selectblank',
                'label' => esc_html__('Choose Custom Widget Area in Footer Column 2', 'buro'),
                'description' => esc_html__('Choose custom widget area to display in footer column 2"', 'buro'),
                'parent' => $enable_custom_footer_col_2_widget_meta_container,
                'options' => $buro_mikado_custom_sidebars
            ));
        }

//        ------------------------------------------------------------------------------------------

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_enable_custom_footer_col_3_widget_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Enable Custom Widget Area in Footer Column 3', 'buro'),
                'description' => esc_html__('Enabling this option will show widget area for Footer Top Column 3', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_mkd_enable_custom_widget_footer_col_3_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );

        $enable_custom_footer_col_3_widget_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'mkd_enable_custom_widget_footer_col_3_meta_container',
                'hidden_property' => 'mkd_enable_custom_footer_col_3_widget_meta',
                'hidden_value' => 'no'

            )
        );

        if(count($buro_mikado_custom_sidebars) > 0) {
            buro_mikado_create_meta_box_field(array(
                'name' => 'mkd_custom_footer_col_3_widget_meta',
                'type' => 'selectblank',
                'label' => esc_html__('Choose Custom Widget Area in Footer Column 3', 'buro'),
                'description' => esc_html__('Choose custom widget area to display in footer column 3"', 'buro'),
                'parent' => $enable_custom_footer_col_3_widget_meta_container,
                'options' => $buro_mikado_custom_sidebars
            ));
        }

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_enable_custom_footer_col_4_widget_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Enable Custom Widget Area in Footer Column 4', 'buro'),
                'description' => esc_html__('Enabling this option will show widget area for Footer Top Column 4', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_mkd_enable_custom_widget_footer_col_4_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );

        $enable_custom_footer_col_4_widget_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'mkd_enable_custom_widget_footer_col_4_meta_container',
                'hidden_property' => 'mkd_enable_custom_footer_col_4_widget_meta',
                'hidden_value' => 'no'

            )
        );

        if(count($buro_mikado_custom_sidebars) > 0) {
            buro_mikado_create_meta_box_field(array(
                'name' => 'mkd_custom_footer_col_4_widget_meta',
                'type' => 'selectblank',
                'label' => esc_html__('Choose Custom Widget Area in Footer Column 4', 'buro'),
                'description' => esc_html__('Choose custom widget area to display in footer column 4"', 'buro'),
                'parent' => $enable_custom_footer_col_4_widget_meta_container,
                'options' => $buro_mikado_custom_sidebars
            ));
        }

//        ------------------------------------------------------------------------------------------

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_show_footer_bottom_meta',
                'type' => 'yesno',
                'default_value' => 'yes',
                'label' => esc_html__('Show Footer Bottom for this Page', 'buro'),
                'description' => esc_html__('Enabling this option will show Footer Bottom area', 'buro'),
                'args' => array(
                    'dependence' => true,
                    'dependence_hide_on_yes' => '',
                    'dependence_show_on_yes' => '#mkd_show_footer_bottom_meta_container'
                ),
                'parent' => $footer_meta_box,
            )
        );


        $show_footer_bottom_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $footer_meta_box,
                'name' => 'show_footer_bottom_meta_container',
                'hidden_property' => 'mkd_show_footer_bottom_meta',
                'hidden_value' => 'no'

            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_footer_bottom_skin_meta',
                'type' => 'select',
                'default_value' => 'light',
                'label' => esc_html__('Footer Bottom Skin', 'buro'),
                'description' => esc_html__('Choose footer bottom skin', 'buro'),
                'options' => array(
                    '' => esc_html__('Default', 'buro'),
                    'light' => esc_html__('Light', 'buro'),
                    'dark' => esc_html__('Dark', 'buro'),
                ),
                'parent' =>  $show_footer_bottom_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'parent' =>  $show_footer_bottom_meta_container,
                'type' => 'color',
                'name' => 'mkd_footer_bottom_background_color_meta',
                'default_value' => '',
                'label' => esc_html__('Background color', 'buro'),
                'description' => esc_html__('Set background color for footer bottom', 'buro')
            )
        );

//

//	    buro_mikado_create_meta_box_field(
//	        array(
//	            'name' => 'mkd_disable_footer_meta',
//	            'type' => 'yesno',
//	            'default_value' => 'no',
//	            'label' => esc_html__('Disable Footer for this Page', 'buro'),
//	            'description' => esc_html__('Enabling this option will hide footer on this page', 'buro'),
//	            'parent' => $footer_meta_box,
//	        )
//	    );
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_footer_meta_fields');
}