<?php

if(!function_exists('buro_mikado_map_general_meta_fields')) {

	function buro_mikado_map_general_meta_fields() {

		$general_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('General', 'buro'),
		        'name' => 'general_meta'
		    )
		);


	    buro_mikado_create_meta_box_field(
	        array(
	            'name' => 'mkd_page_background_color_meta',
	            'type' => 'color',
	            'default_value' => '',
	            'label' => esc_html__('Page Background Color', 'buro'),
	            'description' => esc_html__('Choose background color for page content', 'buro'),
	            'parent' => $general_meta_box
	        )
	    );
		
		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_page_padding_meta',
				'type' => 'text',
				'default_value' => '',
				'label' => esc_html__('Page Padding', 'buro'),
				'description' => esc_html__('Insert padding in format 10px 10px 10px 10px', 'buro'),
				'parent' => $general_meta_box
			)
		);

	    buro_mikado_create_meta_box_field(
	        array(
	            'name' => 'mkd_page_slider_meta',
	            'type' => 'text',
	            'default_value' => '',
	            'label' => esc_html__('Slider Shortcode', 'buro'),
	            'description' => esc_html__('Paste your slider shortcode here', 'buro'),
	            'parent' => $general_meta_box
	        )
	    );

		$boxed_option      = buro_mikado_options()->getOptionValue('boxed');
		$boxed_default_dependency = array(
			'' => '#mkd_boxed_container'
		);

		$boxed_show_array = array(
			'yes' => '#mkd_boxed_container'
		);

		$boxed_hide_array = array(
			'no' => '#mkd_boxed_container'
		);

		if($boxed_option === 'yes') {
			$boxed_show_array = array_merge($boxed_show_array, $boxed_default_dependency);
			$temp_boxed_no = array(
				'hidden_value' => 'no'
			);
		} else {
			$boxed_hide_array = array_merge($boxed_hide_array, $boxed_default_dependency);
			$temp_boxed_no = array(
				'hidden_values'   => array('','no')
			);
		}

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_boxed_meta',
				'type'          => 'select',
				'label'         => esc_html__('Boxed Layout', 'buro'),
				'parent'        => $general_meta_box,
				'default_value' => '',
				'options'     => array(
					''		=> esc_html__('Default', 'buro'),
					'yes'	=> esc_html__('Yes', 'buro'),
					'no'	=> esc_html__('No', 'buro')
				),
				'args' => array(
					"dependence" => true,
					'show'       => $boxed_show_array,
					'hide'       => $boxed_hide_array
				)
			)
		);

		$boxed_container = buro_mikado_add_admin_container_no_style(
			array_merge(
				array(
					'parent'            => $general_meta_box,
					'name'              => 'boxed_container',
					'hidden_property'   => 'mkd_boxed_meta'
				),
				$temp_boxed_no
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_page_background_color_in_box_meta',
				'type'          => 'color',
				'label'         => esc_html__('Page Background Color', 'buro'),
				'description'   => esc_html__('Choose the page background color outside box.', 'buro'),
				'parent'        => $boxed_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_boxed_background_image_meta',
				'type'          => 'image',
				'label'         => esc_html__('Background Image', 'buro'),
				'description'   => esc_html__('Choose an image to be displayed in background', 'buro'),
				'parent'        => $boxed_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_boxed_background_image_repeating_meta',
				'type'          => 'select',
				'default_value' => 'no',
				'label'         => esc_html__('Use Background Image as Pattern', 'buro'),
				'description'   => esc_html__('Set this option to "yes" to use the background image as repeating pattern', 'buro'),
				'parent'        => $boxed_container,
				'options'       => array(
					'no'	=>	esc_html__('No', 'buro'),
					'yes'	=>	esc_html__('Yes', 'buro')

				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_boxed_background_image_attachment_meta',
				'type'          => 'select',
				'default_value' => 'fixed',
				'label'         => esc_html__('Background Image Behaviour', 'buro'),
				'description'   => esc_html__('Choose background image behaviour', 'buro'),
				'parent'        => $boxed_container,
				'options'       => array(
					'fixed'     => esc_html__('Fixed', 'buro'),
					'scroll'    => esc_html__('Scroll', 'buro')
				)
			)
		);
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_general_meta_fields');
}