<?php

if(!function_exists('buro_mikado_map_header_meta_fields')) {

	function buro_mikado_map_header_meta_fields() {
		$buro_mikado_custom_sidebars = buro_mikado_get_custom_sidebars();

		$header_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('Header', 'buro'),
		        'name' => 'header_meta'
		    )
		);

		$temp_holder_show		= '';
		$temp_holder_hide		= '';
		$temp_array_standard	= array();
        $temp_array_centered	= array();
		$temp_array_vertical	= array();
		$temp_array_full_screen	= array();
		$temp_array_behaviour	= array();
		switch (buro_mikado_options()->getOptionValue('header_type')) {

			case 'header-standard':
				$temp_holder_show = '#mkd_mkd_header_standard_type_meta_container,#mkd_mkd_header_behaviour_meta_container';
				$temp_holder_hide = '#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_centered_type_meta_container';

				$temp_array_standard = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-vertical','header-full-screen','header-centered')
				);

				$temp_array_centered = array(
					'hidden_values' => array('','header-standard','header-vertical','header-full-screen')
				);

				$temp_array_vertical = array(
					'hidden_values' => array('','header-standard','header-full-screen','header-centered')
				);
				$temp_array_full_screen = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-centered')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;

			case 'header-centered':
				$temp_holder_show = '#mkd_mkd_header_centered_type_meta_container,#mkd_mkd_header_behaviour_meta_container';
				$temp_holder_hide = '#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_standard_type_meta_container';

				$temp_array_standard = array(
					'hidden_values' => array('','header-vertical','header-full-screen','header-centered')
				);
				$temp_array_centered = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-standard','header-vertical','header-full-screen')
				);
				$temp_array_vertical = array(
					'hidden_values' => array('','header-standard','header-full-screen','header-centered')
				);
				$temp_array_full_screen = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-centered')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;

			case 'header-vertical':
				$temp_holder_show = '#mkd_mkd_header_vertical_type_meta_container';
				$temp_holder_hide = '#mkd_mkd_header_standard_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_behaviour_meta_container,#mkd_mkd_header_centered_type_meta_container';

				$temp_array_standard = array(
					'hidden_values' => array('', 'header-vertical', 'header-full-screen','header-centered')
				);
				$temp_array_centered = array(
					'hidden_values' => array('','header-standard','header-vertical','header-full-screen')
				);
				$temp_array_vertical = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-standard','header-full-screen','header-centered')
				);
				$temp_array_full_screen = array(
					'hidden_values' => array('','header-standard', 'header-vertical','header-centered')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'default',
					'hidden_values' => array('','header-vertical')
				);
				break;
			case 'header-full-screen':
				$temp_holder_show = '#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_behaviour_meta_container';
				$temp_holder_hide = '#mkd_mkd_header_standard_type_meta_container,#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_centered_type_meta_container';
				$temp_array_standard = array(
					'hidden_values' => array('', 'header-vertical', 'header-standard','header-centered')
				);

				$temp_array_centered = array(
					'hidden_values' => array('','header-standard','header-vertical','header-full-screen')
				);

				$temp_array_vertical = array(
					'hidden_values' => array('', 'header-standard','header-full-screen','header-centered')
				);

				$temp_array_full_screen = array(
					'hidden_value' => 'default',
					'hidden_values' => array('header-vertical','header-full-screen','header-centered')
				);
				$temp_array_behaviour = array(
					'hidden_value' => 'header-vertical'
				);
				break;
		}



		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_header_type_meta',
				'type' => 'select',
				'default_value' => '',
				'label' => esc_html__('Choose Header Type', 'buro'),
				'description' => esc_html__('Select header type layout', 'buro'),
				'parent' => $header_meta_box,
				'options' => array(
					'' => esc_html__('Default','buro'),
					'header-standard' => esc_html__('Standard Header Layout','buro'),
					'header-centered' => esc_html__('Centered Header Layout','buro'),
					'header-vertical' => esc_html__('Vertical Header Layout','buro'),
					'header-full-screen' => esc_html__('Full Screen Header Layout','buro')
				),
				'args' => array(
					"dependence" => true,
					"hide" => array(
						"" => $temp_holder_hide,
						'header-standard' 		=> '#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_centered_type_meta_container',
						'header-centered' 		=> '#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_standard_type_meta_container',
						'header-vertical' 		=> '#mkd_mkd_header_standard_type_meta_container,#mkd_mkd_header_full_screen_type_meta_container,#mkd_mkd_header_centered_type_meta_container',
						'header-full-screen'	=> '#mkd_mkd_header_standard_type_meta_container,#mkd_mkd_header_vertical_type_meta_container,#mkd_mkd_header_centered_type_meta_container'
					),
					"show" => array(
						"" => $temp_holder_show,
						"header-standard" 		=> '#mkd_mkd_header_standard_type_meta_container',
						"header-centered" 		=> '#mkd_mkd_header_centered_type_meta_container',
						"header-vertical" 		=> '#mkd_mkd_header_vertical_type_meta_container',
						"header-full-screen" 	=> '#mkd_mkd_header_full_screen_type_meta_container'
					)
				)
			)
		);
		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_header_style_meta',
		        'type' => 'select',
				'default_value' => '',
				'label' => esc_html__('Header Skin', 'buro'),
				'description' => esc_html__('Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'buro'),
				'parent' => $header_meta_box,
				'options' => array(
					'' => '',
					'light-header' => esc_html__('Light','buro'),
					'dark-header' => esc_html__('Dark','buro')
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'parent' => $header_meta_box,
				'type' => 'select',
				'name' => 'mkd_enable_header_style_on_scroll_meta',
				'default_value' => '',
				'label' => esc_html__('Enable Header Style on Scroll', 'buro'),
				'description' => esc_html__('Enabling this option, header will change style depending on row settings for dark/light style', 'buro'),
				'options' => array(
					'' => '',
					'no' => esc_html__('No','buro'),
					'yes' => esc_html__('Yes','buro')
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_disable_header_widget_area_meta',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Disable Header Widget Area', 'buro'),
				'description' => esc_html__('Enabling this option will hide widget area from the right hand side of main menu', 'buro'),
				'parent' => $header_meta_box
			)
		);

		if(count($buro_mikado_custom_sidebars) > 0) {
			buro_mikado_create_meta_box_field(array(
				'name' => 'mkd_custom_header_widget_meta',
				'type' => 'selectblank',
				'label' => esc_html__('Choose Custom Widget Area in Header', 'buro'),
				'description' => esc_html__('Choose custom widget area to display in header area from the right hand side of main menu"', 'buro'),
				'parent' => $header_meta_box,
				'options' => $buro_mikado_custom_sidebars
			));
		}
		if(in_array(buro_mikado_options()->getOptionValue('header_behaviour'), array('sticky-header-on-scroll-up','sticky-header-on-scroll-down-up'))) {
			buro_mikado_create_meta_box_field(
				array(
					'name' => 'mkd_disable_sticky_header_widget_area_meta',
					'type' => 'yesno',
					'default_value' => 'no',
					'label' => esc_html__('Disable Sticky Header Widget Area', 'buro'),
					'description' => esc_html__('Enabling this option will hide widget area from the right hand side of main menu', 'buro'),
					'parent' => $header_meta_box
				)
			);

			if(count($buro_mikado_custom_sidebars) > 0) {
				buro_mikado_create_meta_box_field(array(
					'name' => 'mkd_custom_sticky_header_widget_meta',
					'type' => 'selectblank',
					'label' => esc_html__('Choose Custom Widget Area in Sticky Header', 'buro'),
					'description' => esc_html__('Choose custom widget area to display in header area from the right hand side of main menu"', 'buro'),
					'parent' => $header_meta_box,
					'options' => $buro_mikado_custom_sidebars
				));
			}
		}

		$header_standard_type_meta_container = buro_mikado_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'mkd_header_standard_type_meta_container',
					'hidden_property' => 'mkd_header_type_meta',

				),
				$temp_array_standard
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_color_header_standard_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'buro'),
				'description' => esc_html__('Choose a background color for header area', 'buro'),
				'parent' => $header_standard_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_transparency_header_standard_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_standard_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_color_header_standard_meta',
				'type' => 'color',
				'label' => esc_html__('Border Bottom Color', 'buro'),
				'description' => esc_html__('Choose a border bottom color for header area', 'buro'),
				'parent' => $header_standard_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_transparency_header_standard_meta',
				'type' => 'text',
				'label' => esc_html__('Border Bottom Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the header border bottom color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_standard_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		$header_centered_type_meta_container = buro_mikado_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'mkd_header_centered_type_meta_container',
					'hidden_property' => 'mkd_header_type_meta',

				),
				$temp_array_centered
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_color_header_centered_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'buro'),
				'description' => esc_html__('Choose a background color for header area', 'buro'),
				'parent' => $header_centered_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_transparency_header_centered_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_centered_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_color_header_centered_meta',
				'type' => 'color',
				'label' => esc_html__('Border Bottom Color', 'buro'),
				'description' => esc_html__('Choose a border bottom color for header area', 'buro'),
				'parent' => $header_centered_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_transparency_header_centered_meta',
				'type' => 'text',
				'label' => esc_html__('Border Bottom Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the header border bottom color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_centered_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		$header_vertical_type_meta_container = buro_mikado_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' =>'mkd_header_vertical_type_meta_container',
					'hidden_property' => 'mkd_header_type_meta',
					'hidden_values' => array('header-standard')
				),
				$temp_array_vertical
			)
		);

		buro_mikado_create_meta_box_field(array(
			'name'        => 'mkd_vertical_header_background_color_meta',
			'type'        => 'color',
			'label'       => esc_html__('Background Color',  'buro'),
			'parent'      => $header_vertical_type_meta_container
		));

		buro_mikado_create_meta_box_field(array(
			'name'        => 'mkd_vertical_header_transparency_meta',
			'type'        => 'text',
			'label'       => esc_html__('Background Transparency', 'buro'),
			'description' => esc_html__('Enter transparency for vertical menu (value from 0 to 1)', 'buro'),
			'parent'      => $header_vertical_type_meta_container,
			'args'        => array(
				'col_width' => 1
			)
		));

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_vertical_header_background_image_meta',
				'type'          => 'image',
				'default_value' => '',
				'label'         => esc_html__('Background Image', 'buro'),
				'description'   => esc_html__('Set background image for vertical menu', 'buro'),
				'parent'        => $header_vertical_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_disable_vertical_header_background_image_meta',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Disable Background Image', 'buro'),
				'description' => esc_html__('Enabling this option will hide background image in Vertical Menu', 'buro'),
				'parent' => $header_vertical_type_meta_container
			)
		);

		$header_full_screen_type_meta_container = buro_mikado_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'mkd_header_full_screen_type_meta_container',
					'hidden_property' => 'mkd_header_type_meta',

				),
				$temp_array_full_screen
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_color_header_full_screen_meta',
				'type' => 'color',
				'label' => esc_html__('Background Color', 'buro'),
				'description' => esc_html__('Choose a background color for Full Screen header area', 'buro'),
				'parent' => $header_full_screen_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_background_transparency_header_full_screen_meta',
				'type' => 'text',
				'label' => esc_html__('Background Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the Full Screen header background color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_full_screen_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_color_header_full_screen_meta',
				'type' => 'color',
				'label' => esc_html__('Border Bottom Color', 'buro'),
				'description' => esc_html__('Choose a border bottom color for Full Screen header area', 'buro'),
				'parent' => $header_full_screen_type_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_menu_area_border_bottom_transparency_header_full_screen_meta',
				'type' => 'text',
				'label' => esc_html__('Border Bottom Transparency', 'buro'),
				'description' => esc_html__('Choose a transparency for the Full Screen header border bottom color (0 = fully transparent, 1 = opaque)', 'buro'),
				'parent' => $header_full_screen_type_meta_container,
				'args' => array(
					'col_width' => 2
				)
			)
		);

		$header_behaviour_meta_container = buro_mikado_add_admin_container(
			array_merge(
				array(
					'parent' => $header_meta_box,
					'name' => 'mkd_header_behaviour_meta_container',
					'hidden_property' => 'mkd_header_type_meta',

				),
				$temp_array_behaviour
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'            => 'mkd_scroll_amount_for_sticky_meta',
				'type'            => 'text',
				'label'           => esc_html__('Scroll amount for sticky header appearance', 'buro'),
				'description'     => esc_html__('Define scroll amount for sticky header appearance', 'buro'),
				'parent'          => $header_behaviour_meta_container,
				'args'            => array(
					'col_width' => 2,
					'suffix'    => 'px'
				),
				'hidden_property' => 'mkd_header_behaviour',
				'hidden_values'   => array("sticky-header-on-scroll-up", "fixed-on-scroll")
			)
		);


		buro_mikado_add_admin_section_title(array(
			'name'   => 'top_bar_section_title',
			'parent' => $header_meta_box,
			'title'  => esc_html__('Top Bar','buro')
		));

		$top_bar_global_option      = buro_mikado_options()->getOptionValue('top_bar');
		$top_bar_default_dependency = array(
			'' => '#mkd_top_bar_container_no_style'
		);

		$top_bar_show_array = array(
			'yes' => '#mkd_top_bar_container_no_style'
		);

		$top_bar_hide_array = array(
			'no' => '#mkd_top_bar_container_no_style'
		);

		if($top_bar_global_option === 'yes') {
			$top_bar_show_array = array_merge($top_bar_show_array, $top_bar_default_dependency);
			$temp_top_no = array(
				'hidden_value' => 'no'
			);
		} else {
			$top_bar_hide_array = array_merge($top_bar_hide_array, $top_bar_default_dependency);
			$temp_top_no = array(
				'hidden_values'   => array('','no')
			);
		}


		buro_mikado_create_meta_box_field(array(
			'name'          => 'mkd_top_bar_meta',
			'type'          => 'select',
			'label'         => esc_html__('Enable Top Bar on This Page', 'buro'),
			'description'   => esc_html__('Enabling this option will enable top bar on this page', 'buro'),
			'parent'        => $header_meta_box,
			'default_value' => '',
			'options'       => array(
				''    => esc_html__('Default','buro'),
				'yes' => esc_html__('Yes','buro'),
				'no'  => esc_html__('No','buro')
			),
			'args' => array(
				"dependence" => true,
				'show'       => $top_bar_show_array,
				'hide'       => $top_bar_hide_array
			)
		));

		$top_bar_container = buro_mikado_add_admin_container_no_style(array_merge(array(
			'name'            => 'top_bar_container_no_style',
			'parent'          => $header_meta_box,
			'hidden_property' => 'mkd_top_bar_meta'
		),
			$temp_top_no));

		buro_mikado_create_meta_box_field(array(
			'name'    => 'mkd_top_bar_skin_meta',
			'type'    => 'select',
			'label'   => esc_html__('Top Bar Skin', 'buro'),
			'options' => array(
				''      => esc_html__('Default','buro'),
				'light' => esc_html__('Light','buro'),
				'dark'  => esc_html__('Dark','buro')
			),
			'parent'  => $top_bar_container
		));

		buro_mikado_create_meta_box_field(array(
			'name'   => 'mkd_top_bar_background_color_meta',
			'type'   => 'color',
			'label'  => esc_html__('Top Bar Background Color', 'buro'),
			'parent' => $top_bar_container
		));

		buro_mikado_create_meta_box_field(array(
			'name'        => 'mkd_top_bar_background_transparency_meta',
			'label'       => esc_html__('Top Bar Background Color Transparency', 'buro'),
			'description' => esc_html__('Set top bar background color transparenct. Value should be between 0 and 1', 'buro'),
			'parent'      => $top_bar_container,
			'args'        => array(
				'col_width' => 3
			)
		));

	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_header_meta_fields');
}