<?php

if(!function_exists('buro_mikado_map_portfolio_settings')) {
    function buro_mikado_map_portfolio_settings() {
        $meta_box = buro_mikado_create_meta_box(array(
            'scope' => 'portfolio-item',
            'title' => esc_html__('Portfolio Settings', 'buro'),
            'name'  => 'portfolio_settings_meta_box',
        ));

        buro_mikado_create_meta_box_field(array(
            'name'        => 'mkd_portfolio_single_template_meta',
            'type'        => 'select',
            'label'       =>esc_html__('Portfolio Type', 'buro'),
            'description' => esc_html__('Choose a default type for Single Project pages', 'buro'),
            'parent'      => $meta_box,
            'options'     => array(
                ''                   => esc_html__('Default','buro'),
                'small-images'       => esc_html__('Portfolio small images left','buro'),
                'small-images-right' => esc_html__('Portfolio small images right','buro'),
                'small-slider'       => esc_html__('Portfolio small slider left','buro'),
                'small-slider-right' => esc_html__('Portfolio small slider right','buro'),
                'big-images'         => esc_html__('Portfolio big images','buro'),
                'wide-images'        => esc_html__('Portfolio wide images left','buro'),
                'wide-images-right'  => esc_html__('Portfolio wide images right','buro'),
                'big-slider'         => esc_html__('Portfolio big slider','buro'),
                'wide-slider'        => esc_html__('Portfolio wide slider','buro'),
                'gallery'            => esc_html__('Portfolio gallery','buro'),
                'small-masonry'      => esc_html__('Portfolio small masonry','buro'),
                'big-masonry'        => esc_html__('Portfolio big masonry','buro'),
                'split-screen'       => esc_html__('Portfolio split screen','buro'),
                'full-screen-slider' => esc_html__('Portfolio full screen slider','buro'),
                'custom'             => esc_html__('Portfolio custom','buro'),
                'full-width-custom'  => esc_html__('Portfolio full width custom','buro')
            )
        ));

        $all_pages = array();
        $pages     = get_pages();
        foreach($pages as $page) {
            $all_pages[$page->ID] = $page->post_title;
        }

        buro_mikado_create_meta_box_field(array(
            'name'        => 'portfolio_single_back_to_link',
            'type'        => 'select',
            'label'       => esc_html__('"Back To" Link', 'buro'),
            'description' => esc_html__('Choose "Back To" page to link from portfolio Single Project page', 'buro'),
            'parent'      => $meta_box,
            'options'     => $all_pages
        ));

        buro_mikado_create_meta_box_field(array(
            'name'        => 'portfolio_external_link',
            'type'        => 'text',
            'label'       => esc_html__('Portfolio External Link', 'buro'),
            'description' => esc_html__('Enter URL to link from Portfolio List page', 'buro'),
            'parent'      => $meta_box,
            'args'        => array(
                'col_width' => 3
            )
        ));

        buro_mikado_create_meta_box_field(array(
            'name'        => 'portfolio_masonry_dimenisions',
            'type'        => 'select',
            'label'       => esc_html__('Dimensions for Masonry', 'buro'),
            'description' => esc_html__('Choose image layout when it appears in Masonry type portfolio lists', 'buro'),
            'parent'      => $meta_box,
            'options'     => array(
                'default'            => esc_html__('Default','buro'),
                'large_width'        => esc_html__('Large width','buro'),
                'large_height'       => esc_html__('Large height','buro'),
                'large_width_height' => esc_html__('Large width/height','buro'),
            )
        ));
    }

    add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_portfolio_settings');
}