<?php

/*** Video Post Format ***/

if(!function_exists('buro_mikado_map_post_video_meta_fields')) {

	function buro_mikado_map_post_video_meta_fields() {
		$video_post_format_meta_box = buro_mikado_create_meta_box(
			array(
				'scope' =>	array('post'),
				'title' => esc_html__('Video Post Format', 'buro'),
				'name' 	=> 'post_format_video_meta',
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_video_type_meta',
				'type'        => 'select',
				'label'       => esc_html__('Video Type', 'buro'),
				'description' => esc_html__('Choose video type', 'buro'),
				'parent'      => $video_post_format_meta_box,
				'default_value' => 'youtube',
				'options'     => array(
					'youtube' => esc_html__('Youtube','buro'),
					'vimeo' => esc_html__('Vimeo','buro'),
					'self' => esc_html__('Self Hosted','buro')
				),
				'args' => array(
				'dependence' => true,
				'hide' => array(
					'youtube' => '#mkd_mkd_video_self_hosted_container',
					'vimeo' => '#mkd_mkd_video_self_hosted_container',
					'self' => '#mkd_mkd_video_embedded_container'
				),
				'show' => array(
					'youtube' => '#mkd_mkd_video_embedded_container',
					'vimeo' => '#mkd_mkd_video_embedded_container',
					'self' => '#mkd_mkd_video_self_hosted_container')
			)
			)
		);

		$mkd_video_embedded_container = buro_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name' => 'mkd_video_embedded_container',
				'hidden_property' => 'mkd_video_type_meta',
				'hidden_value' => 'self'
			)
		);

		$mkd_video_self_hosted_container = buro_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name' => 'mkd_video_self_hosted_container',
				'hidden_property' => 'mkd_video_type_meta',
				'hidden_values' => array('youtube', 'vimeo')
			)
		);



		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_post_video_id_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video ID', 'buro'),
				'description' => esc_html__('Enter Video ID', 'buro'),
				'parent'      => $mkd_video_embedded_container,

			)
		);


		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__('Video Image', 'buro'),
				'description' => esc_html__('Upload video image', 'buro'),
				'parent'      => $mkd_video_self_hosted_container,

			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_post_video_webm_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video WEBM', 'buro'),
				'description' => esc_html__('Enter video URL for WEBM format', 'buro'),
				'parent'      => $mkd_video_self_hosted_container,

			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_post_video_mp4_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video MP4', 'buro'),
				'description' => esc_html__('Enter video URL for MP4 format', 'buro'),
				'parent'      => $mkd_video_self_hosted_container,

			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_post_video_ogv_link_meta',
				'type'        => 'text',
				'label'       => esc_html__('Video OGV', 'buro'),
				'description' => esc_html__('Enter video URL for OGV format', 'buro'),
				'parent'      => $mkd_video_self_hosted_container,

			)
		);

	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_post_video_meta_fields');
}