<?php

if(!function_exists('buro_mikado_map_sidebar_meta_fields')) {

	function buro_mikado_map_sidebar_meta_fields() {
		$buro_mikado_custom_sidebars = buro_mikado_get_custom_sidebars();

		$buro_mikado_sidebar_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('Sidebar', 'buro'),
		        'name' => 'sidebar_meta',
		    )
		);

		    buro_mikado_create_meta_box_field(
		        array(
		            'name'        => 'mkd_sidebar_meta',
		            'type'        => 'select',
		            'label'       => esc_html__('Layout', 'buro'),
		            'description' => esc_html__('Choose the sidebar layout', 'buro'),
		            'parent'      => $buro_mikado_sidebar_meta_box,
		            'options'     => array(
								''			=> 'Default',
								'no-sidebar'		=> esc_html__('No Sidebar', 'buro'),
								'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right', 'buro'),
								'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right', 'buro'),
								'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left', 'buro'),
								'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left', 'buro'),
							)
		        )
		    );

		if(count($buro_mikado_custom_sidebars) > 0) {
		    buro_mikado_create_meta_box_field(array(
		        'name' => 'mkd_custom_sidebar_meta',
		        'type' => 'selectblank',
		        'label' => esc_html__('Choose Widget Area in Sidebar','buro'),
		        'description' => esc_html__('Choose Custom Widget area to display in Sidebar"', 'buro'),
		        'parent' => $buro_mikado_sidebar_meta_box,
		        'options' => $buro_mikado_custom_sidebars
		    ));
		}

	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_sidebar_meta_fields');
}