<?php

//Slider

if(!function_exists('buro_mikado_map_slider_meta_fields')) {

	function buro_mikado_map_slider_meta_fields() {
		$slider_meta_box = buro_mikado_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Background', 'buro'),
				'name' => 'slides_type',
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'          => 'mkd_slide_background_type',
				'type'          => 'select',
				'default_value' => 'image',
				'label'         => esc_html__('Slide Background Type', 'buro'),
				'description'   => esc_html__('Do you want to upload an image or video?', 'buro'),
				'parent'        => $slider_meta_box,
				'options'       => array(
					"image" => esc_html__("Image", 'buro'),
					"video" => esc_html__("Video", 'buro'),
				),
				'args' => array(
					"dependence" => true,
					"hide" => array(
						"image" => "#mkd_mkd_slides_video_settings",
						"video" => "#mkd_mkd_slides_image_settings"
					),
					"show" => array(
						"image" => "#mkd_mkd_slides_image_settings",
						"video" => "#mkd_mkd_slides_video_settings"
					)
				)
			)
		);


		//Slide Image

		$image_meta_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_slides_image_settings',
				'parent' => $slider_meta_box,
				'hidden_property' => 'mkd_slide_background_type',
				'hidden_values' => array('video')
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_image',
				'type'        => 'image',
				'label'       => esc_html__('Slide Image', 'buro'),
				'description' => esc_html__('Choose background image', 'buro'),
				'parent'      => $image_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_overlay_image',
				'type'        => 'image',
				'label'       => esc_html__('Overlay Image', 'buro'),
				'description' => esc_html__('Choose overlay image (pattern) for background image', 'buro'),
				'parent'      => $image_meta_container
			)
		);


		//Slide Video

		$video_meta_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_slides_video_settings',
				'parent' => $slider_meta_box,
				'hidden_property' => 'mkd_slide_background_type',
				'hidden_values' => array('image')
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_video_webm',
				'type'        => 'text',
				'label'       => esc_html__('Video - webm', 'buro'),
				'description' => esc_html__('Path to the webm file that you have previously uploaded in Media Section', 'buro'),
				'parent'      => $video_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_video_mp4',
				'type'        => 'text',
				'label'       => esc_html__('Video - mp4', 'buro'),
				'description' => esc_html__('Path to the mp4 file that you have previously uploaded in Media Section', 'buro'),
				'parent'      => $video_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_video_ogv',
				'type'        => 'text',
				'label'       => esc_html__('Video - ogv', 'buro'),
				'description' => esc_html__('Path to the ogv file that you have previously uploaded in Media Section', 'buro'),
				'parent'      => $video_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_video_image',
				'type'        => 'image',
				'label'       => esc_html__('Video Preview Image', 'buro'),
				'description' => esc_html__('Choose background image that will be visible until video is loaded. This image will be shown on touch devices too.', 'buro'),
				'parent'      => $video_meta_container
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_slide_video_overlay',
				'type' => 'yesempty',
				'default_value' => '',
				'label' => esc_html__('Video Overlay Image', 'buro'),
				'description' => esc_html__('Do you want to have a overlay image on video?', 'buro'),
				'parent' => $video_meta_container,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_mkd_slide_video_overlay_container"
				)
			)
		);

		$slide_video_overlay_container = buro_mikado_add_admin_container(array(
			'name' => 'mkd_slide_video_overlay_container',
			'parent' => $video_meta_container,
			'hidden_property' => 'mkd_slide_video_overlay',
			'hidden_values' => array('','no')
		));

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_video_overlay_image',
				'type'        => 'image',
				'label'       => esc_html__('Overlay Image', 'buro'),
				'description' => esc_html__('Choose overlay image (pattern) for background video.', 'buro'),
				'parent'      => $slide_video_overlay_container
			)
		);


		//Slide Elements

		$elements_meta_box = buro_mikado_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Elements', 'buro'),
				'name' => 'mkd_slides_elements'
			)
		);

		buro_mikado_add_admin_section_title(
			array(
				'parent' => $elements_meta_box,
				'name' => 'mkd_slides_elements_frame',
				'title' => esc_html__('Elements Holder Frame', 'buro'),
			)
		);

		buro_mikado_add_slide_holder_frame_scheme(
			array(
				'parent' => $elements_meta_box
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_elements_alignment',
				'type'        => 'select',
				'label'       => esc_html__('Elements Alignment', 'buro'),
				'description' => esc_html__('How elements are aligned with respect to the Holder Frame', 'buro'),
				'parent'      => $elements_meta_box,
				'default_value' => 'center',
				'options' => array(
					"center" => esc_html__("Center", 'buro'),
					"left" => esc_html__("Left", 'buro'),
					"right" => esc_html__("Right", 'buro'),
					"custom" => esc_html__("Custom", 'buro'),
				),
				'args'        => array(
					"dependence" => true,
					"hide" => array(
						"center" => "#mkd_mkd_slide_holder_frame_height",
						"left" => "#mkd_mkd_slide_holder_frame_height",
						"right" => "#mkd_mkd_slide_holder_frame_height",
						"custom" => ""
					),
					"show" => array(
						"center" => "",
						"left" => "",
						"right" => "",
						"custom" => "#mkd_mkd_slide_holder_frame_height"
					)
				)
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_in_grid',
				'type'        => 'select',
				'label'       => esc_html__('Holder Frame in Grid?', 'buro'),
				'description' => esc_html__('Whether to keep the holder frame width the same as that of the grid.', 'buro'),
				'parent'      => $elements_meta_box,
				'default_value' => 'no',
				'options' => array(
					"yes" => esc_html__("Yes", 'buro'),
					"no" => esc_html__("No", 'buro'),
				),
				'args'        => array(
					"dependence" => true,
					"hide" => array(
						"yes" => "#mkd_mkd_slide_holder_frame_width, #mkd_mkd_holder_frame_responsive_container",
						"no" => ""
					),
					"show" => array(
						"yes" => "",
						"no" => "#mkd_mkd_slide_holder_frame_width, #mkd_mkd_holder_frame_responsive_container"
					)
				)
			)
		);

		$holder_frame = buro_mikado_add_admin_group(array(
			'title' => esc_html__('Holder Frame Properties', 'buro'),
			'description' => esc_html__('The frame is always positioned centrally on the slide. All elements are positioned and sized relatively to the holder frame. Refer to the scheme above.', 'buro'),
			'name' => 'mkd_holder_frame',
			'parent' => $elements_meta_box
		));

		$row1 = buro_mikado_add_admin_row(array(
			'name' => 'row1',
			'parent' => $holder_frame
		));

		$holder_frame_width = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width',
				'type'        => 'textsimple',
				'label'       => esc_html__('Relative width (C/A*100)', 'buro'),
				'parent'      => $row1,
				'hidden_property' => 'mkd_slide_holder_frame_in_grid',
				'hidden_values' => array('yes')
			)
		);

		$holder_frame_height = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_height',
				'type'        => 'textsimple',
				'label'       => esc_html__('Height to width ratio (D/C*100)', 'buro'),
				'parent'      => $row1,
				'hidden_property' => 'mkd_slide_holder_elements_alignment',
				'hidden_values' => array('center', 'left', 'right')
			)
		);

		$holder_frame_responsive_container = buro_mikado_add_admin_container(array(
			'name' => 'mkd_holder_frame_responsive_container',
			'parent' => $elements_meta_box,
			'hidden_property' => 'mkd_slide_holder_frame_in_grid',
			'hidden_values' => array('yes')
		));

		$holder_frame_responsive = buro_mikado_add_admin_group(array(
			'title' => esc_html__('Responsive Relative Width', 'buro'),
			'description' => esc_html__('Enter different relative widths of the holder frame for each responsive stage. Leave blank to have the frame width scale proportionally to the screen size.', 'buro'),
			'name' => 'mkd_holder_frame_responsive',
			'parent' => $holder_frame_responsive_container
		));

		$screen_widths_holder_frame = array(
			// These values must match those in mkd.layout.inc, slider.php and shortcodes.js
			"mobile" => 600,
			"tabletp" => 800,
			"tabletl" => 1024,
			"laptop" => 1440
		);

		$row2 = buro_mikado_add_admin_row(array(
			'name' => 'row2',
			'parent' => $holder_frame_responsive
		));

		$holder_frame_width = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width_mobile',
				'type'        => 'textsimple',
				'label'       => esc_html__('Mobile', 'buro') . '(' . esc_html__('up to', 'buro') . $screen_widths_holder_frame["mobile"].'px)',
				'parent'      => $row2
			)
		);

		$holder_frame_height = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width_tablet_p',
				'type'        => 'textsimple',
				'label'       => esc_html__('Tablet - Portrait', 'buro') . ' ('.($screen_widths_holder_frame["mobile"]+1).'px - '.$screen_widths_holder_frame["tabletp"].'px)',
				'parent'      => $row2
			)
		);

		$holder_frame_height = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width_tablet_l',
				'type'        => 'textsimple',
				'label'       => esc_html__('Tablet - Landscape', 'buro') . ' ('.($screen_widths_holder_frame["tabletp"]+1).'px - '.$screen_widths_holder_frame["tabletl"].'px)',
				'parent'      => $row2
			)
		);

		$row3 = buro_mikado_add_admin_row(array(
			'name' => 'row3',
			'parent' => $holder_frame_responsive
		));

		$holder_frame_width = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width_laptop',
				'type'        => 'textsimple',
				'label'       => esc_html__('Laptop', 'buro') . '('.($screen_widths_holder_frame["tabletl"]+1).'px - '.$screen_widths_holder_frame["laptop"].'px)',
				'parent'      => $row3
			)
		);

		$holder_frame_height = buro_mikado_create_meta_box_field(
			array(
				'name'        => 'mkd_slide_holder_frame_width_desktop',
				'type'        => 'textsimple',
				'label'       => esc_html__('Desktop', 'buro') . '(' . esc_html__('above', 'buro') . $screen_widths_holder_frame["laptop"].'px)',
				'parent'      => $row3
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'parent' => $elements_meta_box,
				'type' => 'text',
				'name' => 'mkd_slide_elements_default_width',
				'label' => esc_html__('Default Screen Width in px (A)', 'buro'),
				'description' => esc_html__('All elements marked as responsive scale at the ratio of the actual screen width to this screen width. Default is 1920px.', 'buro'),
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'parent' => $elements_meta_box,
				'type' => 'select',
				'name' => 'mkd_slide_elements_default_animation',
				'default_value' => 'none',
				'label' => esc_html__('Default Elements Animation', 'buro'),
				'description' => esc_html__('This animation will be applied to all elements except those with their own animation settings.', 'buro'),
				'options' => array(
					"none" => esc_html__("No Animation", 'buro'),
					"flip" => esc_html__("Flip", 'buro'),
					"spin" => esc_html__("Spin", 'buro'),
					"fade" => esc_html__("Fade In", 'buro'),
					"from_bottom" => esc_html__("Fly In From Bottom", 'buro'),
					"from_top" => esc_html__("Fly In From Top", 'buro'),
					"from_left" => esc_html__("Fly In From Left", 'buro'),
					"from_right" => esc_html__("Fly In From Right", 'buro'),
				)
			)
		);

		buro_mikado_add_admin_section_title(
			array(
				'parent' => $elements_meta_box,
				'name' => 'mkd_slides_elements_list',
				'title' => esc_html__('Elements', 'buro'),
			)
		);

		$slide_elements = buro_mikado_add_slide_elements_framework(
			array(
				'parent' => $elements_meta_box,
				'name' => 'mkd_slides_elements_holder',
			)
		);

		//Slide Behaviour

		$behaviours_meta_box = buro_mikado_create_meta_box(
			array(
				'scope' => array('slides'),
				'title' => esc_html__('Slide Behaviours', 'buro'),
				'name' => 'mkd_slides_behaviour_settings',
			)
		);

		buro_mikado_add_admin_section_title(
			array(
				'parent' => $behaviours_meta_box,
				'name' => 'mkd_header_styling_title',
				'title' => esc_html__('Header', 'buro'),
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'parent' => $behaviours_meta_box,
				'type' => 'selectblank',
				'name' => 'mkd_slide_header_style',
				'default_value' => '',
				'label' => esc_html__('Header Style', 'buro'),
				'description' => esc_html__('Header style will be applied when this slide is in focus', 'buro'),
				'options' => array(
					"light" => esc_html__("Light", 'buro'),
					"dark" => esc_html__("Dark", 'buro'),
				)
			)
		);

		buro_mikado_add_admin_section_title(
			array(
				'parent' => $behaviours_meta_box,
				'name' => 'mkd_image_animation_title',
				'title' => esc_html__('Slide Image Animation', 'buro'),
			)
		);

		buro_mikado_create_meta_box_field(
			array(
				'name' => 'mkd_enable_image_animation',
				'type' => 'yesno',
				'default_value' => 'no',
				'label' => esc_html__('Enable Image Animation', 'buro'),
				'description' => esc_html__('Enabling this option will turn on a motion animation on the slide image', 'buro'),
				'parent' => $behaviours_meta_box,
				'args' => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_mkd_enable_image_animation_container"
				)
			)
		);

		$enable_image_animation_container = buro_mikado_add_admin_container(array(
			'name' => 'mkd_enable_image_animation_container',
			'parent' => $behaviours_meta_box,
			'hidden_property' => 'mkd_enable_image_animation',
			'hidden_value' => 'no'
		));

		buro_mikado_create_meta_box_field(
			array(
				'parent' => $enable_image_animation_container,
				'type' => 'select',
				'name' => 'mkd_enable_image_animation_type',
				'default_value' => 'zoom_center',
				'label' => esc_html__('Animation Type', 'buro'),
				'options' => array(
					"zoom_center" => esc_html__("Zoom In Center", 'buro'),
					"zoom_top_left" => esc_html__("Zoom In to Top Left", 'buro'),
					"zoom_top_right" => esc_html__("Zoom In to Top Right", 'buro'),
					"zoom_bottom_left" => esc_html__("Zoom In to Bottom Left", 'buro'),
					"zoom_bottom_right" => esc_html__("Zoom In to Bottom Right", 'buro'),
				)
			)
		);
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_slider_meta_fields');
}