<?php

if(!function_exists('buro_mikado_map_title_meta_fields')) {

	function buro_mikado_map_title_meta_fields() {
		$title_meta_box = buro_mikado_create_meta_box(
		    array(
		        'scope' => array('page', 'portfolio-item', 'post'),
		        'title' => esc_html__('Title', 'buro'),
		        'name' => 'title_meta',
		    )
		);

	    buro_mikado_create_meta_box_field(
	        array(
	            'name' => 'mkd_show_title_area_meta',
	            'type' => 'select',
	            'default_value' => '',
	            'label' => esc_html__('Show Title Area', 'buro'),
	            'description' => esc_html__('Disabling this option will turn off page title area', 'buro'),
	            'parent' => $title_meta_box,
	            'options' => array(
	                '' => '',
	                'no' => esc_html__('No','buro'),
	                'yes' => esc_html__('Yes','buro'),
	            ),
	            'args' => array(
	                "dependence" => true,
	                "hide" => array(
	                    "" => "",
	                    "no" => "#mkd_mkd_show_title_area_meta_container",
	                    "yes" => ""
	                ),
	                "show" => array(
	                    "" => "#mkd_mkd_show_title_area_meta_container",
	                    "no" => "",
	                    "yes" => "#mkd_mkd_show_title_area_meta_container"
	                )
	            )
	        )
	    );

	    $show_title_area_meta_container = buro_mikado_add_admin_container(
	        array(
	            'parent' => $title_meta_box,
	            'name' => 'mkd_show_title_area_meta_container',
	            'hidden_property' => 'mkd_show_title_area_meta',
	            'hidden_value' => 'no'
	        )
	    );


        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_in_grid_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Title Area in Grid', 'buro'),
                'description' => esc_html__('Choose wheter for title content to be in grid', 'buro'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'yes' => esc_html__('Yes','buro'),
                    'no' => esc_html__('No','buro')
                )
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_type_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Title Area Type', 'buro'),
                'description' => esc_html__('Choose title type', 'buro'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'standard' => esc_html__('Standard','buro'),
                    'breadcrumb' => esc_html__('Breadcrumb','buro'),
                ),
                'args' => array(
                    "dependence" => true,
                    "hide" => array(
                        "standard" => "",
                        "standard" => "",
                        "breadcrumb" => "#mkd_mkd_title_area_type_meta_container"
                    ),
                    "show" => array(
                        "" => "#mkd_mkd_title_area_type_meta_container",
                        "standard" => "#mkd_mkd_title_area_type_meta_container",
                        "breadcrumb" => ""
                    )
                )
            )
        );

        $title_area_type_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $show_title_area_meta_container,
                'name' => 'mkd_title_area_type_meta_container',
                'hidden_property' => 'mkd_title_area_type_meta',
                'hidden_value' => '',
                'hidden_values' => array('breadcrumb'),
            )
        );

            buro_mikado_create_meta_box_field(
                array(
                    'name' => 'mkd_title_area_enable_breadcrumbs_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' => esc_html__('Enable Breadcrumbs', 'buro'),
                    'description' => esc_html__('This option will display Breadcrumbs in Title Area', 'buro'),
                    'parent' => $title_area_type_meta_container,
                    'options' => array(
                        '' => '',
                        'no' => esc_html__('No','buro'),
                        'yes' => esc_html__('Yes','buro'),
                    ),
                )
            );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_animation_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Animations', 'buro'),
                'description' => esc_html__('Choose an animation for Title Area', 'buro'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'no' => esc_html__('No Animation','buro'),
                    'right-left' => esc_html__('Text right to left','buro'),
                    'left-right' => esc_html__('Text left to right','buro'),
                )
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_vertial_alignment_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Vertical Alignment', 'buro'),
                'description' => esc_html__('Specify title vertical alignment', 'buro'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'header_bottom' => esc_html__('From Bottom of Header','buro'),
                    'window_top' => esc_html__('From Window Top','buro'),
                )
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_content_alignment_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Horizontal Alignment', 'buro'),
                'description' => esc_html__('Specify title horizontal alignment', 'buro'),
                'parent' => $show_title_area_meta_container,
                'options' => array(
                    '' => '',
                    'left' => esc_html__('Left','buro'),
                    'center' => esc_html__('Center','buro'),
                    'right' => esc_html__('Right','buro')
                )
            )
        );

		buro_mikado_create_meta_box_field(
			array(
				'name'			=> 'mkd_title_area_text_size_meta',
				'type'			=> 'select',
				'default_value'	=> '',
				'label'			=> esc_html__('Text Size', 'buro'),
				'description'	=> esc_html__('Choose a default Title size', 'buro'),
				'parent'		=> $show_title_area_meta_container,
				'options'		=> array(
					'' => '',
					'small'     => esc_html__('Small','buro'),
					'medium'    => esc_html__('Medium','buro'),
					'large'     => esc_html__('Large','buro')


				)
			)
		);

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_text_color_meta',
                'type' => 'color',
                'label' => esc_html__('Title Color', 'buro'),
                'description' => esc_html__('Choose a color for title text', 'buro'),
                'parent' => $show_title_area_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_breadcrumb_color_meta',
                'type' => 'color',
                'label' => esc_html__('Breadcrumb Color', 'buro'),
                'description' => esc_html__('Choose a color for breadcrumb text', 'buro'),
                'parent' => $show_title_area_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_color_meta',
                'type' => 'color',
                'label' => 'Background Color',
                'description' => esc_html__('Choose a background color for Title Area', 'buro'),
                'parent' => $show_title_area_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_hide_background_image_meta',
                'type' => 'yesno',
                'default_value' => 'no',
                'label' => esc_html__('Hide Background Image', 'buro'),
                'description' => esc_html__('Enable this option to hide background image in Title Area', 'buro'),
                'parent' => $show_title_area_meta_container,
                'args' => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "#mkd_mkd_hide_background_image_meta_container",
                    "dependence_show_on_yes" => ""
                )
            )
        );

        $hide_background_image_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $show_title_area_meta_container,
                'name' => 'mkd_hide_background_image_meta_container',
                'hidden_property' => 'mkd_hide_background_image_meta',
                'hidden_value' => 'yes'
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_image_meta',
                'type' => 'image',
                'label' => esc_html__('Background Image', 'buro'),
                'description' => esc_html__('Choose an Image for Title Area', 'buro'),
                'parent' => $hide_background_image_meta_container
            )
        );

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_title_area_background_image_responsive_meta',
                'type' => 'select',
                'default_value' => '',
                'label' => esc_html__('Background Responsive Image', 'buro'),
                'description' => esc_html__('Enabling this option will make Title background image responsive', 'buro'),
                'parent' => $hide_background_image_meta_container,
                'options' => array(
                    '' => '',
                    'no' => esc_html__('No','buro'),
                    'yes' => esc_html__('Yes','buro')
                ),
                'args' => array(
                    "dependence" => true,
                    "hide" => array(
                        "" => "",
                        "no" => "",
                        "yes" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta"
                    ),
                    "show" => array(
                        "" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta",
                        "no" => "#mkd_mkd_title_area_background_image_responsive_meta_container, #mkd_mkd_title_area_height_meta",
                        "yes" => ""
                    )
                )
            )
        );

        $title_area_background_image_responsive_meta_container = buro_mikado_add_admin_container(
            array(
                'parent' => $hide_background_image_meta_container,
                'name' => 'mkd_title_area_background_image_responsive_meta_container',
                'hidden_property' => 'mkd_title_area_background_image_responsive_meta',
                'hidden_value' => 'yes'
            )
        );

            buro_mikado_create_meta_box_field(
                array(
                    'name' => 'mkd_title_area_background_image_parallax_meta',
                    'type' => 'select',
                    'default_value' => '',
                    'label' => esc_html__('Background Image in Parallax', 'buro'),
                    'description' => esc_html__('Enabling this option will make Title background image parallax', 'buro'),
                    'parent' => $title_area_background_image_responsive_meta_container,
                    'options' => array(
                        '' => '',
                        'no' => esc_html__('No','buro'),
                        'yes' => esc_html__('Yes','buro'),
                        'yes_zoom' => esc_html__('Yes, with zoom out','buro')
                    )
                )
            );

        buro_mikado_create_meta_box_field(array(
            'name' => 'mkd_title_area_height_meta',
            'type' => 'text',
            'label' => esc_html__('Height', 'buro'),
            'description' => esc_html__('Set a height for Title Area', 'buro'),
            'parent' => $show_title_area_meta_container,
            'args' => array(
                'col_width' => 2,
                'suffix' => 'px'
            )
        ));

        buro_mikado_create_meta_box_field(array(
            'name' => 'mkd_title_area_subtitle_meta',
            'type' => 'text',
            'default_value' => '',
            'label' => esc_html__('Subtitle Text', 'buro'),
            'description' => esc_html__('Enter your subtitle text', 'buro'),
            'parent' => $show_title_area_meta_container,
            'args' => array(
                'col_width' => 6
            )
        ));

        buro_mikado_create_meta_box_field(
            array(
                'name' => 'mkd_subtitle_color_meta',
                'type' => 'color',
                'label' => esc_html__('Subtitle Color', 'buro'),
                'description' => esc_html__('Choose a color for subtitle text', 'buro'),
                'parent' => $show_title_area_meta_container
            )
        );
	}
	
	add_action('buro_mikado_meta_boxes_map', 'buro_mikado_map_title_meta_fields');
}