<?php

if ( ! function_exists('buro_mikado_general_options_map') ) {
	/**
	 * General options page
	 */
	function buro_mikado_general_options_map() {

		buro_mikado_add_admin_page(
			array(
				'slug'  => '',
				'title' => esc_html__('General', 'buro'),
				'icon'  => 'fa fa-institution'
			)
		);

        $panel_logo = buro_mikado_add_admin_panel(
            array(
                'page' => '',
                'name' => 'panel_logo',
                'title' => esc_html__('Branding', 'buro'),
            )
        );

        buro_mikado_add_admin_field(
            array(
                'parent' => $panel_logo,
                'type' => 'yesno',
                'name' => 'hide_logo',
                'default_value' => 'no',
                'label' => esc_html__('Hide Logo', 'buro'),
                'description' => esc_html__('Enabling this option will hide logo image', 'buro'),
                'args' => array(
                    "dependence" => true,
                    "dependence_hide_on_yes" => "#mkd_hide_logo_container",
                    "dependence_show_on_yes" => ""
                )
            )
        );

        $hide_logo_container = buro_mikado_add_admin_container(
            array(
                'parent' => $panel_logo,
                'name' => 'hide_logo_container',
                'hidden_property' => 'hide_logo',
                'hidden_value' => 'yes'
            )
        );

        buro_mikado_add_admin_field(
            array(
                'name' => 'logo_image',
                'type' => 'image',
                'default_value' => MIKADO_ASSETS_ROOT."/img/logo.png",
                'label' => esc_html__('Logo Image - Default', 'buro'),
                'description' => esc_html__('Choose a default logo image to display ', 'buro'),
                'parent' => $hide_logo_container
            )
        );

        buro_mikado_add_admin_field(
            array(
                'name' => 'logo_image_dark',
                'type' => 'image',
                'default_value' => MIKADO_ASSETS_ROOT."/img/logo_dark.png",
                'label' => esc_html__('Logo Image - Dark', 'buro'),
                'description' => esc_html__('Choose a default logo image to display ', 'buro'),
                'parent' => $hide_logo_container
            )
        );

        buro_mikado_add_admin_field(
            array(
                'name' => 'logo_image_light',
                'type' => 'image',
                'default_value' => MIKADO_ASSETS_ROOT."/img/logo_light.png",
                'label' => esc_html__('Logo Image - Light', 'buro'),
                'description' => esc_html__('Choose a default logo image to display ', 'buro'),
                'parent' => $hide_logo_container
            )
        );

        buro_mikado_add_admin_field(
            array(
                'name' => 'logo_image_sticky',
                'type' => 'image',
                'default_value' => MIKADO_ASSETS_ROOT."/img/logo.png",
                'label' => esc_html__('Logo Image - Sticky', 'buro'),
                'description' => esc_html__('Choose a default logo image to display ', 'buro'),
                'parent' => $hide_logo_container
            )
        );

        buro_mikado_add_admin_field(
            array(
                'name' => 'logo_image_mobile',
                'type' => 'image',
                'default_value' => MIKADO_ASSETS_ROOT."/img/logo.png",
                'label' => esc_html__('Logo Image - Mobile', 'buro'),
                'description' => esc_html__('Choose a default logo image to display ', 'buro'),
                'parent' => $hide_logo_container
            )
        );

		$panel_design_style = buro_mikado_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_design_style',
				'title' => esc_html__('Appearance', 'buro'),
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'google_fonts',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose a default Google font for your site', 'buro'),
				'parent'		=> $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'google_fonts_second',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Second Font Family','buro'),
				'description'   => esc_html__('Choose a second default Google font for your site(default is Montserrat)','buro'),
				'parent' 		=> $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_fonts',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__('Additional Google Fonts', 'buro'),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_additional_google_fonts_container"
				)
			)
		);

		$additional_google_fonts_container = buro_mikado_add_admin_container(
			array(
				'parent'            => $panel_design_style,
				'name'              => 'additional_google_fonts_container',
				'hidden_property'   => 'additional_google_fonts',
				'hidden_value'      => 'no'
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_font1',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose additional Google font for your site', 'buro'),
				'parent'        => $additional_google_fonts_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_font2',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose additional Google font for your site', 'buro'),
				'parent'        => $additional_google_fonts_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_font3',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose additional Google font for your site', 'buro'),
				'parent'        => $additional_google_fonts_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_font4',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose additional Google font for your site', 'buro'),
				'parent'        => $additional_google_fonts_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'additional_google_font5',
				'type'          => 'font',
				'default_value' => '-1',
				'label'         => esc_html__('Font Family', 'buro'),
				'description'   => esc_html__('Choose additional Google font for your site', 'buro'),
				'parent'        => $additional_google_fonts_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'first_color',
				'type'          => 'color',
				'label'         => esc_html__('First Main Color', 'buro'),
				'description'   => esc_html__('Choose the most dominant theme color. Default color is #ffd401', 'buro'),
				'parent'        => $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'second_color',
				'type'          => 'color',
				'label'         => esc_html__('Second Main Color', 'buro'),
				'description'   => esc_html__('Choose the second dominant theme color. Default color is #ec008c', 'buro'),
				'parent'        => $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'page_background_color',
				'type'          => 'color',
				'label'         => esc_html__('Page Background Color', 'buro'),
				'description'   => esc_html__('Choose the background color for page content. Default color is #ffffff', 'buro'),
				'parent'        => $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'selection_color',
				'type'          => 'color',
				'label'         => esc_html__('Text Selection Color', 'buro'),
				'description'   => esc_html__('Choose the color users see when selecting text', 'buro'),
				'parent'        => $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'boxed',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__('Boxed Layout', 'buro'),
				'parent'        => $panel_design_style,
				'args'          => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_boxed_container"
				)
			)
		);

		$boxed_container = buro_mikado_add_admin_container(
			array(
				'parent'            => $panel_design_style,
				'name'              => 'boxed_container',
				'hidden_property'   => 'boxed',
				'hidden_value'      => 'no'
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'page_background_color_in_box',
				'type'          => 'color',
				'label'         => esc_html__('Page Background Color', 'buro'),
				'description'   => esc_html__('Choose the page background color outside box.', 'buro'),
				'parent'        => $boxed_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'boxed_background_image',
				'type'          => 'image',
				'label'         => esc_html__('Background Image', 'buro'),
				'description'   => esc_html__('Choose an image to be displayed in background', 'buro'),
				'parent'        => $boxed_container
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'boxed_background_image_repeating',
				'type'          => 'select',
				'default_value' => 'no',
				'label'         => esc_html__('Use Background Image as Pattern', 'buro'),
				'description'   => esc_html__('Set this option to "yes" to use the background image as repeating pattern', 'buro'),
				'parent'        => $boxed_container,
				'options'       => array(
					'no'	=>	esc_html__('No', 'buro'),
					'yes'	=>	esc_html__('Yes', 'buro'),
				)
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'boxed_background_image_attachment',
				'type'          => 'select',
				'default_value' => 'fixed',
				'label'         => esc_html__('Background Image Behaviour', 'buro'),
				'description'   => esc_html__('Choose background image behaviour', 'buro'),
				'parent'        => $boxed_container,
				'options'       => array(
					'fixed'     => esc_html__('Fixed', 'buro'),
					'scroll'    => esc_html__('Scroll', 'buro'),
				)
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'initial_content_width',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__('Initial Width of Content', 'buro'),
				'description'   => esc_html__('Choose the initial width of content which is in grid. Applies to pages set to "Default Template" and rows set to "In Grid"', 'buro'),
				'parent'        => $panel_design_style,
				'options'       => array(
					""          => esc_html__("1300px - default",'buro'),
					"grid-1300" => esc_html__("1300px",'buro'),
					"grid-1200" => esc_html__("1200px",'buro'),
					"grid-1000" => esc_html__("1000px",'buro'),
					"grid-800"  => esc_html__("800px",'buro')
				)
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'preload_pattern_image',
				'type'          => 'image',
				'label'         => esc_html__('Preload Pattern Image', 'buro'),
				'description'   => esc_html__('Choose preload pattern image to be displayed until images are loaded ', 'buro'),
				'parent'        => $panel_design_style
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name' => 'element_appear_amount',
				'type' => 'text',
				'label' => esc_html__('Element Appearance', 'buro'),
				'description' => esc_html__('For animated elements, set distance (related to browser bottom) to start the animation', 'buro'),
				'parent' => $panel_design_style,
				'args' => array(
					'col_width' => 2,
					'suffix' => 'px'
				)
			)
		);

		$panel_settings = buro_mikado_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_settings',
				'title' => esc_html__('Behavior', 'buro'),
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'smooth_scroll',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__('Smooth Scroll', 'buro'),
				'description'   => esc_html__('Enabling this option will perform a smooth scrolling effect on every page (except on Mac and touch devices)', 'buro'),
				'parent'        => $panel_settings
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'smooth_page_transitions',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__('Smooth Page Transitions', 'buro'),
				'description'   => esc_html__('Enabling this option will perform a smooth transition between pages when clicking on links.', 'buro'),
				'parent'        => $panel_settings,
				'args'          => array(
					"dependence" => true,
					"dependence_hide_on_yes" => "",
					"dependence_show_on_yes" => "#mkd_page_transitions_container"
				)
			)
		);

		$page_transitions_container = buro_mikado_add_admin_container(
			array(
				'parent'            => $panel_settings,
				'name'              => 'page_transitions_container',
				'hidden_property'   => 'smooth_page_transitions',
				'hidden_value'      => 'no'
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'smooth_pt_bgnd_color',
				'type'          => 'color',
				'label'         => esc_html__('Page Loader Background Color', 'buro'),
				'parent'        => $page_transitions_container
			)
		);

		$group_pt_spinner_animation = buro_mikado_add_admin_group(array(
			'name'          => 'group_pt_spinner_animation',
			'title'         => esc_html__('Loader Style', 'buro'),
			'description'   => esc_html__('Define styles for loader spinner animation', 'buro'),
			'parent'        => $page_transitions_container
		));

		$row_pt_spinner_animation = buro_mikado_add_admin_row(array(
			'name'      => 'row_pt_spinner_animation',
			'parent'    => $group_pt_spinner_animation
		));

		buro_mikado_add_admin_field(array(
			'type'          => 'selectsimple',
			'name'          => 'smooth_pt_spinner_type',
			'default_value' => '',
			'label'         => esc_html__('Spinner Type', 'buro'),
			'parent'        => $row_pt_spinner_animation,
			'options'       => array(
				"pulse" => esc_html__("Pulse", 'buro'),
				"double_pulse" => esc_html__("Double Pulse", 'buro'),
				"cube" => esc_html__("Cube", 'buro'),
				"rotating_cubes" => esc_html__("Rotating Cubes", 'buro'),
				"stripes" => esc_html__("Stripes", 'buro'),
				"wave" => esc_html__("Wave", 'buro'),
				"two_rotating_circles" => esc_html__("2 Rotating Circles", 'buro'),
				"five_rotating_circles" => esc_html__("5 Rotating Circles", 'buro'),
				"atom" => esc_html__("Atom", 'buro'),
				"clock" => esc_html__("Clock", 'buro'),
				"mitosis" => esc_html__("Mitosis", 'buro'),
				"lines" => esc_html__("Lines", 'buro'),
				"fussion" => esc_html__("Fussion", 'buro'),
				"wave_circles" => esc_html__("Wave Circles", 'buro'),
				"pulse_circles" => esc_html__("Pulse Circles", 'buro'),
			)
		));

		buro_mikado_add_admin_field(array(
			'type'          => 'colorsimple',
			'name'          => 'smooth_pt_spinner_color',
			'default_value' => '',
			'label'         => esc_html__('Spinner Color', 'buro'),
			'parent'        => $row_pt_spinner_animation
		));

		buro_mikado_add_admin_field(
			array(
				'name'          => 'show_back_button',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__('Show "Back To Top Button"', 'buro'),
				'description'   => esc_html__('Enabling this option will display a Back to Top button on every page', 'buro'),
				'parent'        => $panel_settings
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'responsiveness',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__('Responsiveness', 'buro'),
				'description'   => esc_html__('Enabling this option will make all pages responsive', 'buro'),
				'parent'        => $panel_settings
			)
		);

		$panel_custom_code = buro_mikado_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_custom_code',
				'title' => esc_html__('Custom Code', 'buro'),
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'custom_css',
				'type'          => 'textarea',
				'label'         => esc_html__('Custom CSS', 'buro'),
				'description'   => esc_html__('Enter your custom CSS here', 'buro'),
				'parent'        => $panel_custom_code
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'          => 'custom_js',
				'type'          => 'textarea',
				'label'         => esc_html__('Custom JS', 'buro'),
				'description'   => esc_html__('Enter your custom Javascript here', 'buro'),
				'parent'        => $panel_custom_code
			)
		);

		$panel_google_api = buro_mikado_add_admin_panel(
			array(
				'page'  => '',
				'name'  => 'panel_google_api',
				'title' => esc_html__('Google API', 'buro'),
			)
		);

		buro_mikado_add_admin_field(
			array(
				'name'        => 'google_maps_api_key',
				'type'        => 'text',
				'label'       => esc_html__('Google Maps Api Key', 'buro'),
				'description' => esc_html__('Insert your Google Maps API key here. For instructions on how to create a Google Maps API key, please refer to our documentation.', 'buro'),
				'parent'      => $panel_google_api
			)
		);
	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_general_options_map', 1);

}