<?php

if ( ! function_exists('buro_mikado_page_options_map') ) {

    function buro_mikado_page_options_map() {

        buro_mikado_add_admin_page(
            array(
                'slug'  => '_page_page',
                'title' => esc_html__('Page', 'buro'),
                'icon'  => 'fa fa-file-o'
            )
        );

        $custom_sidebars = buro_mikado_get_custom_sidebars();

        $panel_sidebar = buro_mikado_add_admin_panel(
            array(
                'page'  => '_page_page',
                'name'  => 'panel_sidebar',
                'title' => esc_html__('Design Style', 'buro'),
            )
        );

        buro_mikado_add_admin_field(array(
            'name'        => 'page_sidebar_layout',
            'type'        => 'select',
            'label'       => esc_html__('Sidebar Layout', 'buro'),
            'description' => esc_html__('Choose a sidebar layout for pages', 'buro'),
            'default_value' => 'default',
            'parent'      => $panel_sidebar,
            'options'     => array(
                'default'			=> esc_html__('No Sidebar', 'buro'),
                'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right', 'buro'),
                'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right', 'buro'),
                'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left', 'buro'),
                'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left', 'buro'),
            )
        ));


        if(count($custom_sidebars) > 0) {
            buro_mikado_add_admin_field(array(
                'name' => 'page_custom_sidebar',
                'type' => 'selectblank',
                'label' => esc_html__('Sidebar to Display', 'buro'),
                'description' => esc_html__('Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'buro'),
                'parent' => $panel_sidebar,
                'options' => $custom_sidebars
            ));
        }

        $panel_widgets = buro_mikado_add_admin_panel(
            array(
                'page'  => '_page_page',
                'name'  => 'panel_widgets',
                'title' => esc_html__('Widgets', 'buro'),
            )
        );

        /**
         * Navigation style
         */
        buro_mikado_add_admin_field(array(
            'type'			=> 'color',
            'name'			=> 'sidebar_background_color',
            'default_value'	=> '',
            'label'			=> esc_html__('Sidebar Background Color', 'buro'),
            'description'	=> esc_html__('Choose background color for sidebar', 'buro'),
            'parent'		=> $panel_widgets
        ));

        $group_sidebar_padding = buro_mikado_add_admin_group(array(
            'name'		=> 'group_sidebar_padding',
            'title'		=> esc_html__('Padding', 'buro'),
            'parent'	=> $panel_widgets
        ));

        $row_sidebar_padding = buro_mikado_add_admin_row(array(
            'name'		=> 'row_sidebar_padding',
            'parent'	=> $group_sidebar_padding
        ));

        buro_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'sidebar_padding_top',
            'default_value'	=> '',
            'label'			=> esc_html__('Top Padding', 'buro'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_sidebar_padding
        ));

        buro_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'sidebar_padding_right',
            'default_value'	=> '',
            'label'			=> esc_html__('Right Padding', 'buro'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_sidebar_padding
        ));

        buro_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'sidebar_padding_bottom',
            'default_value'	=> '',
            'label'			=> esc_html__('Bottom Padding', 'buro'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_sidebar_padding
        ));

        buro_mikado_add_admin_field(array(
            'type'			=> 'textsimple',
            'name'			=> 'sidebar_padding_left',
            'default_value'	=> '',
            'label'			=> esc_html__('Left Padding', 'buro'),
            'args'			=> array(
                'suffix'	=> 'px'
            ),
            'parent'		=> $row_sidebar_padding
        ));

        buro_mikado_add_admin_field(array(
            'type'			=> 'select',
            'name'			=> 'sidebar_alignment',
            'default_value'	=> '',
            'label'			=> esc_html__('Text Alignment', 'buro'),
            'description'	=> esc_html__('Choose text aligment', 'buro'),
            'options'		=> array(
                'left' => esc_html__('Left', 'buro'),
                'center' => esc_html__('Center', 'buro'),
                'right' => esc_html__('Right', 'buro'),
            ),
            'parent'		=> $panel_widgets
        ));

    }

    add_action( 'buro_mikado_options_map', 'buro_mikado_page_options_map', 7);

}