<?php

if ( ! function_exists('buro_mikado_parallax_options_map') ) {
	/**
	 * Parallax options page
	 */
	function buro_mikado_parallax_options_map()
	{

		$panel_parallax = buro_mikado_add_admin_panel(
			array(
				'page'  => '_elements_page',
				'name'  => 'panel_parallax',
				'title' => esc_html__('Parallax', 'buro'),
			)
		);

		buro_mikado_add_admin_field(array(
			'type'			=> 'onoff',
			'name'			=> 'parallax_on_off',
			'default_value'	=> 'off',
			'label'			=> esc_html__('Parallax on touch devices', 'buro'),
			'description'	=> esc_html__('Enabling this option will allow parallax on touch devices', 'buro'),
			'parent'		=> $panel_parallax
		));

		buro_mikado_add_admin_field(array(
			'type'			=> 'text',
			'name'			=> 'parallax_min_height',
			'default_value'	=> '400',
			'label'			=> esc_html__('Parallax Min Height', 'buro'),
			'description'	=> esc_html__('Set a minimum height for parallax images on small displays (phones, tablets, etc.)', 'buro'),
			'args'			=> array(
				'col_width'	=> 3,
				'suffix'	=> 'px'
			),
			'parent'		=> $panel_parallax
		));

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_parallax_options_map',20);

}