<?php

if ( ! function_exists('buro_mikado_reset_options_map') ) {
	/**
	 * Reset options panel
	 */
	function buro_mikado_reset_options_map() {

		buro_mikado_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__('Reset', 'buro'),
				'icon'  => 'fa fa-retweet'
			)
		);

		$panel_reset = buro_mikado_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__('Reset', 'buro'),
			)
		);

		buro_mikado_add_admin_field(array(
			'type'	=> 'yesno',
			'name'	=> 'reset_to_defaults',
			'default_value'	=> 'no',
			'label'			=> esc_html__('Reset to Defaults', 'buro'),
			'description'	=> esc_html__('This option will reset all Mikado Options values to defaults', 'buro'),
			'parent'		=> $panel_reset
		));

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_reset_options_map', 20);

}