<?php

/*
   Interface: iBuroMikadoLayoutNode
   A interface that implements Layout Node methods
*/
interface iBuroMikadoLayoutNode
{
	public function hasChidren();
	public function getChild($key);
	public function addChild($key, $value);
}

/*
   Interface: iBuroMikadoRender
   A interface that implements Render methods
*/
interface iBuroMikadoRender
{
	public function render($factory);
}

/*
   Class: BuroMikadoPanel
   A class that initializes Mikado Panel
*/
class BuroMikadoPanel implements iBuroMikadoLayoutNode, iBuroMikadoRender {

	public $children;
	public $title;
	public $name;
	public $hidden_property;
	public $hidden_value;
	public $hidden_values;

	function __construct($title_label="",$name="",$hidden_property="",$hidden_value="",$hidden_values=array()) {
		$this->children = array();
		$this->title = $title_label;
		$this->name = $name;
		$this->hidden_property = $hidden_property;
		$this->hidden_value = $hidden_value;
		$this->hidden_values = $hidden_values;
	}

	public function hasChidren() {
		return (count($this->children) > 0)?true:false;
	}

	public function getChild($key) {
		return $this->children[$key];
	}

	public function addChild($key, $value) {
		$this->children[$key] = $value;
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			if (buro_mikado_option_get_value($this->hidden_property)==$this->hidden_value)
				$hidden = true;
			else {
				foreach ($this->hidden_values as $value) {
					if (buro_mikado_option_get_value($this->hidden_property)==$value)
						$hidden = true;

				}
			}
		}
		?>
		<div class="mkd-page-form-section-holder" id="mkd_<?php echo esc_attr($this->name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<h3 class="mkd-page-section-title"><?php echo esc_html($this->title); ?></h3>
			<?php
			foreach ($this->children as $child) {
				$this->renderChild($child, $factory);
			}
			?>
		</div>
	<?php
	}

	public function renderChild(iBuroMikadoRender $child, $factory) {
		$child->render($factory);
	}
}

/*
   Class: BuroMikadoContainer
   A class that initializes Mikado Container
*/
class BuroMikadoContainer implements iBuroMikadoLayoutNode, iBuroMikadoRender {

	public $children;
	public $name;
	public $hidden_property;
	public $hidden_value;
	public $hidden_values;

	function __construct($name="",$hidden_property="",$hidden_value="",$hidden_values=array()) {
		$this->children = array();
		$this->name = $name;
		$this->hidden_property = $hidden_property;
		$this->hidden_value = $hidden_value;
		$this->hidden_values = $hidden_values;
	}

	public function hasChidren() {
		return (count($this->children) > 0)?true:false;
	}

	public function getChild($key) {
		return $this->children[$key];
	}

	public function addChild($key, $value) {
		$this->children[$key] = $value;
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			if (buro_mikado_option_get_value($this->hidden_property)==$this->hidden_value)
				$hidden = true;
			else {
				foreach ($this->hidden_values as $value) {
					if (buro_mikado_option_get_value($this->hidden_property)==$value)
						$hidden = true;

				}
			}
		}
		?>
		<div class="mkd-page-form-container-holder" id="mkd_<?php echo esc_attr($this->name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<?php
			foreach ($this->children as $child) {
				$this->renderChild($child, $factory);
			}
			?>
		</div>
	<?php
	}

	public function renderChild(iBuroMikadoRender $child, $factory) {
		$child->render($factory);
	}
}


/*
   Class: BuroMikadoContainerNoStyle
   A class that initializes Mikado Container without css classes
*/
class BuroMikadoContainerNoStyle implements iBuroMikadoLayoutNode, iBuroMikadoRender {

	public $children;
	public $name;
	public $hidden_property;
	public $hidden_value;
	public $hidden_values;

	function __construct($name="",$hidden_property="",$hidden_value="",$hidden_values=array()) {
		$this->children = array();
		$this->name = $name;
		$this->hidden_property = $hidden_property;
		$this->hidden_value = $hidden_value;
		$this->hidden_values = $hidden_values;
	}

	public function hasChidren() {
		return (count($this->children) > 0)?true:false;
	}

	public function getChild($key) {
		return $this->children[$key];
	}

	public function addChild($key, $value) {
		$this->children[$key] = $value;
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			if (buro_mikado_option_get_value($this->hidden_property)==$this->hidden_value)
				$hidden = true;
			else {
				foreach ($this->hidden_values as $value) {
					if (buro_mikado_option_get_value($this->hidden_property)==$value)
						$hidden = true;

				}
			}
		}
		?>
		<div id="mkd_<?php echo esc_attr($this->name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<?php
			foreach ($this->children as $child) {
				$this->renderChild($child, $factory);
			}
			?>
		</div>
	<?php
	}

	public function renderChild(iBuroMikadoRender $child, $factory) {
		$child->render($factory);
	}
}

/*
   Class: BuroMikadoGroup
   A class that initializes Mikado Group
*/
class BuroMikadoGroup implements iBuroMikadoLayoutNode, iBuroMikadoRender {

	public $children;
	public $title;
	public $description;

	function __construct($title_label="",$description="") {
		$this->children = array();
		$this->title = $title_label;
		$this->description = $description;
	}

	public function hasChidren() {
		return (count($this->children) > 0)?true:false;
	}

	public function getChild($key) {
		return $this->children[$key];
	}

	public function addChild($key, $value) {
		$this->children[$key] = $value;
	}

	public function render($factory) {
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($this->title); ?></h4>

				<p><?php echo esc_html($this->description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<?php
					foreach ($this->children as $child) {
						$this->renderChild($child, $factory);
					}
					?>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php
	}

	public function renderChild(iBuroMikadoRender $child, $factory) {
		$child->render($factory);
	}
}

/*
   Class: BuroMikadoNotice
   A class that initializes Mikado Notice
*/
class BuroMikadoNotice implements iBuroMikadoRender {

	public $children;
	public $title;
	public $description;
	public $notice;
	public $hidden_property;
	public $hidden_value;
	public $hidden_values;

	function __construct($title_label="",$description="",$notice="",$hidden_property="",$hidden_value="",$hidden_values=array()) {
		$this->children = array();
		$this->title = $title_label;
		$this->description = $description;
		$this->notice = $notice;
		$this->hidden_property = $hidden_property;
		$this->hidden_value = $hidden_value;
		$this->hidden_values = $hidden_values;
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			if (buro_mikado_option_get_value($this->hidden_property)==$this->hidden_value)
				$hidden = true;
			else {
				foreach ($this->hidden_values as $value) {
					if (buro_mikado_option_get_value($this->hidden_property)==$value)
						$hidden = true;

				}
			}
		}
		?>

		<div class="mkd-page-form-section"<?php if ($hidden) { ?> style="display: none"<?php } ?>>


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($this->title); ?></h4>

				<p><?php echo esc_html($this->description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="alert alert-warning">
						<?php echo esc_html($this->notice); ?>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php
	}
}

/*
   Class: BuroMikadoRow
   A class that initializes Mikado Row
*/
class BuroMikadoRow implements iBuroMikadoLayoutNode, iBuroMikadoRender {

	public $children;
	public $next;

	function __construct($next=false) {
		$this->children = array();
		$this->next = $next;
	}

	public function hasChidren() {
		return (count($this->children) > 0)?true:false;
	}

	public function getChild($key) {
		return $this->children[$key];
	}

	public function addChild($key, $value) {
		$this->children[$key] = $value;
	}

	public function render($factory) {
		?>
		<div class="row<?php if ($this->next) echo " next-row"; ?>">
			<?php
			foreach ($this->children as $child) {
				$this->renderChild($child, $factory);
			}
			?>
		</div>
	<?php
	}

	public function renderChild(iBuroMikadoRender $child, $factory) {
		$child->render($factory);
	}
}

/*
   Class: BuroMikadoTitle
   A class that initializes Mikado Title
*/
class BuroMikadoTitle implements iBuroMikadoRender {
	private $name;
	private $title;
	public $hidden_property;
	public $hidden_values = array();

	function __construct($name="",$title_label="",$hidden_property="",$hidden_value="") {
		$this->title = $title_label;
		$this->name = $name;
		$this->hidden_property = $hidden_property;
		$this->hidden_value = $hidden_value;
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			if (buro_mikado_option_get_value($this->hidden_property)==$this->hidden_value)
				$hidden = true;
		}
		?>
		<h5 class="mkd-page-section-subtitle" id="mkd_<?php echo esc_attr($this->name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>><?php echo esc_html($this->title); ?></h5>
	<?php
	}
}

/*
   Class: BuroMikadoField
   A class that initializes Mikado Field
*/
class BuroMikadoField implements iBuroMikadoRender {
	private $type;
	private $name;
	private $default_value;
	private $label;
	private $description;
	private $options = array();
	private $args = array();
	public $hidden_property;
	public $hidden_values = array();


	function __construct($type,$name,$default_value="",$label="",$description="", $options = array(), $args = array(),$hidden_property="", $hidden_values = array()) {		
		global $buro_mikado_Framework;
		$this->type = $type;
		$this->name = $name;
		$this->default_value = $default_value;
		$this->label = $label;
		$this->description = $description;
		$this->options = $options;
		$this->args = $args;
		$this->hidden_property = $hidden_property;
		$this->hidden_values = $hidden_values;
		$buro_mikado_Framework->mkdOptions->addOption($this->name,$this->default_value, $type);
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			foreach ($this->hidden_values as $value) {
				if (buro_mikado_option_get_value($this->hidden_property)==$value)
					$hidden = true;

			}
		}
		$factory->render( $this->type, $this->name, $this->label, $this->description, $this->options, $this->args, $hidden );
	}
}

/*
   Class: BuroMikadoMetaField
   A class that initializes Mikado Meta Field
*/
class BuroMikadoMetaField implements iBuroMikadoRender {
	private $type;
	private $name;
	private $default_value;
	private $label;
	private $description;
	private $options = array();
	private $args = array();
	public $hidden_property;
	public $hidden_values = array();


	function __construct($type,$name,$default_value="",$label="",$description="", $options = array(), $args = array(),$hidden_property="", $hidden_values = array()) {
		global $buro_mikado_Framework;
		$this->type = $type;
		$this->name = $name;
		$this->default_value = $default_value;
		$this->label = $label;
		$this->description = $description;
		$this->options = $options;
		$this->args = $args;
		$this->hidden_property = $hidden_property;
		$this->hidden_values = $hidden_values;
		$buro_mikado_Framework->mkdMetaBoxes->addOption($this->name,$this->default_value);
	}

	public function render($factory) {
		$hidden = false;
		if (!empty($this->hidden_property)){
			foreach ($this->hidden_values as $value) {
				if (buro_mikado_option_get_value($this->hidden_property)==$value)
					$hidden = true;

			}
		}
		$factory->render( $this->type, $this->name, $this->label, $this->description, $this->options, $this->args, $hidden );
	}
}

abstract class BuroMikadoFieldType {

	abstract public function render( $name, $label="",$description="", $options = array(), $args = array(), $hidden = false );

}

class BuroMikadoFieldText extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		$col_width = 12;
		if(isset($args["col_width"])) {
            $col_width = $args["col_width"];
        }

        $suffix = !empty($args['suffix']) ? $args['suffix'] : false;

		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-<?php echo esc_attr($col_width); ?>">
                            <?php if($suffix) : ?>
                            <div class="input-group">
                            <?php endif; ?>
                                <input type="text"
                                    class="form-control mkd-input mkd-form-element"
                                    name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(htmlspecialchars(buro_mikado_option_get_value($name))); ?>"
                                    />
                                <?php if($suffix) : ?>
                                    <div class="input-group-addon"><?php echo esc_html($args['suffix']); ?></div>
                                <?php endif; ?>
                            <?php if($suffix) : ?>
                            </div>
                            <?php endif; ?>

                        </div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldTextSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {

		$suffix = !empty($args['suffix']) ? $args['suffix'] : false;

		?>


		<div class="col-lg-3" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
			<?php if($suffix) : ?>
			<div class="input-group">
            <?php endif; ?>
				<input type="text"
				   class="form-control mkd-input mkd-form-element"
				   name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(htmlspecialchars(buro_mikado_option_get_value($name))); ?>"
				   />
				<?php if($suffix) : ?>
					<div class="input-group-addon"><?php echo esc_html($args['suffix']); ?></div>
				<?php endif; ?>
			<?php if($suffix) : ?>
			</div>
			<?php endif; ?>
		</div>
	<?php

	}

}

class BuroMikadoFieldTextArea extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->


			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<textarea class="form-control mkd-form-element"
									  name="<?php echo esc_attr($name); ?>"
									  rows="5"><?php echo esc_html(htmlspecialchars(buro_mikado_option_get_value($name))); ?></textarea>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldTextAreaSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		?>

		<div class="col-lg-3">
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
			<textarea class="form-control mkd-form-element"
					  name="<?php echo esc_attr($name); ?>"
					  rows="5"><?php echo esc_html(buro_mikado_option_get_value($name)); ?></textarea>
		</div>
	<?php

	}

}

class BuroMikadoFieldColor extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<input type="text" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>" class="my-color-field"/>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldColorSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		?>

		<div class="col-lg-3" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
			<input type="text" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>" class="my-color-field"/>
		</div>
	<?php

	}

}

class BuroMikadoFieldImage extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<div class="mkd-media-uploader">
								<div <?php if (!buro_mikado_option_has_value($name)) { ?> style="display: none"<?php } ?>
									class="mkd-media-image-holder">
									<img src="<?php if (buro_mikado_option_has_value($name)) { echo esc_url(buro_mikado_get_attachment_thumb_url(buro_mikado_option_get_value($name))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
										 class="mkd-media-image img-thumbnail"/>
								</div>
								<div style="display: none"
									 class="mkd-media-meta-fields">
									<input type="hidden" class="mkd-media-upload-url"
										   name="<?php echo esc_attr($name); ?>"
										   value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
								</div>
								<a class="mkd-media-upload-btn btn btn-sm btn-primary"
								   href="javascript:void(0)"
								   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
								   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
								<a style="display: none;" href="javascript: void(0)"
								   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldImageSimple extends BuroMikadoFieldType {

    public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
        ?>


        <div class="col-lg-3" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
            <em class="mkd-field-description"><?php echo esc_html($label); ?></em>
            <div class="mkd-media-uploader">
                <div <?php if (!buro_mikado_option_has_value($name)) { ?> style="display: none"<?php } ?>
                    class="mkd-media-image-holder">
                    <img src="<?php if (buro_mikado_option_has_value($name)) { echo esc_url(buro_mikado_get_attachment_thumb_url(buro_mikado_option_get_value($name))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
                         class="mkd-media-image img-thumbnail"/>
                </div>
                <div style="display: none"
                     class="mkd-media-meta-fields">
                    <input type="hidden" class="mkd-media-upload-url"
                           name="<?php echo esc_attr($name); ?>"
                           value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
                </div>
                <a class="mkd-media-upload-btn btn btn-sm btn-primary"
                   href="javascript:void(0)"
                   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
                   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
                <a style="display: none;" href="javascript: void(0)"
                   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
            </div>
        </div>
    <?php

    }

}

class BuroMikadoFieldFont extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		global $buro_mikado_fonts_array;
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-3">
							<select class="form-control mkd-form-element"
									name="<?php echo esc_attr($name); ?>">
								<option value="-1"><?php esc_html_e('Default','buro'); ?></option>
								<?php foreach($buro_mikado_fonts_array as $fontArray) { ?>
									<option <?php if (buro_mikado_option_get_value($name) == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr(str_replace(' ', '+', $fontArray["family"])); ?>"><?php echo esc_html($fontArray["family"]); ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFontSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		global $buro_mikado_fonts_array;
		?>


		<div class="col-lg-3">
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
			<select class="form-control mkd-form-element"
					name="<?php echo esc_attr($name); ?>">
				<option value="-1"><?php esc_html_e('Default','buro'); ?></option>
				<?php foreach($buro_mikado_fonts_array as $fontArray) { ?>
					<option <?php if (buro_mikado_option_get_value($name) == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr(str_replace(' ', '+', $fontArray["family"])); ?>"><?php echo esc_html($fontArray["family"]); ?></option>
				<?php } ?>
			</select>
		</div>
	<?php

	}

}

class BuroMikadoFieldSelect extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$show = array();
		if(isset($args["show"]))
			$show = $args["show"];
		$hide = array();
		if(isset($args["hide"]))
			$hide = $args["hide"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>" <?php if ($hidden) { ?> style="display: none"<?php } ?>>


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-3">
							<select class="form-control mkd-form-element<?php if ($dependence) { echo " dependence"; } ?>"
								<?php foreach($show as $key=>$value) { ?>
									data-show-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
								<?php } ?>
								<?php foreach($hide as $key=>$value) { ?>
									data-hide-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
								<?php } ?>
									name="<?php echo esc_attr($name); ?>">
								<?php foreach($options as $key=>$value) { if ($key == "-1") $key = ""; ?>
									<option <?php if (buro_mikado_option_get_value($name) == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldSelectBlank extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$show = array();
		if(isset($args["show"]))
			$show = $args["show"];
		$hide = array();
		if(isset($args["hide"]))
			$hide = $args["hide"];
		?>

		<div class="mkd-page-form-section"<?php if ($hidden) { ?> style="display: none"<?php } ?>>


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-3">
							<select class="form-control mkd-form-element<?php if ($dependence) { echo " dependence"; } ?>"
								<?php foreach($show as $key=>$value) { ?>
									data-show-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
								<?php } ?>
								<?php foreach($hide as $key=>$value) { ?>
									data-hide-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
								<?php } ?>
									name="<?php echo esc_attr($name); ?>">
								<option <?php if (buro_mikado_option_get_value($name) == "") { echo "selected='selected'"; } ?>  value=""></option>
								<?php foreach($options as $key=>$value) { if ($key == "-1") $key = ""; ?>
									<option <?php if (buro_mikado_option_get_value($name) == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldSelectSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
        $dependence = false;
        if(isset($args["dependence"]))
            $dependence = true;
        $show = array();
        if(isset($args["show"]))
            $show = $args["show"];
        $hide = array();
        if(isset($args["hide"]))
            $hide = $args["hide"];
        ?>


		<div class="col-lg-3">
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
            <select class="form-control mkd-form-element<?php if ($dependence) { echo " dependence"; } ?>"
                <?php foreach($show as $key=>$value) { ?>
                    data-show-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
                <?php } ?>
                <?php foreach($hide as $key=>$value) { ?>
                    data-hide-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
                <?php } ?>
                    name="<?php echo esc_attr($name); ?>">
                <option <?php if (buro_mikado_option_get_value($name) == "") { echo "selected='selected'"; } ?>  value=""></option>
                <?php foreach($options as $key=>$value) { if ($key == "-1") $key = ""; ?>
                    <option <?php if (buro_mikado_option_get_value($name) == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
                <?php } ?>
            </select>
		</div>
	<?php

	}

}

class BuroMikadoFieldSelectBlankSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
        $dependence = false;
        if(isset($args["dependence"]))
            $dependence = true;
        $show = array();
        if(isset($args["show"]))
            $show = $args["show"];
        $hide = array();
        if(isset($args["hide"]))
            $hide = $args["hide"];
        ?>


		<div class="col-lg-3">
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
            <select class="form-control mkd-form-element<?php if ($dependence) { echo " dependence"; } ?>"
                <?php foreach($show as $key=>$value) { ?>
                    data-show-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
                <?php } ?>
                <?php foreach($hide as $key=>$value) { ?>
                    data-hide-<?php echo str_replace(' ', '',$key); ?>="<?php echo esc_attr($value); ?>"
                <?php } ?>
                    name="<?php echo esc_attr($name); ?>">
                <option <?php if (buro_mikado_option_get_value($name) == "") { echo "selected='selected'"; } ?>  value=""></option>
                <?php foreach($options as $key=>$value) { if ($key == "-1") $key = ""; ?>
                    <option <?php if (buro_mikado_option_get_value($name) == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
                <?php } ?>
            </select>
		</div>
	<?php

	}

}

class BuroMikadoFieldYesNo extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "no") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_yesno" value="yes"<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_yesno" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}
}

class BuroMikadoFieldYesNoSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="col-lg-3">
			<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
			<p class="field switch">
				<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
					   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
				<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
					   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "no") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
				<input type="checkbox" id="checkbox" class="checkbox"
					   name="<?php echo esc_attr($name); ?>_yesno" value="yes"<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?>/>
				<input type="hidden" class="checkboxhidden_yesno" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
			</p>
		</div>
	<?php

	}
}

class BuroMikadoFieldOnOff extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">

							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "on") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('On', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "off") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Off', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_onoff" value="on"<?php if (buro_mikado_option_get_value($name) == "on") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_onoff" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldPortfolioFollow extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "portfolio_single_follow") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "portfolio_single_no_follow") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_portfoliofollow" value="portfolio_single_follow"<?php if (buro_mikado_option_get_value($name) == "portfolio_single_follow") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_portfoliofollow" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldZeroOne extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">

							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "1") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "0") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_zeroone" value="1"<?php if (buro_mikado_option_get_value($name) == "1") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_zeroone" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldImageVideo extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch switch-type">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "image") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Image', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "video") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Video', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_imagevideo" value="image"<?php if (buro_mikado_option_get_value($name) == "image") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_imagevideo" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldYesEmpty extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_yesempty" value="yes"<?php if (buro_mikado_option_get_value($name) == "yes") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_yesempty" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFlagPage extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "page") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_flagpage" value="page"<?php if (buro_mikado_option_get_value($name) == "page") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_flagpage" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFlagPost extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {

		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "post") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_flagpost" value="post"<?php if (buro_mikado_option_get_value($name) == "post") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_flagpost" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFlagMedia extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "attachment") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_flagmedia" value="attachment"<?php if (buro_mikado_option_get_value($name) == "attachment") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_flagmedia" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFlagPortfolio extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "portfolio_page") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_flagportfolio" value="portfolio_page"<?php if (buro_mikado_option_get_value($name) == "portfolio_page") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_flagportfolio" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldFlagProduct extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		global $buro_mikado_options;
		$dependence = false;
		if(isset($args["dependence"]))
			$dependence = true;
		$dependence_hide_on_yes = "";
		if(isset($args["dependence_hide_on_yes"]))
			$dependence_hide_on_yes = $args["dependence_hide_on_yes"];
		$dependence_show_on_yes = "";
		if(isset($args["dependence_show_on_yes"]))
			$dependence_show_on_yes = $args["dependence_show_on_yes"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->



			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<p class="field switch">
								<label data-hide="<?php echo esc_attr($dependence_hide_on_yes); ?>" data-show="<?php echo esc_attr($dependence_show_on_yes); ?>"
									   class="cb-enable<?php if (buro_mikado_option_get_value($name) == "product") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('Yes', 'buro') ?></span></label>
								<label data-hide="<?php echo esc_attr($dependence_show_on_yes); ?>" data-show="<?php echo esc_attr($dependence_hide_on_yes); ?>"
									   class="cb-disable<?php if (buro_mikado_option_get_value($name) == "") { echo " selected"; } ?><?php if ($dependence) { echo " dependence"; } ?>"><span><?php esc_html_e('No', 'buro') ?></span></label>
								<input type="checkbox" id="checkbox" class="checkbox"
									   name="<?php echo esc_attr($name); ?>_flagproduct" value="product"<?php if (buro_mikado_option_get_value($name) == "product") { echo " selected"; } ?>/>
								<input type="hidden" class="checkboxhidden_flagproduct" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>
							</p>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldRange extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		$range_min = 0;
		$range_max = 1;
		$range_step = 0.01;
		$range_decimals = 2;
		if(isset($args["range_min"]))
			$range_min = $args["range_min"];
		if(isset($args["range_max"]))
			$range_max = $args["range_max"];
		if(isset($args["range_step"]))
			$range_step = $args["range_step"];
		if(isset($args["range_decimals"]))
			$range_decimals = $args["range_decimals"];
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<div class="mkd-slider-range-wrapper">
								<div class="form-inline">
									<input type="text"
										   class="form-control mkd-form-element mkd-form-element-xsmall pull-left mkd-slider-range-value"
										   name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>

									<div class="mkd-slider-range small"
										 data-step="<?php echo esc_attr($range_step); ?>" data-min="<?php echo esc_attr($range_min); ?>" data-max="<?php echo esc_attr($range_max); ?>" data-decimals="<?php echo esc_attr($range_decimals); ?>" data-start="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"></div>
								</div>

							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}

class BuroMikadoFieldRangeSimple extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		?>

		<div class="col-lg-3" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>
			<div class="mkd-slider-range-wrapper">
				<div class="form-inline">
					<em class="mkd-field-description"><?php echo esc_html($label); ?></em>
					<input type="text"
						   class="form-control mkd-form-element mkd-form-element-xxsmall pull-left mkd-slider-range-value"
						   name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"/>

					<div class="mkd-slider-range xsmall"
						 data-step="0.01" data-max="1" data-start="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"></div>
				</div>

			</div>
		</div>
	<?php

	}

}

class BuroMikadoFieldRadio extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {

		$checked = "";
		if ($default_value == $value)
			$checked = "checked";
		$html = '<input type="radio" name="'.$name.'" value="'.$default_value.'" '.$checked.' /> '.$label.'<br />';
		echo wp_kses($html, array(
			'input' => array(
				'type' => true,
				'name' => true,
				'value' => true,
				'checked' => true
			),
			'br' => true
		));

	}

}

class BuroMikadoFieldRadioGroup extends BuroMikadoFieldType {

    public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
        $dependence = isset($args["dependence"]) && $args["dependence"] ? true : false;
        $show = !empty($args["show"]) ? $args["show"] : array();
        $hide = !empty($args["hide"]) ? $args["hide"] : array();

        $use_images = isset($args["use_images"]) && $args["use_images"] ? true : false;
        $hide_labels = isset($args["hide_labels"]) && $args["hide_labels"] ? true : false;
        $hide_radios = $use_images ? 'display: none' : '';
        $checked_value = buro_mikado_option_get_value($name);
        ?>

        <div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>" <?php if ($hidden) { ?> style="display: none"<?php } ?>>

            <div class="mkd-field-desc">
                <h4><?php echo esc_html($label); ?></h4>

                <p><?php echo esc_html($description); ?></p>
            </div>
            <!-- close div.mkd-field-desc -->

            <div class="mkd-section-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php if(is_array($options) && count($options)) { ?>
                                <div class="mkd-radio-group-holder <?php if($use_images) echo "with-images"; ?>">
                                    <?php foreach($options as $key => $atts) {
                                        $selected = false;
                                        if($checked_value == $key) {
                                            $selected = true;
                                        }

                                        $show_val = "";
                                        $hide_val = "";
                                        if($dependence) {
                                            if(array_key_exists($key, $show)) {
                                                $show_val = $show[$key];
                                            }

                                            if(array_key_exists($key, $hide)) {
                                                $hide_val = $hide[$key];
                                            }
                                        }
                                    ?>
                                        <label class="radio-inline">
                                            <input
                                                <?php echo buro_mikado_get_inline_attr($show_val, 'data-show'); ?>
                                                <?php echo buro_mikado_get_inline_attr($hide_val, 'data-hide'); ?>
                                                <?php if($selected) echo "checked"; ?> <?php buro_mikado_inline_style($hide_radios); ?>
                                                type="radio"
                                                name="<?php echo esc_attr($name);  ?>"
                                                value="<?php echo esc_attr($key); ?>"
                                                <?php if($dependence) buro_mikado_class_attribute("dependence"); ?>> <?php if(!empty($atts["label"]) && !$hide_labels) echo esc_attr($atts["label"]); ?>

                                            <?php if($use_images) { ?>
                                                <img title="<?php if(!empty($atts["label"])) echo esc_attr($atts["label"]); ?>" src="<?php echo esc_url($atts['image']); ?>" alt="<?php echo esc_attr("$key image") ?>"/>
                                            <?php } ?>
                                        </label>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- close div.mkd-section-content -->

        </div>
    <?php
    }

}

class BuroMikadoFieldCheckBox extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {

		$checked = "";
		if ($default_value == $value)
			$checked = "checked";
		$html = '<input type="checkbox" name="'.$name.'" value="'.$default_value.'" '.$checked.' /> '.$label.'<br />';
		echo wp_kses($html, array(
			'input' => array(
				'type' => true,
				'name' => true,
				'value' => true,
				'checked' => true
			),
			'br' => true
		));

	}

}

class BuroMikadoFieldDate extends BuroMikadoFieldType {

	public function render( $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {
		$col_width = 2;
		if(isset($args["col_width"]))
			$col_width = $args["col_width"];
		?>

		<div class="mkd-page-form-section" id="mkd_<?php echo esc_attr($name); ?>"<?php if ($hidden) { ?> style="display: none"<?php } ?>>


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($label); ?></h4>

				<p><?php echo esc_html($description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-<?php echo esc_attr($col_width); ?>">
							<input type="text"
								   id = "portfolio_date"
								   class="datepicker form-control mkd-input mkd-form-element"
								   name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr(buro_mikado_option_get_value($name)); ?>"
								/></div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}

}


class BuroMikadoFieldFactory {

	public function render( $field_type, $name, $label="", $description="", $options = array(), $args = array(), $hidden = false ) {


		switch ( strtolower( $field_type ) ) {

			case 'text':
				$field = new BuroMikadoFieldText();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'textsimple':
				$field = new BuroMikadoFieldTextSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'textarea':
				$field = new BuroMikadoFieldTextArea();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'textareasimple':
				$field = new BuroMikadoFieldTextAreaSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'color':
				$field = new BuroMikadoFieldColor();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'colorsimple':
				$field = new BuroMikadoFieldColorSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'image':
				$field = new BuroMikadoFieldImage();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

            case 'imagesimple':
				$field = new BuroMikadoFieldImageSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'font':
				$field = new BuroMikadoFieldFont();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'fontsimple':
				$field = new BuroMikadoFieldFontSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'select':
				$field = new BuroMikadoFieldSelect();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'selectblank':
				$field = new BuroMikadoFieldSelectBlank();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'selectsimple':
				$field = new BuroMikadoFieldSelectSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'selectblanksimple':
				$field = new BuroMikadoFieldSelectBlankSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'yesno':
				$field = new BuroMikadoFieldYesNo();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'yesnosimple':
				$field = new BuroMikadoFieldYesNoSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'onoff':
				$field = new BuroMikadoFieldOnOff();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'portfoliofollow':
				$field = new BuroMikadoFieldPortfolioFollow();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'zeroone':
				$field = new BuroMikadoFieldZeroOne();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'imagevideo':
				$field = new BuroMikadoFieldImageVideo();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'yesempty':
				$field = new BuroMikadoFieldYesEmpty();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'flagpost':
				$field = new BuroMikadoFieldFlagPost();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'flagpage':
				$field = new BuroMikadoFieldFlagPage();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'flagmedia':
				$field = new BuroMikadoFieldFlagMedia();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'flagportfolio':
				$field = new BuroMikadoFieldFlagPortfolio();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'flagproduct':
				$field = new BuroMikadoFieldFlagProduct();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'range':
				$field = new BuroMikadoFieldRange();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'rangesimple':
				$field = new BuroMikadoFieldRangeSimple();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'radio':
				$field = new BuroMikadoFieldRadio();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'checkbox':
				$field = new BuroMikadoFieldCheckBox();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;

			case 'date':
				$field = new BuroMikadoFieldDate();
				$field->render( $name, $label, $description, $options, $args, $hidden );
				break;
            case 'radiogroup':
                $field = new BuroMikadoFieldRadioGroup();
                $field->render( $name, $label, $description, $options, $args, $hidden );
                break;
			default:
				break;

		}

	}

}

/*
   Class: BuroMikadoMultipleImages
   A class that initializes Mikado Multiple Images
*/
class BuroMikadoMultipleImages implements iBuroMikadoRender {
	private $name;
	private $label;
	private $description;


	function __construct($name,$label="",$description="") {
		global $buro_mikado_Framework;
		$this->name = $name;
		$this->label = $label;
		$this->description = $description;
		$buro_mikado_Framework->mkdMetaBoxes->addOption($this->name,"");
	}

	public function render($factory) {
		global $post;
		?>

		<div class="mkd-page-form-section">


			<div class="mkd-field-desc">
				<h4><?php echo esc_html($this->label); ?></h4>

				<p><?php echo esc_html($this->description); ?></p>
			</div>
			<!-- close div.mkd-field-desc -->

			<div class="mkd-section-content">
				<div class="container-fluid">
					<div class="row">
						<div class="col-lg-12">
							<ul class="mkd-gallery-images-holder clearfix">
								<?php
								$image_gallery_val = get_post_meta( $post->ID, $this->name , true );
								if($image_gallery_val!='' ) $image_gallery_array=explode(',',$image_gallery_val);

								if(isset($image_gallery_array) && count($image_gallery_array)!=0):

									foreach($image_gallery_array as $gimg_id):

										$gimage_wp = wp_get_attachment_image_src($gimg_id,'thumbnail', true);
										echo '<li class="mkd-gallery-image-holder"><img src="'.esc_url($gimage_wp[0]).'"/></li>';

									endforeach;

								endif;
								?>
							</ul>
							<input type="hidden" value="<?php echo esc_attr($image_gallery_val); ?>" id="<?php echo esc_attr( $this->name) ?>" name="<?php echo esc_attr( $this->name) ?>">
							<div class="mkd-gallery-uploader">
								<a class="mkd-gallery-upload-btn btn btn-sm btn-primary"
								   href="javascript:void(0)"><?php esc_html_e('Upload', 'buro'); ?></a>
								<a class="mkd-gallery-clear-btn btn btn-sm btn-default pull-right"
								   href="javascript:void(0)"><?php esc_html_e('Remove All', 'buro'); ?></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- close div.mkd-section-content -->

		</div>
	<?php

	}
}

/*
   Class: BuroMikadoImagesVideos
   A class that initializes Mikado Images Videos
*/
class BuroMikadoImagesVideos implements iBuroMikadoRender {
	private $label;
	private $description;


	function __construct($label="",$description="") {
		$this->label = $label;
		$this->description = $description;
	}

	public function render($factory) {
		global $post;
		?>
		<div class="mkd_hidden_portfolio_images" style="display: none">
			<div class="mkd-page-form-section">


				<div class="mkd-field-desc">
					<h4><?php echo esc_html($this->label); ?></h4>

					<p><?php echo esc_html($this->description); ?></p>
				</div>
				<!-- close div.mkd-field-desc -->

				<div class="mkd-section-content">
					<div class="container-fluid">
						<div class="row">
							<div class="col-lg-2">
								<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfolioimgordernumber_x"
									   name="portfolioimgordernumber_x"
									   /></div>
							<div class="col-lg-10">
								<em class="mkd-field-description"><?php esc_html_e('Image/Video title (only for gallery layout - Portfolio Style 6)', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfoliotitle_x"
									   name="portfoliotitle_x"
									   /></div>
						</div>
						<div class="row next-row">
							<div class="col-lg-12">
								<em class="mkd-field-description"><?php esc_html_e('Image', 'buro'); ?></em>
								<div class="mkd-media-uploader">
									<div style="display: none"
										 class="mkd-media-image-holder">
										<img src="" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
											 class="mkd-media-image img-thumbnail"/>
									</div>
									<div style="display: none"
										 class="mkd-media-meta-fields">
										<input type="hidden" class="mkd-media-upload-url"
											   name="portfolioimg_x"
											   id="portfolioimg_x"/>
										<input type="hidden"
											   class="mkd-media-upload-height"
											   name="mkd_options_theme[media-upload][height]"
											   value=""/>
										<input type="hidden"
											   class="mkd-media-upload-width"
											   name="mkd_options_theme[media-upload][width]"
											   value=""/>
									</div>
									<a class="mkd-media-upload-btn btn btn-sm btn-primary"
									   href="javascript:void(0)"
									   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
									   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
									<a style="display: none;" href="javascript: void(0)"
									   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
								</div>
							</div>
						</div>
						<div class="row next-row">
							<div class="col-lg-3">
								<em class="mkd-field-description"><?php esc_html_e('Video type', 'buro'); ?></em>
								<select class="form-control mkd-form-element mkd-portfoliovideotype"
										name="portfoliovideotype_x" id="portfoliovideotype_x">
									<option value=""></option>
									<option value="youtube"><?php esc_html_e('Youtube', 'buro'); ?></option>
									<option value="vimeo"><?php esc_html_e('Vimeo', 'buro'); ?></option>
									<option value="self"><?php esc_html_e('Self hosted', 'buro'); ?></option>
								</select>
							</div>
							<div class="col-lg-3">
								<em class="mkd-field-description"><?php esc_html_e('Video ID', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfoliovideoid_x"
									   name="portfoliovideoid_x"
									   /></div>
						</div>
						<div class="row next-row">
							<div class="col-lg-12">
								<em class="mkd-field-description"><?php esc_html_e('Video image', 'buro'); ?></em>
								<div class="mkd-media-uploader">
									<div style="display: none"
										 class="mkd-media-image-holder">
										<img src="" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
											 class="mkd-media-image img-thumbnail"/>
									</div>
									<div style="display: none"
										 class="mkd-media-meta-fields">
										<input type="hidden" class="mkd-media-upload-url"
											   name="portfoliovideoimage_x"
											   id="portfoliovideoimage_x"/>
										<input type="hidden"
											   class="mkd-media-upload-height"
											   name="mkd_options_theme[media-upload][height]"
											   value=""/>
										<input type="hidden"
											   class="mkd-media-upload-width"
											   name="mkd_options_theme[media-upload][width]"
											   value=""/>
									</div>
									<a class="mkd-media-upload-btn btn btn-sm btn-primary"
									   href="javascript:void(0)"
									   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
									   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
									<a style="display: none;" href="javascript: void(0)"
									   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
								</div>
							</div>
						</div>
						<div class="row next-row">
							<div class="col-lg-4">
								<em class="mkd-field-description"><?php esc_html_e('Video webm', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfoliovideowebm_x"
									   name="portfoliovideowebm_x"
									   /></div>
							<div class="col-lg-4">
								<em class="mkd-field-description"><?php esc_html_e('Video mp4', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfoliovideomp4_x"
									   name="portfoliovideomp4_x"
									   /></div>
							<div class="col-lg-4">
								<em class="mkd-field-description"><?php esc_html_e('Video ogv', 'buro'); ?></em>
								<input type="text"
									   class="form-control mkd-input mkd-form-element"
									   id="portfoliovideoogv_x"
									   name="portfoliovideoogv_x"
									   /></div>
						</div>
						<div class="row next-row">
							<div class="col-lg-12">
								<a class="mkd_remove_image btn btn-sm btn-primary" href="/" onclick="javascript: return false;"><?php esc_html_e('Remove portfolio image/video', 'buro'); ?></a>
							</div>
						</div>



					</div>
				</div>
				<!-- close div.mkd-section-content -->

			</div>
		</div>

		<?php
		$no = 1;
		$portfolio_images = get_post_meta( $post->ID, 'mkd_portfolio_images', true );
		if (count($portfolio_images)>1) {
			usort($portfolio_images, "buro_mikado_compare_portfolio_videos");
		}
		while (isset($portfolio_images[$no-1])) {
			$portfolio_image = $portfolio_images[$no-1];
			?>
			<div class="mkd_portfolio_image" rel="<?php echo esc_attr($no); ?>" style="display: block;">

				<div class="mkd-page-form-section">


					<div class="mkd-field-desc">
						<h4><?php echo esc_html($this->label); ?></h4>

						<p><?php echo esc_html($this->description); ?></p>
					</div>
					<!-- close div.mkd-field-desc -->

					<div class="mkd-section-content">
						<div class="container-fluid">
							<div class="row">
								<div class="col-lg-2">
									<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfolioimgordernumber_<?php echo esc_attr($no); ?>"
										   name="portfolioimgordernumber[]" value="<?php echo isset($portfolio_image['portfolioimgordernumber']) ? esc_attr(stripslashes($portfolio_image['portfolioimgordernumber'])) : ""; ?>"
										   /></div>
								<div class="col-lg-10">
									<em class="mkd-field-description"><?php esc_html_e('Image/Video title (only for gallery layout - Portfolio Style 6)','buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfoliotitle_<?php echo esc_attr($no); ?>"
										   name="portfoliotitle[]" value="<?php echo isset($portfolio_image['portfoliotitle']) ? esc_attr(stripslashes($portfolio_image['portfoliotitle'])) : ""; ?>"
										   /></div>
							</div>
							<div class="row next-row">
								<div class="col-lg-12">
									<em class="mkd-field-description"><?php esc_html_e('Image', 'buro'); ?></em>
									<div class="mkd-media-uploader">
										<div <?php if (stripslashes($portfolio_image['portfolioimg']) == false) { ?> style="display: none"<?php } ?> class="mkdf-media-image-holder">
											<img src="<?php if (stripslashes($portfolio_image['portfolioimg']) == true) { echo esc_url(buro_mikado_get_attachment_thumb_url(stripslashes($portfolio_image['portfolioimg']))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkdf-media-image img-thumbnail"/>
										</div>
										<div style="display: none"
											 class="mkd-media-meta-fields">
											<input type="hidden" class="mkd-media-upload-url"
												   name="portfolioimg[]"
												   id="portfolioimg_<?php echo esc_attr($no); ?>"
												   value="<?php echo stripslashes($portfolio_image['portfolioimg']); ?>"/>
											<input type="hidden"
												   class="mkd-media-upload-height"
												   name="mkd_options_theme[media-upload][height]"
												   value=""/>
											<input type="hidden"
												   class="mkd-media-upload-width"
												   name="mkd_options_theme[media-upload][width]"
												   value=""/>
										</div>
										<a class="mkd-media-upload-btn btn btn-sm btn-primary"
										   href="javascript:void(0)"
										   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
										   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
										<a style="display: none;" href="javascript: void(0)"
										   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
									</div>
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Video type', 'buro'); ?></em>
									<select class="form-control mkd-form-element mkd-portfoliovideotype"
											name="portfoliovideotype[]" id="portfoliovideotype_<?php echo esc_attr($no); ?>">
										<option value=""></option>
										<option <?php if ($portfolio_image['portfoliovideotype'] == "youtube") { echo "selected='selected'"; } ?>  value="youtube"><?php esc_html_e('Youtube', 'buro'); ?></option>
										<option <?php if ($portfolio_image['portfoliovideotype'] == "vimeo") { echo "selected='selected'"; } ?>  value="vimeo"><?php esc_html_e('Vimeo', 'buro'); ?></option>
										<option <?php if ($portfolio_image['portfoliovideotype'] == "self") { echo "selected='selected'"; } ?>  value="self"><?php esc_html_e('Self hosted', 'buro'); ?></option>
									</select>
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Video ID', 'buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfoliovideoid_<?php echo esc_attr($no); ?>"
										   name="portfoliovideoid[]" value="<?php echo isset($portfolio_image['portfoliovideoid']) ? esc_attr(stripslashes($portfolio_image['portfoliovideoid'])) : ""; ?>"
										   /></div>
							</div>
							<div class="row next-row">
								<div class="col-lg-12">
									<em class="mkd-field-description"><?php esc_html_e('Video image', 'buro'); ?></em>
									<div class="mkd-media-uploader">
										<div <?php if (stripslashes($portfolio_image['portfoliovideoimage']) == false) { ?> style="display: none"<?php } ?> class="mkdf-media-image-holder">
											<img src="<?php if (stripslashes($portfolio_image['portfoliovideoimage']) == true) { echo esc_url(buro_mikado_get_attachment_thumb_url(stripslashes($portfolio_image['portfoliovideoimage']))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkdf-media-image img-thumbnail"/>
										</div>
										<div style="display: none"
											 class="mkd-media-meta-fields">
											<input type="hidden" class="mkd-media-upload-url"
												   name="portfoliovideoimage[]"
												   id="portfoliovideoimage_<?php echo esc_attr($no); ?>"
												   value="<?php echo stripslashes($portfolio_image['portfoliovideoimage']); ?>"/>
											<input type="hidden"
												   class="mkd-media-upload-height"
												   name="mkd_options_theme[media-upload][height]"
												   value=""/>
											<input type="hidden"
												   class="mkd-media-upload-width"
												   name="mkd_options_theme[media-upload][width]"
												   value=""/>
										</div>
										<a class="mkd-media-upload-btn btn btn-sm btn-primary"
										   href="javascript:void(0)"
										   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
										   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
										<a style="display: none;" href="javascript: void(0)"
										   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
									</div>
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-4">
									<em class="mkd-field-description"><?php esc_html_e('Video webm', 'buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfoliovideowebm_<?php echo esc_attr($no); ?>"
										   name="portfoliovideowebm[]" value="<?php echo isset($portfolio_image['portfoliovideowebm']) ? esc_attr(stripslashes($portfolio_image['portfoliovideowebm'])) : ""; ?>"
										   /></div>
								<div class="col-lg-4">
									<em class="mkd-field-description"><?php esc_html_e('Video mp4', 'buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfoliovideomp4_<?php echo esc_attr($no); ?>"
										   name="portfoliovideomp4[]" value="<?php echo isset($portfolio_image['portfoliovideomp4']) ? esc_attr(stripslashes($portfolio_image['portfoliovideomp4'])) : ""; ?>"
										   /></div>
								<div class="col-lg-4">
									<em class="mkd-field-description"><?php esc_html_e('Video ogv', 'buro'); ?></em>
									<input type="text"
										   class="form-control mkd-input mkd-form-element"
										   id="portfoliovideoogv_<?php echo esc_attr($no); ?>"
										   name="portfoliovideoogv[]" value="<?php echo isset($portfolio_image['portfoliovideoogv']) ? esc_attr(stripslashes($portfolio_image['portfoliovideoogv'])):""; ?>"
										   /></div>
							</div>
							<div class="row next-row">
								<div class="col-lg-12">
									<a class="mkd_remove_image btn btn-sm btn-primary" href="/" onclick="javascript: return false;"><?php esc_html_e('Remove portfolio image/', 'buro'); ?></a>
								</div>
							</div>



						</div>
					</div>
					<!-- close div.mkd-section-content -->

				</div>
			</div>
			<?php
			$no++;
		}
		?>
		<br />
		<a class="mkd_add_image btn btn-sm btn-primary" onclick="javascript: return false;" href="/" ><?php esc_html_e('Add portfolio image/video', 'buro'); ?></a>
	<?php

	}
}


/*
   Class: BuroMikadoImagesVideos
   A class that initializes Mikado Images Videos
*/
class BuroMikadoImagesVideosFramework implements iBuroMikadoRender {
	private $label;
	private $description;


	function __construct($label="",$description="") {
		$this->label = $label;
		$this->description = $description;
	}

	public function render($factory) {
		global $post;
		?>

		<!--Image hidden start-->
		<div class="mkd-hidden-portfolio-images"  style="display: none">
			<div class="mkd-portfolio-toggle-holder">
				<div class="mkd-portfolio-toggle mkd-toggle-desc">
					<span class="number">1</span><span class="mkd-toggle-inner"><?php esc_html_e('Image', 'buro'); ?> - <em><?php esc_html_e('(Order Number, Image Title)', 'buro'); ?></em></span>
				</div>
				<div class="mkd-portfolio-toggle mkd-portfolio-control">
					<span class="toggle-portfolio-media"><i class="fa fa-caret-up"></i></span>
					<a href="#" class="remove-portfolio-media"><i class="fa fa-times"></i></a>
				</div>
			</div>
			<div class="mkd-portfolio-toggle-content">
				<div class="mkd-page-form-section">
					<div class="mkd-section-content">
						<div class="container-fluid">
							<div class="row">
								<div class="col-lg-2">
									<div class="mkd-media-uploader">
										<em class="mkd-field-description"><?php esc_html_e('Image', 'buro'); ?> </em>
										<div style="display: none" class="mkd-media-image-holder">
											<img src="" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkd-media-image img-thumbnail">
										</div>
										<div  class="mkd-media-meta-fields">
											<input type="hidden" class="mkd-media-upload-url" name="portfolioimg_x" id="portfolioimg_x">
											<input type="hidden" class="mkd-media-upload-height" name="mkd_options_theme[media-upload][height]" value="">
											<input type="hidden" class="mkd-media-upload-width" name="mkd_options_theme[media-upload][width]" value="">
										</div>
										<a class="mkd-media-upload-btn btn btn-sm btn-primary" href="javascript:void(0)" data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>" data-frame-button-text="Select Image"><?php esc_html_e('Upload', 'buro'); ?></a>
										<a style="display: none;" href="javascript: void(0)" class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
									</div>
								</div>
								<div class="col-lg-2">
									<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro'); ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="portfolioimgordernumber_x" name="portfolioimgordernumber_x" >
								</div>
								<div class="col-lg-8">
									<em class="mkd-field-description"><?php esc_html_e('Image Title (works only for Gallery portfolio type selected)', 'buro'); ?> </em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliotitle_x" name="portfoliotitle_x" >
								</div>
							</div>
							<input type="hidden" name="portfoliovideoimage_x" id="portfoliovideoimage_x">
							<input type="hidden" name="portfoliovideotype_x" id="portfoliovideotype_x">
							<input type="hidden" name="portfoliovideoid_x" id="portfoliovideoid_x">
							<input type="hidden" name="portfoliovideowebm_x" id="portfoliovideowebm_x">
							<input type="hidden" name="portfoliovideomp4_x" id="portfoliovideomp4_x">
							<input type="hidden" name="portfoliovideoogv_x" id="portfoliovideoogv_x">
							<input type="hidden" name="portfolioimgtype_x" id="portfolioimgtype_x" value="image">

						</div><!-- close div.container-fluid -->
					</div><!-- close div.mkd-section-content -->
				</div>
			</div>
		</div>
		<!--Image hidden End-->

		<!--Video Hidden Start-->
		<div class="mkd-hidden-portfolio-videos"  style="display: none">
			<div class="mkd-portfolio-toggle-holder">
				<div class="mkd-portfolio-toggle mkd-toggle-desc">
					<span class="number">2</span><span class="mkd-toggle-inner"><?php esc_html_e('Video', 'buro'); ?> - <em><?php esc_html_e('(Order Number, Video Title)', 'buro'); ?></em></span>
				</div>
				<div class="mkd-portfolio-toggle mkd-portfolio-control">
					<span class="toggle-portfolio-media"><i class="fa fa-caret-up"></i></span> <a href="#" class="remove-portfolio-media"><i class="fa fa-times"></i></a>
				</div>
			</div>
			<div class="mkd-portfolio-toggle-content">
				<div class="mkd-page-form-section">
					<div class="mkd-section-content">
						<div class="container-fluid">
							<div class="row">
								<div class="col-lg-2">
									<div class="mkd-media-uploader">
										<em class="mkd-field-description"><?php esc_html_e('Cover Video Image', 'buro'); ?></em>
										<div style="display: none" class="mkd-media-image-holder">
											<img src="" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkd-media-image img-thumbnail">
										</div>
										<div style="display: none" class="mkd-media-meta-fields">
											<input type="hidden" class="mkd-media-upload-url" name="portfoliovideoimage_x" id="portfoliovideoimage_x">
											<input type="hidden" class="mkd-media-upload-height" name="mkd_options_theme[media-upload][height]" value="">
											<input type="hidden" class="mkd-media-upload-width" name="mkd_options_theme[media-upload][width]" value="">
										</div>
										<a class="mkd-media-upload-btn btn btn-sm btn-primary" href="javascript:void(0)" data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>" data-frame-button-text="Select Image"><?php esc_html_e('Upload','buro'); ?></a>
										<a style="display: none;" href="javascript: void(0)" class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
									</div>
								</div>
								<div class="col-lg-10">
									<div class="row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfolioimgordernumber_x" name="portfolioimgordernumber_x" >
										</div>
										<div class="col-lg-10">
											<em class="mkd-field-description"><?php esc_html_e('Video Title (works only for Gallery portfolio type selected)', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliotitle_x" name="portfoliotitle_x" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Video type', 'buro'); ?></em>
											<select class="form-control mkd-form-element mkd-portfoliovideotype" name="portfoliovideotype_x" id="portfoliovideotype_x">
												<option value=""></option>
												<option value="youtube"><?php esc_html_e('Youtube', 'buro'); ?></option>
												<option value="vimeo"><?php esc_html_e('Vimeo', 'buro'); ?></option>
												<option value="self"><?php esc_html_e('Self hosted', 'buro'); ?></option>
											</select>
										</div>
										<div class="col-lg-2 mkd-video-id-holder">
											<em class="mkd-field-description" id="videoId"><?php esc_html_e('Video ID', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliovideoid_x" name="portfoliovideoid_x" >
										</div>
									</div>

									<div class="row next-row mkd-video-self-hosted-path-holder">
										<div class="col-lg-4">
											<em class="mkd-field-description"><?php esc_html_e('Video webm', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliovideowebm_x" name="portfoliovideowebm_x" >
										</div>
										<div class="col-lg-4">
											<em class="mkd-field-description"><?php esc_html_e('Video mp4', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliovideomp4_x" name="portfoliovideomp4_x" >
										</div>
										<div class="col-lg-4">
											<em class="mkd-field-description"><?php esc_html_e('Video ogv', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliovideoogv_x" name="portfoliovideoogv_x" >
										</div>
									</div>
								</div>

							</div>
							<input type="hidden" name="portfolioimg_x" id="portfolioimg_x">
							<input type="hidden" name="portfolioimgtype_x" id="portfolioimgtype_x" value="video">
						</div><!-- close div.container-fluid -->
					</div><!-- close div.mkd-section-content -->
				</div>
			</div>
		</div>
		<!--Video Hidden End-->


		<?php
		$no = 1;
		$portfolio_images = get_post_meta( $post->ID, 'mkd_portfolio_images', true );
		if (is_array($portfolio_images) && count($portfolio_images)>1) {
			usort($portfolio_images, "buro_mikado_compare_portfolio_videos");
		}
		while (isset($portfolio_images[$no-1])) {
			$portfolio_image = $portfolio_images[$no-1];
			if (isset($portfolio_image['portfolioimgtype']))
				$portfolio_img_type = $portfolio_image['portfolioimgtype'];
			else {
				if (stripslashes($portfolio_image['portfolioimg']) == true)
					$portfolio_img_type = "image";
				else
					$portfolio_img_type = "video";
			}
			if ($portfolio_img_type == "image") {
				?>

				<div class="mkd-portfolio-images mkd-portfolio-media" rel="<?php echo esc_attr($no); ?>">
					<div class="mkd-portfolio-toggle-holder">
						<div class="mkd-portfolio-toggle mkd-toggle-desc">
							<span class="number"><?php echo esc_html($no); ?></span><span class="mkd-toggle-inner"><?php esc_html_e('Image', 'buro'); ?> - <em>(<?php echo stripslashes($portfolio_image['portfolioimgordernumber']); ?>, <?php echo stripslashes($portfolio_image['portfoliotitle']); ?>)</em></span>
						</div>
						<div class="mkd-portfolio-toggle mkd-portfolio-control">
							<a href="#" class="toggle-portfolio-media"><i class="fa fa-caret-down"></i></a>
							<a href="#" class="remove-portfolio-media"><i class="fa fa-times"></i></a>
						</div>
					</div>
					<div class="mkd-portfolio-toggle-content" style="display: none">
						<div class="mkd-page-form-section">
							<div class="mkd-section-content">
								<div class="container-fluid">
									<div class="row">
										<div class="col-lg-2">
											<div class="mkd-media-uploader">
												<em class="mkd-field-description"><?php esc_html_e('Image', 'buro'); ?> </em>
												<div <?php if (stripslashes($portfolio_image['portfolioimg']) == false) { ?> style="display: none"<?php } ?> class="mkdf-media-image-holder">
													<img src="<?php if (stripslashes($portfolio_image['portfolioimg']) == true) { echo esc_url(buro_mikado_get_attachment_thumb_url(stripslashes($portfolio_image['portfolioimg']))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkdf-media-image img-thumbnail"/>
												</div>
												<div style="display: none"
													 class="mkd-media-meta-fields">
													<input type="hidden" class="mkd-media-upload-url"
														   name="portfolioimg[]"
														   id="portfolioimg_<?php echo esc_attr($no); ?>"
														   value="<?php echo stripslashes($portfolio_image['portfolioimg']); ?>"/>
													<input type="hidden"
														   class="mkd-media-upload-height"
														   name="mkd_options_theme[media-upload][height]"
														   value=""/>
													<input type="hidden"
														   class="mkd-media-upload-width"
														   name="mkd_options_theme[media-upload][width]"
														   value=""/>
												</div>
												<a class="mkd-media-upload-btn btn btn-sm btn-primary"
												   href="javascript:void(0)"
												   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
												   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
												<a style="display: none;" href="javascript: void(0)"
												   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
											</div>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro'); ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfolioimgordernumber_<?php echo esc_attr($no); ?>" name="portfolioimgordernumber[]" value="<?php echo isset($portfolio_image['portfolioimgordernumber']) ? esc_attr(stripslashes($portfolio_image['portfolioimgordernumber'])) : ""; ?>" >
										</div>
										<div class="col-lg-8">
											<em class="mkd-field-description"><?php esc_html_e('Image Title (works only for Gallery portfolio type selected)', 'buro'); ?> </em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliotitle_<?php echo esc_attr($no); ?>" name="portfoliotitle[]" value="<?php echo isset($portfolio_image['portfoliotitle']) ? esc_attr(stripslashes($portfolio_image['portfoliotitle'])) : ""; ?>" >
										</div>
									</div>
									<input type="hidden" id="portfoliovideoimage_<?php echo esc_attr($no); ?>" name="portfoliovideoimage[]">
									<input type="hidden" id="portfoliovideotype_<?php echo esc_attr($no); ?>" name="portfoliovideotype[]">
									<input type="hidden" id="portfoliovideoid_<?php echo esc_attr($no); ?>" name="portfoliovideoid[]">
									<input type="hidden" id="portfoliovideowebm_<?php echo esc_attr($no); ?>" name="portfoliovideowebm[]">
									<input type="hidden" id="portfoliovideomp4_<?php echo esc_attr($no); ?>" name="portfoliovideomp4[]">
									<input type="hidden" id="portfoliovideoogv_<?php echo esc_attr($no); ?>" name="portfoliovideoogv[]">
									<input type="hidden" id="portfolioimgtype_<?php echo esc_attr($no); ?>" name="portfolioimgtype[]" value="image">
								</div><!-- close div.container-fluid -->
							</div><!-- close div.mkd-section-content -->
						</div>
					</div>
				</div>

			<?php
			} else {
				?>
				<div class="mkd-portfolio-videos mkd-portfolio-media" rel="<?php echo esc_attr($no); ?>">
					<div class="mkd-portfolio-toggle-holder">
						<div class="mkd-portfolio-toggle mkd-toggle-desc">
							<span class="number"><?php echo esc_html($no); ?></span><span class="mkd-toggle-inner"><?php esc_html_e('Video', 'buro'); ?> - <em>(<?php echo stripslashes($portfolio_image['portfolioimgordernumber']); ?>, <?php echo stripslashes($portfolio_image['portfoliotitle']); ?></em>) </span>
						</div>
						<div class="mkd-portfolio-toggle mkd-portfolio-control">
							<a href="#" class="toggle-portfolio-media"><i class="fa fa-caret-down"></i></a> <a href="#" class="remove-portfolio-media"><i class="fa fa-times"></i></a>
						</div>
					</div>
					<div class="mkd-portfolio-toggle-content" style="display: none">
						<div class="mkd-page-form-section">
							<div class="mkd-section-content">
								<div class="container-fluid">
									<div class="row">
										<div class="col-lg-2">
											<div class="mkd-media-uploader">
												<em class="mkd-field-description"><?php esc_html_e('Cover Video Image', 'buro'); ?></em>
												<div <?php if (stripslashes($portfolio_image['portfoliovideoimage']) == false) { ?> style="display: none"<?php } ?>
													class="mkd-media-image-holder">
													<div <?php if (stripslashes($portfolio_image['portfoliovideoimage']) == false) { ?> style="display: none"<?php } ?> class="mkdf-media-image-holder">
														<img src="<?php if (stripslashes($portfolio_image['portfoliovideoimage']) == true) { echo esc_url(buro_mikado_get_attachment_thumb_url(stripslashes($portfolio_image['portfoliovideoimage']))); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>" class="mkdf-media-image img-thumbnail"/>
													</div>
													
												</div>
												<div style="display: none"
													 class="mkd-media-meta-fields">
													<input type="hidden" class="mkd-media-upload-url"
														   name="portfoliovideoimage[]"
														   id="portfoliovideoimage_<?php echo esc_attr($no); ?>"
														   value="<?php echo stripslashes($portfolio_image['portfoliovideoimage']); ?>"/>
													<input type="hidden"
														   class="mkd-media-upload-height"
														   name="mkd_options_theme[media-upload][height]"
														   value=""/>
													<input type="hidden"
														   class="mkd-media-upload-width"
														   name="mkd_options_theme[media-upload][width]"
														   value=""/>
												</div>
												<a class="mkd-media-upload-btn btn btn-sm btn-primary"
												   href="javascript:void(0)"
												   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
												   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
												<a style="display: none;" href="javascript: void(0)"
												   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
											</div>
										</div>
										<div class="col-lg-10">
											<div class="row">
												<div class="col-lg-2">
													<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro') ?></em>
													<input type="text" class="form-control mkd-input mkd-form-element" id="portfolioimgordernumber_<?php echo esc_attr($no); ?>" name="portfolioimgordernumber[]" value="<?php echo isset($portfolio_image['portfolioimgordernumber']) ? esc_attr(stripslashes($portfolio_image['portfolioimgordernumber'])) : ""; ?>" >
												</div>
												<div class="col-lg-10">
													<em class="mkd-field-description"> <?php esc_html_e('Video Title (works only for Gallery portfolio type selected)', 'buro') ?></em>
													<input type="text" class="form-control mkd-input mkd-form-element" id="portfoliotitle_<?php echo esc_attr($no); ?>" name="portfoliotitle[]" value="<?php echo isset($portfolio_image['portfoliotitle']) ? esc_attr(stripslashes($portfolio_image['portfoliotitle'])) : ""; ?>" >
												</div>
											</div>
											<div class="row next-row">
												<div class="col-lg-2">
													<em class="mkd-field-description"><?php esc_html_e('Video Type', 'buro') ?></em>
													<select class="form-control mkd-form-element mkd-portfoliovideotype"
															name="portfoliovideotype[]" id="portfoliovideotype_<?php echo esc_attr($no); ?>">
														<option value=""></option>
														<option <?php if ($portfolio_image['portfoliovideotype'] == "youtube") { echo "selected='selected'"; } ?>  value="youtube"><?php esc_html_e('Youtube', 'buro') ?></option>
														<option <?php if ($portfolio_image['portfoliovideotype'] == "vimeo") { echo "selected='selected'"; } ?>  value="vimeo"><?php esc_html_e('Vimeo', 'buro') ?></option>
														<option <?php if ($portfolio_image['portfoliovideotype'] == "self") { echo "selected='selected'"; } ?>  value="self"><?php esc_html_e('Self hosted', 'buro') ?></option>
													</select>
												</div>
												<div class="col-lg-2 mkd-video-id-holder">
													<em class="mkd-field-description"><?php esc_html_e('Video ID', 'buro') ?></em>
													<input type="text"
														   class="form-control mkd-input mkd-form-element"
														   id="portfoliovideoid_<?php echo esc_attr($no); ?>"
														   name="portfoliovideoid[]" value="<?php echo isset($portfolio_image['portfoliovideoid']) ? esc_attr(stripslashes($portfolio_image['portfoliovideoid'])) : ""; ?>"
														   />
												</div>
											</div>

											<div class="row next-row mkd-video-self-hosted-path-holder">
												<div class="col-lg-4">
													<em class="mkd-field-description"><?php esc_html_e('Video webm', 'buro') ?></em>
													<input type="text"
														   class="form-control mkd-input mkd-form-element"
														   id="portfoliovideowebm_<?php echo esc_attr($no); ?>"
														   name="portfoliovideowebm[]" value="<?php echo isset($portfolio_image['portfoliovideowebm'])? esc_attr(stripslashes($portfolio_image['portfoliovideowebm'])) : ""; ?>"
														   /></div>
												<div class="col-lg-4">
													<em class="mkd-field-description"><?php esc_html_e('Video mp4', 'buro') ?></em>
													<input type="text"
														   class="form-control mkd-input mkd-form-element"
														   id="portfoliovideomp4_<?php echo esc_attr($no); ?>"
														   name="portfoliovideomp4[]" value="<?php echo isset($portfolio_image['portfoliovideomp4']) ? esc_attr(stripslashes($portfolio_image['portfoliovideomp4'])) : ""; ?>"
														   /></div>
												<div class="col-lg-4">
													<em class="mkd-field-description"><?php esc_html_e('Video ogv', 'buro') ?></em>
													<input type="text"
														   class="form-control mkd-input mkd-form-element"
														   id="portfoliovideoogv_<?php echo esc_attr($no); ?>"
														   name="portfoliovideoogv[]" value="<?php echo isset($portfolio_image['portfoliovideoogv']) ? esc_attr(stripslashes($portfolio_image['portfoliovideoogv'])) : ""; ?>"
														   /></div>
											</div>
										</div>

									</div>
									<input type="hidden" id="portfolioimg_<?php echo esc_attr($no); ?>" name="portfolioimg[]">
									<input type="hidden" id="portfolioimgtype_<?php echo esc_attr($no); ?>" name="portfolioimgtype[]" value="video">
								</div><!-- close div.container-fluid -->
							</div><!-- close div.mkd-section-content -->
						</div>
					</div>
				</div>
			<?php
			}
			$no++;
		}
		?>

		<div class="mkd-portfolio-add">
			<a class="mkd-add-image btn btn-sm btn-primary" href="#"><i class="fa fa-camera"></i> <?php esc_html_e('Add Image', 'buro') ?></a>
			<a class="mkd-add-video btn btn-sm btn-primary" href="#"><i class="fa fa-video-camera"></i> <?php esc_html_e('Add Video', 'buro') ?></a>

			<a class="mkd-toggle-all-media btn btn-sm btn-default pull-right" href="#"> <?php esc_html_e('Expand All', 'buro') ?></a>
			<?php /* <a class="mkd-remove-last-row-media btn btn-sm btn-default pull-right" href="#"> Remove last row</a> */ ?>
		</div>
	<?php

	}
}

class BuroMikadoTwitterFramework implements  iBuroMikadoRender {
    public function render($factory) {
        $twitterApi = MikadoTwitterApi::getInstance();
        $message = '';

        if(!empty($_GET['oauth_token']) && !empty($_GET['oauth_verifier'])) {
            if(!empty($_GET['oauth_token'])) {
                update_option($twitterApi::AUTHORIZE_TOKEN_FIELD, $_GET['oauth_token']);
            }

            if(!empty($_GET['oauth_verifier'])) {
                update_option($twitterApi::AUTHORIZE_VERIFIER_FIELD, $_GET['oauth_verifier']);
            }

            $responseObj = $twitterApi->obtainAccessToken();
            if($responseObj->status) {
                $message = esc_html__('You have successfully connected with your Twitter account. If you have any issues fetching data from Twitter try reconnecting.', 'buro');
            } else {
                $message = $responseObj->message;
            }
        }

        $buttonText = $twitterApi->hasUserConnected() ? esc_html__('Re-connect with Twitter', 'buro') : esc_html__('Connect with Twitter', 'buro');
    ?>
        <?php if($message !== '') { ?>
            <div class="alert alert-success" style="margin-top: 20px;">
                <span><?php echo esc_html($message); ?></span>
            </div>
        <?php } ?>
        <div class="mkd-page-form-section" id="mkd_enable_social_share">

            <div class="mkd-field-desc">
                <h4><?php esc_html_e('Connect with Twitter', 'buro'); ?></h4>

                <p><?php esc_html_e('Connecting with Twitter will enable you to show your latest tweets on your site', 'buro'); ?></p>
            </div>
            <!-- close div.mkd-field-desc -->

            <div class="mkd-section-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <a id="mkd-tw-request-token-btn" class="btn btn-primary" href="#"><?php echo esc_html($buttonText); ?></a>
                            <input type="hidden" data-name="current-page-url" value="<?php echo esc_url($twitterApi->buildCurrentPageURI()); ?>"/>
                        </div>
                    </div>
                </div>
            </div>
            <!-- close div.mkd-section-content -->

        </div>
    <?php }
}

class BuroMikadoInstagramFramework implements  iBuroMikadoRender {
    public function render($factory) {
        $instagram_api = MikadoInstagramApi::getInstance();
        $message = '';

        //if code wasn't saved to database
		if(!get_option('mkd_instagram_code')) {
			//check if code parameter is set in URL. That means that user has connected with Instagram
			if(!empty($_GET['code'])) {
				//update code option so we can use it later
				$instagram_api->storeCode();
				$instagram_api->getAccessToken();
				$message = esc_html__('You have successfully connected with your Instagram account. If you have any issues fetching data from Instagram try reconnecting.', 'buro');
				
			} else {
				$instagram_api->storeCodeRequestURI();
			}
		}

		$buttonText = $instagram_api->hasUserConnected() ? esc_html__('Re-connect with Instagram', 'buro') : esc_html__('Connect with Instagram', 'buro');

    ?>
        <?php if($message !== '') { ?>
            <div class="alert alert-success" style="margin-top: 20px;">
                <span><?php echo esc_html($message); ?></span>
            </div>
        <?php } ?>
        <div class="mkd-page-form-section" id="mkd-enable-social-share">

            <div class="mkd-field-desc">
                <h4><?php esc_html_e('Connect with Instagram', 'buro'); ?></h4>

                <p><?php esc_html_e('Connecting with Instagram will enable you to show your latest photos on your site', 'buro'); ?></p>
            </div>
            <!-- close div.mkd-field-desc -->

            <div class="mkd-section-content">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <a class="btn btn-primary" href="<?php echo esc_url($instagram_api->getAuthorizeUrl()); ?>"><?php echo esc_html($buttonText); ?></a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- close div.mkd-section-content -->

        </div>
    <?php }
}

/*
   Class: BuroMikadoImagesVideos
   A class that initializes Mikado Images Videos
*/
class BuroMikadoOptionsFramework implements iBuroMikadoRender {
	private $label;
	private $description;


	function __construct($label="",$description="") {
		$this->label = $label;
		$this->description = $description;
	}

	public function render($factory) {
		global $post;
		?>

		<div class="mkd-portfolio-additional-item-holder" style="display: none">
			<div class="mkd-portfolio-toggle-holder">
				<div class="mkd-portfolio-toggle mkd-toggle-desc">
					<span class="number">1</span><span class="mkd-toggle-inner"><?php esc_html_e('Additional Sidebar Item', 'buro') ?><em><?php esc_html_e('(Order Number, Item Title)', 'buro') ?></em></span>
				</div>
				<div class="mkd-portfolio-toggle mkd-portfolio-control">
					<span class="toggle-portfolio-item"><i class="fa fa-caret-up"></i></span>
					<a href="#" class="remove-portfolio-item"><i class="fa fa-times"></i></a>
				</div>
			</div>
			<div class="mkd-portfolio-toggle-content">
				<div class="mkd-page-form-section">
					<div class="mkd-section-content">
						<div class="container-fluid">
							<div class="row">

								<div class="col-lg-2">
									<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="optionlabelordernumber_x" name="optionlabelordernumber_x" >
								</div>
								<div class="col-lg-10">
									<em class="mkd-field-description"> <?php esc_html_e('Item Title', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="optionLabel_x" name="optionLabel_x" >
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-12">
									<em class="mkd-field-description"><?php esc_html_e('Item Text', 'buro') ?></em>
									<textarea class="form-control mkd-input mkd-form-element" id="optionValue_x" name="optionValue_x" ></textarea>
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-12">
									<em class="mkd-field-description"><?php esc_html_e('Enter Full URL for Item Text Link', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="optionUrl_x" name="optionUrl_x" >
								</div>
							</div>
						</div><!-- close div.mkd-section-content -->
					</div><!-- close div.container-fluid -->
				</div>
			</div>
		</div>
		<?php
		$no = 1;
		$portfolios = get_post_meta( $post->ID, 'mkd_portfolios', true );
		if (is_array($portfolios) && count($portfolios)>1 ) {
			usort($portfolios, "buro_mikado_compare_portfolio_options");
		}
		while (isset($portfolios[$no-1])) {
			$portfolio = $portfolios[$no-1];
			?>
			<div class="mkd-portfolio-additional-item" rel="<?php echo esc_attr($no); ?>">
				<div class="mkd-portfolio-toggle-holder">
					<div class="mkd-portfolio-toggle mkd-toggle-desc">
						<span class="number"><?php echo esc_html($no); ?></span><span class="mkd-toggle-inner"><?php esc_html_e('Additional Sidebar Item', 'buro') ?> - <em>(<?php echo stripslashes($portfolio['optionlabelordernumber']); ?>, <?php echo stripslashes($portfolio['optionLabel']); ?>)</em></span>
					</div>
					<div class="mkd-portfolio-toggle mkd-portfolio-control">
						<span class="toggle-portfolio-item"><i class="fa fa-caret-down"></i></span>
						<a href="#" class="remove-portfolio-item"><i class="fa fa-times"></i></a>
					</div>
				</div>
				<div class="mkd-portfolio-toggle-content" style="display: none">
					<div class="mkd-page-form-section">
						<div class="mkd-section-content">
							<div class="container-fluid">
								<div class="row">

									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Order Number', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="optionlabelordernumber_<?php echo esc_attr($no); ?>" name="optionlabelordernumber[]" value="<?php echo isset($portfolio['optionlabelordernumber']) ? esc_attr(stripslashes($portfolio['optionlabelordernumber'])) : ""; ?>" >
									</div>
									<div class="col-lg-10">
										<em class="mkd-field-description"><?php esc_html_e('Item Title', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="optionLabel_<?php echo esc_attr($no); ?>" name="optionLabel[]" value="<?php echo esc_attr(stripslashes($portfolio['optionLabel'])); ?>" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-12">
										<em class="mkd-field-description"<?php esc_html_e('>Item Text', 'buro') ?></em>
										<textarea class="form-control mkd-input mkd-form-element" id="optionValue_<?php echo esc_attr($no); ?>" name="optionValue[]" ><?php echo esc_attr(stripslashes($portfolio['optionValue'])); ?></textarea>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-12">
										<em class="mkd-field-description"><?php esc_html_e('Enter Full URL for Item Text Link', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="optionUrl_<?php echo esc_attr($no); ?>" name="optionUrl[]" value="<?php echo stripslashes($portfolio['optionUrl']); ?>" >
									</div>
								</div>
							</div><!-- close div.mkd-section-content -->
						</div><!-- close div.container-fluid -->
					</div>
				</div>
			</div>
			<?php
			$no++;
		}
		?>

		<div class="mkd-portfolio-add">
			<a class="mkd-add-item btn btn-sm btn-primary" href="#"><?php esc_html_e(' Add New Item', 'buro') ?></a>


			<a class="mkd-toggle-all-item btn btn-sm btn-default pull-right" href="#"> <?php esc_html_e('Expand All', 'buro') ?></a>
			<?php /* <a class="mkd-remove-last-item-row btn btn-sm btn-default pull-right" href="#"> Remove Last Row</a> */ ?>
		</div>




	<?php

	}
}


/*
   Class: BuroMikadoSlideElementsFramework
   A class that initializes elements for Slider
*/
class BuroMikadoSlideElementsFramework implements iBuroMikadoRender {
	private $label;
	private $description;


	function __construct($label="",$description="") {
		$this->label = $label;
		$this->description = $description;
	}

	public function render($factory) {
		global $post;
		global $buro_mikado_fonts_array;
		global $buro_mikado_IconCollections;

		$custom_positions = get_post_meta( $post->ID, 'mkd_slide_holder_elements_alignment', true ) == 'custom';
		$default_screen_width = get_post_meta( $post->ID, 'mkd_slide_elements_default_width', true );
		if ($default_screen_width == '') $default_screen_width = 1920;

		$screen_widths = array(
			// These values must match those in map.php (for slider), slider.php and shortcodes.js
			"mobile" => 600,
			"tabletp" => 800,
			"tabletl" => 1024,
			"laptop" => 1440
		);
		?>

		<div class="mkd-slide-element-additional-item-holder" style="display: none">
			<div class="mkd-slide-element-toggle-holder">
				<div class="mkd-slide-element-toggle mkd-toggle-desc">
					<span class="number">1</span><span class="mkd-toggle-inner"><?php esc_html_e('Slide Element', 'buro') ?></span>
				</div>
				<div class="mkd-slide-element-toggle mkd-slide-element-control">
					<span class="toggle-slide-element-item"><i class="fa fa-caret-up"></i></span>
					<a href="#" class="remove-slide-element-item"><i class="fa fa-times"></i></a>
				</div>
			</div>
			<div class="mkd-slide-element-toggle-content">
				<div class="mkd-page-form-section">
					<div class="mkd-section-content">
						<div class="container-fluid">
							<div class="row">
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Element Type', 'buro') ?></em>
									<select class="form-control mkd-input mkd-form-element mkd-slide-element-type-selector" id="slideelementtype_x" name="slideelementtype_x" >
										<option value="text"><?php esc_html_e('Text', 'buro') ?></option>
										<option value="image"><?php esc_html_e('Image', 'buro') ?></option>
										<option value="button"><?php esc_html_e('Button', 'buro') ?></option>
										<option value="section-link"><?php esc_html_e('Anchor Link', 'buro') ?></option>
									</select>
								</div>
								<div class="col-lg-9">
									<em class="mkd-field-description"><?php esc_html_e('Element Name (For Your Own Reference)', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementname_x" name="slideelementname_x" >
								</div>
							</div>
							<div class="row next-row mkd-slide-element-type-fields mkd-setf-section-link" style="display: none">
								<div class="col-lg-12">
									<em class="mkd-field-description"><?php esc_html_e('Anchor Link is always rendered at the bottom of the slide, centrally aligned.', 'buro') ?></em>
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Element Visible?', 'buro') ?></em>
									<select class="form-control mkd-input mkd-form-element" id="slideelementvisible_x" name="slideelementvisible_x" >
										<option value="yes"><?php esc_html_e('Yes', 'buro') ?></option>
										<option value="no"><?php esc_html_e('No', 'buro') ?></option>
									</select>
								</div>
								<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<em class="mkd-field-description"><?php esc_html_e('Pivot Point', 'buro') ?></em>
									<select class="form-control mkd-input mkd-form-element" id="s
									lideelementpivot_x" name="slideelementpivot_x" >
										<option value="top-left"><?php esc_html_e('Top - Left', 'buro') ?></option>
										<option value="top-center"><?php esc_html_e('Top - Center', 'buro') ?></option>
										<option value="top-right"><?php esc_html_e('Margin - Right (px)', 'buro') ?></option>
										<option value="middle-left"><?php esc_html_e('Middle - Left', 'buro') ?></option>
										<option value="middle-center"><?php esc_html_e('Middle - Center', 'buro') ?></option>
										<option value="middle-right"><?php esc_html_e('Middle - Right', 'buro') ?></option>
										<option value="bottom-left"><?php esc_html_e('Bottom - Left', 'buro') ?></option>
										<option value="bottom-center"><?php esc_html_e('Bottom - Center', 'buro') ?></option>
										<option value="bottom-right"><?php esc_html_e('Bottom - Right', 'buro') ?></option>
									</select>
								</div>
								<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<em class="mkd-field-description"><?php esc_html_e('Order', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementzindex_x" name="slideelementzindex_x" value="" >
								</div>
							</div>
							<div class="row next-row mkd-slide-element-all-but-custom"<?php if ($custom_positions) { ?> style="display:none"<?php } ?>>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Margin - Top (px)', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmargintop_x" name="slideelementmargintop_x" >
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Margin - Bottom (px)', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginbottom_x" name="slideelementmarginbottom_x" >
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Margin - Left (px)', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginleft_x" name="slideelementmarginleft_x" >
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Margin - Right (px)', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginright_x" name="slideelementmarginright_x" >
								</div>
							</div>

							<div class="mkd-slide-element-type-fields mkd-setf-text">
								<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative width (F/C*100 or blank for auto width)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextwidth_x" name="slideelementtextwidth_x" value="" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative height (G/D*100 or blank for auto height)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextheight_x" name="slideelementtextheight_x" value="" >
									</div>
								</div>
								<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextleft_x" name="slideelementtextleft_x" value="" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtexttop_x" name="slideelementtexttop_x" value="" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Item Text', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtext_x" name="slideelementtext_x" value="" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextlink_x" name="slideelementtextlink_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementtexttarget_x" name="slideelementtexttarget_x" >
											<option value="_self"><?php esc_html_e('Self', 'buro') ?></option>
											<option value="_blank"><?php esc_html_e('Blank', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Hover Color for Link', 'buro') ?></em>
										<input type="text" id="slideelementtextlinkhovercolor_x" name="slideelementtextlinkhovercolor_x" class="my-color-field"/>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Text Style', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementtextstyle_x" name="slideelementtextstyle_x" >
											<option value="small"><?php esc_html_e('Small Text', 'buro') ?></option>
											<option value="normal" selected><?php esc_html_e('Normal Text', 'buro') ?></option>
											<option value="large"><?php esc_html_e('Large Text', 'buro') ?></option>
											<option value="extra-large"><?php esc_html_e('Extra Large Text', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Text Style Options', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element mkd-slide-element-options-selector-text" id="slideelementtextoptions_x" name="slideelementtextoptions_x" >
											<option value="simple"><?php esc_html_e('Simple', 'buro') ?></option>
											<option value="advanced"><?php esc_html_e('Advanced', 'buro') ?></option>
										</select>
									</div>
								</div>
								<div class="mkd-slide-elements-advanced-text-options" style="display: none">
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Color', 'buro') ?></em>
											<input type="text" id="slideelementfontcolor_x" name="slideelementfontcolor_x" value="" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Size (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementfontsize_x" name="slideelementfontsize_x" value="" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Line Height (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlineheight_x" name="slideelementlineheight_x" value="" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Letter Spacing (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementletterspacing_x" name="slideelementletterspacing_x" value="" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Family', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element"
													id="slideelementfontfamily_x"
													name="slideelementfontfamily_x"
													>
												<option value="-1"><?php esc_html_e('Default', 'buro') ?></option>
												<?php foreach($buro_mikado_fonts_array as $fontArray) { ?>
													<option value="<?php echo esc_attr(str_replace(' ', '+', $fontArray["family"])); ?>"><?php echo esc_html($fontArray["family"]); ?></option>
												<?php } ?>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Style', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementfontstyle_x" name="slideelementfontstyle_x" >
												<option value=""></option>
												<option value="normal"><?php esc_html_e('normal', 'buro') ?></option>
												<option value="italic"><?php esc_html_e('italic', 'buro') ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Weight', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementfontweight_x" name="slideelementfontweight_x" >
												<option value=""></option>
												<?php for ($i=1; $i<=9; $i++) { ?>
													<option value="<?php echo esc_attr($i*100); ?>"><?php echo esc_html($i*100); ?></option>
												<?php } ?>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Text Transform', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementtexttransform_x" name="slideelementtexttransform_x" >
												<option value=""></option>
												<option value="none"><?php esc_html_e('None', 'buro') ?></option>
												<option value="capitalize"><?php esc_html_e('Capitalize', 'buro') ?></option>
												<option value="uppercase"><?php esc_html_e('Uppercase', 'buro') ?></option>
												<option value="lowercase"><?php esc_html_e('Lowercase', 'buro') ?></option>
											</select>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Background Color', 'buro') ?></em>
											<input type="text" id="slideelementtextbgndcolor_x; ?>" name="slideelementtextbgndcolor_x" value="" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Background Transparency (0-1)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextbgndtransparency_x; ?>" name="slideelementtextbgndtransparency_x" value="" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Thickness (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextborderthickness_x" name="slideelementtextborderthickness_x" value="" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Style', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementtextborderstyle_x" name="slideelementtextborderstyle_x" >
												<option value=""></option>
												<option value="solid"><?php esc_html_e('solid', 'buro') ?></option>
												<option value="dashed"><?php esc_html_e('dashed', 'buro') ?></option>
												<option value="dotted"><?php esc_html_e('dotted', 'buro') ?></option>
												<option value="double"><?php esc_html_e('double', 'buro') ?></option>
												<option value="groove"><?php esc_html_e('groove', 'buro') ?></option>
												<option value="ridge"><?php esc_html_e('ridge', 'buro') ?></option>
												<option value="inset"><?php esc_html_e('inset', 'buro') ?></option>
												<option value="outset"><?php esc_html_e('outset', 'buro') ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Color', 'buro') ?></em>
											<input type="text" id="slideelementtextbordercolor_x" name="slideelementtextbordercolor_x" value="" class="my-color-field"/>
										</div>
									</div>
								</div>
							</div>

							<div class="mkd-slide-element-type-fields mkd-setf-image" style="display: none">
								<div class="row next-row">
									<div class="col-lg-12">
										<em class="mkd-field-description"><?php esc_html_e('Image', 'buro') ?></em>
										<div class="mkd-media-uploader">
											<div style="display: none"
												 class="mkd-media-image-holder">
												<img src="" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
													 class="mkd-media-image img-thumbnail"/>
											</div>
											<div style="display: none"
												 class="form-control mkd-input mkd-form-element mkd-media-meta-fields">
												<input type="hidden" class="mkd-media-upload-url"
													   id="slideelementimageurl_x"
													   name="slideelementimageurl_x"
													   value=""/>
												<input type="hidden" class="mkd-media-upload-height"
													   name="slideelementimageuploadheight_x"
													   value=""/>
												<input type="hidden"
													   class="mkd-media-upload-width"
													   name="slideelementimageuploadwidth_x"
													   value=""/>
											</div>
											<a class="mkd-media-upload-btn btn btn-sm btn-primary"
											   href="javascript:void(0)"
											   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
											   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
											<a style="display: none;" href="javascript: void(0)"
											   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
										</div>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative width (F/C*100 or blank for auto width)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagewidth_x" name="slideelementimagewidth_x" value="" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative height (G/D*100 or blank for auto height)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageheight_x" name="slideelementimageheight_x" value="" >
									</div>
								</div>
								<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageleft_x" name="slideelementimageleft_x" value="" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagetop_x" name="slideelementimagetop_x" value="" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Link', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagelink_x" name="slideelementimagelink_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementimagetarget_x" name="slideelementimagetarget_x" >
											<option value="_self"><?php esc_html_e('Self', 'buro') ?></option>
											<option value="_blank"><?php esc_html_e('Blank', 'buro') ?></option>
										</select>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Border Thickness (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageborderthickness_x" name="slideelementimageborderthickness_x" value="" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Border Style', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementimageborderstyle_x" name="slideelementimageborderstyle_x" >
											<option value=""></option>
											<option value="solid"><?php esc_html_e('solid', 'buro') ?></option>
											<option value="dashed"><?php esc_html_e('dashed', 'buro') ?></option>
											<option value="dotted"><?php esc_html_e('dotted', 'buro') ?></option>
											<option value="double"><?php esc_html_e('double', 'buro') ?></option>
											<option value="groove"><?php esc_html_e('groove', 'buro') ?></option>
											<option value="ridge"><?php esc_html_e('ridge', 'buro') ?></option>
											<option value="inset"><?php esc_html_e('inset', 'buro') ?></option>
											<option value="outset"><?php esc_html_e('outset', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Border Color','buro'); ?></em>
										<input type="text" id="slideelementimagebordercolor_x" name="slideelementimagebordercolor_x" value="" class="my-color-field"/>
									</div>
								</div>
							</div>

							<div class="mkd-slide-element-type-fields mkd-setf-button" style="display: none">
								<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonleft_x" name="slideelementbuttonleft_x" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttontop_x" name="slideelementbuttontop_x" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Button Text', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttontext_x" name="slideelementbuttontext_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Link', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonlink_x" name="slideelementbuttonlink_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementbuttontarget_x" name="slideelementbuttontarget_x" >
											<option value="_self"><?php esc_html_e('Self', 'buro') ?></option>
											<option value="_blank"><?php esc_html_e('Blank', 'buro') ?></option>
										</select>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Button Size', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementbuttonsize_x" name="slideelementbuttonsize_x" >
											<option value="" ><?php esc_html_e('Default', 'buro') ?></option>
											<option value="small"><?php esc_html_e('Small', 'buro') ?></option>
											<option value="medium"><?php esc_html_e('Medium', 'buro') ?></option>
											<option value="large"><?php esc_html_e('Large', 'buro') ?></option>
											<option value="huge"><?php esc_html_e('Extra Large', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Button Type', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementbuttontype_x" name="slideelementbuttontype_x" >
											<option value="" ><?php esc_html_e('Default', 'buro') ?></option>
											<option value="outline"><?php esc_html_e('Outline', 'buro') ?></option>
											<option value="solid"><?php esc_html_e('Solid', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3 mkd-slide-element-all-but-custom"<?php if ($custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Keep in Line with Other Buttons?', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementbuttoninline_x" name="slideelementbuttoninline_x" >
											<option value="no"><?php esc_html_e('No', 'buro') ?></option>
											<option value="yes"><?php esc_html_e('Yes', 'buro') ?></option>
										</select>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Font Size (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonfontsize_x" name="slideelementbuttonfontsize_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Font Weight (px)', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementbuttonfontweight_x" name="slideelementbuttonfontweight_x" >
											<option value=""></option>
											<?php for ($i=1; $i<=9; $i++) { ?>
												<option value="<?php echo esc_attr($i*100); ?>"><?php echo esc_html($i*100); ?></option>
											<?php } ?>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Font Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonfontcolor_x" name="slideelementbuttonfontcolor_x" class="my-color-field"/>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Font Hover Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonfonthovercolor_x" name="slideelementbuttonfonthovercolor_x" class="my-color-field"/>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Background Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonbgndcolor_x" name="slideelementbuttonbgndcolor_x" class="my-color-field"/>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Background Hover Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonbgndhovercolor_x" name="slideelementbuttonbgndhovercolor_x" class="my-color-field"/>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Border Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonbordercolor_x" name="slideelementbuttonbordercolor_x" class="my-color-field"/>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Border Hover Color', 'buro') ?></em>
										<input type="text" id="slideelementbuttonborderhovercolor_x" name="slideelementbuttonborderhovercolor_x" class="my-color-field"/>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Icon Pack', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element mkd-slide-element-button-icon-pack"
												id="slideelementbuttoniconpack_x"
												name="slideelementbuttoniconpack_x"
												>
											<?php
											$icon_packs = $buro_mikado_IconCollections->getIconCollectionsEmpty("no_icon");
											foreach ($icon_packs as $key=>$value) { ?>
												<option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
												<?php
											}
											?>
										</select>
									</div>
									<?php
									foreach ($buro_mikado_IconCollections->iconCollections as $collection_key => $collection_object) {
										$icons_array = $collection_object->getIconsArray();
										?>
										<div class="col-lg-3 mkd-slide-element-button-icon-collection <?php echo esc_attr($collection_key); ?>" style="display: none">
											<em class="mkd-field-description"><?php esc_html_e('Button Icon','buro'); ?></em>
											<select class="form-control mkd-input mkd-form-element"
													id="slideelementbuttonicon_<?php echo esc_attr($collection_key); ?>_x"
													name="slideelementbuttonicon_<?php echo esc_attr($collection_key); ?>_x"
													>
												<?php
												foreach ($icons_array as $key=>$value) { ?>
													<option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
													<?php
												}
												?>
											</select>
										</div>
										<?php
									}
									?>
								</div>
							</div>

							<div class="mkd-slide-element-type-fields mkd-setf-section-link" style="display: none">
								<!--
								<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-6">
										<em class="mkd-field-description">Relative position - Left (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinkleft_x" name="slideelementsectionlinkleft_x" >
									</div>
									<div class="col-lg-6">
										<em class="mkd-field-description">Relative position - Top(Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinktop_x" name="slideelementsectionlinktop_x" >
									</div>
								</div>
								-->
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Target Section Anchor (i.e. "#products")', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinkanchor_x" name="slideelementsectionlinkanchor_x" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Anchor Link Text (i.e. "Scroll Down")', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinktext_x" name="slideelementsectionlinktext_x" >
									</div>
								</div>
							</div>

							<div class="row next-row">
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Animation', 'buro') ?></em>
									<select class="form-control mkd-input mkd-form-element" id="slideelementanimation_x" name="slideelementanimation_x" >
										<option value="default"><?php esc_html_e('Default', 'buro') ?></option>
										<option value="none"><?php esc_html_e('No Animation)', 'buro') ?></option>
										<option value="flip"><?php esc_html_e('Flip', 'buro') ?></option>
										<option value="spin"><?php esc_html_e('Spin', 'buro') ?></option>
										<option value="fade"><?php esc_html_e('Fade In', 'buro') ?></option>
										<option value="from_bottom"><?php esc_html_e('Fly In From Bottom', 'buro') ?></option>
										<option value="from_top"><?php esc_html_e('Fly In From Top', 'buro') ?></option>
										<option value="from_left"><?php esc_html_e('Fly In From Left', 'buro') ?></option>
										<option value="from_right"><?php esc_html_e('Fly In From Right', 'buro') ?></option>
									</select>
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Animation Delay (i.e. "0.5s" or "400ms")', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementanimationdelay_x" name="slideelementanimationdelay_x" >
								</div>
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Animation Duration (i.e. "0.5s" or "400ms")', 'buro') ?></em>
									<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementanimationduration_x" name="slideelementanimationduration_x" >
								</div>
							</div>
							<div class="row next-row">
								<div class="col-lg-3">
									<em class="mkd-field-description"><?php esc_html_e('Element Responsiveness', 'buro') ?></em>
									<select class="form-control mkd-input mkd-form-element mkd-slide-element-responsiveness-selector" id="slideelementresponsive_x" name="slideelementresponsive_x" >
										<option value="proportional"><?php esc_html_e('Preserve proportions', 'buro') ?></option>
										<option value="stages"><?php esc_html_e('Scale based on stage coefficients', 'buro') ?></option>
									</select>
								</div>
							</div>
							<div class="mkd-slide-responsive-scale-factors" style="display:none">
								<div class="row next-row">
									<div class="col-lg-12">
										<em class="mkd-field-description"><?php esc_html_e('Enter below the scale sactors for each responsive stage, relative to the values above (or to the original size for images).<br/>Scale Factor of 1 leaves the element at the same size as for the default screen width of', 'buro') ?> <span class="mkd-slide-dynamic-def-width"><?php echo esc_html($default_screen_width); ?></span><?php esc_html_e('px, while setting it to zero hides the element.', 'buro') ?><div class="mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>><?php esc_html_e('If you also wish to change the position of the element for a certain stage, enter the desired position in the corresponding fields.', 'buro') ?></div></em>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Mobile<br>(up to', 'buro') ?> <?php echo esc_html($screen_widths["mobile"]); ?>px)</em>
									</div>
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscalemobile_x" name="slideelementscalemobile_x" placeholder="0.5">
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftmobile_x" name="slideelementleftmobile_x" >
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtopmobile_x" name="slideelementtopmobile_x" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Tablet (Portrait)', 'buro') ?><br>(<?php echo esc_html($screen_widths["mobile"]+1); ?>px - <?php echo esc_html($screen_widths["tabletp"]); ?>px)</em>
									</div>
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaletabletp_x" name="slideelementscaletabletp_x" placeholder="0.6">
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlefttabletp_x" name="slideelementlefttabletp_x" >
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoptabletp_x" name="slideelementtoptabletp_x" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Tablet (Landscape)', 'buro') ?><br>(<?php echo esc_html($screen_widths["tabletp"]+1); ?>px - <?php echo esc_html($screen_widths["tabletl"]); ?>px)</em>
									</div>
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaletabletl_x" name="slideelementscaletabletl_x" placeholder="0.7">
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlefttabletl_x" name="slideelementlefttabletl_x" >
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoptabletl_x" name="slideelementtoptabletl_x" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Laptop', 'buro') ?><br>(<?php echo esc_html($screen_widths["tabletl"]+1); ?>px - <?php echo esc_html($screen_widths["laptop"]); ?>px)</em>
									</div>
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscalelaptop_x" name="slideelementscalelaptop_x" placeholder="0.8">
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftlaptop_x" name="slideelementleftlaptop_x" >
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoplaptop_x" name="slideelementtoplaptop_x" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Desktop', 'buro') ?><br>(above <?php echo esc_html($screen_widths["laptop"]); ?>px)</em>
									</div>
									<div class="col-lg-2">
										<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaledesktop_x" name="slideelementscaledesktop_x" placeholder="1">
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftdesktop_x" name="slideelementleftdesktop_x" >
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtopdesktop_x" name="slideelementtopdesktop_x" >
									</div>
								</div>
							</div>
						</div><!-- close div.mkd-section-content -->
					</div><!-- close div.container-fluid -->
				</div>
			</div>
		</div>
		<?php
		$no = 1;
		$slide_elements = get_post_meta( $post->ID, 'mkd_slide_elements', true );
		
		while (isset($slide_elements[$no-1])) {
			$slide_element = $slide_elements[$no-1];
			?>
			<div class="mkd-slide-element-additional-item" rel="<?php echo esc_attr($no); ?>">
				<div class="mkd-slide-element-toggle-holder">
					<div class="mkd-slide-element-toggle mkd-toggle-desc">
						<span class="number"><?php echo esc_html($no); ?></span><span class="mkd-toggle-inner"><?php esc_html_e('Slide Element', 'buro') ?> - <em><?php echo esc_html(stripslashes($slide_element['slideelementname'])); ?></em></span>
					</div>
					<div class="mkd-slide-element-toggle mkd-slide-element-control">
						<span class="toggle-slide-element-item"><i class="fa fa-caret-down"></i></span>
						<a href="#" class="remove-slide-element-item"><i class="fa fa-times"></i></a>
					</div>
				</div>
				<div class="mkd-slide-element-toggle-content" style="display: none">
					<div class="mkd-page-form-section">
						<div class="mkd-section-content">
							<div class="container-fluid">
								<div class="row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Element Type', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element mkd-slide-element-type-selector" id="slideelementtype_<?php echo esc_attr($no); ?>" name="slideelementtype[]" >
											<option value="text" <?php echo esc_attr($slide_element['slideelementtype']) == "text" ? "selected" : ""; ?>><?php esc_html_e('Text', 'buro') ?></option>
											<option value="image" <?php echo esc_attr($slide_element['slideelementtype']) == "image" ? "selected" : ""; ?>><?php esc_html_e('Image', 'buro') ?></option>
											<option value="button" <?php echo esc_attr($slide_element['slideelementtype']) == "button" ? "selected" : ""; ?>><?php esc_html_e('Button', 'buro') ?></option>
											<option value="section-link" <?php echo esc_attr($slide_element['slideelementtype']) == "section-link" ? "selected" : ""; ?>><?php esc_html_e('Anchor Link', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-9">
										<em class="mkd-field-description"><?php esc_html_e('Element Name (For Your Own Reference)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementname_<?php esc_attr($no); ?>" name="slideelementname[]" value="<?php echo esc_attr($slide_element['slideelementname']); ?>" >
									</div>
								</div>
								<div class="row next-row mkd-slide-element-type-fields mkd-setf-section-link"<?php if ($slide_element['slideelementtype'] != "section-link") { ?> style="display: none"<?php } ?>>
									<div class="col-lg-12">
										<em class="mkd-field-description"><?php esc_html_e('Anchor Link is always rendered at the bottom of the slide, centrally aligned.', 'buro') ?></em>
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Element Visible?', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementvisible_<?php echo esc_attr($no); ?>" name="slideelementvisible[]" >
											<option value="yes" <?php if (isset($slide_element['slideelementvisible'])) {echo esc_attr($slide_element['slideelementvisible']) == "yes" ? "selected" : "";}  ?>><?php esc_html_e('Yes','buro'); ?></option>
											<option value="no" <?php if (isset($slide_element['slideelementvisible'])) {echo esc_attr($slide_element['slideelementvisible']) == "no" ? "selected" : "";}  ?>><?php esc_html_e('No','buro'); ?></option>
										</select>
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Pivot Point', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementpivot_<?php echo esc_attr($no); ?>" name="slideelementpivot[]" >
											<option value="top-left" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "top-left" ? "selected" : "";}  ?>><?php esc_html_e('Top - Left', 'buro') ?></option>
											<option value="top-center" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "top-center" ? "selected" : "";}  ?>><?php esc_html_e('Top - Center', 'buro') ?></option>
											<option value="top-right" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "top-right" ? "selected" : "";}  ?>><?php esc_html_e('Top - Right', 'buro') ?></option>
											<option value="middle-left" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "middle-left" ? "selected" : "";}  ?>><?php esc_html_e('Middle - Left', 'buro') ?></option>
											<option value="middle-center" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "middle-center" ? "selected" : "";}  ?>><?php esc_html_e('Middle - Center', 'buro') ?></option>
											<option value="middle-right" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "middle-right" ? "selected" : "";}  ?>><?php esc_html_e('Middle - Right', 'buro') ?></option>
											<option value="bottom-left" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "bottom-left" ? "selected" : "";}  ?>><?php esc_html_e('Bottom - Left', 'buro') ?></option>
											<option value="bottom-center" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "bottom-center" ? "selected" : "";}  ?>><?php esc_html_e('Bottom - Center', 'buro') ?></option>
											<option value="bottom-right" <?php if (isset($slide_element['slideelementpivot'])) {echo esc_attr($slide_element['slideelementpivot']) == "bottom-right" ? "selected" : "";}  ?>><?php esc_html_e('Bottom - Right', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<em class="mkd-field-description"><?php esc_html_e('Order', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementzindex_<?php esc_attr($no); ?>" name="slideelementzindex[]" value="<?php echo isset($slide_element['slideelementzindex']) ? esc_attr($slide_element['slideelementzindex']) : ''; ?>" >
									</div>
								</div>
								<div class="row next-row mkd-slide-element-all-but-custom"<?php if ($custom_positions) { ?> style="display:none"<?php } ?>>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Margin - Top (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmargintop_<?php esc_attr($no); ?>" name="slideelementmargintop[]" value="<?php echo isset($slide_element['slideelementmargintop']) ? esc_attr($slide_element['slideelementmargintop']) : ''; ?>" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Margin - Bottom (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginbottom_<?php esc_attr($no); ?>" name="slideelementmarginbottom[]" value="<?php echo isset($slide_element['slideelementmarginbottom']) ? esc_attr($slide_element['slideelementmarginbottom']) : ''; ?>" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Margin - Left (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginleft_<?php esc_attr($no); ?>" name="slideelementmarginleft[]" value="<?php echo isset($slide_element['slideelementmarginleft']) ? esc_attr($slide_element['slideelementmarginleft']) : ''; ?>" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Margin - Right (px)', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementmarginright_<?php esc_attr($no); ?>" name="slideelementmarginright[]" value="<?php echo isset($slide_element['slideelementmarginright']) ? esc_attr($slide_element['slideelementmarginright']) : ''; ?>" >
									</div>
								</div>

								<div class="mkd-slide-element-type-fields mkd-setf-text"<?php if ($slide_element['slideelementtype'] != "text") { ?> style="display: none"<?php } ?>>
									<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative width (F/C*100 or blank for auto width)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextwidth_<?php esc_attr($no); ?>" name="slideelementtextwidth[]" value="<?php echo isset($slide_element['slideelementtextwidth']) ? esc_attr($slide_element['slideelementtextwidth']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative height (G/D*100 or blank for auto height)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextheight_<?php esc_attr($no); ?>" name="slideelementtextheight[]" value="<?php echo isset($slide_element['slideelementtextheight']) ? esc_attr($slide_element['slideelementtextheight']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextleft_<?php esc_attr($no); ?>" name="slideelementtextleft[]" value="<?php echo isset($slide_element['slideelementtextleft']) ? esc_attr($slide_element['slideelementtextleft']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtexttop_<?php esc_attr($no); ?>" name="slideelementtexttop[]" value="<?php echo isset($slide_element['slideelementtexttop']) ? esc_attr($slide_element['slideelementtexttop']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Item Text', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtext_<?php esc_attr($no); ?>" name="slideelementtext[]" value="<?php echo esc_attr($slide_element['slideelementtext']); ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Link', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextlink_<?php echo esc_attr($no); ?>" name="slideelementtextlink[]" value="<?php echo isset($slide_element['slideelementtextlink']) ? esc_attr($slide_element['slideelementtextlink']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementtexttarget_<?php echo esc_attr($no); ?>" name="slideelementtexttarget[]" >
												<option value="_self" <?php if (isset($slide_element['slideelementtexttarget'])) {echo esc_attr($slide_element['slideelementtexttarget']) == "_self" ? "selected" : "";} ?>><?php esc_html_e('Self','buro'); ?></option>
												<option value="_blank" <?php if (isset($slide_element['slideelementtexttarget'])) {echo esc_attr($slide_element['slideelementtexttarget']) == "_blank" ? "selected" : "";} ?>><?php esc_html_e('Blank','buro'); ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Hover Color for Link', 'buro') ?></em>
											<input type="text" id="slideelementtextlinkhovercolor_<?php esc_attr($no); ?>" name="slideelementtextlinkhovercolor[]" value="<?php echo isset($slide_element['slideelementtextlinkhovercolor']) ? esc_attr($slide_element['slideelementtextlinkhovercolor']) : ''; ?>" class="my-color-field"/>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Text Style', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementtextstyle_<?php echo esc_attr($no); ?>" name="slideelementtextstyle[]" >
												<option value="small" <?php if (isset($slide_element['slideelementtextstyle'])) {echo esc_attr($slide_element['slideelementtextstyle']) == "small" ? "selected" : "";} ?>><?php esc_html_e('Small Text','buro'); ?></option>
												<option value="normal" <?php if (isset($slide_element['slideelementtextstyle'])) {echo esc_attr($slide_element['slideelementtextstyle']) == "normal" ? "selected" : "";} ?>><?php esc_html_e('Normal Text','buro'); ?></option>
												<option value="large" <?php if (isset($slide_element['slideelementtextstyle'])) {echo esc_attr($slide_element['slideelementtextstyle']) == "large" ? "selected" : "";}  ?>><?php esc_html_e('Large Text','buro'); ?></option>
												<option value="extra-large" <?php if (isset($slide_element['slideelementtextstyle'])) {echo esc_attr($slide_element['slideelementtextstyle']) == "extra-large" ? "selected" : "";} ?>><?php esc_html_e('Extra Large Text','buro'); ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Text Style Options', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element mkd-slide-element-options-selector mkd-slide-element-options-selector-text" id="slideelementtextoptions_<?php echo esc_attr($no); ?>" name="slideelementtextoptions[]" >
												<option value="simple" <?php if (isset($slide_element['slideelementtextoptions'])) {echo esc_attr($slide_element['slideelementtextoptions']) == "simple" ? "selected" : "";}  ?>><?php esc_html_e('Simple','buro'); ?></option>
												<option value="advanced" <?php if (isset($slide_element['slideelementtextoptions'])) {echo esc_attr($slide_element['slideelementtextoptions']) == "advanced" ? "selected" : "";}  ?>><?php esc_html_e('Advanced','buro'); ?></option>
											</select>
										</div>
									</div>
									<div class="mkd-slide-elements-advanced-text-options"<?php if (isset($slide_element['slideelementtextoptions']) && $slide_element['slideelementtextoptions'] != "advanced") { ?> style="display: none"<?php } ?>>
										<div class="row next-row">
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Font Color', 'buro') ?></em>
												<input type="text" id="slideelementfontcolor_<?php esc_attr($no); ?>" name="slideelementfontcolor[]" value="<?php echo esc_attr($slide_element['slideelementfontcolor']); ?>" class="my-color-field"/>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Font Size (px)', 'buro') ?></em>
												<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementfontsize_<?php esc_attr($no); ?>" name="slideelementfontsize[]" value="<?php echo esc_attr($slide_element['slideelementfontsize']); ?>" >
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Line Height (px)', 'buro') ?></em>
												<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlineheight_<?php esc_attr($no); ?>" name="slideelementlineheight[]" value="<?php echo esc_attr($slide_element['slideelementlineheight']); ?>" >
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Letter Spacing (px)', 'buro') ?></em>
												<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementletterspacing_<?php esc_attr($no); ?>" name="slideelementletterspacing[]" value="<?php echo esc_attr($slide_element['slideelementletterspacing']); ?>" >
											</div>
										</div>
										<div class="row next-row">
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Font Family', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element"
														id="slideelementfontfamily_<?php echo esc_attr($no); ?>"
														name="slideelementfontfamily[]"
														>
													<option value="-1"><?php esc_html_e('Default', 'buro') ?></option>
													<?php foreach($buro_mikado_fonts_array as $fontArray) { ?>
														<option <?php if (isset($slide_element['slideelementfontfamily']) && $slide_element['slideelementfontfamily'] == str_replace(' ', '+', $fontArray["family"])) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr(str_replace(' ', '+', $fontArray["family"])); ?>"><?php echo esc_html($fontArray["family"]); ?></option>
													<?php } ?>
												</select>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Font Style', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element" id="slideelementfontstyle_<?php echo esc_attr($no); ?>" name="slideelementfontstyle[]" >
													<option value="" <?php if (isset($slide_element['slideelementfontstyle'])) {echo esc_attr($slide_element['slideelementfontstyle']) == "" ? "selected" : "";} ?>></option>
													<option value="normal" <?php if (isset($slide_element['slideelementfontstyle'])) {echo esc_attr($slide_element['slideelementfontstyle']) == "normal" ? "selected" : "";}  ?>><?php esc_html_e('normal', 'buro') ?></option>
													<option value="italic" <?php if (isset($slide_element['slideelementfontstyle'])) {echo esc_attr($slide_element['slideelementfontstyle']) == "italic" ? "selected" : "";} ?>><?php esc_html_e('italic', 'buro') ?></option>
												</select>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Font Weight', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element" id="slideelementfontweight_<?php echo esc_attr($no); ?>" name="slideelementfontweight[]" >
													<option value="" <?php if (isset($slide_element['slideelementfontweight'])) {echo esc_attr($slide_element['slideelementfontweight']) == "" ? "selected" : "";} ?>></option>
													<?php for ($i=1; $i<=9; $i++) { ?>
														<option value="<?php echo esc_attr($i*100); ?>" <?php if (isset($slide_element['slideelementfontweight'])) {echo (int)$slide_element['slideelementfontweight'] == $i*100 ? "selected" : "";} ?>><?php echo esc_html($i*100); ?></option>
													<?php } ?>
												</select>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Text Transform', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element" id="slideelementtexttransform_<?php echo esc_attr($no); ?>" name="slideelementtexttransform[]" >
													<option value="" <?php if (isset($slide_element['slideelementtexttransform'])) {echo esc_attr($slide_element['slideelementtexttransform']) == "" ? "selected" : "";} ?>></option>
													<option value="none" <?php if (isset($slide_element['slideelementtexttransform'])) {echo esc_attr($slide_element['slideelementtexttransform']) == "none" ? "selected" : "";}  ?>><?php esc_html_e('None', 'buro') ?></option>
													<option value="capitalize" <?php if (isset($slide_element['slideelementtexttransform'])) {echo esc_attr($slide_element['slideelementtexttransform']) == "capitalize" ? "selected" : "";}  ?>><?php esc_html_e('Capitalize', 'buro') ?></option>
													<option value="uppercase" <?php if (isset($slide_element['slideelementtexttransform'])) {echo esc_attr($slide_element['slideelementtexttransform']) == "uppercase" ? "selected" : "";} ?>><?php esc_html_e('Uppercase', 'buro') ?></option>
													<option value="lowercase" <?php if (isset($slide_element['slideelementtexttransform'])) {echo esc_attr($slide_element['slideelementtexttransform']) == "lowercase" ? "selected" : "";} ?>><?php esc_html_e('Lowercase', 'buro') ?></option>
												</select>
											</div>
										</div>
										<div class="row next-row">
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Background Color', 'buro') ?></em>
												<input type="text" id="slideelementtextbgndcolor_<?php esc_attr($no); ?>" name="slideelementtextbgndcolor[]" value="<?php echo isset($slide_element['slideelementtextbgndcolor']) ? esc_attr($slide_element['slideelementtextbgndcolor']) : ''; ?>" class="my-color-field"/>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Background Transparency', 'buro') ?> (0-1)</em>
												<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextbgndtransparency_<?php esc_attr($no); ?>" name="slideelementtextbgndtransparency[]" value="<?php echo isset($slide_element['slideelementtextbgndtransparency']) ? esc_attr($slide_element['slideelementtextbgndtransparency']) : ''; ?>" >
											</div>
										</div>
										<div class="row next-row">
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Border Thickness (px)', 'buro') ?></em>
												<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtextborderthickness_<?php esc_attr($no); ?>" name="slideelementtextborderthickness[]" value="<?php echo isset($slide_element['slideelementtextborderthickness']) ? esc_attr($slide_element['slideelementtextborderthickness']) : ''; ?>" >
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Border Style', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element" id="slideelementtextborderstyle_<?php echo esc_attr($no); ?>" name="slideelementtextborderstyle[]" >
													<option value="" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "" ? "selected" : "";} ?>></option>
													<option value="solid" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "solid" ? "selected" : "";}  ?>><?php esc_html_e('solid', 'buro') ?></option>
													<option value="dashed" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "dashed" ? "selected" : "";}  ?>><?php esc_html_e('dashed', 'buro') ?></option>
													<option value="dotted" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "dotted" ? "selected" : "";} ?>><?php esc_html_e('dotted', 'buro') ?></option>
													<option value="double" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "double" ? "selected" : "";} ?>><?php esc_html_e('double', 'buro') ?></option>
													<option value="groove" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "groove" ? "selected" : "";}  ?>><?php esc_html_e('groove', 'buro') ?></option>
													<option value="ridge" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "ridge" ? "selected" : "";}  ?>><?php esc_html_e('ridge', 'buro') ?></option>
													<option value="inset" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "inset" ? "selected" : "";} ?>><?php esc_html_e('inset', 'buro') ?></option>
													<option value="outset" <?php if (isset($slide_element['slideelementtextborderstyle'])) {echo esc_attr($slide_element['slideelementtextborderstyle']) == "outset" ? "selected" : "";} ?>><?php esc_html_e('outset', 'buro') ?></option>
												</select>
											</div>
											<div class="col-lg-3">
												<em class="mkd-field-description"><?php esc_html_e('Border Color', 'buro') ?></em>
												<input type="text" id="slideelementtextbordercolor_<?php esc_attr($no); ?>" name="slideelementtextbordercolor[]" value="<?php echo isset($slide_element['slideelementtextbordercolor']) ? esc_attr($slide_element['slideelementtextbordercolor']) : ''; ?>" class="my-color-field"/>
											</div>
										</div>
									</div>
								</div>

								<div class="mkd-slide-element-type-fields mkd-setf-image"<?php if ($slide_element['slideelementtype'] != "image") { ?> style="display: none"<?php } ?>>
									<div class="row next-row">
										<div class="col-lg-12">
											<em class="mkd-field-description"><?php esc_html_e('Image', 'buro') ?></em>
											<div class="mkd-media-uploader">
												<div <?php if ($slide_element['slideelementimageurl'] == "") { ?> style="display: none"<?php } ?>
													class="mkd-media-image-holder">
													<img src="<?php if ($slide_element['slideelementimageurl'] != "") { echo esc_url(buro_mikado_get_attachment_thumb_url($slide_element['slideelementimageurl'])); } ?>" alt="<?php esc_attr_e( 'Image thumbnail', 'buro' ); ?>"
														 class="mkd-media-image img-thumbnail"/>
												</div>
												<div style="display: none"
													 class="form-control mkd-input mkd-form-element mkd-media-meta-fields">
													<input type="hidden" class="mkd-media-upload-url"
														   id="slideelementimageurl_<?php esc_attr($no); ?>"
														   name="slideelementimageurl[]"
														   value="<?php echo esc_attr($slide_element['slideelementimageurl']); ?>"/>
													<input type="hidden" class="mkd-media-upload-height"
														   name="slideelementimageuploadheight[]"
														   value="<?php echo esc_attr($slide_element['slideelementimageuploadheight']); ?>"/>
													<input type="hidden"
														   class="mkd-media-upload-width"
														   name="slideelementimageuploadwidth[]"
														   value="<?php echo esc_attr($slide_element['slideelementimageuploadwidth']); ?>"/>
												</div>
												<a class="mkd-media-upload-btn btn btn-sm btn-primary"
												   href="javascript:void(0)"
												   data-frame-title="<?php esc_attr_e('Select Image', 'buro'); ?>"
												   data-frame-button-text="<?php esc_html_e('Select Image', 'buro'); ?>"><?php esc_html_e('Upload', 'buro'); ?></a>
												<a style="display: none;" href="javascript: void(0)"
												   class="mkd-media-remove-btn btn btn-default btn-sm"><?php esc_html_e('Remove', 'buro'); ?></a>
											</div>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative width (F/C*100 or blank for auto width)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagewidth_<?php esc_attr($no); ?>" name="slideelementimagewidth[]" value="<?php echo isset($slide_element['slideelementimagewidth']) ? esc_attr($slide_element['slideelementimagewidth']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative height (G/D*100 or blank for auto height)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageheight_<?php esc_attr($no); ?>" name="slideelementimageheight[]" value="<?php echo isset($slide_element['slideelementimageheight']) ? esc_attr($slide_element['slideelementimageheight']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageleft_<?php esc_attr($no); ?>" name="slideelementimageleft[]" value="<?php echo isset($slide_element['slideelementimageleft']) ? esc_attr($slide_element['slideelementimageleft']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagetop_<?php esc_attr($no); ?>" name="slideelementimagetop[]" value="<?php echo isset($slide_element['slideelementimagetop']) ? esc_attr($slide_element['slideelementimagetop']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Link', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimagelink_<?php echo esc_attr($no); ?>" name="slideelementimagelink[]" value="<?php echo isset($slide_element['slideelementimagelink']) ? esc_attr($slide_element['slideelementimagelink']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementimagetarget_<?php echo esc_attr($no); ?>" name="slideelementimagetarget[]" >
												<option value="_self" <?php if (isset($slide_element['slideelementimagetarget'])) {echo esc_attr($slide_element['slideelementimagetarget']) == "_self" ? "selected" : "";} ?>><?php esc_html_e('Self', 'buro') ?></option>
												<option value="_blank" <?php if (isset($slide_element['slideelementimagetarget'])) {echo esc_attr($slide_element['slideelementimagetarget']) == "_blank" ? "selected" : "";} ?>><?php esc_html_e('Blank', 'buro') ?></option>
											</select>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Thickness (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementimageborderthickness_<?php esc_attr($no); ?>" name="slideelementimageborderthickness[]" value="<?php echo isset($slide_element['slideelementimageborderthickness']) ? esc_attr($slide_element['slideelementimageborderthickness']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Style', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementimageborderstyle_<?php echo esc_attr($no); ?>" name="slideelementimageborderstyle[]" >
												<option value="" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "" ? "selected" : "";} ?>></option>
												<option value="solid" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "solid" ? "selected" : "";}  ?>><?php esc_html_e('solid', 'buro') ?></option>
												<option value="dashed" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "dashed" ? "selected" : "";}  ?>><?php esc_html_e('dashed', 'buro') ?></option>
												<option value="dotted" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "dotted" ? "selected" : "";} ?>><?php esc_html_e('dotted', 'buro') ?></option>
												<option value="double" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "double" ? "selected" : "";} ?>><?php esc_html_e('double', 'buro') ?></option>
												<option value="groove" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "groove" ? "selected" : "";}  ?>><?php esc_html_e('groove', 'buro') ?></option>
												<option value="ridge" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "ridge" ? "selected" : "";}  ?>><?php esc_html_e('ridge', 'buro') ?></option>
												<option value="inset" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "inset" ? "selected" : "";} ?>><?php esc_html_e('inset', 'buro') ?></option>
												<option value="outset" <?php if (isset($slide_element['slideelementimageborderstyle'])) {echo esc_attr($slide_element['slideelementimageborderstyle']) == "outset" ? "selected" : "";} ?>><?php esc_html_e('outset', 'buro') ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Color', 'buro') ?></em>
											<input type="text" id="slideelementimagebordercolor_<?php esc_attr($no); ?>" name="slideelementimagebordercolor[]" value="<?php echo isset($slide_element['slideelementimagebordercolor']) ? esc_attr($slide_element['slideelementimagebordercolor']) : ''; ?>" class="my-color-field"/>
										</div>
									</div>
								</div>

								<div class="mkd-slide-element-type-fields mkd-setf-button"<?php if ($slide_element['slideelementtype'] != "button") { ?> style="display: none"<?php } ?>>
									<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonleft_<?php esc_attr($no); ?>" name="slideelementbuttonleft[]" value="<?php echo isset($slide_element['slideelementbuttonleft']) ? esc_attr($slide_element['slideelementbuttonleft']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttontop_<?php esc_attr($no); ?>" name="slideelementbuttontop[]" value="<?php echo isset($slide_element['slideelementbuttontop']) ? esc_attr($slide_element['slideelementbuttontop']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Button Text', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttontext_<?php echo esc_attr($no); ?>" name="slideelementbuttontext[]" value="<?php echo isset($slide_element['slideelementbuttontext']) ? esc_attr($slide_element['slideelementbuttontext']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Link', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonlink_<?php echo esc_attr($no); ?>" name="slideelementbuttonlink[]" value="<?php echo isset($slide_element['slideelementbuttonlink']) ? esc_attr($slide_element['slideelementbuttonlink']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Target', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementbuttontarget_<?php echo esc_attr($no); ?>" name="slideelementbuttontarget[]" >
												<option value="_self" <?php if (isset($slide_element['slideelementbuttontarget'])) {echo esc_attr($slide_element['slideelementbuttontarget']) == "_self" ? "selected" : "";} ?>><?php esc_html_e('Self','buro'); ?></option>
												<option value="_blank" <?php if (isset($slide_element['slideelementbuttontarget'])) {echo esc_attr($slide_element['slideelementbuttontarget']) == "_blank" ? "selected" : "";} ?>><?php esc_html_e('Blank','buro'); ?></option>
											</select>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Button Size', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementbuttonsize_<?php echo esc_attr($no); ?>" name="slideelementbuttonsize[]" >
												<option value="" <?php if (isset($slide_element['slideelementbuttonsize'])) {echo esc_attr($slide_element['slideelementbuttonsize']) == "" ? "selected" : "";} ?>><?php esc_html_e('Default','buro'); ?></option>
												<option value="small" <?php if (isset($slide_element['slideelementbuttonsize'])) {echo esc_attr($slide_element['slideelementbuttonsize']) == "small" ? "selected" : "";}  ?>><?php esc_html_e('Small','buro'); ?></option>
												<option value="medium" <?php if (isset($slide_element['slideelementbuttonsize'])) {echo esc_attr($slide_element['slideelementbuttonsize']) == "medium" ? "selected" : "";} ?>><?php esc_html_e('Medium','buro'); ?></option>
												<option value="large" <?php if (isset($slide_element['slideelementbuttonsize'])) {echo esc_attr($slide_element['slideelementbuttonsize']) == "large" ? "selected" : "";} ?>><?php esc_html_e('Large','buro'); ?></option>
												<option value="huge" <?php if (isset($slide_element['slideelementbuttonsize'])) {echo esc_attr($slide_element['slideelementbuttonsize']) == "huge" ? "selected" : "";} ?>><?php esc_html_e('Extra Large','buro'); ?></option>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Button Type', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementbuttontype_<?php echo esc_attr($no); ?>" name="slideelementbuttontype[]" >
												<option value="" <?php if (isset($slide_element['slideelementbuttontype'])) {echo esc_attr($slide_element['slideelementbuttontype']) == "" ? "selected" : "";} ?>><?php esc_html_e('Default','buro'); ?></option>
												<option value="outline" <?php if (isset($slide_element['slideelementbuttontype'])) {echo esc_attr($slide_element['slideelementbuttontype']) == "outline" ? "selected" : "";}  ?>><?php esc_html_e('Outline','buro'); ?></option>
												<option value="solid" <?php if (isset($slide_element['slideelementbuttontype'])) {echo esc_attr($slide_element['slideelementbuttontype']) == "solid" ? "selected" : "";} ?>><?php esc_html_e('Solid','buro'); ?></option>
											</select>
										</div>
										<div class="col-lg-3 mkd-slide-element-all-but-custom"<?php if ($custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Keep in Line with Other Buttons?', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementbuttoninline_<?php echo esc_attr($no); ?>" name="slideelementbuttoninline[]" >
												<option value="no" <?php if (isset($slide_element['slideelementbuttoninline'])) {echo esc_attr($slide_element['slideelementbuttoninline']) == "no" ? "selected" : "";}  ?>><?php esc_html_e('No','buro'); ?></option>
												<option value="yes" <?php if (isset($slide_element['slideelementbuttoninline'])) {echo esc_attr($slide_element['slideelementbuttoninline']) == "yes" ? "selected" : "";} ?>><?php esc_html_e('Yes','buro'); ?></option>
											</select>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Size (px)', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementbuttonfontsize_<?php echo esc_attr($no); ?>" name="slideelementbuttonfontsize[]" value="<?php echo isset($slide_element['slideelementbuttonfontsize']) ? esc_attr($slide_element['slideelementbuttonfontsize']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Weight (px)', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element" id="slideelementbuttonfontweight_<?php echo esc_attr($no); ?>" name="slideelementbuttonfontweight[]" >
												<option value="" <?php if (isset($slide_element['slideelementbuttonfontweight'])) {echo esc_attr($slide_element['slideelementbuttonfontweight']) == "" ? "selected" : "";} ?>></option>
												<?php for ($i=1; $i<=9; $i++) { ?>
													<option value="<?php echo esc_attr($i*100); ?>" <?php if (isset($slide_element['slideelementbuttonfontweight'])) {echo (int)$slide_element['slideelementbuttonfontweight'] == $i*100 ? "selected" : "";} ?>><?php echo esc_html($i*100); ?></option>
												<?php } ?>
											</select>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonfontcolor_<?php esc_attr($no); ?>" name="slideelementbuttonfontcolor[]" value="<?php echo isset($slide_element['slideelementbuttonfontcolor']) ? esc_attr($slide_element['slideelementbuttonfontcolor']) : ''; ?>" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Font Hover Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonfonthovercolor_<?php esc_attr($no); ?>" name="slideelementbuttonfonthovercolor[]" value="<?php echo isset($slide_element['slideelementbuttonfonthovercolor']) ? esc_attr($slide_element['slideelementbuttonfonthovercolor']) : ''; ?>" class="my-color-field"/>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Background Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonbgndcolor_<?php esc_attr($no); ?>" name="slideelementbuttonbgndcolor[]" value="<?php echo isset($slide_element['slideelementbuttonbgndcolor']) ? esc_attr($slide_element['slideelementbuttonbgndcolor']) : ''; ?>" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Background Hover Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonbgndhovercolor_<?php esc_attr($no); ?>" name="slideelementbuttonbgndhovercolor[]" value="<?php echo isset($slide_element['slideelementbuttonbgndhovercolor']) ? esc_attr($slide_element['slideelementbuttonbgndhovercolor']) : ''; ?>" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonbordercolor_<?php esc_attr($no); ?>" name="slideelementbuttonbordercolor[]" value="<?php echo isset($slide_element['slideelementbuttonbordercolor']) ? esc_attr($slide_element['slideelementbuttonbordercolor']) : ''; ?>" class="my-color-field"/>
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Border Hover Color', 'buro') ?></em>
											<input type="text" id="slideelementbuttonborderhovercolor_<?php esc_attr($no); ?>" name="slideelementbuttonborderhovercolor[]" value="<?php echo isset($slide_element['slideelementbuttonborderhovercolor']) ? esc_attr($slide_element['slideelementbuttonborderhovercolor']) : ''; ?>" class="my-color-field"/>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Icon Pack', 'buro') ?></em>
											<select class="form-control mkd-input mkd-form-element mkd-slide-element-button-icon-pack"
													id="slideelementbuttoniconpack_<?php echo esc_attr($no); ?>"
													name="slideelementbuttoniconpack[]"
													>
												<?php
												$icon_packs = $buro_mikado_IconCollections->getIconCollectionsEmpty("no_icon");
												foreach ($icon_packs as $key=>$value) { ?>
													<option <?php if (isset($slide_element['slideelementbuttoniconpack']) && $slide_element['slideelementbuttoniconpack'] == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
													<?php
												}
												?>
											</select>
										</div>
										<?php
										foreach ($buro_mikado_IconCollections->iconCollections as $collection_key => $collection_object) {
											$icons_array = $collection_object->getIconsArray();
											?>
											<div class="col-lg-3 mkd-slide-element-button-icon-collection <?php echo esc_attr($collection_key); ?>"<?php if (!isset($slide_element['slideelementbuttoniconpack']) || $slide_element['slideelementbuttoniconpack'] != $collection_key) { ?> style="display: none"<?php } ?>>
												<em class="mkd-field-description"><?php esc_html_e('Button Icon', 'buro') ?></em>
												<select class="form-control mkd-input mkd-form-element"
														id="slideelementbuttonicon_<?php echo esc_attr($collection_key).'_'.esc_attr($no); ?>"
														name="slideelementbuttonicon_<?php echo esc_attr($collection_key); ?>[]"
														>
													<?php
													foreach ($icons_array as $key=>$value) { ?>
														<option <?php if (isset($slide_element['slideelementbuttonicon_'.$collection_key]) && $slide_element['slideelementbuttonicon_'.$collection_key] == $key) { echo "selected='selected'"; } ?>  value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
														<?php
													}
													?>
												</select>
											</div>
											<?php
										}
										?>
									</div>
								</div>

								<div class="mkd-slide-element-type-fields mkd-setf-section-link"<?php if ($slide_element['slideelementtype'] != "section-link") { ?> style="display: none"<?php } ?>>
									<!--
									<div class="row next-row mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
										<div class="col-lg-6">
											<em class="mkd-field-description"Relative position - Left (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinkleft_<?php esc_attr($no); ?>" name="slideelementsectionlinkleft[]" value="<?php echo isset($slide_element['slideelementsectionlinkleft']) ? esc_attr($slide_element['slideelementsectionlinkleft']) : ''; ?>" >
										</div>
										<div class="col-lg-6">
											<em class="mkd-field-description">Relative position - Top (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinktop_<?php esc_attr($no); ?>" name="slideelementsectionlinktop[]" value="<?php echo isset($slide_element['slideelementsectionlinktop']) ? esc_attr($slide_element['slideelementsectionlinktop']) : ''; ?>" >
										</div>
									</div>
									-->
									<div class="row next-row">
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Target Section Anchor (i.e. "#products")', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinkanchor_<?php esc_attr($no); ?>" name="slideelementsectionlinkanchor[]" value="<?php echo isset($slide_element['slideelementsectionlinkanchor']) ? esc_attr($slide_element['slideelementsectionlinkanchor']) : ''; ?>" >
										</div>
										<div class="col-lg-3">
											<em class="mkd-field-description"><?php esc_html_e('Anchor Link Text (i.e. "Scroll Down")', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementsectionlinktext_<?php esc_attr($no); ?>" name="slideelementsectionlinktext[]" value="<?php echo isset($slide_element['slideelementsectionlinktext']) ? esc_attr($slide_element['slideelementsectionlinktext']) : ''; ?>" >
										</div>
									</div>
								</div>

								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Animation', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element" id="slideelementanimation_<?php echo esc_attr($no); ?>" name="slideelementanimation[]" >
											<option value="default" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "default" ? "selected" : "";}  ?>><?php esc_html_e('Default','buro');?></option>
											<option value="none" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "none" ? "selected" : "";}  ?>><?php esc_html_e('No Animation', 'buro') ?></option>
											<option value="flip" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "flip" ? "selected" : "";}  ?>><?php esc_html_e('Flip', 'buro') ?></option>
											<option value="Spin" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "Spin" ? "selected" : "";}  ?>><?php esc_html_e('Spin', 'buro') ?></option>
											<option value="fade" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "fade" ? "selected" : "";}  ?>><?php esc_html_e('Fade In', 'buro') ?></option>
											<option value="from_bottom" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "from_bottom" ? "selected" : "";}  ?>><?php esc_html_e('Fly In From Bottom', 'buro') ?></option>
											<option value="from_top" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "from_top" ? "selected" : "";}  ?>><?php esc_html_e('Fly In From Top', 'buro') ?></option>
											<option value="from_left" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "from_left" ? "selected" : "";}  ?>><?php esc_html_e('Fly In From Left', 'buro') ?></option>
											<option value="from_right" <?php if (isset($slide_element['slideelementanimation'])) {echo esc_attr($slide_element['slideelementanimation']) == "from_right" ? "selected" : "";}  ?>><?php esc_html_e('Fly In From Right', 'buro') ?></option>
										</select>
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Animation Delay (i.e. "0.5s" or "400ms")', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementanimationdelay_<?php esc_attr($no); ?>" name="slideelementanimationdelay[]" value="<?php echo isset($slide_element['slideelementanimationdelay']) ? esc_attr($slide_element['slideelementanimationdelay']) : ''; ?>" >
									</div>
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Animation Duration (i.e. "0.5s" or "400ms")', 'buro') ?></em>
										<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementanimationduration_<?php esc_attr($no); ?>" name="slideelementanimationduration[]" value="<?php echo isset($slide_element['slideelementanimationduration']) ? esc_attr($slide_element['slideelementanimationduration']) : ''; ?>" >
									</div>
								</div>
								<div class="row next-row">
									<div class="col-lg-3">
										<em class="mkd-field-description"><?php esc_html_e('Element Responsiveness', 'buro') ?></em>
										<select class="form-control mkd-input mkd-form-element mkd-slide-element-responsiveness-selector" id="slideelementresponsive_<?php echo esc_attr($no); ?>" name="slideelementresponsive[]" >
											<option value="proportional" <?php if (isset($slide_element['slideelementresponsive'])) {echo esc_attr($slide_element['slideelementresponsive']) == "proportional" ? "selected" : "";}  ?>><?php esc_html_e('Preserve proportions','buro'); ?></option>
											<option value="stages" <?php if (isset($slide_element['slideelementresponsive'])) {echo esc_attr($slide_element['slideelementresponsive']) == "stages" ? "selected" : "";}  ?>><?php esc_html_e('Scale based on stage coefficients','buro'); ?></option>
										</select>
									</div>
								</div>
								<div class="mkd-slide-responsive-scale-factors"<?php if (isset($slide_element['slideelementresponsive']) && $slide_element['slideelementresponsive'] == 'proportional') { ?> style="display:none"<?php } ?>>
									<div class="row next-row">
										<div class="col-lg-12">
											<em class="mkd-field-description"><?php esc_html_e('Enter below the Scale Factors for each responsive stage, relative to the values above (or to the original size for images).<br/>Scale Factor of 1 leaves the element at the same size as for the default screen width of', 'buro') ?> <span class="mkd-slide-dynamic-def-width"><?php echo esc_html($default_screen_width); ?></span><?php esc_html_e('px, while setting it to zero hides the element.', 'buro') ?><div class="mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>><?php esc_html_e('If you also wish to change the position of the element for a certain stage, enter the desired position in the corresponding fields.', 'buro') ?></div></em>
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Mobile', 'buro') ?><br>(up to <?php echo esc_html($screen_widths["mobile"]); ?>px)</em>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscalemobile_<?php esc_attr($no); ?>" name="slideelementscalemobile[]" value="<?php echo isset($slide_element['slideelementscalemobile']) ? esc_attr($slide_element['slideelementscalemobile']) : ''; ?>" placeholder="0.5">
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftmobile_<?php esc_attr($no); ?>" name="slideelementleftmobile[]" value="<?php echo isset($slide_element['slideelementleftmobile']) ? esc_attr($slide_element['slideelementleftmobile']) : ''; ?>" >
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtopmobile_<?php esc_attr($no); ?>" name="slideelementtopmobile[]" value="<?php echo isset($slide_element['slideelementtopmobile']) ? esc_attr($slide_element['slideelementtopmobile']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Tablet (Portrait)', 'buro') ?><br>(<?php echo esc_html($screen_widths["mobile"]+1); ?>px - <?php echo esc_html($screen_widths["tabletp"]); ?>px)</em>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaletabletp_<?php esc_attr($no); ?>" name="slideelementscaletabletp[]" value="<?php echo isset($slide_element['slideelementscaletabletp']) ? esc_attr($slide_element['slideelementscaletabletp']) : ''; ?>" placeholder="0.6">
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlefttabletp_<?php esc_attr($no); ?>" name="slideelementlefttabletp[]" value="<?php echo isset($slide_element['slideelementlefttabletp']) ? esc_attr($slide_element['slideelementlefttabletp']) : ''; ?>" >
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoptabletp_<?php esc_attr($no); ?>" name="slideelementtoptabletp[]" value="<?php echo isset($slide_element['slideelementtoptabletp']) ? esc_attr($slide_element['slideelementtoptabletp']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Tablet (Landscape)', 'buro') ?><br>(<?php echo esc_html($screen_widths["tabletp"]+1); ?>px - <?php echo esc_html($screen_widths["tabletl"]); ?>px)</em>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaletabletl_<?php esc_attr($no); ?>" name="slideelementscaletabletl[]" value="<?php echo isset($slide_element['slideelementscaletabletl']) ? esc_attr($slide_element['slideelementscaletabletl']) : ''; ?>" placeholder="0.7">
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementlefttabletl_<?php esc_attr($no); ?>" name="slideelementlefttabletl[]" value="<?php echo isset($slide_element['slideelementlefttabletl']) ? esc_attr($slide_element['slideelementlefttabletl']) : ''; ?>" >
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoptabletl_<?php esc_attr($no); ?>" name="slideelementtoptabletl[]" value="<?php echo isset($slide_element['slideelementtoptabletl']) ? esc_attr($slide_element['slideelementtoptabletl']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Laptop', 'buro') ?><br>(<?php echo esc_html($screen_widths["tabletl"]+1); ?>px - <?php echo esc_html($screen_widths["laptop"]); ?>px)</em>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscalelaptop_<?php esc_attr($no); ?>" name="slideelementscalelaptop[]" value="<?php echo isset($slide_element['slideelementscalelaptop']) ? esc_attr($slide_element['slideelementscalelaptop']) : ''; ?>" placeholder="0.8">
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftlaptop_<?php esc_attr($no); ?>" name="slideelementleftlaptop[]" value="<?php echo isset($slide_element['slideelementleftlaptop']) ? esc_attr($slide_element['slideelementleftlaptop']) : ''; ?>" >
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtoplaptop_<?php esc_attr($no); ?>" name="slideelementtoplaptop[]" value="<?php echo isset($slide_element['slideelementtoplaptop']) ? esc_attr($slide_element['slideelementtoplaptop']) : ''; ?>" >
										</div>
									</div>
									<div class="row next-row">
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Desktop', 'buro') ?><br>(above <?php echo esc_html($screen_widths["laptop"]); ?>px)</em>
										</div>
										<div class="col-lg-2">
											<em class="mkd-field-description"><?php esc_html_e('Scale Factor', 'buro') ?></em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementscaledesktop_<?php esc_attr($no); ?>" name="slideelementscaledesktop[]" value="<?php echo isset($slide_element['slideelementscaledesktop']) ? esc_attr($slide_element['slideelementscaledesktop']) : ''; ?>" placeholder="1">
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Left', 'buro') ?> (X/C*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementleftdesktop_<?php esc_attr($no); ?>" name="slideelementleftdesktop[]" value="<?php echo isset($slide_element['slideelementleftdesktop']) ? esc_attr($slide_element['slideelementleftdesktop']) : ''; ?>" >
										</div>
										<div class="col-lg-3 mkd-slide-element-custom-only"<?php if (!$custom_positions) { ?> style="display:none"<?php } ?>>
											<em class="mkd-field-description"><?php esc_html_e('Relative position - Top', 'buro') ?> (Y/D*100)</em>
											<input type="text" class="form-control mkd-input mkd-form-element" id="slideelementtopdesktop_<?php esc_attr($no); ?>" name="slideelementtopdesktop[]" value="<?php echo isset($slide_element['slideelementtopdesktop']) ? esc_attr($slide_element['slideelementtopdesktop']) : ''; ?>" >
										</div>
									</div>
								</div>
							</div><!-- close div.mkd-section-content -->
						</div><!-- close div.container-fluid -->
					</div>
				</div>
			</div>
			<?php
			$no++;
		}
		?>

		<div class="mkd-slide-element-add">
			<a class="mkd-add-item btn btn-sm btn-primary" href="#"> <?php esc_html_e('Add New Item', 'buro') ?></a>


			<a class="mkd-toggle-all-item btn btn-sm btn-default pull-right" href="#"><?php esc_html_e('Expand All', 'buro') ?></a>
			<?php /* <a class="mkd-remove-last-item-row btn btn-sm btn-default pull-right" href="#"> Remove Last Row</a> */ ?>
		</div>




		<?php

	}
}


/*
   Class: BuroMikadoHolderFrameScheme
   A class that initializes elements for Slider
*/
class BuroMikadoHolderFrameScheme implements iBuroMikadoRender {
	private $label;
	private $description;


	function __construct($label="",$description="") {
		$this->label = $label;
		$this->description = $description;
	}

	public function render($factory) {
		?>

		<div class="mkd-slide-elements-holder-frame-scheme"><img src="<?php echo esc_url(MIKADO_ASSETS_ROOT . '/img/holder-frame-scheme.png'); ?>"></div>

		<?php

	}
}

class BuroMikadoRepeater implements iBuroMikadoRender
{
	private $label;
	private $description;
	private $name;
	private $fields;
	private $num_of_rows;
	private $button_text;

	function __construct($fields, $name, $label = '', $description = '', $button_text = '')
	{
		global $buro_mikado_Framework;

		$this->label = $label;
		$this->description = $description;
		$this->fields = $fields;
		$this->name = $name;
		$this->num_of_rows = 1;
		$this->button_text = !empty($button_text) ? $button_text : 'Add New Item';

		$counter = 0;
		foreach ($this->fields as $field) {
			if(!isset($this->fields[$counter]['options'])){
				$this->fields[$counter]['options'] = array();
			}
			if(!isset($this->fields[$counter]['args'])){
				$this->fields[$counter]['args'] = array();
			}
			if(!isset($this->fields[$counter]['hidden'])){
				$this->fields[$counter]['hidden'] = false;
			}
			if(!isset($this->fields[$counter]['label'])){
				$this->fields[$counter]['label'] = '';
			}
			if(!isset($this->fields[$counter]['description'])){
				$this->fields[$counter]['description'] = '';
			}
			if(!isset($this->fields[$counter]['default_value'])){
				$this->fields[$counter]['default_value'] = '';
			}

			$buro_mikado_Framework->mkdMetaBoxes->addOption($this->fields[$counter]['name'], $this->fields[$counter]['default_value']);
			$counter++;
		}
	}

	public function render($factory, $row_fields_num = -1)
	{
		global $post;

		$clones = array();

		if(!empty($post)){
			$clones = get_post_meta($post->ID, $this->fields[0]['name'], true);
		}

		?>
		<div class="mkd-repeater-wrapper">
			<div class="mkd-repeater-fields-holder clearfix">
				<?php if (empty($clones)) { //first time
					if ($row_fields_num === -1) {
						?>
						<div class="mkd-repeater-fields-row">
						<?php
					}
					$counter = 0;
					foreach ($this->fields as $field) {
						if ($row_fields_num !== -1 && $counter % $row_fields_num === 0) { ?>
							<div class="mkd-repeater-fields-row">
							<?php
						}
						$factory->render($field['type'], $field['name'], $field['label'], $field['description'], $field['options'], $field['args'], $field['hidden'], array('index' => 0, 'value' => $field['default_value']));
						$counter++;
						if ($row_fields_num !== -1 && $counter % $row_fields_num === 0) { ?>
							<div class="mkd-repeater-remove"><a class="mkd-clone-remove" href="#"><i class="fa fa-times"></i></a></div>
							</div>
							<?php
						}
					}
					if ($row_fields_num === -1) {
						?>
						<div class="mkd-repeater-remove"><a class="mkd-clone-remove" href="#"><i class="fa fa-times"></i></a></div>
						</div>
						<?php
					}
				} else {
					$j = 0;
					$index = 0;
					$values = array();
					foreach ($this->fields as $field) {
						if ($j++ === 0) { // avoid unnecessary get_post_meta call
							$values[] = $clones;
						} else {
							$values[] = get_post_meta($post->ID, $field['name'], true);
						}
					}
					while (isset($clones[$index])) { // rows
						$count = 0;
						if ($row_fields_num === -1) {
							?>
							<div class="mkd-repeater-fields-row ">
							<?php
						}
						foreach ($this->fields as $field) { // columns
							if ($row_fields_num !== -1 && $count % $row_fields_num === 0) { ?>
								<div class="mkd-repeater-fields-row">
								<?php
							}

							$factory->render($field['type'], $field['name'], $field['label'], $field['description'], $field['options'], $field['args'], $field['hidden'], array('index' => $index, 'value' => $values[$count][$index]));
							if ($row_fields_num !== -1 && $count % $row_fields_num === 0) { ?>
								<div class="mkd-repeater-remove"><a class="mkd-clone-remove" href="#"><i
											class="fa fa-times"></i></a></div>
								</div>
								<?php
							}
							$count++;
						}
						if ($row_fields_num === -1) {
							?>
							<div class="mkd-repeater-remove">
								<a title="<?php esc_attr_e('Remove section', 'buro'); ?>" class="mkd-clone-remove" href="#">
									<i class="fa fa-times"></i>
								</a>
							</div>
							</div>
							<?php
						}
						++$index;
					}
					$this->num_of_rows = $index;
				}
				?>
			</div>
			<div class="mkd-repeater-add">
				<a class="mkd-clone btn btn-sm btn-primary"
				   data-count="<?php echo esc_attr($this->num_of_rows) ?>"
				   href="#"><?php echo esc_html($this->button_text); ?></a>
			</div>
		</div>


		<?php

	}
}
