<?php

if ( ! function_exists('buro_mikado_blog_options_map') ) {

	function buro_mikado_blog_options_map() {

		buro_mikado_add_admin_page(
			array(
				'slug' => '_blog_page',
				'title' => esc_html__('Blog','buro'),
				'icon' => 'fa fa-files-o'
			)
		);

		/**
		 * Blog Lists
		 */

		$custom_sidebars = buro_mikado_get_custom_sidebars();

		$panel_blog_lists = buro_mikado_add_admin_panel(
			array(
				'page' => '_blog_page',
				'name' => 'panel_blog_lists',
				'title' => esc_html__('Blog Lists','buro')
			)
		);

		buro_mikado_add_admin_field(array(
			'name'        => 'blog_list_type',
			'type'        => 'select',
			'label'       => esc_html__('Blog Layout for Archive Pages','buro'),
			'description' => esc_html__('Choose a default blog layout','buro'),
			'default_value' => 'standard',
			'parent'      => $panel_blog_lists,
			'options'     => array(
				'standard'				=> esc_html__('Blog: Standard Layout','buro'),
				'masonry' 				=> esc_html__('Blog: Masonry Layout','buro'),
				'masonry-full-width' 	=> esc_html__('Blog: Masonry Full Width Layout','buro'),
				'standard-whole-post' 	=> esc_html__('Blog: Standard Whole Post Layout','buro')
			)
		));

		buro_mikado_add_admin_field(array(
			'name'        => 'archive_sidebar_layout',
			'type'        => 'select',
			'label'       => esc_html__('Archive and Category Sidebar','buro'),
			'description' => esc_html__('Choose a sidebar layout for archived Blog Post Lists and Category Blog Lists','buro'),
			'parent'      => $panel_blog_lists,
			'options'     => array(
				'default'			=> esc_html__('No Sidebar','buro'),
				'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right','buro'),
				'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right','buro'),
				'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left','buro'),
				'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left','buro')
			)
		));


		if(count($custom_sidebars) > 0) {
			buro_mikado_add_admin_field(array(
				'name' => 'blog_custom_sidebar',
				'type' => 'selectblank',
				'label' => esc_html__('Sidebar to Display','buro'),
				'description' => esc_html__('Choose a sidebar to display on Blog Post Lists and Category Blog Lists. Default sidebar is "Sidebar Page"','buro'),
				'parent' => $panel_blog_lists,
				'options' => buro_mikado_get_custom_sidebars()
			));
		}

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'pagination',
				'default_value' => 'yes',
				'label' => esc_html__('Pagination','buro'),
				'parent' => $panel_blog_lists,
				'description' => esc_html__('Enabling this option will display pagination links on bottom of Blog Post List','buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_mkd_pagination_container'
				)
			)
		);

		$pagination_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_pagination_container',
				'hidden_property' => 'pagination',
				'hidden_value' => 'no',
				'parent' => $panel_blog_lists,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'parent' => $pagination_container,
				'type' => 'text',
				'name' => 'blog_page_range',
				'default_value' => '',
				'label' => esc_html__('Pagination Range limit','buro'),
				'description' => esc_html__('Enter a number that will limit pagination to a certain range of links','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);

		buro_mikado_add_admin_field(array(
			'name'        => 'masonry_pagination',
			'type'        => 'select',
			'label'       => esc_html__('Pagination on Masonry','buro'),
			'description' => esc_html__('Choose a pagination style for Masonry Blog List','buro'),
			'parent'      => $pagination_container,
			'options'     => array(
				'standard'			=> esc_html__('Standard','buro'),
				'load-more'			=> esc_html__('Load More','buro'),
				'infinite-scroll' 	=> esc_html__('Infinite Scroll','buro'),
			),
			
		));
		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'enable_load_more_pag',
				'default_value' => 'no',
				'label' => esc_html__('Load More Pagination on Other Lists','buro'),
				'parent' => $pagination_container,
				'description' => esc_html__('Enable Load More Pagination on other lists','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'masonry_filter',
				'default_value' => 'no',
				'label' => esc_html__('Masonry Filter','buro'),
				'parent' => $panel_blog_lists,
				'description' => esc_html__('Enabling this option will display category filter on Masonry and Masonry Full Width Templates','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);		
		buro_mikado_add_admin_field(
			array(
				'type' => 'text',
				'name' => 'number_of_chars',
				'default_value' => '',
				'label' => esc_html__('Number of Words in Excerpt','buro'),
				'parent' => $panel_blog_lists,
				'description' => esc_html__('Enter a number of words in excerpt (article summary)','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);
		buro_mikado_add_admin_field(
			array(
				'type' => 'text',
				'name' => 'standard_number_of_chars',
				'default_value' => '',
				'label' => esc_html__('Standard Type Number of Words in Excerpt','buro'),
				'parent' => $panel_blog_lists,
				'description' => esc_html__('Enter a number of words in excerpt (article summary)','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);
		buro_mikado_add_admin_field(
			array(
				'type' => 'text',
				'name' => 'masonry_number_of_chars',
				'default_value' => '',
				'label' => esc_html__('Masonry Type Number of Words in Excerpt','buro'),
				'parent' => $panel_blog_lists,
				'description' => esc_html__('Enter a number of words in excerpt (article summary)','buro'),
				'args' => array(
					'col_width' => 3
				)
			)
		);

		/**
		 * Blog Single
		 */
		$panel_blog_single = buro_mikado_add_admin_panel(
			array(
				'page' => '_blog_page',
				'name' => 'panel_blog_single',
				'title' => esc_html__('Blog Single','buro'),
			)
		);


		buro_mikado_add_admin_field(array(
			'name'        => 'blog_single_sidebar_layout',
			'type'        => 'select',
			'label'       => esc_html__('Sidebar Layout','buro'),
			'description' => esc_html__('Choose a sidebar layout for Blog Single pages','buro'),
			'parent'      => $panel_blog_single,
			'options'     => array(
				'default'			=> esc_html__('No Sidebar','buro'),
				'sidebar-33-right'	=> esc_html__('Sidebar 1/3 Right','buro'),
				'sidebar-25-right' 	=> esc_html__('Sidebar 1/4 Right','buro'),
				'sidebar-33-left' 	=> esc_html__('Sidebar 1/3 Left','buro'),
				'sidebar-25-left' 	=> esc_html__('Sidebar 1/4 Left','buro')
			),
			'default_value'	=> 'default'
		));


		if(count($custom_sidebars) > 0) {
			buro_mikado_add_admin_field(array(
				'name' => 'blog_single_custom_sidebar',
				'type' => 'selectblank',
				'label' => esc_html__('Sidebar to Display','buro'),
				'description' => esc_html__('Choose a sidebar to display on Blog Single pages. Default sidebar is "Sidebar"','buro'),
				'parent' => $panel_blog_single,
				'options' => buro_mikado_get_custom_sidebars()
			));
		}

        buro_mikado_add_admin_field(
            array(
                'name'          => 'blog_single_title_in_title_area',
                'type'          => 'yesno',
                'label'         => esc_html__( 'Show Post Title in Title Area', 'buro'),
                'description'   => esc_html__( 'Enabling this option will show post title in title area on single post pages', 'buro'),
                'parent'        => $panel_blog_single,
                'default_value' => 'no'
            )
        );

		buro_mikado_add_admin_field(array(
			'name'			=> 'blog_single_related_posts',
			'type'			=> 'yesno',
			'label'			=> esc_html__('Show Related Posts','buro'),
			'description'   => esc_html__('Enabling this option will show related posts on your single post.','buro'),
			'parent'        => $panel_blog_single,
			'default_value' => 'no'
		));

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'blog_single_navigation',
				'default_value' => 'no',
				'label' => esc_html__('Enable Prev/Next Single Post Navigation Links','buro'),
				'parent' => $panel_blog_single,
				'description' => esc_html__('Enable navigation links through the blog posts (left and right arrows will appear)','buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_mkd_blog_single_navigation_container'
				)
			)
		);

		$blog_single_navigation_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_blog_single_navigation_container',
				'hidden_property' => 'blog_single_navigation',
				'hidden_value' => 'no',
				'parent' => $panel_blog_single,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type'        => 'yesno',
				'name' => 'blog_navigation_through_same_category',
				'default_value' => 'no',
				'label'       => esc_html__('Enable Navigation Only in Current Category','buro'),
				'description' => esc_html__('Limit your navigation only through current category','buro'),
				'parent'      => $blog_single_navigation_container,
				'args' => array(
					'col_width' => 3
				)
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'blog_author_info',
				'default_value' => 'no',
				'label' => esc_html__('Show Author Info Box','buro'),
				'parent' => $panel_blog_single,
				'description' => esc_html__('Enabling this option will display author name and descriptions on Blog Single pages','buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_mkd_blog_single_author_info_container'
				)
			)
		);

		$blog_single_author_info_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_blog_single_author_info_container',
				'hidden_property' => 'blog_author_info',
				'hidden_value' => 'no',
				'parent' => $panel_blog_single,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type'        => 'yesno',
				'name' => 'blog_author_info_email',
				'default_value' => 'no',
				'label'       => esc_html__('Show Author Email','buro'),
				'description' => esc_html__('Enabling this option will show author email','buro'),
				'parent'      => $blog_single_author_info_container,
				'args' => array(
					'col_width' => 3
				)
			)
		);

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_blog_options_map', 12);

}











