<?php

if ( ! function_exists('buro_mikado_footer_options_map') ) {
	/**
	 * Add footer options
	 */
	function buro_mikado_footer_options_map() {

		buro_mikado_add_admin_page(
			array(
				'slug' => '_footer_page',
				'title' => esc_html__('Footer', 'buro'),
				'icon' => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = buro_mikado_add_admin_panel(
			array(
				'title' => esc_html__('Footer', 'buro'),
				'name' => 'footer',
				'page' => '_footer_page'
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'uncovering_footer',
				'default_value' => 'no',
				'label' => esc_html__('Uncovering Footer', 'buro'),
				'description' => esc_html__('Enabling this option will make Footer gradually appear on scroll', 'buro'),
				'parent' => $footer_panel,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'footer_in_grid',
				'default_value' => 'yes',
				'label' => esc_html__('Footer in Grid', 'buro'),
				'description' => esc_html__('Enabling this option will place Footer content in grid', 'buro'),
				'parent' => $footer_panel,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'show_footer_top',
				'default_value' => 'yes',
				'label' => esc_html__('Show Footer Top', 'buro'),
				'description' => esc_html__('Enabling this option will show Footer Top area', 'buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_show_footer_top_container'
				),
				'parent' => $footer_panel,
			)
		);

		$show_footer_top_container = buro_mikado_add_admin_container(
			array(
				'name' => 'show_footer_top_container',
				'hidden_property' => 'show_footer_top',
				'hidden_value' => 'no',
				'parent' => $footer_panel
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'select',
				'name' => 'footer_top_columns',
				'default_value' => '4',
				'label' => esc_html__('Footer Top Columns', 'buro'),
				'description' => esc_html__('Choose number of columns for Footer Top area', 'buro'),
				'options' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'5' => '3(25%+25%+50%)',
					'6' => '3(50%+25%+25%)',
					'4' => '4'
				),
				'parent' => $show_footer_top_container,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type' => 'select',
				'name' => 'footer_top_columns_alignment',
				'default_value' => '',
				'label' => esc_html__('Footer Top Columns Alignment', 'buro'),
				'description' => esc_html__('Text Alignment in Footer Columns', 'buro'),
				'options' => array(
					'left' => esc_html__('Left', 'buro'),
					'center' => esc_html__('Center', 'buro'),
					'right' => esc_html__('Right', 'buro'),
				),
				'parent' => $show_footer_top_container,
			)
		);

        buro_mikado_add_admin_field(
            array(
                'parent' => $show_footer_top_container,
                'type' => 'color',
                'name' => 'footer_top_background_color',
                'default_value' => '',
                'label' => esc_html__('Background color', 'buro'),
                'description' => esc_html__('Set background color for footer top', 'buro'),
            )
        );

        buro_mikado_add_admin_field(
            array(
                'type' => 'select',
                'name' => 'footer_top_skin',
                'default_value' => 'light',
                'label' => esc_html__('Footer Top Skin', 'buro'),
                'description' => esc_html__('Choose footer top skin', 'buro'),
                'options' => array(
                    'light' => esc_html__('Light', 'buro'),
                    'dark' => esc_html__('Dark', 'buro'),
                ),
                'parent' => $show_footer_top_container,
            )
        );

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'show_footer_bottom',
				'default_value' => 'yes',
				'label' => esc_html__('Show Footer Bottom', 'buro'),
				'description' => esc_html__('Enabling this option will show Footer Bottom area', 'buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_show_footer_bottom_container'
				),
				'parent' => $footer_panel,
			)
		);

		$show_footer_bottom_container = buro_mikado_add_admin_container(
			array(
				'name' => 'show_footer_bottom_container',
				'hidden_property' => 'show_footer_bottom',
				'hidden_value' => 'no',
				'parent' => $footer_panel
			)
		);

        buro_mikado_add_admin_field(
            array(
                'parent' => $show_footer_bottom_container,
                'type' => 'color',
                'name' => 'footer_bottom_background_color',
                'default_value' => '',
                'label' => esc_html__('Background color', 'buro'),
                'description' => esc_html__('Set background color for footer bottom', 'buro'),
            )
        );

		buro_mikado_add_admin_field(
			array(
				'type' => 'select',
				'name' => 'footer_bottom_skin',
				'default_value' => 'light',
				'label' => esc_html__('Footer Bottom Skin', 'buro'),
				'description' => esc_html__('Choose footer bottom skin', 'buro'),
				'options' => array(
                    'light' => esc_html__('Light', 'buro'),
                    'dark' => esc_html__('Dark', 'buro'),
				),
				'parent' => $show_footer_bottom_container,
			)
		);

        buro_mikado_add_admin_field(
            array(
                'type' => 'select',
                'name' => 'footer_bottom_columns',
                'default_value' => '3',
                'label' => esc_html__('Footer Bottom Columns', 'buro'),
                'description' => esc_html__('Choose number of columns for Footer Bottom area', 'buro'),
                'options' => array(
                    '1' => '1',
                    '2' => '2',
                    '3' => '3'
                ),
                'parent' => $show_footer_bottom_container,
            )
        );

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_footer_options_map', 10);

}