<?php

if (!function_exists('buro_mikado_register_footer_sidebar')) {

	function buro_mikado_register_footer_sidebar() {

		register_sidebar(array(
			'name' => 'Footer Column 1',
			'id' => 'footer_column_1',
			'description' => 'Footer Column 1',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-column-1 %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Column 2',
			'id' => 'footer_column_2',
			'description' => 'Footer Column 2',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-column-2 %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Column 3',
			'id' => 'footer_column_3',
			'description' => 'Footer Column 3',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-column-3 %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Column 4',
			'id' => 'footer_column_4',
			'description' => 'Footer Column 4',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-column-4 %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Bottom',
			'id' => 'footer_text',
			'description' => 'Footer Bottom',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-text %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Bottom Left',
			'id' => 'footer_bottom_left',
			'description' => 'Footer Bottom Left',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-bottom-left %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

		register_sidebar(array(
			'name' => 'Footer Bottom Right',
			'id' => 'footer_bottom_right',
			'description' => 'Footer Bottom Right',
			'before_widget' => '<div id="%1$s" class="widget mkd-footer-bottom-left %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h5 class="mkd-footer-widget-title">',
			'after_title' => '</h5>'
		));

	}

	add_action('widgets_init', 'buro_mikado_register_footer_sidebar');

}

if (!function_exists('buro_mikado_get_footer')) {
	/**
	 * Loads footer HTML
	 */
	function buro_mikado_get_footer() {

        $id = buro_mikado_get_page_id();

		$parameters = array();
		$id = buro_mikado_get_page_id();
		$parameters['footer_classes'] = buro_mikado_get_footer_classes($id);
		$parameters['display_footer_top'] = (buro_mikado_get_meta_field_intersect('show_footer_top') == 'yes') ? true : false;
		$parameters['display_footer_bottom'] = (buro_mikado_get_meta_field_intersect('show_footer_bottom') == 'yes') ? true : false;

		buro_mikado_get_module_template_part('templates/footer', 'footer', '', $parameters);

	}

}

if (!function_exists('buro_mikado_get_content_bottom_area')) {
	/**
	 * Loads content bottom area HTML with all needed parameters
	 */
	function buro_mikado_get_content_bottom_area() {

		$parameters = array();

		//Current page id
		$id = buro_mikado_get_page_id();

		//is content bottom area enabled for current page?
		$parameters['content_bottom_area'] = buro_mikado_get_meta_field_intersect('enable_content_bottom_area');
		if ($parameters['content_bottom_area'] == 'yes') {
			//Sidebar for content bottom area
			$parameters['content_bottom_area_sidebar'] = buro_mikado_get_meta_field_intersect('content_bottom_sidebar_custom_display');
			//Content bottom area in grid
			$parameters['content_bottom_area_in_grid'] = buro_mikado_get_meta_field_intersect('content_bottom_in_grid');
			//Content bottom area background color
			$parameters['content_bottom_background_color'] = 'background-color: '.buro_mikado_get_meta_field_intersect('content_bottom_background_color');
		}

		buro_mikado_get_module_template_part('templates/parts/content-bottom-area', 'footer', '', $parameters);

	}

}

if (!function_exists('buro_mikado_get_footer_top')) {
	/**
	 * Return footer top HTML
	 */
	function buro_mikado_get_footer_top() {

		$parameters = array();

		$parameters['footer_top_border'] = buro_mikado_get_footer_top_border();
        $parameters['footer_top_background'] = buro_mikado_get_footer_top_background();
		$parameters['footer_top_border_in_grid'] = (buro_mikado_options()->getOptionValue('footer_top_border_in_grid') == 'yes') ? 'mkd-in-grid' : '';
		$parameters['footer_in_grid'] = (buro_mikado_options()->getOptionValue('footer_in_grid') == 'yes') ? true : false;
		$parameters['footer_top_classes'] = buro_mikado_footer_top_classes();
		$parameters['footer_top_columns'] = buro_mikado_options()->getOptionValue('footer_top_columns');

		buro_mikado_get_module_template_part('templates/parts/footer-top', 'footer', '', $parameters);

	}
//    buro_mikado_get_meta_field_intersect('title_area_text_size', $id)
}



if (!function_exists('buro_mikado_get_footer_bottom')) {
	/**
	 * Return footer bottom HTML
	 */
	function buro_mikado_get_footer_bottom() {

		$parameters = array();

		$parameters['footer_bottom_border'] = buro_mikado_get_footer_bottom_border();
		$parameters['footer_bottom_border_in_grid'] = (buro_mikado_options()->getOptionValue('footer_bottom_border_in_grid') == 'yes') ? 'mkd-in-grid' : '';
		$parameters['footer_in_grid'] = (buro_mikado_options()->getOptionValue('footer_in_grid') == 'yes') ? true : false;
		$parameters['footer_bottom_columns'] = buro_mikado_options()->getOptionValue('footer_bottom_columns');
		$parameters['footer_bottom_border_bottom'] = buro_mikado_get_footer_bottom_bottom_border();
        $parameters['footer_bottom_classes'] = buro_mikado_footer_bottom_classes();
        $parameters['footer_bottom_background'] = buro_mikado_get_footer_bottom_background();

		buro_mikado_get_module_template_part('templates/parts/footer-bottom', 'footer', '', $parameters);

	}

}

//Functions for custom widgets options in Footer Columns 1,2,3,4

if(!function_exists('buro_mikado_get_footer_1_widget')) {

    function buro_mikado_get_footer_1_widget() {
        $id = buro_mikado_get_page_id();
//        $params = array();

        $widget_area = get_post_meta($id, 'mkd_custom_footer_col_1_widget_meta', true);

        if ($widget_area == ''){
            $widget_area = 'footer_column_1';
        }

       return $widget_area;

    }
}

if(!function_exists('buro_mikado_get_footer_2_widget')) {

    function buro_mikado_get_footer_2_widget() {
        $id = buro_mikado_get_page_id();
//        $params = array();

        $widget_area = get_post_meta($id, 'mkd_custom_footer_col_2_widget_meta', true);

        if ($widget_area == ''){
            $widget_area = 'footer_column_2';
        }

        return $widget_area;

    }
}

if(!function_exists('buro_mikado_get_footer_3_widget')) {

    function buro_mikado_get_footer_3_widget() {
        $id = buro_mikado_get_page_id();
//        $params = array();

        $widget_area = get_post_meta($id, 'mkd_custom_footer_col_3_widget_meta', true);

        if ($widget_area == ''){
            $widget_area = 'footer_column_3';
        }

        return $widget_area;

    }
}

if(!function_exists('buro_mikado_get_footer_4_widget')) {

    function buro_mikado_get_footer_4_widget() {
        $id = buro_mikado_get_page_id();
//        $params = array();

        $widget_area = get_post_meta($id, 'mkd_custom_footer_col_4_widget_meta', true);
        $widget_area_container = get_post_meta($id, 'mkd_enable_custom_footer_col_4_widget_meta', true);

        if ($widget_area == '' || $widget_area_container == 'no'){
            $widget_area = 'footer_column_4';
        }

        return $widget_area;

    }
}

//Functions for loading sidebars

if (!function_exists('buro_mikado_get_footer_sidebar_25_25_50')) {

	function buro_mikado_get_footer_sidebar_25_25_50() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-three-columns-25-25-50', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_sidebar_50_25_25')) {

	function buro_mikado_get_footer_sidebar_50_25_25() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-three-columns-50-25-25', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_sidebar_four_columns')) {

	function buro_mikado_get_footer_sidebar_four_columns() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-four-columns', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_sidebar_three_columns')) {

	function buro_mikado_get_footer_sidebar_three_columns() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-three-columns', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_sidebar_two_columns')) {

	function buro_mikado_get_footer_sidebar_two_columns() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-two-columns', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_sidebar_one_column')) {

	function buro_mikado_get_footer_sidebar_one_column() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-one-column', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_bottom_sidebar_three_columns')) {

	function buro_mikado_get_footer_bottom_sidebar_three_columns() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-bottom-three-columns', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_bottom_sidebar_two_columns')) {

	function buro_mikado_get_footer_bottom_sidebar_two_columns() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-bottom-two-columns', 'footer');
	}

}

if (!function_exists('buro_mikado_get_footer_bottom_sidebar_one_column')) {

	function buro_mikado_get_footer_bottom_sidebar_one_column() {
		buro_mikado_get_module_template_part('templates/sidebars/sidebar-bottom-one-column', 'footer');
	}

}

