<?php

if(!function_exists('buro_mikado_register_full_screen_menu_nav')) {
    function buro_mikado_register_full_screen_menu_nav() {
	    register_nav_menus(
		    array(
			    'popup-navigation' => esc_html__('Fullscreen Navigation', 'buro')
		    )
	    );
    }

	add_action('after_setup_theme', 'buro_mikado_register_full_screen_menu_nav');
}

if ( !function_exists('buro_mikado_register_full_screen_menu_sidebars') ) {

	function buro_mikado_register_full_screen_menu_sidebars() {

		register_sidebar(array(
			'name' => 'Fullscreen Menu Top',
			'id' => 'fullscreen_menu_above',
			'description' => 'This widget area is rendered above fullscreen menu',
			'before_widget' => '<div class="%2$s mkd-fullscreen-menu-above-widget">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="mkd-fullscreen-widget-title">',
			'after_title' => '</h4>'
		));

		register_sidebar(array(
			'name' => 'Fullscreen Menu Bottom',
			'id' => 'fullscreen_menu_below',
			'description' => 'This widget area is rendered in the bottom of the fullscreen menu',
			'before_widget' => '<div class="%2$s mkd-fullscreen-menu-below-widget">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="mkd-fullscreen-widget-title">',
			'after_title' => '</h4>'
		));

	}

	add_action('widgets_init', 'buro_mikado_register_full_screen_menu_sidebars');

}

if(!function_exists('buro_mikado_fullscreen_menu_body_class')) {
	/**
	 * Function that adds body classes for different full screen menu types
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function buro_mikado_fullscreen_menu_body_class($classes) {

		if ( buro_mikado_get_meta_field_intersect('header_type', buro_mikado_get_page_id()) == 'header-full-screen'  ) {

			$classes[] = 'mkd-' . buro_mikado_options()->getOptionValue('fullscreen_menu_animation_style');

		}

		return $classes;
	}

	add_filter('body_class', 'buro_mikado_fullscreen_menu_body_class');
}

if ( !function_exists('buro_mikado_get_full_screen_menu') ) {
	/**
	 * Loads fullscreen menu HTML template
	 */
	function buro_mikado_get_full_screen_menu() {

		if ( buro_mikado_get_meta_field_intersect('header_type', buro_mikado_get_page_id()) == 'header-full-screen'  ) {

			$parameters = array(
				'fullscreen_menu_in_grid' => buro_mikado_options()->getOptionValue('fullscreen_in_grid') === 'yes' ? true : false
			);

			buro_mikado_get_module_template_part('templates/fullscreen-menu', 'fullscreenmenu', '', $parameters);

		}

	}

}

if ( !function_exists('buro_mikado_get_full_screen_menu_navigation') ) {
	/**
	 * Loads fullscreen menu navigation HTML template
	 */
	function buro_mikado_get_full_screen_menu_navigation() {

		buro_mikado_get_module_template_part('templates/parts/navigation', 'fullscreenmenu');

	}

}