<?php

if(!function_exists('buro_mikado_header_top_bar_styles')) {
    /**
     * Generates styles for header top bar
     */
    function buro_mikado_header_top_bar_styles() {
        global $buro_mikado_options;

        if($buro_mikado_options['top_bar_height'] !== '') {
            echo buro_mikado_dynamic_css('.mkd-top-bar', array('height' => $buro_mikado_options['top_bar_height'].'px'));
            echo buro_mikado_dynamic_css('.mkd-top-bar .mkd-logo-wrapper a', array('max-height' => $buro_mikado_options['top_bar_height'].'px'));
        }

        if($buro_mikado_options['top_bar_in_grid'] == 'yes') {
            $top_bar_grid_selector = '.mkd-top-bar .mkd-grid .mkd-vertical-align-containers';
            $top_bar_grid_styles = array();
            if($buro_mikado_options['top_bar_grid_background_color'] !== '') {
                $grid_background_color    = $buro_mikado_options['top_bar_grid_background_color'];
                $grid_background_transparency = 1;

                if(buro_mikado_options()->getOptionValue('top_bar_grid_background_transparency')) {
                    $grid_background_transparency = buro_mikado_options()->getOptionValue('top_bar_grid_background_transparency');
                }

                $grid_background_color = buro_mikado_rgba_color($grid_background_color, $grid_background_transparency);
                $top_bar_grid_styles['background-color'] = $grid_background_color;
            }

            echo buro_mikado_dynamic_css($top_bar_grid_selector, $top_bar_grid_styles);
        }

        $background_color = buro_mikado_options()->getOptionValue('top_bar_background_color');
        $top_bar_styles = array();
        if($background_color !== '') {
            $background_transparency = 1;
            if(buro_mikado_options()->getOptionValue('top_bar_background_transparency') !== '') {
               $background_transparency = buro_mikado_options()->getOptionValue('top_bar_background_transparency');
            }

            $background_color = buro_mikado_rgba_color($background_color, $background_transparency);
            $top_bar_styles['background-color'] = $background_color;
        }

        echo buro_mikado_dynamic_css('.mkd-top-bar', $top_bar_styles);

    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_header_top_bar_styles');
}


if (!function_exists('buro_mikado_header_top_bar_responsive_styles')){
	/**
     * Generates styles for header top bar on responsive
     */
	function buro_mikado_header_top_bar_responsive_styles(){
		$top_bar_responsive_styles = array();

        $hide_top_bar_on_responsive = buro_mikado_options()->getOptionValue('hide_top_bar_on_responsive');

        if($hide_top_bar_on_responsive === 'yes') { 
        	$top_bar_responsive_styles['height'] = '0';
        	$top_bar_responsive_styles['display'] = 'none';
        }

        echo buro_mikado_dynamic_css('.mkd-top-bar', $top_bar_responsive_styles);

	}

	add_action('buro_mikado_style_dynamic_responsive_1024', 'buro_mikado_header_top_bar_responsive_styles');
}

if(!function_exists('buro_mikado_header_standard_menu_area_styles')) {
    /**
     * Generates styles for header standard menu
     */
    function buro_mikado_header_standard_menu_area_styles() {
        global $buro_mikado_options;

        $menu_area_header_standard_styles = array();

        if($buro_mikado_options['menu_area_background_color_header_standard'] !== '') {
            $menu_area_background_color        = $buro_mikado_options['menu_area_background_color_header_standard'];
            $menu_area_background_transparency = 1;

            if($buro_mikado_options['menu_area_background_transparency_header_standard'] !== '') {
                $menu_area_background_transparency = $buro_mikado_options['menu_area_background_transparency_header_standard'];
            }

            $menu_area_header_standard_styles['background-color'] = buro_mikado_rgba_color($menu_area_background_color, $menu_area_background_transparency);
        }

        if($buro_mikado_options['menu_area_height_header_standard'] !== '') {
            $max_height = intval(buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_standard']) * 0.9).'px';
            echo buro_mikado_dynamic_css('.mkd-header-standard .mkd-page-header .mkd-logo-wrapper a', array('max-height' => $max_height));

            $menu_area_header_standard_styles['height'] = buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_standard']).'px';

        }

        echo buro_mikado_dynamic_css('.mkd-header-standard .mkd-page-header .mkd-menu-area', $menu_area_header_standard_styles);

    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_header_standard_menu_area_styles');
}

if(!function_exists('buro_mikado_header_centered_menu_area_styles')) {
    /**
     * Generates styles for header centered menu
     */
    function buro_mikado_header_centered_menu_area_styles() {
        global $buro_mikado_options;

        $menu_area_header_centered_styles = array();

        if($buro_mikado_options['menu_area_background_color_header_centered'] !== '') {
            $menu_area_background_color        = $buro_mikado_options['menu_area_background_color_header_centered'];
            $menu_area_background_transparency = 1;

            if($buro_mikado_options['menu_area_background_transparency_header_centered'] !== '') {
                $menu_area_background_transparency = $buro_mikado_options['menu_area_background_transparency_header_centered'];
            }

            $menu_area_header_centered_styles['background-color'] = buro_mikado_rgba_color($menu_area_background_color, $menu_area_background_transparency);
        }

        if($buro_mikado_options['menu_area_height_header_centered'] !== '') {
            $max_height = intval(buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_centered']) * 0.9).'px';
            echo buro_mikado_dynamic_css('.mkd-header-centered .mkd-page-header .mkd-logo-wrapper a', array('max-height' => $max_height));

            $menu_area_header_centered_styles['height'] = buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_centered']).'px';

        }

        echo buro_mikado_dynamic_css('.mkd-header-centered .mkd-page-header .mkd-menu-area', $menu_area_header_centered_styles);

    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_header_centered_menu_area_styles');
}

if(!function_exists('buro_mikado_vertical_menu_styles')) {
    /**
     * Generates styles for sticky haeder
     */
    function buro_mikado_vertical_menu_styles() {

        $vertical_header_styles = array();

        $vertical_header_selectors = array(
            '.mkd-header-vertical .mkd-vertical-area-background'
        );

        if(buro_mikado_options()->getOptionValue('vertical_header_background_color') !== '') {
            $vertical_header_styles['background-color'] = buro_mikado_options()->getOptionValue('vertical_header_background_color');
        }

        if(buro_mikado_options()->getOptionValue('vertical_header_transparency') !== '') {
            $vertical_header_styles['opacity'] = buro_mikado_options()->getOptionValue('vertical_header_transparency');
        }

        if(buro_mikado_options()->getOptionValue('vertical_header_background_image') !== '') {
            $vertical_header_styles['background-image'] = 'url('.buro_mikado_options()->getOptionValue('vertical_header_background_image').')';
        }


        echo buro_mikado_dynamic_css($vertical_header_selectors, $vertical_header_styles);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_vertical_menu_styles');
}

if(!function_exists('buro_mikado_header_full_screen_menu_area_styles')) {
	/**
	 * Generates styles for header standard menu
	 */
	function buro_mikado_header_full_screen_menu_area_styles() {
		global $buro_mikado_options;

		$menu_area_header_full_screen_styles = array();

		if($buro_mikado_options['menu_area_background_color_header_full_screen'] !== '') {
			$menu_area_background_color        = $buro_mikado_options['menu_area_background_color_header_full_screen'];
			$menu_area_background_transparency = 1;

			if($buro_mikado_options['menu_area_background_transparency_header_full_screen'] !== '') {
				$menu_area_background_transparency = $buro_mikado_options['menu_area_background_transparency_header_full_screen'];
			}

			$menu_area_header_full_screen_styles['background-color'] = buro_mikado_rgba_color($menu_area_background_color, $menu_area_background_transparency);
		}

		if($buro_mikado_options['menu_area_height_header_full_screen'] !== '') {
			$max_height = intval(buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_full_screen']) * 0.9).'px';
			echo buro_mikado_dynamic_css('.mkd-header-full-screen .mkd-page-header .mkd-logo-wrapper a', array('max-height' => $max_height));

			$menu_area_header_full_screen_styles['height'] = buro_mikado_filter_px($buro_mikado_options['menu_area_height_header_full_screen']).'px';

		}

		echo buro_mikado_dynamic_css('.mkd-header-full-screen .mkd-page-header .mkd-menu-area', $menu_area_header_full_screen_styles);

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_header_full_screen_menu_area_styles');
}

if(!function_exists('buro_mikado_sticky_header_styles')) {
    /**
     * Generates styles for sticky haeder
     */
    function buro_mikado_sticky_header_styles() {
        global $buro_mikado_options;

        if($buro_mikado_options['sticky_header_in_grid'] == 'yes' && $buro_mikado_options['sticky_header_grid_background_color'] !== '') {
            $sticky_header_grid_background_color        = $buro_mikado_options['sticky_header_grid_background_color'];
            $sticky_header_grid_background_transparency = 1;

            if($buro_mikado_options['sticky_header_grid_transparency'] !== '') {
                $sticky_header_grid_background_transparency = $buro_mikado_options['sticky_header_grid_transparency'];
            }

            echo buro_mikado_dynamic_css('.mkd-page-header .mkd-sticky-header .mkd-grid .mkd-vertical-align-containers', array('background-color' => buro_mikado_rgba_color($sticky_header_grid_background_color, $sticky_header_grid_background_transparency)));
        }

        if($buro_mikado_options['sticky_header_background_color'] !== '') {

            $sticky_header_background_color              = $buro_mikado_options['sticky_header_background_color'];
            $sticky_header_background_color_transparency = 1;

            if($buro_mikado_options['sticky_header_transparency'] !== '') {
                $sticky_header_background_color_transparency = $buro_mikado_options['sticky_header_transparency'];
            }

            echo buro_mikado_dynamic_css('.mkd-page-header .mkd-sticky-header .mkd-sticky-holder', array('background-color' => buro_mikado_rgba_color($sticky_header_background_color, $sticky_header_background_color_transparency)));
        }

        if($buro_mikado_options['sticky_header_height'] !== '') {
            $max_height = intval(buro_mikado_filter_px($buro_mikado_options['sticky_header_height']) * 0.9).'px';

            echo buro_mikado_dynamic_css('.mkd-page-header .mkd-sticky-header', array('height' => $buro_mikado_options['sticky_header_height'].'px'));
            echo buro_mikado_dynamic_css('.mkd-page-header .mkd-sticky-header .mkd-logo-wrapper a', array('max-height' => $max_height));
        }

        $sticky_menu_item_styles = array();
        if($buro_mikado_options['sticky_color'] !== '') {
            $sticky_menu_item_styles['color'] = $buro_mikado_options['sticky_color'];
        }
        if($buro_mikado_options['sticky_google_fonts'] !== '-1') {
            $sticky_menu_item_styles['font-family'] = buro_mikado_get_formatted_font_family($buro_mikado_options['sticky_google_fonts']);
        }
        if($buro_mikado_options['sticky_fontsize'] !== '') {
            $sticky_menu_item_styles['font-size'] = $buro_mikado_options['sticky_fontsize'].'px';
        }
        if($buro_mikado_options['sticky_lineheight'] !== '') {
            $sticky_menu_item_styles['line-height'] = $buro_mikado_options['sticky_lineheight'].'px';
        }
        if($buro_mikado_options['sticky_texttransform'] !== '') {
            $sticky_menu_item_styles['text-transform'] = $buro_mikado_options['sticky_texttransform'];
        }
        if($buro_mikado_options['sticky_fontstyle'] !== '') {
            $sticky_menu_item_styles['font-style'] = $buro_mikado_options['sticky_fontstyle'];
        }
        if($buro_mikado_options['sticky_fontweight'] !== '') {
            $sticky_menu_item_styles['font-weight'] = $buro_mikado_options['sticky_fontweight'];
        }
        if($buro_mikado_options['sticky_letterspacing'] !== '') {
            $sticky_menu_item_styles['letter-spacing'] = $buro_mikado_options['sticky_letterspacing'].'px';
        }

        $sticky_menu_item_selector = array(
            '.mkd-main-menu.mkd-sticky-nav > ul > li > a'
        );

        echo buro_mikado_dynamic_css($sticky_menu_item_selector, $sticky_menu_item_styles);

        $sticky_menu_item_hover_styles = array();
        if($buro_mikado_options['sticky_hovercolor'] !== '') {
            $sticky_menu_item_hover_styles['color'] = $buro_mikado_options['sticky_hovercolor'];
        }

        $sticky_menu_item_hover_selector = array(
            '.mkd-main-menu.mkd-sticky-nav > ul > li:hover > a',
            '.mkd-main-menu.mkd-sticky-nav > ul > li.mkd-active-item > a'
        );

        echo buro_mikado_dynamic_css($sticky_menu_item_hover_selector, $sticky_menu_item_hover_styles);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_sticky_header_styles');
}

if(!function_exists('buro_mikado_fixed_header_styles')) {
    /**
     * Generates styles for fixed header
     */
    function buro_mikado_fixed_header_styles() {
        global $buro_mikado_options;

        if($buro_mikado_options['fixed_header_grid_background_color'] !== '') {

            $fixed_header_grid_background_color              = $buro_mikado_options['fixed_header_grid_background_color'];
            $fixed_header_grid_background_color_transparency = 1;

            if($buro_mikado_options['fixed_header_grid_transparency'] !== '') {
                $fixed_header_grid_background_color_transparency = $buro_mikado_options['fixed_header_grid_transparency'];
            }

            echo buro_mikado_dynamic_css('.mkd-fixed-on-scroll .mkd-fixed-wrapper.fixed .mkd-grid .mkd-vertical-align-containers',
                array('background-color' => buro_mikado_rgba_color($fixed_header_grid_background_color, $fixed_header_grid_background_color_transparency)));
        }

        if($buro_mikado_options['fixed_header_background_color'] !== '') {

            $fixed_header_background_color              = $buro_mikado_options['fixed_header_background_color'];
            $fixed_header_background_color_transparency = 1;

            if($buro_mikado_options['fixed_header_transparency'] !== '') {
                $fixed_header_background_color_transparency = $buro_mikado_options['fixed_header_transparency'];
            }

            echo buro_mikado_dynamic_css('.mkd-fixed-on-scroll .mkd-fixed-wrapper.fixed .mkd-menu-area',
                array('background-color' => buro_mikado_rgba_color($fixed_header_background_color, $fixed_header_background_color_transparency)));
        }

    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_fixed_header_styles');
}

if(!function_exists('buro_mikado_main_menu_styles')) {
    /**
     * Generates styles for main menu
     */
    function buro_mikado_main_menu_styles() {
        global $buro_mikado_options;

        if($buro_mikado_options['menu_color'] !== '' || $buro_mikado_options['menu_fontsize'] != '' || $buro_mikado_options['menu_fontstyle'] !== '' || $buro_mikado_options['menu_fontweight'] !== '' || $buro_mikado_options['menu_texttransform'] !== '' || $buro_mikado_options['menu_letterspacing'] !== '' || $buro_mikado_options['menu_google_fonts'] != "-1") { ?>
            .mkd-main-menu.mkd-default-nav > ul > li > a,
            .mkd-page-header #lang_sel > ul > li > a,
            .mkd-page-header #lang_sel_click > ul > li > a,
            .mkd-page-header #lang_sel ul > li:hover > a{
            <?php if($buro_mikado_options['menu_color']) { ?> color: <?php echo esc_attr($buro_mikado_options['menu_color']); ?>; <?php } ?>
            <?php if($buro_mikado_options['menu_google_fonts'] != "-1") { ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['menu_google_fonts'])); ?>', sans-serif;
            <?php } ?>
            <?php if($buro_mikado_options['menu_fontsize'] !== '') { ?> font-size: <?php echo esc_attr($buro_mikado_options['menu_fontsize']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['menu_fontstyle'] !== '') { ?> font-style: <?php echo esc_attr($buro_mikado_options['menu_fontstyle']); ?>; <?php } ?>
            <?php if($buro_mikado_options['menu_fontweight'] !== '') { ?> font-weight: <?php echo esc_attr($buro_mikado_options['menu_fontweight']); ?>; <?php } ?>
            <?php if($buro_mikado_options['menu_texttransform'] !== '') { ?> text-transform: <?php echo esc_attr($buro_mikado_options['menu_texttransform']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['menu_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($buro_mikado_options['menu_letterspacing']); ?>px; <?php } ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_google_fonts'] != "-1") { ?>
            .mkd-page-header #lang_sel_list{
            font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['menu_google_fonts'])); ?>', sans-serif !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_hovercolor'] !== '') { ?>
            .mkd-main-menu.mkd-default-nav > ul > li:hover > a,
            .mkd-main-menu.mkd-default-nav > ul > li.mkd-active-item:hover > a,
            .mkd-page-header #lang_sel ul li a:hover,
            .mkd-page-header #lang_sel_click > ul > li a:hover{
            color: <?php echo esc_attr($buro_mikado_options['menu_hovercolor']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_activecolor'] !== '') { ?>
            .mkd-main-menu.mkd-default-nav > ul > li.mkd-active-item > a{
            color: <?php echo esc_attr($buro_mikado_options['menu_activecolor']); ?>;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_item_icon_position'] == "top" && $buro_mikado_options['menu_item_icon_size'] !== "") { ?>
            body.mkd-menu-with-large-icons .mkd-main-menu.mkd-default-nav > ul > li > a span.mkd-item-inner i{
            font-size: <?php echo esc_attr($buro_mikado_options['menu_item_icon_size']); ?>px !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_light_hovercolor'] !== '') { ?>
			.mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li > a:hover,
            .mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li.mkd-active-item > a:hover,
            .mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li > a:hover,
            .mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li.mkd-active-item > a:hover{
            color: <?php echo esc_attr($buro_mikado_options['menu_light_hovercolor']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_light_activecolor'] !== '') { ?>
            .mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li.mkd-active-item > a,
            .mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li.mkd-active-item > a{
            color: <?php echo esc_attr($buro_mikado_options['menu_light_activecolor']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_dark_hovercolor'] !== '') { ?>
            .mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li > a:hover,
            .mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li.mkd-active-item > a:hover,
            .mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li > a:hover,
            .mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li.mkd-active-item > a:hover{
            color: <?php echo esc_attr($buro_mikado_options['menu_dark_hovercolor']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_dark_activecolor'] !== '') { ?>
            .mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-main-menu > ul > li.mkd-active-item > a,
            .mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-main-menu > ul > li.mkd-active-item > a{
            color: <?php echo esc_attr($buro_mikado_options['menu_dark_activecolor']); ?>;
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_lineheight'] != "" || $buro_mikado_options['menu_padding_left_right'] !== '') { ?>
            .mkd-main-menu.mkd-default-nav > ul > li > a span.mkd-item-inner{
            <?php if($buro_mikado_options['menu_lineheight'] !== '') { ?> line-height: <?php echo esc_attr($buro_mikado_options['menu_lineheight']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['menu_padding_left_right']) { ?> padding: 0  <?php echo esc_attr($buro_mikado_options['menu_padding_left_right']); ?>px; <?php } ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['menu_margin_left_right'] !== '') { ?>
            .mkd-main-menu.mkd-default-nav > ul > li{
            margin: 0  <?php echo esc_attr($buro_mikado_options['menu_margin_left_right']); ?>px;
            }
        <?php } ?>

        <?php
        if($buro_mikado_options['dropdown_background_color'] != "" || $buro_mikado_options['dropdown_background_transparency'] != "") {

            //dropdown background and transparency styles
            $dropdown_bg_color_initial        = '#ffffff';
            $dropdown_bg_transparency_initial = 1;

            $dropdown_bg_color        = $buro_mikado_options['dropdown_background_color'] !== "" ? $buro_mikado_options['dropdown_background_color'] : $dropdown_bg_color_initial;
            $dropdown_bg_transparency = $buro_mikado_options['dropdown_background_transparency'] !== "" ? $buro_mikado_options['dropdown_background_transparency'] : $dropdown_bg_transparency_initial;

            $dropdown_bg_color_rgb = buro_mikado_hex2rgb($dropdown_bg_color);

            ?>

            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li ul,
            .shopping_cart_dropdown,
            .mkd-drop-down .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul,
            .mkd-main-menu.mkd-default-nav #lang_sel ul ul,
            .mkd-main-menu.mkd-default-nav #lang_sel_click  ul ul,
            .header-widget.widget_nav_menu ul ul,
            .mkd-drop-down .mkd-menu-wide.mkd-wide-background .mkd-menu-second{
            background-color: <?php echo esc_attr($dropdown_bg_color); ?>;
            background-color: rgba(<?php echo esc_attr($dropdown_bg_color_rgb[0]); ?>,<?php echo esc_attr($dropdown_bg_color_rgb[1]); ?>,<?php echo esc_attr($dropdown_bg_color_rgb[2]); ?>,<?php echo esc_attr($dropdown_bg_transparency); ?>);
            }

        <?php } //end dropdown background and transparency styles ?>

        <?php
        if($buro_mikado_options['dropdown_top_padding'] !== '') {

            $menu_inner_ul_top = 15; //default value without border
            if($buro_mikado_options['dropdown_top_padding'] !== '') {
                ?>
                .mkd-drop-down .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul,
                .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul{
                padding-top: <?php echo esc_attr($buro_mikado_options['dropdown_top_padding']); ?>px;
                }
                <?php
                $menu_inner_ul_top = $buro_mikado_options['dropdown_top_padding']; //overwrite default value
            } ?>
            .mkd-drop-down .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul li ul,
            body.mkd-slide-from-bottom .mkd-drop-down .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul li:hover ul,
            body.mkd-slide-from-top .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul li:hover ul{
            top:-<?php echo esc_attr($menu_inner_ul_top); ?>px;
            }

        <?php } ?>

        <?php if($buro_mikado_options['dropdown_bottom_padding'] !== '') { ?>
		    .mkd-drop-down .mkd-menu-narrow .mkd-menu-second .mkd-menu-inner ul,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul{
            padding-bottom: <?php echo esc_attr($buro_mikado_options['dropdown_bottom_padding']); ?>px;
            }
        <?php } ?>

        <?php
        $dropdown_separator_full_width = 'no';
        if($buro_mikado_options['enable_dropdown_separator_full_width'] == "yes") {
            $dropdown_separator_full_width = $buro_mikado_options['enable_dropdown_separator_full_width']; ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li:last-child > a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li > ul > li:last-child > a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li > ul > li > ul > li:last-child > a{
            border-bottom:1px solid transparent;
            }

        <?php }
        if($dropdown_separator_full_width !== 'yes' && $buro_mikado_options['dropdown_separator_color'] !== "") {
            ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li a,
            .header-widget.widget_nav_menu ul.menu li ul li a {
            border-color: <?php echo esc_attr($buro_mikado_options['dropdown_separator_color']); ?>;
            }
        <?php } ?>
        <?php
        if($dropdown_separator_full_width == 'yes') {
            ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li,
            .header-widget.widget_nav_menu ul.menu li ul li{
	        border-bottom-width:1px;
	        border-bottom-style:solid;
            <?php if($buro_mikado_options['dropdown_separator_color'] !== "") {?> border-bottom-color: <?php echo esc_attr($buro_mikado_options['dropdown_separator_color']); ?>; <?php } ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_top_position'] !== '') { ?>
            header .mkd-drop-down .mkd-menu-second {
            top: <?php echo esc_attr($buro_mikado_options['dropdown_top_position']).'%;'; ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_color'] !== '' || $buro_mikado_options['dropdown_fontsize'] !== '' || $buro_mikado_options['dropdown_lineheight'] !== '' || $buro_mikado_options['dropdown_fontstyle'] !== '' || $buro_mikado_options['dropdown_fontweight'] !== '' || $buro_mikado_options['dropdown_google_fonts'] != "-1" || $buro_mikado_options['dropdown_texttransform'] !== '' || $buro_mikado_options['dropdown_letterspacing'] !== '') { ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li > a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li > h4,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul > li > h4,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul > li > a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second ul li ul li.menu-item-has-children > a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li.menu-item-has-children > a,
            .mkd-main-menu.mkd-default-nav #lang_sel ul li li a,
            .mkd-main-menu.mkd-default-nav #lang_sel_click ul li ul li a,
            .mkd-main-menu.mkd-default-nav #lang_sel ul ul a,
            .mkd-main-menu.mkd-default-nav #lang_sel_click ul ul a{
            <?php if(!empty($buro_mikado_options['dropdown_color'])) { ?> color: <?php echo esc_attr($buro_mikado_options['dropdown_color']); ?>; <?php } ?>
            <?php if($buro_mikado_options['dropdown_google_fonts'] != "-1") { ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['dropdown_google_fonts'])); ?>', sans-serif !important;
            <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontsize'] !== '') { ?> font-size: <?php echo esc_attr($buro_mikado_options['dropdown_fontsize']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['dropdown_lineheight'] !== '') { ?> line-height: <?php echo esc_attr($buro_mikado_options['dropdown_lineheight']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontstyle'] !== '') { ?> font-style: <?php echo esc_attr($buro_mikado_options['dropdown_fontstyle']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontweight'] !== '') { ?>font-weight: <?php echo esc_attr($buro_mikado_options['dropdown_fontweight']); ?>; <?php } ?>
            <?php if($buro_mikado_options['dropdown_texttransform'] !== '') { ?> text-transform: <?php echo esc_attr($buro_mikado_options['dropdown_texttransform']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($buro_mikado_options['dropdown_letterspacing']); ?>px;  <?php } ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_color'] !== '') { ?>
            .shopping_cart_dropdown ul li
            .item_info_holder .item_left a,
            .shopping_cart_dropdown ul li .item_info_holder .item_right .amount,
            .shopping_cart_dropdown .cart_bottom .subtotal_holder .total,
            .shopping_cart_dropdown .cart_bottom .subtotal_holder .total_amount{
            color: <?php echo esc_attr($buro_mikado_options['dropdown_color']); ?>;
            }
        <?php } ?>

        <?php if(!empty($buro_mikado_options['dropdown_hovercolor'])) { ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner > ul > li:hover > a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second ul li ul li.menu-item-has-children:hover > a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li.menu-item-has-children:hover > a,
            .mkd-main-menu.mkd-default-nav #lang_sel ul li li:hover a,
            .mkd-main-menu.mkd-default-nav #lang_sel_click ul li ul li:hover a,
            .mkd-main-menu.mkd-default-nav #lang_sel ul li:hover > a,
            .mkd-main-menu.mkd-default-nav #lang_sel_click ul li:hover > a{
            color: <?php echo esc_attr($buro_mikado_options['dropdown_hovercolor']); ?> !important;
            }
        <?php } ?>

        <?php if(!empty($buro_mikado_options['dropdown_padding_top_bottom'])) { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second>.mkd-menu-inner>ul>li.mkd-sub>ul>li>a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second ul li a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul.right li a{
            padding-top: <?php echo esc_attr($buro_mikado_options['dropdown_padding_top_bottom']); ?>px;
            padding-bottom: <?php echo esc_attr($buro_mikado_options['dropdown_padding_top_bottom']); ?>px;
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_wide_color'] !== '' || $buro_mikado_options['dropdown_wide_fontsize'] !== '' || $buro_mikado_options['dropdown_wide_lineheight'] !== '' || $buro_mikado_options['dropdown_wide_fontstyle'] !== '' || $buro_mikado_options['dropdown_wide_fontweight'] !== '' || $buro_mikado_options['dropdown_wide_google_fonts'] !== "-1" || $buro_mikado_options['dropdown_wide_texttransform'] !== '' || $buro_mikado_options['dropdown_wide_letterspacing'] !== '') { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul > li > a{
            <?php if($buro_mikado_options['dropdown_wide_color'] !== '') { ?> color: <?php echo esc_attr($buro_mikado_options['dropdown_wide_color']); ?>; <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_google_fonts'] != "-1") { ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['dropdown_wide_google_fonts'])); ?>', sans-serif !important;
            <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontsize'] !== '') { ?> font-size: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontsize']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_lineheight'] !== '') { ?> line-height: <?php echo esc_attr($buro_mikado_options['dropdown_wide_lineheight']); ?>px; <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontstyle'] !== '') { ?> font-style: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontstyle']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontweight'] !== '') { ?>font-weight: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontweight']); ?>; <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_texttransform'] !== '') { ?> text-transform: <?php echo esc_attr($buro_mikado_options['dropdown_wide_texttransform']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_letterspacing'] !== '') { ?> letter-spacing: <?php echo esc_attr($buro_mikado_options['dropdown_wide_letterspacing']); ?>px;  <?php } ?>
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_wide_hovercolor'] !== '') { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner > ul > li:hover > a {
            color: <?php echo esc_attr($buro_mikado_options['dropdown_wide_hovercolor']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_wide_padding_top_bottom'] !== '') { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second>.mkd-menu-inner > ul > li.mkd-sub > ul > li > a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second ul li a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul.right li a{
            padding-top: <?php echo esc_attr($buro_mikado_options['dropdown_wide_padding_top_bottom']); ?>px;
            padding-bottom: <?php echo esc_attr($buro_mikado_options['dropdown_wide_padding_top_bottom']); ?>px;
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_color_thirdlvl'] !== '' || $buro_mikado_options['dropdown_fontsize_thirdlvl'] !== '' || $buro_mikado_options['dropdown_lineheight_thirdlvl'] !== '' || $buro_mikado_options['dropdown_fontstyle_thirdlvl'] !== '' || $buro_mikado_options['dropdown_fontweight_thirdlvl'] !== '' || $buro_mikado_options['dropdown_google_fonts_thirdlvl'] != "-1" || $buro_mikado_options['dropdown_texttransform_thirdlvl'] !== '' || $buro_mikado_options['dropdown_letterspacing_thirdlvl'] !== '') { ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li a{
            <?php if($buro_mikado_options['dropdown_color_thirdlvl'] !== '') { ?> color: <?php echo esc_attr($buro_mikado_options['dropdown_color_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_google_fonts_thirdlvl'] != "-1") { ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['dropdown_google_fonts_thirdlvl'])); ?>', sans-serif;
            <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontsize_thirdlvl'] !== '') { ?> font-size: <?php echo esc_attr($buro_mikado_options['dropdown_fontsize_thirdlvl']); ?>px;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_lineheight_thirdlvl'] !== '') { ?> line-height: <?php echo esc_attr($buro_mikado_options['dropdown_lineheight_thirdlvl']); ?>px;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontstyle_thirdlvl'] !== '') { ?> font-style: <?php echo esc_attr($buro_mikado_options['dropdown_fontstyle_thirdlvl']); ?>;   <?php } ?>
            <?php if($buro_mikado_options['dropdown_fontweight_thirdlvl'] !== '') { ?> font-weight: <?php echo esc_attr($buro_mikado_options['dropdown_fontweight_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_texttransform_thirdlvl'] !== '') { ?> text-transform: <?php echo esc_attr($buro_mikado_options['dropdown_texttransform_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_letterspacing_thirdlvl'] !== '') { ?> letter-spacing: <?php echo esc_attr($buro_mikado_options['dropdown_letterspacing_thirdlvl']); ?>px;  <?php } ?>
            }
        <?php } ?>
        <?php if($buro_mikado_options['dropdown_hovercolor_thirdlvl'] !== '') { ?>
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li:hover > a,
            .mkd-drop-down .mkd-menu-second .mkd-menu-inner ul li ul li:hover > a{
            color: <?php echo esc_attr($buro_mikado_options['dropdown_hovercolor_thirdlvl']); ?> !important;
            }
        <?php } ?>

        <?php if($buro_mikado_options['dropdown_wide_color_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_fontsize_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_lineheight_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_fontstyle_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_fontweight_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_google_fonts_thirdlvl'] != "-1" || $buro_mikado_options['dropdown_wide_texttransform_thirdlvl'] !== '' || $buro_mikado_options['dropdown_wide_letterspacing_thirdlvl'] !== '') { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li a,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second ul li ul li a{
            <?php if($buro_mikado_options['dropdown_wide_color_thirdlvl'] !== '') { ?> color: <?php echo esc_attr($buro_mikado_options['dropdown_wide_color_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_google_fonts_thirdlvl'] != "-1") { ?>
                font-family: '<?php echo esc_attr(str_replace('+', ' ', $buro_mikado_options['dropdown_wide_google_fonts_thirdlvl'])); ?>', sans-serif;
            <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontsize_thirdlvl'] !== '') { ?> font-size: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontsize_thirdlvl']); ?>px;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_lineheight_thirdlvl'] !== '') { ?> line-height: <?php echo esc_attr($buro_mikado_options['dropdown_wide_lineheight_thirdlvl']); ?>px;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontstyle_thirdlvl'] !== '') { ?> font-style: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontstyle_thirdlvl']); ?>;   <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_fontweight_thirdlvl'] !== '') { ?> font-weight: <?php echo esc_attr($buro_mikado_options['dropdown_wide_fontweight_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_texttransform_thirdlvl'] !== '') { ?> text-transform: <?php echo esc_attr($buro_mikado_options['dropdown_wide_texttransform_thirdlvl']); ?>;  <?php } ?>
            <?php if($buro_mikado_options['dropdown_wide_letterspacing_thirdlvl'] !== '') { ?> letter-spacing: <?php echo esc_attr($buro_mikado_options['dropdown_wide_letterspacing_thirdlvl']); ?>px;  <?php } ?>
            }
        <?php } ?>
        <?php if($buro_mikado_options['dropdown_wide_hovercolor_thirdlvl'] !== '') { ?>
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li.mkd-sub ul li) > a:hover,
            .mkd-drop-down .mkd-menu-wide .mkd-menu-second .mkd-menu-inner ul li ul li > a:hover{
            color: <?php echo esc_attr($buro_mikado_options['dropdown_wide_hovercolor_thirdlvl']); ?> !important;
            }
        <?php }

    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_main_menu_styles');
}

if(!function_exists('buro_mikado_vertical_main_menu_styles')) {
    /**
     * Generates styles for vertical main main menu
     */
    function buro_mikado_vertical_main_menu_styles() {
        $dropdown_styles = array();

        if(buro_mikado_options()->getOptionValue('vertical_dropdown_background_color') !== '') {
            $dropdown_styles['background-color'] = buro_mikado_options()->getOptionValue('vertical_dropdown_background_color');
        }

        $dropdown_selector = array(
            '.mkd-header-vertical .mkd-vertical-dropdown-float .menu-item .mkd-menu-second',
            '.mkd-header-vertical .mkd-vertical-dropdown-float .mkd-menu-second .mkd-menu-inner ul ul'
        );

        echo buro_mikado_dynamic_css($dropdown_selector, $dropdown_styles);

        $fist_level_styles = array();
        $fist_level_hover_styles = array();

        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_color') !== '') {
            $fist_level_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_color');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_google_fonts') !== '-1') {
            $fist_level_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('vertical_menu_1st_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_fontsize') !== '') {
            $fist_level_styles['font-size'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_fontsize').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_lineheight') !== '') {
            $fist_level_styles['line-height'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_lineheight').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_texttransform') !== '') {
            $fist_level_styles['text-transform'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_fontstyle') !== '') {
            $fist_level_styles['font-style'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_fontweight') !== '') {
            $fist_level_styles['font-weight'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_letter_spacing') !== '') {
            $fist_level_styles['letter-spacing'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_letter_spacing').'px';
        }

        if(buro_mikado_options()->getOptionValue('vertical_menu_1st_hover_color') !== '') {
            $fist_level_hover_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_1st_hover_color');
        }

        $first_level_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu > ul > li > a'
        );
        $first_level_hover_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu > ul > li > a:hover',
            '.mkd-header-vertical .mkd-vertical-menu > ul > li.mkd-active-item > a'
        );

        echo buro_mikado_dynamic_css($first_level_selector, $fist_level_styles);
        echo buro_mikado_dynamic_css($first_level_hover_selector, $fist_level_hover_styles);

        $second_level_styles = array();
        $second_level_hover_styles = array();

        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_color') !== '') {
            $second_level_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_color');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_google_fonts') !== '-1') {
            $second_level_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('vertical_menu_2nd_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontsize') !== '') {
            $second_level_styles['font-size'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontsize').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_lineheight') !== '') {
            $second_level_styles['line-height'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_lineheight').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_texttransform') !== '') {
            $second_level_styles['text-transform'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontstyle') !== '') {
            $second_level_styles['font-style'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontweight') !== '') {
            $second_level_styles['font-weight'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_letter_spacing') !== '') {
            $second_level_styles['letter-spacing'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_letter_spacing').'px';
        }

        if(buro_mikado_options()->getOptionValue('vertical_menu_2nd_hover_color') !== '') {
            $second_level_hover_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_2nd_hover_color');
        }

        $second_level_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner > ul > li > a'
        );

        $second_level_hover_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner > ul > li > a:hover',
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner > ul > li > a.mkd-active-item'
        );

        echo buro_mikado_dynamic_css($second_level_selector, $second_level_styles);
        echo buro_mikado_dynamic_css($second_level_hover_selector, $second_level_hover_styles);

        $third_level_styles = array();
        $third_level_hover_styles = array();

        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_color') !== '') {
            $third_level_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_color');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_google_fonts') !== '-1') {
            $third_level_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('vertical_menu_3rd_google_fonts'));
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontsize') !== '') {
            $third_level_styles['font-size'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontsize').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_lineheight') !== '') {
            $third_level_styles['line-height'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_lineheight').'px';
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_texttransform') !== '') {
            $third_level_styles['text-transform'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_texttransform');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontstyle') !== '') {
            $third_level_styles['font-style'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontstyle');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontweight') !== '') {
            $third_level_styles['font-weight'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_fontweight');
        }
        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_letter_spacing') !== '') {
            $third_level_styles['letter-spacing'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_letter_spacing').'px';
        }

        if(buro_mikado_options()->getOptionValue('vertical_menu_3rd_hover_color') !== '') {
            $third_level_hover_styles['color'] = buro_mikado_options()->getOptionValue('vertical_menu_3rd_hover_color');
        }

        $third_level_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner ul li ul li a'
        );

        $third_level_hover_selector = array(
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner ul li ul li a:hover',
            '.mkd-header-vertical .mkd-vertical-menu .mkd-menu-second .mkd-menu-inner ul li ul li a.mkd-active-item'
        );

        echo buro_mikado_dynamic_css($third_level_selector, $third_level_styles);
        echo buro_mikado_dynamic_css($third_level_hover_selector, $third_level_hover_styles);
    }

    add_action('buro_mikado_style_dynamic', 'buro_mikado_vertical_main_menu_styles');
}