<?php

if(!function_exists('buro_mikado_header_class')) {
    /**
     * Function that adds class to header based on theme options
     * @param array array of classes from main filter
     * @return array array of classes with added header class
     */
    function buro_mikado_header_class($classes) {
        $header_type = buro_mikado_get_meta_field_intersect('header_type', buro_mikado_get_page_id());

        $classes[] = 'mkd-'.$header_type;

        return $classes;
    }

    add_filter('body_class', 'buro_mikado_header_class');
}

if(!function_exists('buro_mikado_header_behaviour_class')) {
    /**
     * Function that adds behaviour class to header based on theme options
     * @param array array of classes from main filter
     * @return array array of classes with added behaviour class
     */
    function buro_mikado_header_behaviour_class($classes) {

        $classes[] = 'mkd-'.buro_mikado_options()->getOptionValue('header_behaviour');

        return $classes;
    }

    add_filter('body_class', 'buro_mikado_header_behaviour_class');
}

if(!function_exists('buro_mikado_menu_item_icon_position_class')) {
    /**
     * Function that adds menu item icon position class to header based on theme options
     * @param array array of classes from main filter
     * @return array array of classes with added menu item icon position class
     */
    function buro_mikado_menu_item_icon_position_class($classes) {

        if(buro_mikado_options()->getOptionValue('menu_item_icon_position') == 'top'){
            $classes[] = 'mkd-menu-with-large-icons';
        }

        return $classes;
    }

    add_filter('body_class', 'buro_mikado_menu_item_icon_position_class');
}

if(!function_exists('buro_mikado_mobile_header_class')) {
    function buro_mikado_mobile_header_class($classes) {
        $classes[] = 'mkd-default-mobile-header';

        $classes[] = 'mkd-sticky-up-mobile-header';

        return $classes;
    }

    add_filter('body_class', 'buro_mikado_mobile_header_class');
}

if(!function_exists('buro_mikado_menu_dropdown_appearance')) {
    /**
     * Function that adds menu dropdown appearance class to body tag
     * @param array array of classes from main filter
     * @return array array of classes with added menu dropdown appearance class
     */
    function buro_mikado_menu_dropdown_appearance($classes) {

        if(buro_mikado_options()->getOptionValue('menu_dropdown_appearance') !== 'default'){
            $classes[] = 'mkd-'.buro_mikado_options()->getOptionValue('menu_dropdown_appearance');
        }

        return $classes;
    }

    add_filter('body_class', 'buro_mikado_menu_dropdown_appearance');
}

if (!function_exists('buro_mikado_header_skin_class')) {

    function buro_mikado_header_skin_class( $classes ) {

        $id = buro_mikado_get_page_id();

		if(($meta_temp = get_post_meta($id, 'mkd_header_style_meta', true)) !== ''){
			$classes[] = 'mkd-' . $meta_temp;
		} else if ( buro_mikado_options()->getOptionValue('header_style') !== '' ) {
            $classes[] = 'mkd-' . buro_mikado_options()->getOptionValue('header_style');
        }

        return $classes;

    }

    add_filter('body_class', 'buro_mikado_header_skin_class');

}

if (!function_exists('buro_mikado_header_scroll_style_class')) {

	function buro_mikado_header_scroll_style_class( $classes ) {

		if (buro_mikado_get_meta_field_intersect('enable_header_style_on_scroll') == 'yes' ) {
			$classes[] = 'mkd-header-style-on-scroll';
		}

		return $classes;

	}

	add_filter('body_class', 'buro_mikado_header_scroll_style_class');

}

if(!function_exists('buro_mikado_header_global_js_var')) {
    function buro_mikado_header_global_js_var($global_variables) {

        $global_variables['mkdTopBarHeight'] = buro_mikado_get_top_bar_height();
        $global_variables['mkdStickyHeaderHeight'] = buro_mikado_get_sticky_header_height();
        $global_variables['mkdStickyHeaderTransparencyHeight'] = buro_mikado_get_sticky_header_height_of_complete_transparency();
        $global_variables['mkdStickyScrollAmount'] = buro_mikado_get_sticky_scroll_amount();

        return $global_variables;
    }

    add_filter('buro_mikado_js_global_variables', 'buro_mikado_header_global_js_var');
}

if(!function_exists('buro_mikado_header_per_page_js_var')) {
    function buro_mikado_header_per_page_js_var($perPageVars) {

        $perPageVars['mkdStickyScrollAmount'] = buro_mikado_get_sticky_scroll_amount_per_page();

        return $perPageVars;
    }

    add_filter('buro_mikado_per_page_js_vars', 'buro_mikado_header_per_page_js_var');
}

if(!function_exists('buro_mikado_get_top_bar_styles')) {
	/**
	 * Sets per page styles for header top bar
	 *
	 * @param $styles
	 *
	 * @return array
	 */
	function buro_mikado_get_top_bar_styles($styles) {
		$id            = buro_mikado_get_page_id();
		$class_prefix  = buro_mikado_get_unique_page_class();
		$top_bar_style = array();

		$top_bar_bg_color     = get_post_meta($id, 'mkd_top_bar_background_color_meta', true);

		$top_bar_selector = array(
			$class_prefix.' .mkd-top-bar'
		);

		if($top_bar_bg_color !== '') {
			$top_bar_transparency = get_post_meta($id, 'mkd_top_bar_background_transparency_meta', true);
			if($top_bar_transparency === '') {
				$top_bar_transparency = 1;
			}

			$top_bar_style['background-color'] = buro_mikado_rgba_color($top_bar_bg_color, $top_bar_transparency);
		}

		$styles[] = buro_mikado_dynamic_css($top_bar_selector, $top_bar_style);

		return $styles;
	}

	add_filter('buro_mikado_add_page_custom_style', 'buro_mikado_get_top_bar_styles');
}
if(!function_exists('buro_mikado_top_bar_skin_class')) {
	/**
	 * @param $classes
	 *
	 * @return array
	 */
	function buro_mikado_top_bar_skin_class($classes) {
		$id = buro_mikado_get_page_id();
		$top_bar_skin = get_post_meta($id, 'mkd_top_bar_skin_meta', true);

		if($top_bar_skin !== '') {
			$classes[] = 'mkd-top-bar-'.$top_bar_skin;
		}

		return $classes;
	}

	add_filter('body_class', 'buro_mikado_top_bar_skin_class');
}