<?php

if(!function_exists('buro_mikado_register_top_header_areas')) {
    /**
     * Registers widget areas for top header bar when it is enabled
     */
    function buro_mikado_register_top_header_areas() {
        $top_bar_layout  = buro_mikado_options()->getOptionValue('top_bar_layout');
	
	    if(buro_mikado_core_installed()) {
		    register_sidebar( array(
			    'name'          => esc_html__( 'Top Bar Left', 'buro' ),
			    'description' => esc_html__('Widgets added here will appear on the left side in top bar header', 'buro'),
			    'id'            => 'mkd-top-bar-left',
			    'before_widget' => '<div id="%1$s" class="widget %2$s mkd-top-bar-widget">',
			    'after_widget'  => '</div>'
		    ) );
		
		    //register this widget area only if top bar layout is three columns
		    if ( $top_bar_layout === 'three-columns' ) {
			    register_sidebar( array(
				    'name'          => esc_html__( 'Top Bar Center', 'buro' ),
				    'id'            => 'mkd-top-bar-center',
				    'before_widget' => '<div id="%1$s" class="widget %2$s mkd-top-bar-widget">',
				    'after_widget'  => '</div>'
			    ) );
		    }
		
		    register_sidebar( array(
			    'name'          => esc_html__( 'Top Bar Right', 'buro' ),
			    'id'            => 'mkd-top-bar-right',
			    'before_widget' => '<div id="%1$s" class="widget %2$s mkd-top-bar-widget">',
			    'after_widget'  => '</div>'
		    ) );
	    }
    }

    add_action('widgets_init', 'buro_mikado_register_top_header_areas');
}

if(!function_exists('buro_mikado_header_widget_areas')) {
    /**
     * Registers widget areas for header
     */
    function buro_mikado_header_widget_areas() {
	    if(buro_mikado_core_installed()) {
		    register_sidebar( array(
			    'name'          => esc_html__( 'Header Widget Area', 'buro' ),
			    'id'            => 'mkd-header-widget-area',
			    'before_widget' => '<div id="%1$s" class="widget %2$s mkd-header-widget">',
			    'after_widget'  => '</div>',
			    'description'   => esc_html__( 'Widgets added here will appear on the right hand side from the main menu, or in bottom of vertical menu', 'buro' )
		    ) );
	    }
    }

    add_action('widgets_init', 'buro_mikado_header_widget_areas');
}

if(!function_exists('buro_mikado_register_mobile_header_areas')) {
    /**
     * Registers widget areas for mobile header
     */
    function buro_mikado_register_mobile_header_areas() {
        if(buro_mikado_is_responsive_on() && buro_mikado_core_installed()) {
            register_sidebar(array(
                'name'          => esc_html__('Mobile Header Widget Area', 'buro'),
                'id'            => 'mkd-mobile-widget-area',
                'before_widget' => '<div id="%1$s" class="widget %2$s mkd-mobile-header-widget">',
                'after_widget'  => '</div>',
                'description'   => esc_html__('Widgets added here will appear on the right hand side from the mobile logo', 'buro')
            ));
        }
    }

    add_action('widgets_init', 'buro_mikado_register_mobile_header_areas');
}

if(!function_exists('buro_mikado_register_sticky_header_areas')) {
    /**
     * Registers widget area for sticky header
     */
    function buro_mikado_register_sticky_header_areas() {
	    if(buro_mikado_core_installed()) {
		    if ( in_array( buro_mikado_options()->getOptionValue( 'header_behaviour' ), array(
			    'sticky-header-on-scroll-up',
			    'sticky-header-on-scroll-down-up'
		    ) ) ) {
			    register_sidebar( array(
				    'name' => esc_html__( 'Sticky Header Widget Area', 'buro' ),
				    'id' => 'mkd-sticky-widget-area',
				    'before_widget' => '<div id="%1$s" class="widget %2$s mkd-sticky-widget">',
				    'after_widget' => '</div>',
				    'description' => esc_html__( 'Widgets added here will appear on the right hand side in sticky menu', 'buro' )
			    ) );
		    }
	    }
    }

    add_action('widgets_init', 'buro_mikado_register_sticky_header_areas');
}