<?php

if ( ! function_exists('buro_mikado_portfolio_options_map') ) {

	function buro_mikado_portfolio_options_map() {

		buro_mikado_add_admin_page(array(
			'slug'  => '_portfolio',
			'title' => esc_html__('Portfolio','buro'),
			'icon'  => 'fa fa-camera-retro'
		));

		$panel = buro_mikado_add_admin_panel(array(
			'title' => esc_html__('Portfolio Single','buro'),
			'name'  => 'panel_portfolio_single',
			'page'  => '_portfolio'
		));

		buro_mikado_add_admin_field(array(
			'name'        => 'portfolio_single_template',
			'type'        => 'select',
			'label'       => esc_html__('Portfolio Type','buro'),
			'default_value'	=> 'small-images',
			'description' => esc_html__('Choose a default type for Single Project pages','buro'),
			'parent'      => $panel,
			'options'     => array(
				'small-images' => esc_html__('Portfolio small images left','buro'),
				'small-images-right' => esc_html__('Portfolio small images right','buro'),
				'small-slider' => esc_html__('Portfolio small slider left','buro'),
				'small-slider-right' => esc_html__('Portfolio small slider right','buro'),
				'big-images' => esc_html__('Portfolio big images','buro'),
				'wide-images' => esc_html__('Portfolio wide images left','buro'),
                'wide-images-right' => esc_html__('Portfolio wide images right','buro'),
				'big-slider' => esc_html__('Portfolio big slider','buro'),
                'wide-slider' => esc_html__('Portfolio wide slider','buro'),
				'small-masonry' => esc_html__('Portfolio small masonry','buro'),
				'big-masonry' => esc_html__('Portfolio big masonry','buro'),
				'gallery' => esc_html__('Portfolio gallery','buro'),
                'split-screen' => esc_html__('Portfolio split screen','buro'),
                'full-screen-slider' => esc_html__('Portfolio full screen slider','buro'),
				'custom' => esc_html__('Portfolio custom','buro'),
				'full-width-custom' => esc_html__('Portfolio full width custom','buro')
			)
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_lightbox_images',
			'type'          => 'yesno',
			'label'         => esc_html__('Lightbox for Images','buro'),
			'description'   => esc_html__('Enabling this option will turn on lightbox functionality for projects with images.','buro'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_lightbox_videos',
			'type'          => 'yesno',
			'label'         => esc_html__('Lightbox for Videos','buro'),
			'description'   => esc_html__('Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects.','buro'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_hide_categories',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Categories','buro'),
			'description'   => esc_html__('Enabling this option will disable category meta description on Single Projects.','buro'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_hide_date',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Date','buro'),
			'description'   => esc_html__('Enabling this option will disable date meta on Single Projects.','buro'),
			'parent'        => $panel,
			'default_value' => 'no'
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_show_related',
			'type'          => 'yesno',
			'label'         => esc_html__('Show Related Projects','buro'),
			'description'   => esc_html__('Enabling this option will show related projects on your page.','buro'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_sticky_sidebar',
			'type'          => 'yesno',
			'label'         => esc_html__('Sticky Side Text','buro'),
			'description'   => esc_html__('Enabling this option will make side text sticky on Single Project pages','buro'),
			'parent'        => $panel,
			'default_value' => 'yes'
		));

        buro_mikado_add_admin_field(array(
            'name'          => 'portfolio_single_comments',
            'type'          => 'yesno',
            'label'         => esc_html__('Show Comments','buro'),
            'description'   => esc_html__('Enabling this option will show comments on your portfolio.','buro'),
            'parent'        => $panel,
            'default_value' => 'no'
        ));

		buro_mikado_add_admin_field(array(
			'name'          => 'portfolio_single_hide_pagination',
			'type'          => 'yesno',
			'label'         => esc_html__('Hide Pagination','buro'),
			'description'   => esc_html__('Enabling this option will turn off portfolio pagination functionality.','buro'),
			'parent'        => $panel,
			'default_value' => 'yes',
			'args' => array(
				'dependence' => true,
				'dependence_hide_on_yes' => '#mkd_navigate_same_category_container'
			)
		));

		$container_navigate_category = buro_mikado_add_admin_container(array(
			'name'            => 'navigate_same_category_container',
			'parent'          => $panel,
			'hidden_property' => 'portfolio_single_hide_pagination',
			'hidden_value'    => 'yes'
		));

		buro_mikado_add_admin_field(array(
			'name'            => 'portfolio_single_nav_same_category',
			'type'            => 'yesno',
			'label'           => esc_html__('Enable Pagination Through Same Category','buro'),
			'description'     => esc_html__('Enabling this option will make portfolio pagination sort through current category.','buro'),
			'parent'          => $container_navigate_category,
			'default_value'   => 'no'
		));

		buro_mikado_add_admin_field(array(
			'name'        => 'portfolio_single_numb_columns',
			'type'        => 'select',
			'label'       => esc_html__('Number of Columns','buro'),
			'default_value' => 'three-columns',
			'description' => esc_html__('Enter the number of columns for Portfolio Gallery type','buro'),
			'parent'      => $panel,
			'options'     => array(
				'two-columns' => esc_html__('2 columns','buro'),
				'three-columns' => esc_html__('3 columns','buro'),
				'four-columns' => esc_html__('4 columns','buro')
			)
		));

		buro_mikado_add_admin_field(array(
			'name'        => 'portfolio_single_slug',
			'type'        => 'text',
			'label'       => esc_html__('Portfolio Single Slug','buro'),
			'description' => esc_html__('Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)','buro'),
			'parent'      => $panel,
			'args'        => array(
				'col_width' => 3
			)
		));

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_portfolio_options_map', 13);

}