<?php 
$back_to_link = get_post_meta( get_the_ID(), 'portfolio_single_back_to_link', true );
?>
<div class="mkd-portfolio-list-holder-outer mkd-ptf-gallery mkd-portfolio-slider-holder mkd-portfolio-related-holder mkd-ptf-hover-zoom-out-simple" data-items='5' data-centered='yes'>
    <h5 class="mkd-ptf-related-title"><?php esc_html_e('Related Projects', 'buro'); ?></h5>
    <div class="mkd-portfolio-list-holder clearfix">
        <?php
        $query = buro_mikado_get_related_post_type(get_the_ID(), array('posts_per_page' => '6'));
        if (is_object($query)) {
            if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                <?php if (has_post_thumbnail()) {
                    $id = get_the_ID();
                    $item_link = get_permalink($id);
                    if (get_post_meta($id, 'portfolio_external_link', true) !== '') {
                        $item_link = get_post_meta($id, 'portfolio_external_link', true);
                    }

                    $categories = wp_get_post_terms($id, 'portfolio-category');
                    $category_html = '';
                    $k = 1;
                    foreach ($categories as $cat) {
                        $category_html .= '<span>' . $cat->name . '</span>';
                        if (count($categories) != $k) {
                            $category_html .= ' / ';
                        }
                        $k++;
                    }
                    ?>
                    <article class="mkd-portfolio-item mix">
	                    <div class="mkd-portfolio-item-inner">
	                    	<div class = "mkd-item-image-holder">
								<a class="mkd-portfolio-link" href="<?php echo esc_url($item_link); ?>"></a>
									<?php
										echo get_the_post_thumbnail(get_the_ID(),'buro_mikado_landscape');
									?>
								<div class="mkd-item-text-overlay">
									<div class="mkd-item-text-overlay-inner">
										<div class="mkd-item-text-holder">
											<h4 class="mkd-item-title">
												<a class="mkd-portfolio-title-link" href="<?php echo esc_url($item_link); ?>">
													<?php echo esc_attr(get_the_title()); ?>
												</a>
											</h4>
										</div>
									</div>
								</div>
							</div>
						</div>
                    </article>
                <?php } ?>
                <?php
            endwhile;
            endif;
            wp_reset_postdata();
        } else { ?>
            <p><?php esc_html_e('No related portfolios were found.', 'buro'); ?></p>
        <?php }
        ?>
    </div>
</div>

