<?php

if (!function_exists('buro_mikado_search_opener_icon_size')) {

	function buro_mikado_search_opener_icon_size()
	{

		if (buro_mikado_options()->getOptionValue('header_search_icon_size')) {
			echo buro_mikado_dynamic_css('.mkd-search-opener, .mkd-header-standard .mkd-search-opener', array(
				'font-size' => buro_mikado_filter_px(buro_mikado_options()->getOptionValue('header_search_icon_size')) . 'px'
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_opener_icon_size');

}

if (!function_exists('buro_mikado_search_opener_icon_colors')) {

	function buro_mikado_search_opener_icon_colors()
	{

		if (buro_mikado_options()->getOptionValue('header_search_icon_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-opener', array(
				'color' => buro_mikado_options()->getOptionValue('header_search_icon_color')
			));
		}

		if (buro_mikado_options()->getOptionValue('header_search_icon_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-opener:hover', array(
				'color' => buro_mikado_options()->getOptionValue('header_search_icon_hover_color')
			));
		}

		if (buro_mikado_options()->getOptionValue('header_light_search_icon_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener,
			.mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener,
			.mkd-light-header .mkd-top-bar .mkd-search-opener', array(
				'color' => buro_mikado_options()->getOptionValue('header_light_search_icon_color') . ' !important'
			));
		}

		if (buro_mikado_options()->getOptionValue('header_light_search_icon_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-light-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener:hover,
			.mkd-light-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener:hover,
			.mkd-light-header .mkd-top-bar .mkd-search-opener:hover', array(
				'color' => buro_mikado_options()->getOptionValue('header_light_search_icon_hover_color') . ' !important'
			));
		}

		if (buro_mikado_options()->getOptionValue('header_dark_search_icon_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener,
			.mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener,
			.mkd-dark-header .mkd-top-bar .mkd-search-opener', array(
				'color' => buro_mikado_options()->getOptionValue('header_dark_search_icon_color') . ' !important'
			));
		}
		if (buro_mikado_options()->getOptionValue('header_dark_search_icon_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-dark-header .mkd-page-header > div:not(.mkd-sticky-header) .mkd-search-opener:hover,
			.mkd-dark-header.mkd-header-style-on-scroll .mkd-page-header .mkd-search-opener:hover,
			.mkd-dark-header .mkd-top-bar .mkd-search-opener:hover', array(
				'color' => buro_mikado_options()->getOptionValue('header_dark_search_icon_hover_color') . ' !important'
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_opener_icon_colors');

}

if (!function_exists('buro_mikado_search_opener_icon_background_colors')) {

	function buro_mikado_search_opener_icon_background_colors()
	{

		if (buro_mikado_options()->getOptionValue('search_icon_background_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-opener', array(
				'background-color' => buro_mikado_options()->getOptionValue('search_icon_background_color')
			));
		}

		if (buro_mikado_options()->getOptionValue('search_icon_background_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-opener:hover', array(
				'background-color' => buro_mikado_options()->getOptionValue('search_icon_background_hover_color')
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_opener_icon_background_colors');
}

if (!function_exists('buro_mikado_search_opener_text_styles')) {

	function buro_mikado_search_opener_text_styles()
	{
		$text_styles = array();

		if (buro_mikado_options()->getOptionValue('search_icon_text_color') !== '') {
			$text_styles['color'] = buro_mikado_options()->getOptionValue('search_icon_text_color');
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_fontsize') !== '') {
			$text_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_icon_text_fontsize')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_lineheight') !== '') {
			$text_styles['line-height'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_icon_text_lineheight')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_texttransform') !== '') {
			$text_styles['text-transform'] = buro_mikado_options()->getOptionValue('search_icon_text_texttransform');
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_google_fonts') !== '-1') {
			$text_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('search_icon_text_google_fonts')) . ', sans-serif';
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_fontstyle') !== '') {
			$text_styles['font-style'] = buro_mikado_options()->getOptionValue('search_icon_text_fontstyle');
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_fontweight') !== '') {
			$text_styles['font-weight'] = buro_mikado_options()->getOptionValue('search_icon_text_fontweight');
		}		
		if (buro_mikado_options()->getOptionValue('search_icon_text_letterspacing') !== '') {
			$text_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_icon_text_letterspacing')).'px';
		}

		if (!empty($text_styles)) {
			echo buro_mikado_dynamic_css('.mkd-search-icon-text', $text_styles);
		}
		if (buro_mikado_options()->getOptionValue('search_icon_text_color_hover') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-opener:hover .mkd-search-icon-text', array(
				'color' => buro_mikado_options()->getOptionValue('search_icon_text_color_hover')
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_opener_text_styles');
}

if (!function_exists('buro_mikado_search_opener_spacing')) {

	function buro_mikado_search_opener_spacing()
	{
		$spacing_styles = array();

		if (buro_mikado_options()->getOptionValue('search_padding_left') !== '') {
			$spacing_styles['padding-left'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_padding_left')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_padding_right') !== '') {
			$spacing_styles['padding-right'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_padding_right')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_margin_left') !== '') {
			$spacing_styles['margin-left'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_margin_left')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_margin_right') !== '') {
			$spacing_styles['margin-right'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_margin_right')) . 'px';
		}

		if (!empty($spacing_styles)) {
			echo buro_mikado_dynamic_css('.mkd-search-opener', $spacing_styles);
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_opener_spacing');
}

if (!function_exists('buro_mikado_search_bar_background')) {

	function buro_mikado_search_bar_background()
	{

		if (buro_mikado_options()->getOptionValue('search_background_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover, .mkd-search-fade .mkd-fullscreen-search-holder .mkd-fullscreen-search-table, .mkd-fullscreen-search-overlay', array(
				'background-color' => buro_mikado_options()->getOptionValue('search_background_color')
			));
		}
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_bar_background');
}

if (!function_exists('buro_mikado_search_text_styles')) {

	function buro_mikado_search_text_styles()
	{
		$text_styles = array();

		if (buro_mikado_options()->getOptionValue('search_text_color') !== '') {
			$text_styles['color'] = buro_mikado_options()->getOptionValue('search_text_color');
			$placeholder_webkit = array(
				'.mkd-search-cover input[type="text"]::-webkit-input-placeholder',
				'.mkd-form-holder .mkd-search-field::-webkit-input-placeholder',
				'.mkd-fullscreen-search-opened .mkd-form-holder .mkd-search-field::-webkit-input-placeholder'
			);
			$placeholder_moz1 = array(
				'.mkd-search-cover input[type="text"]:-moz-input-placeholder',
				'.mkd-form-holder .mkd-search-field:-moz-input-placeholder',
				'mkd-fullscreen-search-opened .mkd-form-holder .mkd-search-field:-moz-input-placeholder'
			);
			$placeholder_moz2 = array(
				'.mkd-search-cover input[type="text"]::-moz-input-placeholder',
				'.mkd-form-holder .mkd-search-field::-moz-input-placeholder',
				'mkd-fullscreen-search-opened .mkd-form-holder .mkd-search-field::-moz-input-placeholder'
			);
			$placeholder_ms = array(
				'.mkd-search-cover input[type="text"]:-ms-input-placeholder',
				'.mkd-form-holder .mkd-search-field:-ms-input-placeholder',
				'mkd-fullscreen-search-opened .mkd-form-holder .mkd-search-field:-ms-input-placeholder'
			);
			echo buro_mikado_dynamic_css($placeholder_webkit,array('color' => $text_styles['color']));
			echo buro_mikado_dynamic_css($placeholder_moz1,array('color' => $text_styles['color']));
			echo buro_mikado_dynamic_css($placeholder_moz2,array('color' => $text_styles['color']));
			echo buro_mikado_dynamic_css($placeholder_ms,array('color' => $text_styles['color']));
		}
		if (buro_mikado_options()->getOptionValue('search_text_fontsize') !== '') {
			$text_styles['font-size'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_text_fontsize')) . 'px';
		}
		if (buro_mikado_options()->getOptionValue('search_text_texttransform') !== '') {
			$text_styles['text-transform'] = buro_mikado_options()->getOptionValue('search_text_texttransform');
		}
		if (buro_mikado_options()->getOptionValue('search_text_google_fonts') !== '-1') {
			$text_styles['font-family'] = buro_mikado_get_formatted_font_family(buro_mikado_options()->getOptionValue('search_text_google_fonts')) . ', sans-serif';
		}
		if (buro_mikado_options()->getOptionValue('search_text_fontstyle') !== '') {
			$text_styles['font-style'] = buro_mikado_options()->getOptionValue('search_text_fontstyle');
		}
		if (buro_mikado_options()->getOptionValue('search_text_fontweight') !== '') {
			$text_styles['font-weight'] = buro_mikado_options()->getOptionValue('search_text_fontweight');
		}
		if (buro_mikado_options()->getOptionValue('search_text_letterspacing') !== '') {
			$text_styles['letter-spacing'] = buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_text_letterspacing')) . 'px';
		}

		if (!empty($text_styles)) {
			echo buro_mikado_dynamic_css('.mkd-search-cover input[type="text"], .mkd-fullscreen-search-opened .mkd-form-holder .mkd-search-field', $text_styles);
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_text_styles');
}

if (!function_exists('buro_mikado_search_icon_styles')) {

	function buro_mikado_search_icon_styles()
	{

		if (buro_mikado_options()->getOptionValue('search_icon_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover input[type="submit"], .mkd-fullscreen-search-holder .mkd-search-submit', array(
				'color' => buro_mikado_options()->getOptionValue('search_icon_color')
			));
		}
		if (buro_mikado_options()->getOptionValue('search_icon_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover input[type="submit"]:hover, .mkd-fullscreen-search-holder .mkd-search-submit:hover', array(
				'color' => buro_mikado_options()->getOptionValue('search_icon_hover_color')
			));
		}
		if (buro_mikado_options()->getOptionValue('search_icon_size') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover input[type="submit"], .mkd-fullscreen-search-holder .mkd-search-submit', array(
				'font-size' => buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_icon_size')) . 'px'
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_icon_styles');
}

if (!function_exists('buro_mikado_search_close_icon_styles')) {

	function buro_mikado_search_close_icon_styles()
	{

		if (buro_mikado_options()->getOptionValue('search_close_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover .mkd-search-close a, .mkd-fullscreen-search-holder .mkd-fullscreen-search-close-container a', array(
				'color' => buro_mikado_options()->getOptionValue('search_close_color')
			));
		}
		if (buro_mikado_options()->getOptionValue('search_close_hover_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover .mkd-search-close a:hover, .mkd-fullscreen-search-holder .mkd-fullscreen-search-close-container a:hover', array(
				'color' => buro_mikado_options()->getOptionValue('search_close_hover_color')
			));
		}
		if (buro_mikado_options()->getOptionValue('search_close_size') !== '') {
			echo buro_mikado_dynamic_css('.mkd-search-cover .mkd-search-close a, .mkd-fullscreen-search-holder .mkd-fullscreen-search-close-container a', array(
				'font-size' => buro_mikado_filter_px(buro_mikado_options()->getOptionValue('search_close_size')) . 'px'
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_close_icon_styles');
}

if (!function_exists('buro_mikado_search_border_styles')) {

	function buro_mikado_search_border_styles()
	{

		if (buro_mikado_options()->getOptionValue('search_border_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-fullscreen-search-holder .mkd-field-holder', array(
				'border-color' => buro_mikado_options()->getOptionValue('search_border_color')
			));
		}
		if (buro_mikado_options()->getOptionValue('search_border_focus_color') !== '') {
			echo buro_mikado_dynamic_css('.mkd-fullscreen-search-holder .mkd-field-holder .mkd-line', array(
				'background-color' => buro_mikado_options()->getOptionValue('search_border_focus_color')
			));
		}

	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_search_border_styles');
}

?>
