<?php

if ( ! function_exists('buro_mikado_woocommerce_options_map') ) {

	/**
	 * Add Woocommerce options page
	 */
	function buro_mikado_woocommerce_options_map() {

		buro_mikado_add_admin_page(
			array(
				'slug' => '_woocommerce_page',
				'title' =>  esc_html__('Woocommerce', 'buro'),
				'icon' => 'fa fa-shopping-cart'
			)
		);

		/**
		 * Product List Settings
		 */
		$panel_product_list = buro_mikado_add_admin_panel(
			array(
				'page' => '_woocommerce_page',
				'name' => 'panel_product_list',
				'title' => esc_html__('Product List', 'buro'),
			)
		);

		buro_mikado_add_admin_field(array(
			'name'        	=> 'mkd_woo_products_list_full_width',
			'type'        	=> 'yesno',
			'label'       	=> esc_html__('Enable Full Width Template', 'buro'),
			'default_value'	=> 'no',
			'description' 	=> esc_html__('Enabling this option will enable full width template for shop page', 'buro'),
			'parent'      	=> $panel_product_list,
		));

		buro_mikado_add_admin_field(array(
			'name'        	=> 'mkd_woo_product_list_columns',
			'type'        	=> 'select',
			'label'       	=> esc_html__('Product List Columns', 'buro'),
			'default_value'	=> 'mkd-woocommerce-columns-3',
			'description' 	=> esc_html__('Choose number of columns for product listing and related products on single product', 'buro'),
			'options'		=> array(
				'mkd-woocommerce-columns-3' => esc_html__('3 Columns (2 with sidebar)', 'buro'),
				'mkd-woocommerce-columns-4' => esc_html__('4 Columns (3 with sidebar)', 'buro'),
			),
			'parent'      	=> $panel_product_list,
		));

		buro_mikado_add_admin_field(array(
			'name'        	=> 'mkd_woo_products_per_page',
			'type'        	=> 'text',
			'label'       	=> esc_html__('Number of products per page', 'buro'),
			'default_value'	=> '',
			'description' 	=> esc_html__('Set number of products on shop page', 'buro'),
			'parent'      	=> $panel_product_list,
			'args' 			=> array(
				'col_width' => 3
			)
		));

		buro_mikado_add_admin_field(array(
			'name'        	=> 'mkd_products_list_title_tag',
			'type'        	=> 'select',
			'label'       	=> esc_html__('Products Title Tag', 'buro'),
			'default_value'	=> 'h5',
			'description' 	=> '',
			'options'		=> array(
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
			),
			'parent'      	=> $panel_product_list,
		));

		/**
		 * Single Product Settings
		 */
		$panel_single_product = buro_mikado_add_admin_panel(
			array(
				'page' => '_woocommerce_page',
				'name' => 'panel_single_product',
				'title' => esc_html__('Single Product','buro'),
			)
		);

		buro_mikado_add_admin_field(array(
			'name'        	=> 'mkd_single_product_title_tag',
			'type'        	=> 'select',
			'label'       	=> esc_html__('Single Product Title Tag', 'buro'),
			'default_value'	=> 'h3',
			'description' 	=> '',
			'options'		=> array(
				'h1' => 'h1',
				'h2' => 'h2',
				'h3' => 'h3',
				'h4' => 'h4',
				'h5' => 'h5',
				'h6' => 'h6',
			),
			'parent'      	=> $panel_single_product,
		));

		buro_mikado_add_admin_field(
			array(
				'type' => 'yesno',
				'name' => 'product_single_navigation',
				'default_value' => 'no',
				'label' => esc_html__('Enable Prev/Next Single Product Navigation Links', 'buro'),
				'parent' => $panel_single_product,
				'description' => esc_html__('Enable navigation links through the products', 'buro'),
				'args' => array(
					'dependence' => true,
					'dependence_hide_on_yes' => '',
					'dependence_show_on_yes' => '#mkd_mkd_product_single_navigation_container'
				)
			)
		);

		$product_single_navigation_container = buro_mikado_add_admin_container(
			array(
				'name' => 'mkd_product_single_navigation_container',
				'hidden_property' => 'product_single_navigation',
				'hidden_value' => 'no',
				'parent' => $panel_single_product,
			)
		);

		buro_mikado_add_admin_field(
			array(
				'type'        => 'yesno',
				'name' => 'product_navigation_through_same_category',
				'default_value' => 'yes',
				'label'       => esc_html__('Enable Navigation Only in Current Category', 'buro'),
				'description' => esc_html__('Limit your navigation only through current category', 'buro'),
				'parent'      => $product_single_navigation_container,
				'args' => array(
					'col_width' => 3
				)
			)
		);

	}

	add_action( 'buro_mikado_options_map', 'buro_mikado_woocommerce_options_map', 19);

}