<?php

if (!function_exists('buro_mikado_woocommerce_products_per_page')) {
	/**
	 * Function that sets number of products per page. Default is 12
	 * @return int number of products to be shown per page
	 */
	function buro_mikado_woocommerce_products_per_page() {

		$products_per_page = 12;

		if (buro_mikado_options()->getOptionValue('mkd_woo_products_per_page')) {
			$products_per_page = buro_mikado_options()->getOptionValue('mkd_woo_products_per_page');
		}

		return $products_per_page;

	}

}

if (!function_exists('buro_mikado_woocommerce_related_products_args')) {
	/**
	 * Function that sets number of displayed related products. Hooks to woocommerce_output_related_products_args filter
	 * @param $args array array of args for the query
	 * @return mixed array of changed args
	 */
	function buro_mikado_woocommerce_related_products_args($args) {

		if (buro_mikado_options()->getOptionValue('mkd_woo_product_list_columns')) {

			$related = buro_mikado_options()->getOptionValue('mkd_woo_product_list_columns');
			switch ($related) {
				case 'mkd-woocommerce-columns-4':
					$args['posts_per_page'] = 8;
					break;
				case 'mkd-woocommerce-columns-3':
					$args['posts_per_page'] = 6;
					break;
				default:
					$args['posts_per_page'] = 6;
			}

		} else {
			$args['posts_per_page'] = 6;
		}

		return $args;

	}

}

if (!function_exists('buro_mikado_woocommerce_template_loop_product_title')) {
	/**
	 * Function for overriding product title template in Product List Loop
	 */
	function buro_mikado_woocommerce_template_loop_product_title() {

		$tag = buro_mikado_options()->getOptionValue('mkd_products_list_title_tag');
		the_title('<' . $tag . ' class="mkd-product-list-product-title"><a href="'.get_the_permalink().'">', '</a></' . $tag . '>');

	}

}

if (!function_exists('buro_mikado_woocommerce_template_single_title')) {
	/**
	 * Function for overriding product title template in Single Product template
	 */
	function buro_mikado_woocommerce_template_single_title() {

		$tag = buro_mikado_options()->getOptionValue('mkd_single_product_title_tag');
		the_title('<' . $tag . '  itemprop="name" class="mkd-single-product-title">', '</' . $tag . '>');

	}

}

if (!function_exists('buro_mikado_woocommerce_sale_flash')) {
	/**
	 * Function for overriding Sale Flash Template
	 *
	 * @return string
	 */
	function buro_mikado_woocommerce_sale_flash() {

        global $product;
        $availability = $product->get_availability();

        if ( !$product->is_in_stock() && WC_Admin_Settings::get_option( 'woocommerce_notify_no_stock')=='yes') {
            return apply_filters( 'woocommerce_stock_html', '<span class="mkd-product-badge mkd-out-of-stock ' . esc_attr( $availability['class'] ) . '"><span class="mkd-product-badge-inner mkd-out-of-stock-inner">' . esc_html( $availability['availability'] ) . '</span></span>', $availability['availability'] );
        }else{
		    return '<span class="mkd-product-badge mkd-onsale"><span class="mkd-product-badge-inner mkd-onsale-inner">' . esc_html__('Sale', 'buro') . '</span></span>';
        }
	}

}

if (!function_exists('buro_mikado_woocommerce_out_of_stock_flash')) {
	/**
	 * Function for overriding Out of Stock badge
	 *
	 * @return string
	 */
	function buro_mikado_woocommerce_out_of_stock_flash() {

		global $product;
		$availability = $product->get_availability();

		if ( !$product->is_in_stock() && WC_Admin_Settings::get_option( 'woocommerce_notify_no_stock')=='yes') {
			print apply_filters( 'woocommerce_stock_html', '<span class="mkd-product-badge mkd-out-of-stock ' . esc_attr( $availability['class'] ) . '"><span class="mkd-product-badge-inner mkd-out-of-stock-inner">' . esc_html__('Sold', 'buro') . '</span></span>', $availability['availability'] );
		}
	}

}

if (!function_exists('buro_mikado_custom_override_checkout_fields')) {
	/**
	 * Overrides placeholder values for checkout fields
	 * @param array all checkout fields
	 * @return array checkout fields with overriden values
	 */
	function buro_mikado_custom_override_checkout_fields($fields) {
		//billing fields
		$args_billing = array(
			'first_name'	=> esc_html__('First name','buro'),
			'last_name'		=> esc_html__('Last name','buro'),
			'company'		=> esc_html__('Company name','buro'),
			'address_1'		=> esc_html__('Address','buro'),
			'email'			=> esc_html__('Email','buro'),
			'phone'			=> esc_html__('Phone','buro'),
			'postcode'		=> esc_html__('Postcode / ZIP','buro'),
			'state'			=> esc_html__('State / County', 'buro'),
			'city'          => esc_html__('Billing City', 'buro'),
		);

		//shipping fields
		$args_shipping = array(
			'first_name' => esc_html__('First name','buro'),
			'last_name'  => esc_html__('Last name','buro'),
			'company'    => esc_html__('Company name','buro'),
			'address_1'  => esc_html__('Address','buro'),
			'postcode'   => esc_html__('Postcode / ZIP','buro'),
			'state'		 => esc_html__('State / County', 'buro'),
			'city'       => esc_html__('Shipping City', 'buro'),
		);

		//override billing placeholder values
		foreach ($args_billing as $key => $value) {
			$fields["billing"]["billing_{$key}"]["placeholder"] = $value;
		}

		//override shipping placeholder values
		foreach ($args_shipping as $key => $value) {
			$fields["shipping"]["shipping_{$key}"]["placeholder"] = $value;
		}

		return $fields;
	}

}

if (!function_exists('buro_mikado_woocommerce_loop_add_to_cart_link')) {
	/**
	 * Function that overrides default woocommerce add to cart button on product list
	 * Uses HTML from mkd_button
	 *
	 * @return mixed|string
	 */
	function buro_mikado_woocommerce_loop_add_to_cart_link() {

		global $product;

		$add_to_cart_button = '';
		$button_text = '';
		$product_type = '';
		$product_id = '';

		$button_url = $product->add_to_cart_url();

		if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
			$product_type = $product->get_type();
			$product_id = $product->get_id();
		} else {
			$product_type = $product->product_type;
			$product_id = $product->get_id();
		}


		$button_classes = sprintf('%s product_type_%s %s',
			$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : 'mkd-view-product',
			esc_attr( $product_type ),
			esc_attr($product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart ' : ' ')
		);
		//$button_text = $product->add_to_cart_text();
		$button_attrs = array(
			'rel' => 'nofollow',
			'data-product_id' => esc_attr( $product_id ),
			'data-product_sku' => esc_attr( $product->get_sku() ),
			'data-quantity' => esc_attr( isset( $quantity ) ? $quantity : 1 )
		);



		if ($product->is_purchasable() && $product->is_in_stock()){
			$button_text = esc_html__('Add to cart','buro');
		}
		else{
			$button_text = esc_html__('View Product','buro');
		}

		$add_to_cart_button = buro_mikado_get_button_html(
			array(
				'link'			=> $button_url,
				'custom_class'	=> $button_classes,
				'custom_attrs'	=> $button_attrs,
				'size'			=> 'huge-full-width',
				'text'			=> $button_text
			)
		);

		return $add_to_cart_button;

	}

}

if (!function_exists('buro_mikado_get_woocommerce_add_to_cart_button')) {
	/**
	 * Function that overrides default woocommerce add to cart button on simple and grouped product single template
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_get_woocommerce_add_to_cart_button() {

		global $product;

		$add_to_cart_button = buro_mikado_get_button_html(
			array(
				'custom_class'	=> 'single_add_to_cart_button alt',
				'text'			=> $product->single_add_to_cart_text(),
				'html_type'		=> 'button',
                'type'          => 'solid',
                'size'          => 'small'
			)
		);

		print buro_mikado_display_content_output($add_to_cart_button);

	}

}

if (!function_exists('buro_mikado_get_woocommerce_add_to_cart_button_external')) {
	/**
	 * Function that overrides default woocommerce add to cart button on external product single template
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_get_woocommerce_add_to_cart_button_external() {

		global $product;

		$add_to_cart_button = buro_mikado_get_button_html(
			array(
				'link'			=> $product->add_to_cart_url(),
				'custom_class'	=> 'single_add_to_cart_button alt',
				'text'			=> $product->single_add_to_cart_text(),
				'size'			=> 'large',
				'custom_attrs'	=> array(
					'rel' 		=> 'nofollow'
				)
			)
		);

		print buro_mikado_display_content_output($add_to_cart_button);

	}

}

if ( ! function_exists('buro_mikado_woocommerce_single_variation_add_to_cart_button') ) {
	/**
	 * Function that overrides default woocommerce add to cart button on variable product single template
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_woocommerce_single_variation_add_to_cart_button() {
		global $product;

		$product_id = '';


		if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
			$product_id = $product->get_id();
		} else{
			$product_id = $product->get_id();
		}

		$html = '<div class="variations_button">';
		woocommerce_quantity_input( array( 'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : 1 ) );

		$button = buro_mikado_get_button_html(array(
			'html_type'		=> 'button',
			'custom_class'	=> 'single_add_to_cart_button alt',
			'text'			=> $product->single_add_to_cart_text(),
			'size'			=> 'large',
		));

		$html .= $button;

		$html .= '<input type="hidden" name="add-to-cart" value="' . absint( $product_id ) . '" />';
		$html .= '<input type="hidden" name="product_id" value="' . absint( $product_id ) . '" />';
		$html .= '<input type="hidden" name="variation_id" class="variation_id" value="" />';
		$html .= '</div>';

		print buro_mikado_display_content_output($html);

	}

}

if (!function_exists('buro_mikado_get_woocommerce_apply_coupon_button')) {
	/**
	 * Function that overrides default woocommerce apply coupon button
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_get_woocommerce_apply_coupon_button() {

		$coupon_button = buro_mikado_get_button_html(array(
			'html_type'		=> 'input',
			'input_name'	=> 'apply_coupon',
			'size'			=> 'small',
			'text'			=> esc_html__( 'Apply Coupon', 'buro' ),
			'type'          => 'solid'
		));

		print buro_mikado_display_content_output($coupon_button);

	}

}

if (!function_exists('buro_mikado_get_woocommerce_update_cart_button')) {
	/**
	 * Function that overrides default woocommerce update cart button
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_get_woocommerce_update_cart_button() {

		$update_cart_button = buro_mikado_get_button_html(array(
			'html_type'		=> 'input',
			'input_name'	=> 'update_cart',
			'size'			=> 'small',
			'text'			=> esc_html__( 'Update Cart', 'buro' ),
			'type'          => 'solid'
		));

		print buro_mikado_display_content_output($update_cart_button);

	}

}

if (!function_exists('buro_mikado_woocommerce_button_proceed_to_checkout')) {
	/**
	 * Function that overrides default woocommerce proceed to checkout button
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_woocommerce_button_proceed_to_checkout() {

		$proceed_to_checkout_button = buro_mikado_get_button_html(array(
			'link'			=> get_permalink(get_option('woocommerce_checkout_page_id')),
			'custom_class'	=> 'checkout-button alt wc-forward',
			'text'			=> esc_html__( 'Proceed to Checkout', 'buro' ),
			'type'          => 'solid'
		));

		print buro_mikado_display_content_output($proceed_to_checkout_button);

	}

}

if (!function_exists('buro_mikado_get_woocommerce_update_totals_button')) {
	/**
	 * Function that overrides default woocommerce update totals button
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_get_woocommerce_update_totals_button() {

		$update_totals_button = buro_mikado_get_button_html(array(
			'html_type'		=> 'button',
			'text'			=> esc_html__( 'Update Totals', 'buro' ),
			'custom_attrs'	=> array(
				'value'		=> 1,
				'name'		=> 'calc_shipping'
			),
			'type'          => 'solid'
		));

		print buro_mikado_display_content_output($update_totals_button);

	}

}

if (!function_exists('buro_mikado_woocommerce_pay_order_button_html')) {
	/**
	 * Function that overrides default woocommerce pay order button on checkout page
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_woocommerce_pay_order_button_html() {

		$pay_order_button_text = esc_html__('Pay for order', 'buro');

		$place_order_button = buro_mikado_get_button_html(array(
			'html_type'		=> 'input',
			'custom_class'	=> 'alt',
			'custom_attrs'	=> array(
				'id'			=> 'place_order',
				'data-value'	=> $pay_order_button_text
			),
			'text'			=> $pay_order_button_text,
			'type'          => 'solid'
		));

		return $place_order_button;

	}

}

if (!function_exists('buro_mikado_woocommerce_order_button_html')) {
	/**
	 * Function that overrides default woocommerce place order button on checkout page
	 * Uses HTML from mkd_button
	 */
	function buro_mikado_woocommerce_order_button_html() {

		$pay_order_button_text = esc_html__('Place Order', 'buro');

		$place_order_button = buro_mikado_get_button_html(array(
			'html_type'		=> 'input',
			'custom_class'	=> 'alt',
			'custom_attrs'	=> array(
				'id'			=> 'place_order',
				'data-value'	=> $pay_order_button_text,
				'name'			=> 'woocommerce_checkout_place_order'
			),
			'text'			=> $pay_order_button_text,
			'type'          => 'solid'
		));

		return $place_order_button;

	}

}

if (!function_exists('buro_mikado_woocommerce_new_single_thumbnails_html')) {
	/**
	 * Function that overrides default woocommerce thumbnails on single page
	 */
	function buro_mikado_woocommerce_new_single_thumbnails_html($sprintf, $attachment_id) {
		$image_url = wp_get_attachment_url($attachment_id);
		$wp_get_attachment_image = wp_get_attachment_image($attachment_id,apply_filters('single_product_small_thumbnail_size', 'shop_thumbnail'));

		$new_sprintf = sprintf( '<a href="%s" >%s</a>', $image_url, $wp_get_attachment_image);

		return $new_sprintf; 

	}
}

if (!function_exists('buro_mikado_woocommerce_single_thumbnails_html')) {
	/**
	 * Function that overrides default woocommerce thumbnails on single page
	 */
	function buro_mikado_woocommerce_single_thumbnails_html($sprintf, $attachment_id, $post_id, $image_class) {
		$image_url = wp_get_attachment_url($attachment_id);
		$wp_get_attachment_image = wp_get_attachment_image($attachment_id,apply_filters('single_product_small_thumbnail_size', 'shop_thumbnail'));

		$new_sprintf = sprintf( '<a href="%s" class="%s">%s</a>', $image_url, $image_class, $wp_get_attachment_image);

		return $new_sprintf; 

	}

}


if (!function_exists('buro_mikado_woocommerce_single_review_form')) {

    /**
     * Function that overrides default woocommerce single product review form
     * Adds placeholders
     *
     * @param $comment_form
     * @return mixed
     */
    function buro_mikado_woocommerce_single_review_form($comment_form) {

        $commenter = wp_get_current_commenter();

        if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
            $comment_form['comment_field'] = '<p class="comment-form-rating"><label for="rating">' . esc_html__( 'Your Rating', 'buro' ) .'</label><select name="rating" id="rating">
				<option value="">' . esc_html__( 'Rate&hellip;', 'buro' ) . '</option>
				<option value="5">' . esc_html__( 'Perfect', 'buro' ) . '</option>
				<option value="4">' . esc_html__( 'Good', 'buro' ) . '</option>
				<option value="3">' . esc_html__( 'Average', 'buro' ) . '</option>
				<option value="2">' . esc_html__( 'Not that bad', 'buro' ) . '</option>
				<option value="1">' . esc_html__( 'Very Poor', 'buro' ) . '</option>
			</select></p>';
        }

        $comment_form['comment_field'] .= '<textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" placeholder="'. esc_attr__( "Your Message", "buro" ).'"></textarea>';

        $comment_form['label_submit'] = esc_html__( 'Send', 'buro' );

        $comment_form['fields'] = array(
            'author' => '<div class="mkd-two-columns-50-50 clearfix"><div class="mkd-two-columns-50-50-inner"><div class="mkd-column"><div class="mkd-column-inner"> ' .
                '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" placeholder="'. esc_attr__( "Your Name", "buro" ).'*"/>'.
                '</div></div>',
            'email'  => '<div class="mkd-column"><div class="mkd-column-inner"> ' .
                '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" placeholder="'. esc_attr__( "Your Email", "buro" ).'*"/>'.
                '</div></div></div></div>'
        );

        return $comment_form;
    }
}

if(!function_exists('buro_mikado_woocommerce_review_display_gravatar')){

	function buro_mikado_woocommerce_review_display_gravatar($comment){
		echo get_avatar( $comment, apply_filters( 'woocommerce_review_gravatar_size', '120' ), '' );
	}

}

if (!function_exists('buro_mikado_woocommerce_review_display_meta')) {

    /**
     * Function that overrides default woocommerce review display meta
     * Adds placeholders
     *
     * @param $comment_form
     * @return mixed
     */
    function buro_mikado_woocommerce_review_display_meta($comment_form) {
		global $comment;

		$verified = wc_review_is_from_verified_owner( $comment->comment_ID );

		if ( '0' === $comment->comment_approved ) { ?>

				<p class="meta"><em><?php _e( 'Your comment is awaiting approval', 'buro' ); ?></em></p>

		<?php } else { ?>

			<p class="meta mkd-product-comment-meta">
				<strong class="mkd-product-comment-author" itemprop="author"><?php comment_author(); ?></strong> <?php

					if ( get_option( 'woocommerce_review_rating_verification_label' ) === 'yes' )
						if ( $verified )
							echo '<em class="verified">(' . esc_html__( 'verified owner', 'buro' ) . ')</em> ';

				?><time class="mkd-product-comment-date" itemprop="datePublished" datetime="<?php echo get_comment_date( 'c' ); ?>"><?php echo get_comment_date( wc_date_format() ); ?></time>
			</p>

		<?php }
    }
}

if (!function_exists('buro_mikado_woocommerce_product_categories')) {
    /**
     * Function that displays product categories
     */
    function buro_mikado_woocommerce_product_categories(){
		global $product;

		if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
			$product_categories = wc_get_product_category_list( $product->get_id(), ', ' );
		} else {
			$product_categories = $product->get_categories(', ');
		}

		if ($product_categories != '') { ?>
			<div class="mkd-product-cat">
				<?php echo wp_kses($product_categories, array(
					'a' => array(
						'href' => true,
						'rel' => true,
						'class' => true,
						'title' => true,
						'id' => true
					)
				)); ?>
			</div>
		<?php }
    }
}

if(!function_exists('buro_mikado_woocommerce_out_of_stock_price_list')){
    /**
     * Remove product price if its out of stock (in case that user leaves the price) on list
     */
    function buro_mikado_woocommerce_out_of_stock_price_list(){
        global $product;

        if ( !$product->is_in_stock()) {
            remove_action('woocommerce_shop_loop_item_title','woocommerce_template_loop_price',10);
        }else{
            add_action('woocommerce_shop_loop_item_title','woocommerce_template_loop_price',10);
        }
    }
}

if(!function_exists('buro_mikado_woocommerce_out_of_stock_price_single')){
    /**
     * Remove product price if its out of stock (in case that user leaves the price) on single product
     */
    function buro_mikado_woocommerce_out_of_stock_price_single(){
        global $product;

        if ( !$product->is_in_stock()) {
            remove_action('woocommerce_single_product_summary','woocommerce_template_single_price',10);
        }else{
            add_action('woocommerce_single_product_summary','woocommerce_template_single_price',10);
        }
    }
}

if(!function_exists('buro_mikado_woocommerce_product_navigation')){
    function buro_mikado_woocommerce_product_navigation(){
        if (is_product() && buro_mikado_options()->getOptionValue('product_single_navigation') == 'yes') {
            $navigation_product_through_category = buro_mikado_options()->getOptionValue('product_navigation_through_same_category'); ?>
            <div class="mkd-product-single-navigation mkd-two-columns-50-50">
                <div class="mkd-product-single-navigation-inner mkd-two-columns-50-50-inner clearfix">
                    <div class="mkd-column">
	                    <?php if ( get_previous_post() != "" ) { ?>
		                    <div class="mkd-product-single-prev mkd-column-inner">
			                    <?php
			                    if ( $navigation_product_through_category == 'yes' ) {
				                    previous_post_link( '%link', '<span class="arrow_carrot-left"></span>'.esc_html__( 'Previous Product', 'buro' ), true, '', 'product_cat' );
			                    } else {
				                    previous_post_link( '%link', '<span class="arrow_carrot-left"></span>'.esc_html__( 'Previous Product', 'buro' ) );
			                    }
			                    ?>
		                    </div>
	                    <?php } ?>
                    </div>
                    <div class="mkd-column">
	                    <?php if ( get_next_post() != "" ) { ?>
		                    <div class="mkd-product-single-next mkd-column-inner">
			                    <?php
			                    if ( $navigation_product_through_category == 'yes' ) {
				                    next_post_link( '%link', esc_html__( 'Next Product', 'buro' ).'<span class="arrow_carrot-right"></span>', true, '', 'product_cat' );
			                    } else {
				                    next_post_link( '%link', esc_html__( 'Next Product', 'buro' ).'<span class="arrow_carrot-right"></span>' );
			                    }
			                    ?>
		                    </div>
	                    <?php } ?>
                    </div>
                </div>
            </div>
        <?php }
    }
}

if(!function_exists('buro_mikado_woocommerce_before_thumbnails')){
	function buro_mikado_woocommerce_before_thumbnails(){
		print '<div class="thumbnails columns-3">';
	}
}

if(!function_exists('buro_mikado_woocommerce_after_thumbnails')){
	function buro_mikado_woocommerce_after_thumbnails(){
		print '</div>';
	}
}

if (!function_exists('buro_mikado_woocommerce_review_comment_form_args')){
	function buro_mikado_woocommerce_review_comment_form_args($args){
		$args['title_reply_before'] = '<h3 id="reply-title" class="comment-reply-title">';
		$args['title_reply_after'] = '</h3>';

		return $args;
	}
}