<?php
include_once get_template_directory() . '/theme-includes.php';

if (!function_exists('buro_mikado_styles')) {
    /**
     * Function that includes theme's core styles
     */
    function buro_mikado_styles() {
        wp_register_style('buro-mikado-blog', MIKADO_ASSETS_ROOT . '/css/blog.min.css');

        //include theme's core styles
        wp_enqueue_style('buro-mikado-default-style', MIKADO_ROOT . '/style.css');
        wp_enqueue_style('buro-mikado-modules-plugins', MIKADO_ASSETS_ROOT . '/css/plugins.min.css');
        wp_enqueue_style('buro-mikado-modules', MIKADO_ASSETS_ROOT . '/css/modules.min.css');

        buro_mikado_icon_collections()->enqueueStyles();

        if (buro_mikado_load_blog_assets()) {
            wp_enqueue_style('buro-mikado-blog');
        }

        if (buro_mikado_load_blog_assets() || is_singular('portfolio-item')) {
            wp_enqueue_style('wp-mediaelement');
        }

        //define files afer which style dynamic needs to be included. It should be included last so it can override other files
        $style_dynamic_deps_array = array();

        //is woocommerce installed?
        if (buro_mikado_is_woocommerce_installed()) {
            if (buro_mikado_load_woo_assets()) {

                $style_dynamic_deps_array[] = 'buro-mikado-woocommerce';

                //include theme's woocommerce styles
                wp_enqueue_style('buro-mikado-woocommerce', MIKADO_ASSETS_ROOT . '/css/woocommerce.min.css');


                //is responsive option turned on?
                if (buro_mikado_options()->getOptionValue('responsiveness') == 'yes') {
                    $style_dynamic_deps_array[] = 'buro-mikado-woocommerce-responsive';
                    //include theme's woocommerce responsive styles
                    wp_enqueue_style('buro-mikado-woocommerce-responsive', MIKADO_ASSETS_ROOT . '/css/woocommerce-responsive.min.css');
                }
            }
        }


        //is responsive option turned on?
        if (buro_mikado_is_responsive_on()) {
            wp_enqueue_style('buro-mikado-modules-responsive', MIKADO_ASSETS_ROOT . '/css/modules-responsive.min.css');
            wp_enqueue_style('buro-mikado-blog-responsive', MIKADO_ASSETS_ROOT . '/css/blog-responsive.min.css');

            //include proper styles
            if (file_exists(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_responsive.css') && buro_mikado_is_css_folder_writable() && !is_multisite()) {
                wp_enqueue_style('buro-mikado-style-dynamic-responsive', MIKADO_ASSETS_ROOT . '/css/style_dynamic_responsive.css', array(), filemtime(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_responsive.css'));
            } elseif (file_exists(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_responsive_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css') && buro_mikado_is_css_folder_writable() && is_multisite()) {
                wp_enqueue_style('buro-mikado-style-dynamic-responsive', MIKADO_ASSETS_ROOT . '/css/style_dynamic_responsive_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css', array(), filemtime(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_responsive_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css'));
            }
        }

        if (file_exists(MIKADO_ROOT_DIR . '/assets/css/style_dynamic.css') && buro_mikado_is_css_folder_writable() && !is_multisite()) {
            wp_enqueue_style('buro-mikado-style-dynamic', MIKADO_ASSETS_ROOT . '/css/style_dynamic.css', $style_dynamic_deps_array, filemtime(MIKADO_ROOT_DIR . '/assets/css/style_dynamic.css')); //it must be included after woocommerce styles so it can override it
        } else if (file_exists(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css') && buro_mikado_is_css_folder_writable() && is_multisite()) {
            wp_enqueue_style('buro-mikado-style-dynamic', MIKADO_ASSETS_ROOT . '/css/style_dynamic_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css', $style_dynamic_deps_array, filemtime(MIKADO_ROOT_DIR . '/assets/css/style_dynamic_ms_id_' . buro_mikado_get_multisite_blog_id() . '.css')); //it must be included after woocommerce styles so it can override it
        }

        //include Visual Composer styles
        if (class_exists('WPBakeryVisualComposerAbstract')) {
            wp_enqueue_style('js_composer_front');
        }
    }

    add_action('wp_enqueue_scripts', 'buro_mikado_styles');
}

if (!function_exists('buro_mikado_google_fonts_styles')) {
    /**
     * Function that includes google fonts defined anywhere in the theme
     */
    function buro_mikado_google_fonts_styles() {
        $font_simple_field_array = buro_mikado_options()->getOptionsByType('fontsimple');
        if (!(is_array($font_simple_field_array) && count($font_simple_field_array) > 0)) {
            $font_simple_field_array = array();
        }

        $font_field_array = buro_mikado_options()->getOptionsByType('font');
        if (!(is_array($font_field_array) && count($font_field_array) > 0)) {
            $font_field_array = array();
        }

        $available_font_options = array_merge($font_simple_field_array, $font_field_array);
        $font_weight_str = '100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';

        //define available font options array
        $fonts_array = array();
        foreach ($available_font_options as $font_option) {
            //is font set and not set to default and not empty?
            $font_option_value = buro_mikado_options()->getOptionValue($font_option);
            if (buro_mikado_is_font_option_valid($font_option_value) && !buro_mikado_is_native_font($font_option_value)) {
                $font_option_string = $font_option_value . ':' . $font_weight_str;
                if (!in_array($font_option_string, $fonts_array)) {
                    $fonts_array[] = $font_option_string;
                }
            }
        }

        $fonts_array = array_diff($fonts_array, array('-1:' . $font_weight_str));
        $google_fonts_string = implode('|', $fonts_array);

        //default fonts should be separated with %7C because of HTML validation
        $default_font_string = 'Prompt:' . $font_weight_str . '|Rubik:' . $font_weight_str;
        $protocol = is_ssl() ? 'https:' : 'http:';

        //is google font option checked anywhere in theme?
        if (count($fonts_array) > 0) {

            //include all checked fonts
            $fonts_full_list = $default_font_string . '|' . str_replace('+', ' ', $google_fonts_string);
            $fonts_full_list_args = array(
                'family' => urlencode($fonts_full_list),
                'subset' => urlencode('latin,latin-ext'),
            );

            $buro_mikado_fonts = add_query_arg($fonts_full_list_args, $protocol . '//fonts.googleapis.com/css');
            wp_enqueue_style('buro-mikado-google-fonts', esc_url_raw($buro_mikado_fonts), array(), '1.0.0');

        } else {
            //include default google font that theme is using
            $default_fonts_args = array(
                'family' => urlencode($default_font_string),
                'subset' => urlencode('latin,latin-ext'),
            );
            $buro_mikado_fonts = add_query_arg($default_fonts_args, $protocol . '//fonts.googleapis.com/css');
            wp_enqueue_style('buro-mikado-google-fonts', esc_url_raw($buro_mikado_fonts), array(), '1.0.0');
        }

    }

    add_action('wp_enqueue_scripts', 'buro_mikado_google_fonts_styles');
}

if (!function_exists('buro_mikado_scripts')) {
    /**
     * Function that includes all necessary scripts
     */
    function buro_mikado_scripts() {
        global $wp_scripts;

        //init theme core scripts
        wp_enqueue_script('jquery-ui-core');
        wp_enqueue_script('jquery-ui-tabs');
        wp_enqueue_script('jquery-ui-accordion');
        wp_enqueue_script('wp-mediaelement');

        //wp_enqueue_script('buro-mikado-third-party', MIKADO_ASSETS_ROOT . '/js/third-party.min.js', array('jquery'), false, true);
	    wp_enqueue_script( 'appear', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.appear.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'modernizr', MIKADO_ASSETS_ROOT . '/js/modules/plugins/modernizr.custom.85257.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'appear', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.hoverdir.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'hoverIntent', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.hoverIntent.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'jquery-plugin', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.plugin.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'countdown', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.countdown.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'parallax', MIKADO_ASSETS_ROOT . '/js/modules/plugins/parallax.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'select2', MIKADO_ASSETS_ROOT . '/js/modules/plugins/select2.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'easypiechart', MIKADO_ASSETS_ROOT . '/js/modules/plugins/easypiechart.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'waypoints', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.waypoints.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'Chart', MIKADO_ASSETS_ROOT . '/js/modules/plugins/Chart.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'counter', MIKADO_ASSETS_ROOT . '/js/modules/plugins/counter.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'fluidvids', MIKADO_ASSETS_ROOT . '/js/modules/plugins/fluidvids.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'prettyPhoto', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.prettyPhoto.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'nicescroll', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.nicescroll.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'ScrollToPlugin', MIKADO_ASSETS_ROOT . '/js/modules/plugins/ScrollToPlugin.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'TweenLite', MIKADO_ASSETS_ROOT . '/js/modules/plugins/TweenLite.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'TweenLite', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery-scrollspy.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'mixitup', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.mixitup.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'waitforimages', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.waitforimages.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'easing', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.easing.1.3.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'skrollr', MIKADO_ASSETS_ROOT . '/js/modules/plugins/skrollr.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'slick', MIKADO_ASSETS_ROOT . '/js/modules/plugins/slick.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'bootstrapCarousel', MIKADO_ASSETS_ROOT . '/js/modules/plugins/bootstrapCarousel.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'touchSwipe', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.touchSwipe.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'multiscroll', MIKADO_ASSETS_ROOT . '/js/modules/plugins/jquery.multiscroll.min.js', array( 'jquery' ), false, true );
	    wp_enqueue_script( 'mixitup', MIKADO_ASSETS_ROOT . '/js/modules/plugins/typed.js', array( 'jquery' ), false, true );
        
        wp_enqueue_script('isotope', MIKADO_ASSETS_ROOT . '/js/jquery.isotope.min.js', array('jquery'), false, true);

        if (buro_mikado_is_smoth_scroll_enabled()) {
            wp_enqueue_script("buro-mikado-smooth-page-scroll", MIKADO_ASSETS_ROOT . "/js/smoothPageScroll.js", array(), false, true);
        }

        //include google map api script
        if (buro_mikado_options()->getOptionValue('google_maps_api_key') != '') {
            $google_maps_api_key = buro_mikado_options()->getOptionValue('google_maps_api_key');
            wp_enqueue_script('google-map-api', '//maps.googleapis.com/maps/api/js?key=' . $google_maps_api_key, array(), false, true);
        }

        wp_enqueue_script('buro-mikado-modules', MIKADO_ASSETS_ROOT . '/js/modules.min.js', array('jquery'), false, true);

        if (buro_mikado_load_blog_assets()) {
            wp_enqueue_script('buro-mikado-blog', MIKADO_ASSETS_ROOT . '/js/blog.min.js', array('jquery'), false, true);
        }

        //include comment reply script
        $wp_scripts->add_data('comment-reply', 'group', 1);
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script("comment-reply");
        }

        //include Visual Composer script
        if (class_exists('WPBakeryVisualComposerAbstract')) {
            wp_enqueue_script('wpb_composer_front_js');
        }
    }

    add_action('wp_enqueue_scripts', 'buro_mikado_scripts');
}

//defined content width variable
if (!isset($content_width))
    $content_width = 1060;

if (!function_exists('buro_mikado_theme_setup')) {
    /**
     * Function that adds various features to theme. Also defines image sizes that are used in a theme
     */
    function buro_mikado_theme_setup() {
        //add support for feed links
        add_theme_support('automatic-feed-links');

        //add support for post formats
        add_theme_support('post-formats', array('gallery', 'link', 'quote', 'video', 'audio'));

        //add theme support for post thumbnails
        add_theme_support('post-thumbnails');

        //add theme support for title tag
        add_theme_support('title-tag');

        //define thumbnail sizes
        add_image_size('buro_mikado_square', 550, 550, true);
        add_image_size('buro_mikado_landscape', 800, 600, true);
        add_image_size('buro_mikado_portrait', 600, 800, true);
        add_image_size('buro_mikado_large_width', 1100, 550, true);
        add_image_size('buro_mikado_large_height', 550, 1100, true);
        add_image_size('buro_mikado_large_width_height', 1100, 1100, true);

        load_theme_textdomain('buro', get_template_directory() . '/languages');

        add_editor_style('assets/css/editor-style.css');
    }

    add_action('after_setup_theme', 'buro_mikado_theme_setup');
}


if ( ! function_exists( 'buro_mikado_enqueue_editor_customizer_styles' ) ) {
	/**
	 * Enqueue supplemental block editor styles
	 */
	function buro_mikado_enqueue_editor_customizer_styles() {
		wp_enqueue_style( 'buro-mikado-editor-blocks-styles', MIKADO_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/editor-blocks-style.css' );
		wp_enqueue_style( 'buro-mikado-editor-customizer-styles', MIKADO_FRAMEWORK_ADMIN_ASSETS_ROOT . '/css/editor-customizer-style.css' );
	}
	
	// add google font
	add_action( 'enqueue_block_editor_assets', 'buro_mikado_google_fonts_styles' );
	// add action
	add_action( 'enqueue_block_editor_assets', 'buro_mikado_enqueue_editor_customizer_styles' );
}

if (!function_exists('buro_mikado_rgba_color')) {
    /**
     * Function that generates rgba part of css color property
     *
     * @param $color string hex color
     * @param $transparency float transparency value between 0 and 1
     *
     * @return string generated rgba string
     */
    function buro_mikado_rgba_color($color, $transparency) {
        if ($color !== '' && $transparency !== '') {
            $rgba_color = '';

            $rgb_color_array = buro_mikado_hex2rgb($color);
            $rgba_color .= 'rgba(' . implode(', ', $rgb_color_array) . ', ' . $transparency . ')';

            return $rgba_color;
        }
    }
}


if (!function_exists('buro_mikado_header_meta')) {
    /**
     * Function that echoes meta data if our seo is enabled
     */
    function buro_mikado_header_meta() { ?>

        <meta charset="<?php bloginfo('charset'); ?>"/>
        <link rel="profile" href="http://gmpg.org/xfn/11"/>
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>

    <?php }

    add_action('buro_mikado_header_meta', 'buro_mikado_header_meta');
}

if (!function_exists('buro_mikado_user_scalable_meta')) {
    /**
     * Function that outputs user scalable meta if responsiveness is turned on
     * Hooked to buro_mikado_header_meta action
     */
    function buro_mikado_user_scalable_meta() {
        //is responsiveness option is chosen?
        if (buro_mikado_is_responsive_on()) { ?>
            <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=yes">
        <?php } else { ?>
            <meta name="viewport" content="width=1200,user-scalable=yes">
        <?php }
    }

    add_action('buro_mikado_header_meta', 'buro_mikado_user_scalable_meta');
}

if (!function_exists('buro_mikado_get_page_id')) {
    /**
     * Function that returns current page / post id.
     * Checks if current page is woocommerce page and returns that id if it is.
     * Checks if current page is any archive page (category, tag, date, author etc.) and returns -1 because that isn't
     * page that is created in WP admin.
     *
     * @return int
     *
     * @version 0.1
     *
     * @see buro_mikado_is_woocommerce_installed()
     * @see buro_mikado_is_woocommerce_shop()
     */
    function buro_mikado_get_page_id() {
        if (buro_mikado_is_woocommerce_installed() && buro_mikado_is_woocommerce_shop()) {
            return buro_mikado_get_woo_shop_page_id();
        }

        if (is_archive() || is_search() || is_404() || (is_home() && is_front_page())) {
            return -1;
        }

        return get_queried_object_id();
    }
}


if (!function_exists('buro_mikado_is_default_wp_template')) {
    /**
     * Function that checks if current page archive page, search, 404 or default home blog page
     * @return bool
     *
     * @see is_archive()
     * @see is_search()
     * @see is_404()
     * @see is_front_page()
     * @see is_home()
     */
    function buro_mikado_is_default_wp_template() {
        return is_archive() || is_search() || is_404() || (is_front_page() && is_home());
    }
}

if (!function_exists('buro_mikado_get_page_template_name')) {
    /**
     * Returns current template file name without extension
     * @return string name of current template file
     */
    function buro_mikado_get_page_template_name() {
        $file_name = '';

        if (!buro_mikado_is_default_wp_template()) {
            $file_name_without_ext = preg_replace('/\\.[^.\\s]{3,4}$/', '', basename(get_page_template()));

            if ($file_name_without_ext !== '') {
                $file_name = $file_name_without_ext;
            }
        }

        return $file_name;
    }
}

if (!function_exists('buro_mikado_has_shortcode')) {
    /**
     * Function that checks whether shortcode exists on current page / post
     *
     * @param string shortcode to find
     * @param string content to check. If isn't passed current post content will be used
     *
     * @return bool whether content has shortcode or not
     */
    function buro_mikado_has_shortcode($shortcode, $content = '') {
        $has_shortcode = false;

        if ($shortcode) {
            //if content variable isn't past
            if ($content == '') {
                //take content from current post
                $page_id = buro_mikado_get_page_id();
                if (!empty($page_id)) {
                    $current_post = get_post($page_id);

                    if (is_object($current_post) && property_exists($current_post, 'post_content')) {
                        $content = $current_post->post_content;
                    }
                }
            }

            //does content has shortcode added?
            if (stripos($content, '[' . $shortcode) !== false) {
                $has_shortcode = true;
            }
        }

        return $has_shortcode;
    }
}

if (!function_exists('buro_mikado_get_dynamic_sidebar')) {
    /**
     * Return Custom Widget Area content
     *
     * @return string
     */
    function buro_mikado_get_dynamic_sidebar($index = 1) {
        ob_start();
        dynamic_sidebar($index);
        $sidebar_contents = ob_get_clean();

        return $sidebar_contents;
    }
}

if (!function_exists('buro_mikado_get_sidebar')) {
    /**
     * Return Sidebar
     *
     * @return string
     */
    function buro_mikado_get_sidebar() {

        $id = buro_mikado_get_page_id();

        $sidebar = "sidebar";

        if (get_post_meta($id, 'mkd_custom_sidebar_meta', true) != '') {
            $sidebar = get_post_meta($id, 'mkd_custom_sidebar_meta', true);
        } else {
            if (is_single() && buro_mikado_options()->getOptionValue('blog_single_custom_sidebar') != '') {
                $sidebar = esc_attr(buro_mikado_options()->getOptionValue('blog_single_custom_sidebar'));
            } elseif ((is_archive() || (is_home() && is_front_page())) && buro_mikado_options()->getOptionValue('blog_custom_sidebar') != '') {
                $sidebar = esc_attr(buro_mikado_options()->getOptionValue('blog_custom_sidebar'));
            } elseif (is_page() && buro_mikado_options()->getOptionValue('page_custom_sidebar') != '') {
                $sidebar = esc_attr(buro_mikado_options()->getOptionValue('page_custom_sidebar'));
            }
        }

        return $sidebar;
    }
}


if (!function_exists('buro_mikado_sidebar_columns_class')) {

    /**
     * Return classes for columns holder when sidebar is active
     *
     * @return array
     */

    function buro_mikado_sidebar_columns_class() {

        $sidebar_class = array();
        $sidebar_layout = buro_mikado_sidebar_layout();

        switch ($sidebar_layout):
            case 'sidebar-33-right':
                $sidebar_class[] = 'mkd-two-columns-66-33';
                break;
            case 'sidebar-25-right':
                $sidebar_class[] = 'mkd-two-columns-75-25';
                break;
            case 'sidebar-33-left':
                $sidebar_class[] = 'mkd-two-columns-33-66';
                break;
            case 'sidebar-25-left':
                $sidebar_class[] = 'mkd-two-columns-25-75';
                break;

        endswitch;

        $sidebar_class[] = 'clearfix';

        return buro_mikado_class_attribute($sidebar_class);

    }

}


if (!function_exists('buro_mikado_sidebar_layout')) {

    /**
     * Function that check is sidebar is enabled and return type of sidebar layout
     */

    function buro_mikado_sidebar_layout() {

        $sidebar_layout = '';
        $page_id = buro_mikado_get_page_id();

        $page_sidebar_meta = get_post_meta($page_id, 'mkd_sidebar_meta', true);

        if (($page_sidebar_meta !== '') && $page_id !== -1) {
            if ($page_sidebar_meta == 'no-sidebar') {
                $sidebar_layout = '';
            } else {
                $sidebar_layout = $page_sidebar_meta;
            }
        } else {
            if (is_single() && buro_mikado_options()->getOptionValue('blog_single_sidebar_layout')) {
                $sidebar_layout = esc_attr(buro_mikado_options()->getOptionValue('blog_single_sidebar_layout'));
            } elseif ((is_archive() || (is_home() && is_front_page())) && buro_mikado_options()->getOptionValue('archive_sidebar_layout')) {
                $sidebar_layout = esc_attr(buro_mikado_options()->getOptionValue('archive_sidebar_layout'));
            } elseif (is_page() && buro_mikado_options()->getOptionValue('page_sidebar_layout')) {
                $sidebar_layout = esc_attr(buro_mikado_options()->getOptionValue('page_sidebar_layout'));
            }
        }
	
	    if ( ! empty( $sidebar_layout ) && ! is_active_sidebar( buro_mikado_get_sidebar() ) ) {
		    $sidebar_layout = '';
	    }
        return $sidebar_layout;

    }

}


if (!function_exists('buro_mikado_page_custom_style')) {

    /**
     * Function that print custom page style
     */

    function buro_mikado_page_custom_style() {
        $style = array();
        $style = apply_filters('buro_mikado_add_page_custom_style', $style);

        if ($style !== '') {
            wp_add_inline_style('buro-mikado-modules', implode(' ', $style));
        }
    }

    add_action('wp_enqueue_scripts', 'buro_mikado_page_custom_style');

}


if (!function_exists('buro_mikado_get_unique_page_class')) {
    /**
     * Returns unique page class based on post type and page id
     *
     * @return string
     */
    function buro_mikado_get_unique_page_class() {
        $id = buro_mikado_get_page_id();
        $page_class = '';

        if (is_single()) {
            $page_class = '.postid-' . $id;
        } elseif ($id === buro_mikado_get_woo_shop_page_id()) {
            $page_class = '.archive';
        } elseif (is_home()) {
            $page_class .= '.home';
        } else {
            $page_class .= '.page-id-' . $id;
        }

        return $page_class;
    }
}

if (!function_exists('buro_mikado_container_style')) {

    /**
     * Function that return container style
     */

    function buro_mikado_container_style($style) {
        $id = buro_mikado_get_page_id();
        $class_prefix = buro_mikado_get_unique_page_class();

        $container_selector = array(
            $class_prefix . ' .mkd-content .mkd-content-inner > .mkd-container',
            $class_prefix . ' .mkd-content .mkd-content-inner > .mkd-full-width',
        );

        $container_class = array();
        $page_background_color = get_post_meta($id, "mkd_page_background_color_meta", true);

        if ($page_background_color) {
            $container_class['background-color'] = $page_background_color;
        }

        $current_style = buro_mikado_dynamic_css($container_selector, $container_class);
        $style[] = $current_style;

        return $style;

    }

    add_filter('buro_mikado_add_page_custom_style', 'buro_mikado_container_style');
}

if (!function_exists('buro_mikado_page_padding')) {

    /**
     * Function that return container style
     */

    function buro_mikado_page_padding($style) {

        $id = buro_mikado_get_page_id();
        $class_prefix = buro_mikado_get_unique_page_class();


        $page_selector = array(
            $class_prefix . ' .mkd-content .mkd-content-inner > .mkd-container > .mkd-container-inner',
            $class_prefix . ' .mkd-content .mkd-content-inner > .mkd-full-width > .mkd-full-width-inner'
        );
        $page_css = array();

        $page_padding = get_post_meta($id, 'mkd_page_padding_meta', true);

        if ($page_padding !== '') {
            $page_css['padding'] = $page_padding;
        }

        $current_style = buro_mikado_dynamic_css($page_selector, $page_css);

        $style[] = $current_style;

        return $style;

    }

    add_filter('buro_mikado_add_page_custom_style', 'buro_mikado_page_padding');
}

if (!function_exists('buro_mikado_page_boxed_style')) {

    /**
     * Function that return container style
     */

    function buro_mikado_page_boxed_style($style) {

        $id = buro_mikado_get_page_id();
        $class_prefix = buro_mikado_get_unique_page_class();

        $page_selector = array(
            $class_prefix . '.mkd-boxed .mkd-wrapper'
        );
        $page_css = array();

        $page_background_color = get_post_meta($id, 'mkd_page_background_color_in_box_meta', true);
        $page_background_image = get_post_meta($id, 'mkd_boxed_background_image_meta', true);
        $page_background_image_repeating = get_post_meta($id, 'mkd_boxed_background_image_repeating_meta', true);

        if ($page_background_color !== '') {
            $page_css['background-color'] = $page_background_color;
        }
        if ($page_background_image !== '' && $page_background_image_repeating != '') {
            $page_css['background-image'] = 'url(' . $page_background_image . ')';
            $page_css['background-repeat'] = $page_background_image_repeating;

            if ($page_background_image_repeating == 'no') {
                $page_css['background-position'] = 'center 0';
                $page_css['background-repeat'] = 'no-repeat';
            } else {
                $page_css['background-position'] = '0 0';
                $page_css['background-repeat'] = 'repeat';
            }
        }

        $current_style = buro_mikado_dynamic_css($page_selector, $page_css);

        $style[] = $current_style;

        return $style;

    }

    add_filter('buro_mikado_add_page_custom_style', 'buro_mikado_page_boxed_style');
}

if (!function_exists('buro_mikado_print_custom_css')) {
    /**
     * Prints out custom css from theme options
     */
    function buro_mikado_print_custom_css() {
        $custom_css = buro_mikado_options()->getOptionValue('custom_css');

        if ($custom_css !== '') {
            wp_add_inline_style('buro-mikado-modules', $custom_css);
        }
    }

    add_action('wp_enqueue_scripts', 'buro_mikado_print_custom_css');
}

if (!function_exists('buro_mikado_print_custom_js')) {
    /**
     * Prints out custom css from theme options
     */
    function buro_mikado_print_custom_js() {
        $custom_js = buro_mikado_options()->getOptionValue('custom_js');

        if ($custom_js !== '') {
            wp_add_inline_script('buro-mikado-modules', $custom_js);
        }

    }

    add_action('wp_enqueue_scripts', 'buro_mikado_print_custom_js');
}


if (!function_exists('buro_mikado_get_global_variables')) {
    /**
     * Function that generates global variables and put them in array so they could be used in the theme
     */
    function buro_mikado_get_global_variables() {

        $global_variables = array();
        $element_appear_amount = -150;

        $global_variables['mkdAddForAdminBar'] = is_admin_bar_showing() ? 32 : 0;
        $global_variables['mkdElementAppearAmount'] = buro_mikado_options()->getOptionValue('element_appear_amount') !== '' ? buro_mikado_options()->getOptionValue('element_appear_amount') : $element_appear_amount;
        $global_variables['mkdFinishedMessage'] = esc_html__('No more posts', 'buro');
        $global_variables['mkdLoadingMoreText'] = esc_html__('Loading...', 'buro');
        $global_variables['mkdMessage'] = esc_html__('Loading new posts...', 'buro');
        $global_variables['mkdLoadMoreText'] = esc_html__('Show More', 'buro');
        $global_variables['mkdAddingToCart'] = esc_html__('Adding to Cart...', 'buro');
        $global_variables['mkdFirstColor'] = buro_mikado_options()->getOptionValue('first_color') !== '' ? buro_mikado_options()->getOptionValue('first_color') : '#e9003f';

        $global_variables = apply_filters('buro_mikado_js_global_variables', $global_variables);

        wp_localize_script('buro-mikado-modules', 'mkdGlobalVars', array(
            'vars' => $global_variables
        ));

    }

    add_action('wp_enqueue_scripts', 'buro_mikado_get_global_variables');
}

if (!function_exists('buro_mikado_per_page_js_variables')) {
    /**
     * Outputs global JS variable that holds page settings
     */
    function buro_mikado_per_page_js_variables() {
        $per_page_js_vars = apply_filters('buro_mikado_per_page_js_vars', array());

        wp_localize_script('buro-mikado-modules', 'mkdPerPageVars', array(
            'vars' => $per_page_js_vars
        ));
    }

    add_action('wp_enqueue_scripts', 'buro_mikado_per_page_js_variables');
}

if (!function_exists('buro_mikado_content_elem_style_attr')) {
    /**
     * Defines filter for adding custom styles to content HTML element
     */
    function buro_mikado_content_elem_style_attr() {
        $styles = apply_filters('buro_mikado_content_elem_style_attr', array());

        buro_mikado_inline_style($styles);
    }
}

if (!function_exists('buro_mikado_is_woocommerce_installed')) {
    /**
     * Function that checks if woocommerce is installed
     * @return bool
     */
    function buro_mikado_is_woocommerce_installed() {
        return function_exists('is_woocommerce');
    }
}

if (!function_exists('buro_mikado_visual_composer_installed')) {
    /**
     * Function that checks if visual composer installed
     * @return bool
     */
    function buro_mikado_visual_composer_installed() {
        //is Visual Composer installed?
        if (class_exists('WPBakeryVisualComposerAbstract')) {
            return true;
        }

        return false;
    }
}

if (!function_exists('buro_mikado_contact_form_7_installed')) {
    /**
     * Function that checks if contact form 7 installed
     * @return bool
     */
    function buro_mikado_contact_form_7_installed() {
        //is Contact Form 7 installed?
        if (defined('WPCF7_VERSION')) {
            return true;
        }

        return false;
    }
}

if (!function_exists('buro_mikado_is_wpml_installed')) {
    /**
     * Function that checks if WPML plugin is installed
     * @return bool
     *
     * @version 0.1
     */
    function buro_mikado_is_wpml_installed() {
        return defined('ICL_SITEPRESS_VERSION');
    }
}

if ( ! function_exists( 'buro_mikado_is_gutenberg_installed' ) ) {
	/**
	 * Function that checks if Gutenberg plugin installed
	 * @return bool
	 */
	function buro_mikado_is_gutenberg_installed() {
		return function_exists( 'is_gutenberg_page' ) && is_gutenberg_page();
	}
}

if ( ! function_exists( 'buro_mikado_is_wp_gutenberg_installed' ) ) {
	/**
	 * Function that checks if WordPress 5.x with Gutenberg editor installed
	 * @return bool
	 */
	function buro_mikado_is_wp_gutenberg_installed() {
		return class_exists( 'WP_Block_Type' );
	}
}

if (!function_exists('buro_mikado_max_image_width_srcset')) {
    /**
     * Set max width for srcset to 1920
     *
     * @return int
     */
    function buro_mikado_max_image_width_srcset() {
        return 1920;
    }

    add_filter('max_srcset_image_width', 'buro_mikado_max_image_width_srcset');
}