<?php

if(!function_exists('buro_mikado_register_sidebars')) {
    /**
     * Function that registers theme's sidebars
     */
    function buro_mikado_register_sidebars() {

        register_sidebar(array(
            'name' => esc_html__('Sidebar', 'buro'),
            'id' => 'sidebar',
            'description' => esc_html__('Default Sidebar', 'buro'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h5 class="mkd-widget-title">',
            'after_title' => '</h5>'
        ));

    }

    add_action('widgets_init', 'buro_mikado_register_sidebars');
}

if(!function_exists('buro_mikado_add_support_custom_sidebar')) {
    /**
     * Function that adds theme support for custom sidebars. It also creates BuroMikadoSidebar object
     */
    function buro_mikado_add_support_custom_sidebar() {
        add_theme_support('BuroMikadoSidebar');
        if (get_theme_support('BuroMikadoSidebar')) new BuroMikadoSidebar();
    }

    add_action('after_setup_theme', 'buro_mikado_add_support_custom_sidebar');
}
