<?php
/*
Template Name: Landing Page
*/
$buro_mikado_sidebar = buro_mikado_sidebar_layout();

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <?php
        /**
         * buro_mikado_header_meta hook
         *
         * @see buro_mikado_header_meta() - hooked with 10
         * @see mkd_user_scalable_meta() - hooked with 10
         */
        do_action('buro_mikado_header_meta');
        ?>

        <?php wp_head(); ?>
    </head>

<body <?php body_class(); ?>>

<?php 
if (buro_mikado_options()->getOptionValue('smooth_page_transitions') == "yes") {
	$buro_mikado_ajax_class = 'mkd-mimic-ajax';
?>
<div class="mkd-smooth-transition-loader <?php echo esc_attr($buro_mikado_ajax_class); ?>">
    <div class="mkd-st-loader">
        <div class="mkd-st-loader1">
            <?php buro_mikado_loading_spinners(); ?>
        </div>
    </div>
</div>
<?php } ?>

<div class="mkd-wrapper">
	<div class="mkd-wrapper-inner">
		<div class="mkd-content">
			<div class="mkd-content-inner">
				<?php get_template_part( 'title' ); ?>
				<?php get_template_part('slider');?>
				<div class="mkd-full-width">
					<div class="mkd-full-width-inner">
						<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
							<?php if(($buro_mikado_sidebar == 'default')||($buro_mikado_sidebar == '')) : ?>
								<?php the_content(); ?>
								<?php do_action('buro_mikado_page_after_content'); ?>
							<?php elseif($buro_mikado_sidebar == 'sidebar-33-right' || $buro_mikado_sidebar == 'sidebar-25-right'): ?>
								<div <?php echo buro_mikado_sidebar_columns_class(); ?>>
									<div class="mkd-column1 mkd-content-left-from-sidebar">
										<div class="mkd-column-inner">
											<?php the_content(); ?>
											<?php do_action('buro_mikado_page_after_content'); ?>
										</div>
									</div>
									<div class="mkd-column2">
										<?php get_sidebar(); ?>
									</div>
								</div>
							<?php elseif($buro_mikado_sidebar == 'sidebar-33-left' || $buro_mikado_sidebar == 'sidebar-25-left'): ?>
								<div <?php echo buro_mikado_sidebar_columns_class(); ?>>
									<div class="mkd-column1">
										<?php get_sidebar(); ?>
									</div>
									<div class="mkd-column2 mkd-content-right-from-sidebar">
										<div class="mkd-column-inner">
											<?php the_content(); ?>
											<?php do_action('buro_mikado_page_after_content'); ?>
										</div>
									</div>
								</div>
							<?php endif; ?>
						<?php endwhile; ?>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php wp_footer(); ?>
</body>
</html>