<?php 
/*
Template Name: WooCommerce
*/ 
?>
<?php

$buro_mikado_id = get_option('woocommerce_shop_page_id');
$buro_mikado_shop = get_post($buro_mikado_id);
$buro_mikado_sidebar = buro_mikado_sidebar_layout();

if(get_post_meta($buro_mikado_id, 'mkd_page_background_color', true) != ''){
	$buro_mikado_background_color = 'background-color: '.esc_attr(get_post_meta($buro_mikado_id, 'mkd_page_background_color', true));
}else{
	$buro_mikado_background_color = '';
}

$buro_mikado_content_style = '';
if(get_post_meta($buro_mikado_id, 'mkd_content-top-padding', true) != '') {
	if(get_post_meta($buro_mikado_id, 'mkd_content-top-padding-mobile', true) == 'yes') {
		$buro_mikado_content_style = 'padding-top:'.esc_attr(get_post_meta($buro_mikado_id, 'mkd_content-top-padding', true)).'px !important';
	} else {
		$buro_mikado_content_style = 'padding-top:'.esc_attr(get_post_meta($buro_mikado_id, 'mkd_content-top-padding', true)).'px';
	}
}

if ( get_query_var('paged') ) {
	$buro_mikado_paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
	$buro_mikado_paged = get_query_var('page');
} else {
	$buro_mikado_paged = 1;
}

get_header();

buro_mikado_get_title();
get_template_part('slider');

$buro_mikado_full_width = false;

if ( buro_mikado_options()->getOptionValue('mkd_woo_products_list_full_width') == 'yes' && !is_singular('product') ) {
	$buro_mikado_full_width = true;
}

if ( $buro_mikado_full_width ) { ?>
	<div class="mkd-full-width" <?php buro_mikado_inline_style($buro_mikado_background_color); ?>>
		<div class="mkd-full-width-inner" <?php buro_mikado_inline_style($buro_mikado_content_style); ?>>
<?php } else { ?>
	<div class="mkd-container" <?php buro_mikado_inline_style($buro_mikado_background_color); ?>>
		<div class="mkd-container-inner clearfix" <?php buro_mikado_inline_style($buro_mikado_content_style); ?>>
<?php }
			//Woocommerce content
			if ( ! is_singular('product') ) {

				switch( $buro_mikado_sidebar ) {

					case 'sidebar-33-right': ?>
						<div class="mkd-two-columns-66-33 grid2 mkd-woocommerce-with-sidebar clearfix">
							<div class="mkd-column1">
								<div class="mkd-column-inner">
									<?php buro_mikado_woocommerce_content(); ?>
								</div>
							</div>
							<div class="mkd-column2">
								<?php get_sidebar();?>
							</div>
						</div>
					<?php
						break;
					case 'sidebar-25-right': ?>
						<div class="mkd-two-columns-75-25 grid2 mkd-woocommerce-with-sidebar clearfix">
							<div class="mkd-column1 mkd-content-left-from-sidebar">
								<div class="mkd-column-inner">
									<?php buro_mikado_woocommerce_content(); ?>
								</div>
							</div>
							<div class="mkd-column2">
								<?php get_sidebar();?>
							</div>
						</div>
					<?php
						break;
					case 'sidebar-33-left': ?>
						<div class="mkd-two-columns-33-66 grid2 mkd-woocommerce-with-sidebar clearfix">
							<div class="mkd-column1">
								<?php get_sidebar();?>
							</div>
							<div class="mkd-column2">
								<div class="mkd-column-inner">
									<?php buro_mikado_woocommerce_content(); ?>
								</div>
							</div>
						</div>
					<?php
						break;
					case 'sidebar-25-left': ?>
						<div class="mkd-two-columns-25-75 grid2 mkd-woocommerce-with-sidebar clearfix">
							<div class="mkd-column1">
								<?php get_sidebar();?>
							</div>
							<div class="mkd-column2 mkd-content-right-from-sidebar">
								<div class="mkd-column-inner">
									<?php buro_mikado_woocommerce_content(); ?>
								</div>
							</div>
						</div>
					<?php
						break;
					default:
						buro_mikado_woocommerce_content();
				}

			} else {
				buro_mikado_woocommerce_content();
			} ?>

			</div>
	</div>
	<?php do_action('buro_mikado_after_container_close'); ?>
<?php get_footer(); ?>
