<?php
/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.5
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

if ( ! is_a( $product, 'WC_Product' ) ) {
	return;
}

$product_id = '';

if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
	$product_id = $product->get_id();
} else{
	$product_id = $product->id;
}
?>

<li>
	<a href="<?php echo esc_url( get_permalink( $product_id ) ); ?>" title="<?php echo esc_attr( $product->get_title() ); ?>">
		<?php print buro_mikado_display_content_output($product->get_image('thumbnail')); ?>
	</a>
	<div>
		<a href="<?php echo esc_url( get_permalink( $product_id ) ); ?>" title="<?php echo esc_attr( $product->get_title() ); ?>">
			<span class="product-title"><?php print wp_kses_post($product->get_title()); ?></span>
		</a>
		<?php if ( ! empty( $show_rating ) ) {
			if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
				print wc_get_rating_html( $product->get_average_rating() );
			} else {
				print buro_mikado_display_content_output($product->get_rating_html());
			}
		} ?>
		<?php print buro_mikado_display_content_output($product->get_price_html()); ?>
	</div>
</li>
