<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $post, $product;

$cat_count = sizeof( get_the_terms( $post->ID, 'product_cat' ) );
$tag_count = sizeof( get_the_terms( $post->ID, 'product_tag' ) );

?>
<div class="product_meta">

    <?php do_action( 'woocommerce_product_meta_start' ); ?>

    <h5 class="mkd-product-meta-title"><?php esc_html_e('Info','buro');?></h5>

    <?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) { ?>

        <span class="sku_wrapper"><span class="mkd-info-meta-title"><?php esc_html_e( 'SKU:', 'buro' ); ?></span><span class="sku mkd-info-meta-content"><?php echo buro_mikado_display_content_output(( $sku = $product->get_sku() ) ? $sku : esc_html_e( 'N/A', 'buro' )); ?></span></span>

    <?php } ?>

    <?php 
	if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
		print wc_get_product_category_list( $product->get_id(), '<span class="mkd-product-meta-separator">, </span>', '<span class="posted_in"><span class="mkd-info-meta-title">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'buro' ) . '</span><span class="mkd-info-meta-content">', '</span></span>');
		print wc_get_product_tag_list( $product->get_id(), '<span class="mkd-product-meta-separator">, </span>', '<span class="tagged_as"><span class="mkd-info-meta-title">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'buro' ) . '</span><span class="mkd-info-meta-content">', '</span></span>');
	} else {
		print buro_mikado_display_content_output($product->get_categories( '<span class="mkd-product-meta-separator">, </span>', '<span class="posted_in"><span class="mkd-info-meta-title">' . _n( 'Category:', 'Categories:', $cat_count, 'buro' ) . '</span><span class="mkd-info-meta-content">', '</span></span>' ));
		print buro_mikado_display_content_output($product->get_tags( '<span class="mkd-product-meta-separator">, </span>', '<span class="tagged_as"><span class="mkd-info-meta-title">' . _n( 'Tag:', 'Tags:', $tag_count, 'buro' ) . '</span><span class="mkd-info-meta-content">', '</span></span>' ));
	} ?>

    <?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>