<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {

	if ( $related_products ) : ?>

		<section class="related products">

			<div class="mkd-related-products-title-holder">
				<h5><?php esc_html_e( 'Related Products', 'buro' ); ?></h5>
				<div class="mkd-related-nav-holder">
					<span class="mkd-related-prev"><span class="arrow_carrot-left"></span></span>
					<span class="mkd-related-glob"><a href="<?php echo get_permalink( get_option( 'woocommerce_shop_page_id' ) ); ?>"><span class="icon_grid-3x3"></span></a></span>
					<span class="mkd-related-next"><span class="arrow_carrot-right"></span></span>
				</div>
			</div>

			<?php woocommerce_product_loop_start(); ?>

				<?php foreach ( $related_products as $related_product ) : ?>

					<?php
					 	$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );

						wc_get_template_part( 'content', 'product' ); ?>

				<?php endforeach; ?>

			<?php woocommerce_product_loop_end(); ?>

		</section>

	<?php endif;

	wp_reset_postdata();
} else {

	global $product, $woocommerce_loop;

	if ( empty( $product ) || ! $product->exists() ) {
		return;
	}

	if ( ! $related = $product->get_related( $posts_per_page ) ) {
		return;
	}

	$product_id = '';

	if ( version_compare( WOOCOMMERCE_VERSION, '3.0' ) >= 0 ) {
		$product_id = $product->get_id();
	} else{
		$product_id = $product->id;
	}

	$args = apply_filters( 'woocommerce_related_products_args', array(
		'post_type'            => 'product',
		'ignore_sticky_posts'  => 1,
		'no_found_rows'        => 1,
		'posts_per_page'       => $posts_per_page,
		'orderby'              => $orderby,
		'post__in'             => $related,
		'post__not_in'         => array( $product_id )
	) );

	$products                    = new WP_Query( $args );
	$woocommerce_loop['name']    = 'related';
	$woocommerce_loop['columns'] = apply_filters( 'woocommerce_related_products_columns', $columns );

	if ( $products->have_posts() ) : ?>

		<div class="related products">

			<div class="mkd-related-products-title-holder">
				<h5><?php esc_html_e( 'Related Products', 'buro' ); ?></h5>
				<div class="mkd-related-nav-holder">
					<span class="mkd-related-prev"><span class="lnr lnr-chevron-left"></span></span>
					<span class="mkd-related-glob"><a href="<?php echo get_permalink( get_option( 'woocommerce_shop_page_id' ) ); ?>"><span class="icon_grid-3x3"></span></a></span>
					<span class="mkd-related-next"><span class="lnr lnr-chevron-right"></span></span>
				</div>
			</div>
			<?php woocommerce_product_loop_start(); ?>

				<?php while ( $products->have_posts() ) : $products->the_post(); ?>

					<?php wc_get_template_part( 'content', 'product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php woocommerce_product_loop_end(); ?>

		</div>

	<?php endif;

	wp_reset_postdata();
} 