<?php

if(!function_exists('buro_mikado_export_options')) {
	/**
	 * Function that saves theme options to db.
	 * It hooks to ajax wp_ajax_mkd_save_options action.
	 */
	function buro_mikado_export_options() {
		$options = get_option("mkd_options_buro");
		$output = base64_encode(serialize($options));

		return $output;
	}

}

if(!function_exists('buro_mikado_import_theme_options')) {
	/**
	 * Function that import theme options to db.
	 * It hooks to ajax wp_ajax_buro_mikado_import_theme_options action.
	 */
	function buro_mikado_import_theme_options() {

		if(current_user_can('administrator')) {
			if (empty($_POST) || !isset($_POST)) {
				buro_mikado_ajax_status('error', esc_html__('Import field is empty', 'mikado-core'));
			} else {
				$data = $_POST;
				if (wp_verify_nonce($data['nonce'], 'mkd_import_theme_options_secret_value')) {
					$content = $data['content'];
					$unserialized_content = unserialize(base64_decode($content));
					update_option( 'mkd_options_buro', $unserialized_content);
					buro_mikado_ajax_status('success', esc_html__('Options are imported successfully', 'mikado-core'));
				} else {
					buro_mikado_ajax_status('error', esc_html__('Non valid authorization', 'mikado-core'));
				}

			}
		} else {
			buro_mikado_ajax_status('error', esc_html__('You don\'t have privileges for this operation', 'mikado-core'));
		}
	}

	add_action('wp_ajax_buro_mikado_import_theme_options', 'buro_mikado_import_theme_options');
}

if( ! function_exists( 'buro_mikado_ajax_status' ) ) {

	/**
	 * Function that return status from ajax functions
	 *
	 */

	function buro_mikado_ajax_status($status, $message, $data = NULL) {

		$response = array (
			'status' => $status,
			'message' => $message,
			'data' => $data
		);

		$output = json_encode($response);

		exit($output);

	}

}