<?php 

if(!function_exists('buro_mikado_accordions_typography_styles')){
	function buro_mikado_accordions_typography_styles(){
		$selector = '.mkd-accordion-holder .mkd-title-holder';
		$styles = array();
		
		$font_family = buro_mikado_options()->getOptionValue('accordions_font_family');
		if(buro_mikado_is_font_option_valid($font_family)){
			$styles['font-family'] = buro_mikado_get_font_option_val($font_family);
		}
		
		$text_transform = buro_mikado_options()->getOptionValue('accordions_text_transform');
       if(!empty($text_transform)) {
           $styles['text-transform'] = $text_transform;
       }

       $font_style = buro_mikado_options()->getOptionValue('accordions_font_style');
       if(!empty($font_style)) {
           $styles['font-style'] = $font_style;
       }

       $letter_spacing = buro_mikado_options()->getOptionValue('accordions_letter_spacing');
       if($letter_spacing !== '') {
           $styles['letter-spacing'] = buro_mikado_filter_px($letter_spacing).'px';
       }

       $font_weight = buro_mikado_options()->getOptionValue('accordions_font_weight');
       if(!empty($font_weight)) {
           $styles['font-weight'] = $font_weight;
       }

       echo buro_mikado_dynamic_css($selector, $styles);
	}
	add_action('buro_mikado_style_dynamic', 'buro_mikado_accordions_typography_styles');
}

if(!function_exists('buro_mikado_accordions_initial_color_styles')){

	function buro_mikado_accordions_initial_color_styles(){

		$selector = '.mkd-accordion-holder.mkd-initial .mkd-title-holder';
		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('accordions_title_color')) {
			$styles['color'] = buro_mikado_options()->getOptionValue('accordions_title_color');
		}
		
		if(buro_mikado_options()->getOptionValue('accordions_back_color')) {
			$styles['background-color'] = buro_mikado_options()->getOptionValue('accordions_back_color');
		}

		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_accordions_initial_color_styles');
}

if(!function_exists('buro_mikado_accordions_active_color_styles')){
	
	function buro_mikado_accordions_active_color_styles(){
		$selector = array(
			'.mkd-accordion-holder.mkd-initial .mkd-title-holder.ui-state-active',
			'.mkd-accordion-holder.mkd-initial .mkd-title-holder.ui-state-hover'
		);
		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('accordions_title_color_active')) {
			$styles['color'] = buro_mikado_options()->getOptionValue('accordions_title_color_active');
		}
		
		if(buro_mikado_options()->getOptionValue('accordions_back_color_active')) {
			$styles['background-color'] = buro_mikado_options()->getOptionValue('accordions_back_color_active');
		}

		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_accordions_active_color_styles');
}