<?php 
if(!function_exists('buro_mikado_accordions_map')) {
    /**
     * Add Accordion options to elements panel
     */
   function buro_mikado_accordions_map() {
		
       $panel = buro_mikado_add_admin_panel(array(
           'title' => esc_html__('Accordions', 'buro'),
           'name'  => 'panel_accordions',
           'page'  => '_elements_page'
       ));

       //Typography options
       buro_mikado_add_admin_section_title(array(
           'name' => 'typography_section_title',
           'title' => esc_html__('Typography', 'buro'),
           'parent' => $panel
       ));

       $typography_group = buro_mikado_add_admin_group(array(
           'name' => 'typography_group',
           'title' => esc_html__('Typography', 'buro'),
			'description' => esc_html__('Setup typography for accordions navigation', 'buro'),
           'parent' => $panel
       ));

       $typography_row = buro_mikado_add_admin_row(array(
           'name' => 'typography_row',
           'next' => true,
           'parent' => $typography_group
       ));

       buro_mikado_add_admin_field(array(
           'parent'        => $typography_row,
           'type'          => 'fontsimple',
           'name'          => 'accordions_font_family',
           'default_value' => '',
           'label'         => esc_html__('Font Family', 'buro'),
       ));

       buro_mikado_add_admin_field(array(
           'parent'        => $typography_row,
           'type'          => 'selectsimple',
           'name'          => 'accordions_text_transform',
           'default_value' => '',
           'label'         => esc_html__('Text Transform', 'buro'),
           'options'       => buro_mikado_get_text_transform_array()
       ));

       buro_mikado_add_admin_field(array(
           'parent'        => $typography_row,
           'type'          => 'selectsimple',
           'name'          => 'accordions_font_style',
           'default_value' => '',
           'label'         => esc_html__('Font Style', 'buro'),
           'options'       => buro_mikado_get_font_style_array()
       ));

       buro_mikado_add_admin_field(array(
           'parent'        => $typography_row,
           'type'          => 'textsimple',
           'name'          => 'accordions_letter_spacing',
           'default_value' => '',
           'label'         => esc_html__('Letter Spacing', 'buro'),
           'args'          => array(
               'suffix' => 'px'
           )
       ));

       $typography_row2 = buro_mikado_add_admin_row(array(
           'name' => 'typography_row2',
           'next' => true,
           'parent' => $typography_group
       ));		
		
       buro_mikado_add_admin_field(array(
           'parent'        => $typography_row2,
           'type'          => 'selectsimple',
           'name'          => 'accordions_font_weight',
           'default_value' => '',
           'label'         => esc_html__('Font Weight', 'buro'),
           'options'       => buro_mikado_get_font_weight_array()
       ));
		
		//Initial Accordion Color Styles
		
		buro_mikado_add_admin_section_title(array(
           'name' => 'accordion_color_section_title',
           'title' => esc_html__('Basic Accordions Color Styles', 'buro'),
           'parent' => $panel
       ));
		
		$accordions_color_group = buro_mikado_add_admin_group(array(
           'name' => 'accordions_color_group',
           'title' => esc_html__('Accordion Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for accordion title', 'buro'),
           'parent' => $panel
       ));
		$accordions_color_row = buro_mikado_add_admin_row(array(
           'name' => 'accordions_color_row',
           'next' => true,
           'parent' => $accordions_color_group
       ));
		buro_mikado_add_admin_field(array(
           'parent'        => $accordions_color_row,
           'type'          => 'colorsimple',
           'name'          => 'accordions_title_color',
           'default_value' => '',
           'label'         => esc_html__('Title/Icon Color', 'buro'),
       ));

		buro_mikado_add_admin_field(array(
           'parent'        => $accordions_color_row,
           'type'          => 'colorsimple',
           'name'          => 'accordions_back_color',
           'default_value' => '',
           'label'         => esc_html__('Background Color', 'buro'),
       ));
		
		$active_accordions_color_group = buro_mikado_add_admin_group(array(
           'name' => 'active_accordions_color_group',
           'title' => esc_html__('Active and Hover Accordion Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for active and hover accordions', 'buro'),
           'parent' => $panel
       ));
		$active_accordions_color_row = buro_mikado_add_admin_row(array(
           'name' => 'active_accordions_color_row',
           'next' => true,
           'parent' => $active_accordions_color_group
       ));
		buro_mikado_add_admin_field(array(
           'parent'        => $active_accordions_color_row,
           'type'          => 'colorsimple',
           'name'          => 'accordions_title_color_active',
           'default_value' => '',
           'label'         => esc_html__('Title/Icon Color', 'buro'),
       ));

		buro_mikado_add_admin_field(array(
           'parent'        => $active_accordions_color_row,
           'type'          => 'colorsimple',
           'name'          => 'accordions_back_color_active',
           'default_value' => '',
           'label'         => esc_html__('Background Color', 'buro'),
       ));
       
   }
   add_action('buro_mikado_options_elements_map', 'buro_mikado_accordions_map');
}