<?php
/**
 * Banner shortcode template
 */
?>

<div class="mkd-banner <?php echo esc_attr($banner_classes);?>">
	<?php if($link != '') { ?>
		<a href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($link_target); ?>">
	<?php } ?>
		<div class="mkd-banner-image-inner">
			<?php if ($item_image !== '') { ?>
				<div class="mkd-banner-image">
					<?php echo wp_get_attachment_image($item_image,'full');?>
				</div>
			<?php } ?>	
			<div class="mkd-banner-info">
				<div class="mkd-banner-info-table">
					<div class="mkd-banner-info-table-cell">
						<?php if ($banner_title !== '') { ?>
							<div class="mkd-banner-title-holder">
								<<?php echo esc_attr($title_tag);?> class="mkd-banner-title" <?php echo buro_mikado_get_inline_attrs($title_hover_styles); ?> <?php echo buro_mikado_get_inline_style($title_styles); ?>>
									<?php echo wp_kses_post($banner_title) ?>
								</<?php echo esc_attr($title_tag);?>>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	<?php if($link != '') { ?>
		</a>
	<?php } ?>
</div>