<?php
namespace BuroMikado\Modules\Shortcodes\heroTypographyLayout;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class heroTypographyLayout
 */
class heroTypographyLayout implements ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkd_hero_typography_layout';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Hero Typography Layout', 'buro' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by MIKADO', 'buro' ),
					'icon'                      => 'icon-wpb-hero-typography-layout extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type' => 'attach_image',
							'heading' => esc_html__('Background Image','buro'),
							'param_name' => 'background_image',
						),
						array(
							'type' => 'textfield',
							'heading' => esc_html__('Text','buro'),
							'param_name' => 'text',
                            'admin_label' => true
						),
						array(
							'type' => 'colorpicker',
							'heading' => esc_html__('Text Color','buro'),
							'param_name' => 'text_color',
						),
                        array(
                            'type' => 'param_group',
                            'heading' => esc_html__( 'Highlighted Text Instances', 'buro' ),
                            'param_name' => 'highlighted_text_instances',
                            'value' => '',
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'param_name' => 'highlighted_text',
                                    'heading' => esc_html__( 'Highlighted Text Instance', 'buro' ),
                                    'admin_label' => true
                                ),
                                array(
									'type' => 'colorpicker',
                                    'param_name' => 'highlighted_text_color',
                                    'heading' => esc_html__( 'Highlighted Text Instance Color', 'buro' )
                                ),
                            )
                        ),
						array(
							'type' => 'textfield',
							'heading' => esc_html__('Additional Character','buro'),
							'param_name' => 'additional_character',
							'group' => esc_html__('Additional Options','buro'),
						),
						array(
						    'type' => 'dropdown',
						    'param_name' => 'enable_parallax',
						    'heading' => esc_html__( 'Enable Parallax', 'buro' ),
						    'value' => array(
						        esc_html__( 'Yes', 'buro' ) => 'yes',
						        esc_html__( 'No', 'buro' ) => 'no'
						    ),
							'group' => esc_html__('Additional Options','buro'),
						),
						array(
						    'type' => 'dropdown',
						    'param_name' => 'enable_preloader',
						    'heading' => esc_html__( 'Enable Preloader', 'buro' ),
						    'value' => array(
						        esc_html__( 'Yes', 'buro' ) => 'yes',
						        esc_html__( 'No', 'buro' ) => 'no'
						    ),
							'group' => esc_html__('Additional Options','buro'),
						),
						array(
						    'type' => 'dropdown',
						    'param_name' => 'enable_scroll_down_notice',
						    'heading' => esc_html__( 'Enable Scroll Down Notice', 'buro' ),
						    'value' => array(
						        esc_html__( 'Yes', 'buro' ) => 'yes',
						        esc_html__( 'No', 'buro' ) => 'no'
						    ),
							'group' => esc_html__('Additional Options','buro'),
						),
                    )
				)
			);
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
			'background_image' => '',
            'text' => '',
            'text_color' => '',
            'highlighted_text_instances' => '',
            'additional_character' => '',
            'enable_parallax' => 'yes',
            'enable_preloader' => 'yes',
            'enable_scroll_down_notice' => 'yes'
		);
		
		$params = shortcode_atts($args, $atts);
		$params['holder_classes'] = $this->getHolderClasses($params);
		$params['text_styles'] = $this->getTextStyles($params);
		$params['background_styles'] = $this->getBackgroundStyles($params);
        $params['highlighted_text_instances'] = vc_param_group_parse_atts($params['highlighted_text_instances']);
		
		$html = mkd_core_get_module_shortcode_template_part('templates/hero-typography-layout-template', 'hero-typography-layout', '', $params);
		
		return $html;
	}
	
	/**
	 * Generates holder classes
	 *
	 * @param $params
	 *
	 * @return string
	 */
	private function getHolderClasses($params){
		$holderClasses = array();

		$holderClasses[] = 'mkd-hero-typography-layout';

		if(!empty($params['enable_parallax']) && $params['enable_parallax'] === 'yes') {
		    $holderClasses[] = 'mkd-htl-with-parallax';
        }

		if(!empty($params['enable_preloader']) && $params['enable_preloader'] === 'yes') {
		    $holderClasses[] = 'mkd-htl-with-preloader';
        }

		if(!empty($params['enable_scroll_down_notice']) && $params['enable_scroll_down_notice'] === 'yes') {
		    $holderClasses[] = 'mkd-htl-with-scroll-down-notice';
        }

		return implode(' ', $holderClasses);
	}

	/**
	 * Generates text styles
	 *
	 * @param $params
	 *
	 * @return string
	 */
	private function getTextStyles($params){
		$textStyles = array();

		if(!empty($params['text_color'])) {
		    $textStyles[] = 'color:' .$params['text_color'].';';
        }

		return implode(' ', $textStyles);
	}

	/**
	 * Generates background styles
	 *
	 * @param $params
	 *
	 * @return string
	 */
	private function getBackgroundStyles($params){
		$backgroundStyles = array();

		if(!empty($params['background_image'])) {
		    $backgroundStyles[] = 'background-image: url(' . wp_get_attachment_url($params['background_image']).')';
        }

		return implode(' ', $backgroundStyles);
	}
}