<?php
/**
 * Hero Typography Layout shortcode template
 */
?>
<div class="<?php echo esc_attr($holder_classes); ?>">
	<?php if($enable_preloader === 'yes') { ?>
		<div class="mkd-htl-preloader">
			<div class="mkd-htl-spinner">
				<?php for ($i=0; $i < 10; $i++) { ?>
					<div class="mkd-htl-spinner-blade"></div>
				<?php } ?>
			</div>
			<div class="mkd-htl-preloader-bgrnd"></div>
		</div>
	<?php } ?>
	<div class="mkd-htl-content-holder">
		<div class="mkd-htl-content">
			<span class="mkd-htl-content-element mkd-htl-static-content-element" <?php buro_mikado_inline_style($text_styles);?>>
				<?php echo esc_attr($text); ?>
			</span>
			<span class="mkd-htl-content-element mkd-htl-highlighted-content-element">
				<?php foreach ($highlighted_text_instances as $highlighted_text_instance): ?>
				    <?php $highlighted_text_color = ''; ?>
				    <?php if (isset($highlighted_text_instance['highlighted_text_color'])) { 
		    			$highlighted_text_color = 'color:'.$highlighted_text_instance['highlighted_text_color'].';';
				    } ?>
				    <span class="mkd-htl-highlighted-text-instance" <?php buro_mikado_inline_style($highlighted_text_color);?>>
				    	<span class="mkd-htl-highlighted-text-instance-content">
					    	<?php echo esc_attr($highlighted_text_instance['highlighted_text']);  ?>
					    </span>
				    </span>
				<?php endforeach; ?>
				<span class="mkd-htl-additional-character">
					<?php echo esc_attr($additional_character); ?>
				</span>
				<span class="mkd-htl-underline"></span>
			</span>
		</div>
	</div>	
	<?php if(!empty($background_image)) { ?>
		<div class="mkd-htl-background" <?php buro_mikado_inline_style($background_styles);?>></div>
	<?php } ?>
	<?php if($enable_scroll_down_notice === 'yes') { ?>
		<div class="mkd-htl-scroll-down" <?php buro_mikado_inline_style($text_styles);?>>
			<i class="fa fa-chevron-down" aria-hidden="true"></i>
		</div>
	<?php } ?>
</div>
