<?php
namespace BuroMikado\Modules\Shortcodes\InteractiveLinkShowcase;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

/**
 * Class InteractiveLinkShowcase
 */
class InteractiveLinkShowcase implements ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkd_interactive_link_showcase';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 */
	public function vcMap() {
		if(function_exists('vc_map')) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Interactive Link Showcase', 'buro' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by MIKADO', 'buro' ),
					'icon'                      => 'icon-wpb-interactive-link-showcase extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
					'params'                    => array(
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'skin',
                            'heading'     => esc_html__( 'Links Skin', 'buro' ),
                            'value'       => array(
                                esc_html__( 'Light', 'buro' )    => 'light',
                                esc_html__( 'Dark', 'buro' )     => 'dark'
                            )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'target',
                            'heading'     => esc_html__( 'Link Target', 'buro' ),
                            'value'       => array(
                                esc_html__( 'Same Window', 'buro' )    => '_self',
                                esc_html__( 'New Window', 'buro' )     => '_blank'
                            ),
                            'save_always' => true
                        ),
                        array(
                            'type' => 'param_group',
                            'heading' => esc_html__( 'Link Items', 'buro' ),
                            'param_name' => 'link_items',
                            'value' => '',
                            'params' => array(
                                array(
                                    'type'        => 'textfield',
                                    'param_name'  => 'title',
                                    'heading'     => esc_html__( 'Text', 'buro' ),
                                    'save_always' => true,
                                    'admin_label' => true
                                ),
                                array(
                                    'type'       => 'textfield',
                                    'param_name' => 'link',
                                    'heading'    => esc_html__( 'Link', 'buro' )
                                ),
                                array(
                                    'type'        => 'attach_image',
                                    'param_name'  => 'image',
                                    'heading'     => esc_html__( 'Image', 'buro' ),
                                    'description' => esc_html__( 'Select image from media library', 'buro' )
                                ),
                            )
                        ),
                    )
				)
			);
		}
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
            'skin'              => 'light',
            'target'            => '_self',
            'link_items'        => ''
		);
		
		$params = shortcode_atts($args, $atts);
		$params['holder_classes'] = $this->getHolderClasses($params);
        $params['content'] = $content;
        $params['link_items'] = vc_param_group_parse_atts($params['link_items']);
		
		$html = mkd_core_get_module_shortcode_template_part('templates/interactive-link-showcase', 'interactive-link-showcase', '', $params);
		
		return $html;
	}
	
	/**
	 * Generates holder classes
	 *
	 * @param $params
	 *
	 * @return string
	 */
	private function getHolderClasses($params){
		$holderClasses = array();

		$holderClasses[] = 'mkd-ils';
		if(!empty($params['skin'])) {
		    $holderClasses[] = 'mkd-ils-skin-' . $params['skin'];
        }

		return implode(' ', $holderClasses);
	}
}