<?php
namespace BuroMikado\Modules\Shortcodes\Process;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;

class ProcessHolder implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'mkd_process_holder';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map(array(
			'name'                    => esc_html__('Process','buro'),
			'base'                    => $this->getBase(),
			'as_parent'               => array('only' => 'mkd_process_item'),
			'content_element'         => true,
			'category'                => esc_html__('by MIKADO', 'buro'),
			'icon'                    => 'icon-wpb-process-holder extended-custom-icon',
			'js_view'                 => 'VcColumnView',
			'params'                  => array(
				array(
					'type'        => 'dropdown',
					'param_name'  => 'number_of_items',
					'heading'     => esc_html__('Number of Process Items', 'buro'),
					'value'       => array(
						esc_html__('Three', 'buro') => 'three',
						esc_html__('Four', 'buro')  => 'four',
						esc_html__('Five', 'buro')  => 'five'
					),
					'admin_label' => true,
				)
			)
		));
	}

	public function render($atts, $content = null) {
		$default_atts = array(
			'number_of_items' => 'three'
		);

		$params            = shortcode_atts($default_atts, $atts);
		$params['content'] = $content;

		$params['holder_classes'] = array(
			'mkd-process-holder',
			'mkd-process-holder-items-'.$params['number_of_items']
		);

		return mkd_core_get_module_shortcode_template_part('templates/process-holder-template', 'process', '', $params);
	}
}