<?php
namespace BuroMikado\Modules\Shortcodes\SectionTitle;

use BuroMikado\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class SectionTitle
 */
class SectionTitle implements ShortcodeInterface {

	/**
	 * @var string
	 */
	private $base;

	public function __construct() {
		$this->base = 'mkd_section_title';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 *
	 */
	public function vcMap() {

		vc_map( array(
				'name' => esc_html__('Section Title', 'buro'),
				'base' => $this->getBase(),
				'category' => esc_html__('by MIKADO','buro'),
				'icon' => 'icon-wpb-section-title extended-custom-icon',
				'allowed_container_element' => 'vc_row',
				'params' => array(
					array(
						'type'			=> 'textfield',
						'heading'		=> esc_html__('Title Text','buro'),
						'param_name'	=> 'title_text',
						'value'			=> '',
						'admin_label'	=> true
					),
					array(
						'type'			=> 'textfield',
						'heading'		=> esc_html__('Highlighted Title Text','buro'),
						'param_name'	=> 'highlighted_text',
						'value'			=> '',
						'admin_label'	=> true,
						'description'   =>esc_html__('Highlighted title text will be appended to title text','buro')
					),
					array(
						'type'			=> 'dropdown',
						'heading'		=> esc_html__('Text Align','buro'),
						'param_name'	=> 'text_align',
						'value'			=> array(
							''			=> '',
							esc_html__('Left','buro')	=> 'left',
							esc_html__('Center','buro')	=> 'center',
							esc_html__('Right','buro')	=> 'right',
							esc_html__('Justify','buro')	=> 'justify'
						)
					),
					array(
						'type'        => 'colorpicker',
						'heading'     => esc_html__('Text Color','buro'),
						'param_name'  => 'text_color',
						'dependency'  => array('element' => 'title_text', 'not_empty' => true)
					),
					array(
						'type' => 'textfield',
						'heading' => esc_html__('Text Size (px)', 'buro'),
						'param_name' => 'text_size',
						'dependency' => array('element' => 'title_text', 'not_empty' => true),
					),
					array(
						'type'        => 'colorpicker',
						'heading'     => esc_html__('Highlighted Color','buro'),
						'param_name'  => 'highlighted_color',
						'dependency'  => array('element' => 'highlighted_text', 'not_empty' => true)
					),
					array(
						'type'        => 'dropdown',
						'heading'     => esc_html__('Highlighted Effect','buro'),
						'param_name'  => 'highlighted_effect',
						'value'			=> array(
							esc_html__('None','buro')	 => '',
							esc_html__('Blink','buro')	 => 'blink',
							esc_html__('Type Out','buro') => 'type-out',
						),
						'dependency'  => array('element' => 'highlighted_text', 'not_empty' => true)
					)
				)
		) );
	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @return string
	 */
	public function render($atts, $content = null) {

		$args = array(
			'title_text' => '',
			'highlighted_text' => '',
			'text_align' => 'left',
			'text_color' => '',
			'text_size' => '',
			'highlighted_color'	=> '',
			'highlighted_effect' => ''
		);

		$params = shortcode_atts($args, $atts);

		$params['classes'] = $this->getTitleSectionClass($params);
		$params['title_style'] = $this->getTitleStyle($params);
		$params['highlighted_style'] = $this->getTitleHighlightedStyle($params);

		//Get HTML from template
		$html = mkd_core_get_module_shortcode_template_part('templates/section-title-template', 'section-title', '', $params);

		return $html;

	}

    /**
     * Generates classes for title section
     *
     * @param $params
     *
     * @return array
     */
	private function getTitleSectionClass($params){
		$classes = array();
		$classes[] = 'mkd-section-title';

		if ($params['text_align'] != ''){
			$classes[] = 'mkd-section-align-'.$params['text_align'];
		}

		if ($params['highlighted_effect'] != ''){
			$classes[] = 'mkd-section-'.$params['highlighted_effect'];
		}

		return $classes;
	}

    /**
     * Generates style for title text
     *
     * @param $params
     *
     * @return string
     */
	private function getTitleStyle($params){
		$title_style = array();

		if ($params['text_color'] != ''){
			$title_style[] = 'color: '.$params['text_color'];
		}

		if ($params['text_size'] != ''){
			$title_style[] = 'font-size: '.buro_mikado_filter_px($params['text_size']).'px';
		}

		return implode(';', $title_style);
	}

    /**
     * Generates style for title highlighted text
     *
     * @param $params
     *
     * @return string
     */
	private function getTitleHighlightedStyle($params){
		$highlighted_style = array();

		if ($params['highlighted_color'] != ''){
			$highlighted_style[] = 'color: '.$params['highlighted_color'];
		}

		return implode(';', $highlighted_style);
	}
}